/**
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * 
 */
package de.bsvrz.buv.plugin.doeditor.model.util;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;

import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;

import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;

import de.bsvrz.buv.plugin.doeditor.model.*;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage
 * @generated
 */
public class DoeditorSwitch<T1> extends Switch<T1> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static DoeditorPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DoeditorSwitch() {
		if (modelPackage == null) {
			modelPackage = DoeditorPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T1 doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case DoeditorPackage.VISIBLE_FORM: {
			VisibleForm visibleForm = (VisibleForm) theEObject;
			T1 result = caseVisibleForm(visibleForm);
			if (result == null)
				result = caseNamed(visibleForm);
			if (result == null)
				result = caseLocated(visibleForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ROTATABLE_FORM: {
			RotatableForm rotatableForm = (RotatableForm) theEObject;
			T1 result = caseRotatableForm(rotatableForm);
			if (result == null)
				result = caseVisibleForm(rotatableForm);
			if (result == null)
				result = caseNamed(rotatableForm);
			if (result == null)
				result = caseLocated(rotatableForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDERED_FORM: {
			BorderedForm borderedForm = (BorderedForm) theEObject;
			T1 result = caseBorderedForm(borderedForm);
			if (result == null)
				result = caseVisibleForm(borderedForm);
			if (result == null)
				result = caseNamed(borderedForm);
			if (result == null)
				result = caseLocated(borderedForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ZOOMABLE_FORM: {
			ZoomableForm zoomableForm = (ZoomableForm) theEObject;
			T1 result = caseZoomableForm(zoomableForm);
			if (result == null)
				result = caseVisibleForm(zoomableForm);
			if (result == null)
				result = caseNamed(zoomableForm);
			if (result == null)
				result = caseLocated(zoomableForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.PUNKT_FORM: {
			PunktForm punktForm = (PunktForm) theEObject;
			T1 result = casePunktForm(punktForm);
			if (result == null)
				result = caseRotatableForm(punktForm);
			if (result == null)
				result = caseZoomableForm(punktForm);
			if (result == null)
				result = caseVisibleForm(punktForm);
			if (result == null)
				result = caseNamed(punktForm);
			if (result == null)
				result = caseLocated(punktForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BILD_FORM: {
			BildForm bildForm = (BildForm) theEObject;
			T1 result = caseBildForm(bildForm);
			if (result == null)
				result = caseRotatableForm(bildForm);
			if (result == null)
				result = caseZoomableForm(bildForm);
			if (result == null)
				result = caseVisibleForm(bildForm);
			if (result == null)
				result = caseNamed(bildForm);
			if (result == null)
				result = caseLocated(bildForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.TEXT_FORM: {
			TextForm textForm = (TextForm) theEObject;
			T1 result = caseTextForm(textForm);
			if (result == null)
				result = caseFlaechenForm(textForm);
			if (result == null)
				result = caseBorderedForm(textForm);
			if (result == null)
				result = caseLinienForm(textForm);
			if (result == null)
				result = caseSized(textForm);
			if (result == null)
				result = casePunktForm(textForm);
			if (result == null)
				result = caseRotatableForm(textForm);
			if (result == null)
				result = caseZoomableForm(textForm);
			if (result == null)
				result = caseVisibleForm(textForm);
			if (result == null)
				result = caseNamed(textForm);
			if (result == null)
				result = caseLocated(textForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.POLYLINE_FORM: {
			PolylineForm polylineForm = (PolylineForm) theEObject;
			T1 result = casePolylineForm(polylineForm);
			if (result == null)
				result = caseLinienForm(polylineForm);
			if (result == null)
				result = casePunktForm(polylineForm);
			if (result == null)
				result = caseRotatableForm(polylineForm);
			if (result == null)
				result = caseZoomableForm(polylineForm);
			if (result == null)
				result = caseVisibleForm(polylineForm);
			if (result == null)
				result = caseNamed(polylineForm);
			if (result == null)
				result = caseLocated(polylineForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.POLYGON_FORM: {
			PolygonForm polygonForm = (PolygonForm) theEObject;
			T1 result = casePolygonForm(polygonForm);
			if (result == null)
				result = casePolylineForm(polygonForm);
			if (result == null)
				result = caseFlaechenForm(polygonForm);
			if (result == null)
				result = caseLinienForm(polygonForm);
			if (result == null)
				result = caseSized(polygonForm);
			if (result == null)
				result = casePunktForm(polygonForm);
			if (result == null)
				result = caseRotatableForm(polygonForm);
			if (result == null)
				result = caseZoomableForm(polygonForm);
			if (result == null)
				result = caseVisibleForm(polygonForm);
			if (result == null)
				result = caseNamed(polygonForm);
			if (result == null)
				result = caseLocated(polygonForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FLAECHEN_FORM: {
			FlaechenForm flaechenForm = (FlaechenForm) theEObject;
			T1 result = caseFlaechenForm(flaechenForm);
			if (result == null)
				result = caseLinienForm(flaechenForm);
			if (result == null)
				result = caseSized(flaechenForm);
			if (result == null)
				result = casePunktForm(flaechenForm);
			if (result == null)
				result = caseRotatableForm(flaechenForm);
			if (result == null)
				result = caseZoomableForm(flaechenForm);
			if (result == null)
				result = caseVisibleForm(flaechenForm);
			if (result == null)
				result = caseNamed(flaechenForm);
			if (result == null)
				result = caseLocated(flaechenForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ELLIPSE_FORM: {
			EllipseForm ellipseForm = (EllipseForm) theEObject;
			T1 result = caseEllipseForm(ellipseForm);
			if (result == null)
				result = caseFlaechenForm(ellipseForm);
			if (result == null)
				result = caseLinienForm(ellipseForm);
			if (result == null)
				result = caseSized(ellipseForm);
			if (result == null)
				result = casePunktForm(ellipseForm);
			if (result == null)
				result = caseRotatableForm(ellipseForm);
			if (result == null)
				result = caseZoomableForm(ellipseForm);
			if (result == null)
				result = caseVisibleForm(ellipseForm);
			if (result == null)
				result = caseNamed(ellipseForm);
			if (result == null)
				result = caseLocated(ellipseForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.RECHTECK_FORM: {
			RechteckForm rechteckForm = (RechteckForm) theEObject;
			T1 result = caseRechteckForm(rechteckForm);
			if (result == null)
				result = caseFlaechenForm(rechteckForm);
			if (result == null)
				result = caseLinienForm(rechteckForm);
			if (result == null)
				result = caseSized(rechteckForm);
			if (result == null)
				result = casePunktForm(rechteckForm);
			if (result == null)
				result = caseRotatableForm(rechteckForm);
			if (result == null)
				result = caseZoomableForm(rechteckForm);
			if (result == null)
				result = caseVisibleForm(rechteckForm);
			if (result == null)
				result = caseNamed(rechteckForm);
			if (result == null)
				result = caseLocated(rechteckForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.LINIEN_FORM: {
			LinienForm linienForm = (LinienForm) theEObject;
			T1 result = caseLinienForm(linienForm);
			if (result == null)
				result = casePunktForm(linienForm);
			if (result == null)
				result = caseRotatableForm(linienForm);
			if (result == null)
				result = caseZoomableForm(linienForm);
			if (result == null)
				result = caseVisibleForm(linienForm);
			if (result == null)
				result = caseNamed(linienForm);
			if (result == null)
				result = caseLocated(linienForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.DECORATOR: {
			Decorator decorator = (Decorator) theEObject;
			T1 result = caseDecorator(decorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.TEXT_DECORATOR: {
			TextDecorator textDecorator = (TextDecorator) theEObject;
			T1 result = caseTextDecorator(textDecorator);
			if (result == null)
				result = caseDecorator(textDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ATTRIBUTE_DECORATOR: {
			AttributeDecorator attributeDecorator = (AttributeDecorator) theEObject;
			T1 result = caseAttributeDecorator(attributeDecorator);
			if (result == null)
				result = caseDecorator(attributeDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.INTERVAL_DECORATOR: {
			IntervalDecorator intervalDecorator = (IntervalDecorator) theEObject;
			T1 result = caseIntervalDecorator(intervalDecorator);
			if (result == null)
				result = caseDecorator(intervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ZOOM_DECORATOR: {
			ZoomDecorator zoomDecorator = (ZoomDecorator) theEObject;
			T1 result = caseZoomDecorator(zoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(zoomDecorator);
			if (result == null)
				result = caseDecorator(zoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.EDITOR_DO_MODEL: {
			EditorDoModel editorDoModel = (EditorDoModel) theEObject;
			T1 result = caseEditorDoModel(editorDoModel);
			if (result == null)
				result = caseDoModel(editorDoModel);
			if (result == null)
				result = caseDoKompositum(editorDoModel);
			if (result == null)
				result = caseSkalierungDecorator(editorDoModel);
			if (result == null)
				result = caseDrehungDecorator(editorDoModel);
			if (result == null)
				result = caseNamed(editorDoModel);
			if (result == null)
				result = caseLocated(editorDoModel);
			if (result == null)
				result = caseDoKomponente(editorDoModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR: {
			AttributeTextDecorator attributeTextDecorator = (AttributeTextDecorator) theEObject;
			T1 result = caseAttributeTextDecorator(attributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(attributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(attributeTextDecorator);
			if (result == null)
				result = caseDecorator(attributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ATTRIBUTE_INTERVAL_DECORATOR: {
			AttributeIntervalDecorator attributeIntervalDecorator = (AttributeIntervalDecorator) theEObject;
			T1 result = caseAttributeIntervalDecorator(attributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(attributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(attributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(attributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR: {
			BackgroundAttributeIntervalDecorator backgroundAttributeIntervalDecorator = (BackgroundAttributeIntervalDecorator) theEObject;
			T1 result = caseBackgroundAttributeIntervalDecorator(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = caseBackgroundParameterDefinition(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = caseColorParameterDefinition(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(backgroundAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.PARAMETER_DEFINITION: {
			ParameterDefinition parameterDefinition = (ParameterDefinition) theEObject;
			T1 result = caseParameterDefinition(parameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.COLOR_PARAMETER_DEFINITION: {
			ColorParameterDefinition colorParameterDefinition = (ColorParameterDefinition) theEObject;
			T1 result = caseColorParameterDefinition(colorParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(colorParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BACKGROUND_PARAMETER_DEFINITION: {
			BackgroundParameterDefinition backgroundParameterDefinition = (BackgroundParameterDefinition) theEObject;
			T1 result = caseBackgroundParameterDefinition(backgroundParameterDefinition);
			if (result == null)
				result = caseColorParameterDefinition(backgroundParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(backgroundParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FOREGROUND_PARAMETER_DEFINITION: {
			ForegroundParameterDefinition foregroundParameterDefinition = (ForegroundParameterDefinition) theEObject;
			T1 result = caseForegroundParameterDefinition(foregroundParameterDefinition);
			if (result == null)
				result = caseColorParameterDefinition(foregroundParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(foregroundParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_COLOR_PARAMETER_DEFINITION: {
			BorderColorParameterDefinition borderColorParameterDefinition = (BorderColorParameterDefinition) theEObject;
			T1 result = caseBorderColorParameterDefinition(borderColorParameterDefinition);
			if (result == null)
				result = caseColorParameterDefinition(borderColorParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(borderColorParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FONT_DATA_PARAMETER_DEFINITION: {
			FontDataParameterDefinition fontDataParameterDefinition = (FontDataParameterDefinition) theEObject;
			T1 result = caseFontDataParameterDefinition(fontDataParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(fontDataParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.DREHWINKEL_PARAMETER_DEFINITION: {
			DrehwinkelParameterDefinition drehwinkelParameterDefinition = (DrehwinkelParameterDefinition) theEObject;
			T1 result = caseDrehwinkelParameterDefinition(drehwinkelParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(drehwinkelParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.LINE_ATTRIBUTE_PARAMETER_DEFINITION: {
			LineAttributeParameterDefinition lineAttributeParameterDefinition = (LineAttributeParameterDefinition) theEObject;
			T1 result = caseLineAttributeParameterDefinition(lineAttributeParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(lineAttributeParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.STRING_PARAMETER_DEFINITION: {
			StringParameterDefinition stringParameterDefinition = (StringParameterDefinition) theEObject;
			T1 result = caseStringParameterDefinition(stringParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(stringParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.SICHTBARKEIT_PARAMETER_DEFINITION: {
			SichtbarkeitParameterDefinition sichtbarkeitParameterDefinition = (SichtbarkeitParameterDefinition) theEObject;
			T1 result = caseSichtbarkeitParameterDefinition(sichtbarkeitParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(sichtbarkeitParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ZOOM_VERHALTEN_PARAMETER_DEFINITION: {
			ZoomVerhaltenParameterDefinition zoomVerhaltenParameterDefinition = (ZoomVerhaltenParameterDefinition) theEObject;
			T1 result = caseZoomVerhaltenParameterDefinition(zoomVerhaltenParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(zoomVerhaltenParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_TEXT_DECORATOR: {
			BackgroundAttributeTextDecorator backgroundAttributeTextDecorator = (BackgroundAttributeTextDecorator) theEObject;
			T1 result = caseBackgroundAttributeTextDecorator(backgroundAttributeTextDecorator);
			if (result == null)
				result = caseBackgroundParameterDefinition(backgroundAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(backgroundAttributeTextDecorator);
			if (result == null)
				result = caseColorParameterDefinition(backgroundAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(backgroundAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(backgroundAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(backgroundAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(backgroundAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BACKGROUND_ZOOM_DECORATOR: {
			BackgroundZoomDecorator backgroundZoomDecorator = (BackgroundZoomDecorator) theEObject;
			T1 result = caseBackgroundZoomDecorator(backgroundZoomDecorator);
			if (result == null)
				result = caseBackgroundParameterDefinition(backgroundZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(backgroundZoomDecorator);
			if (result == null)
				result = caseColorParameterDefinition(backgroundZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(backgroundZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(backgroundZoomDecorator);
			if (result == null)
				result = caseDecorator(backgroundZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR: {
			DrehwinkelAttributeTextDecorator drehwinkelAttributeTextDecorator = (DrehwinkelAttributeTextDecorator) theEObject;
			T1 result = caseDrehwinkelAttributeTextDecorator(drehwinkelAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(drehwinkelAttributeTextDecorator);
			if (result == null)
				result = caseDrehwinkelParameterDefinition(drehwinkelAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(drehwinkelAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(drehwinkelAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(drehwinkelAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(drehwinkelAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR: {
			DrehwinkelAttributeIntervalDecorator drehwinkelAttributeIntervalDecorator = (DrehwinkelAttributeIntervalDecorator) theEObject;
			T1 result = caseDrehwinkelAttributeIntervalDecorator(drehwinkelAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(drehwinkelAttributeIntervalDecorator);
			if (result == null)
				result = caseDrehwinkelParameterDefinition(drehwinkelAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(drehwinkelAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(drehwinkelAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(drehwinkelAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(drehwinkelAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.DREHWINKEL_ZOOM_DECORATOR: {
			DrehwinkelZoomDecorator drehwinkelZoomDecorator = (DrehwinkelZoomDecorator) theEObject;
			T1 result = caseDrehwinkelZoomDecorator(drehwinkelZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(drehwinkelZoomDecorator);
			if (result == null)
				result = caseDrehwinkelParameterDefinition(drehwinkelZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(drehwinkelZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(drehwinkelZoomDecorator);
			if (result == null)
				result = caseDecorator(drehwinkelZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR: {
			FontDataAttributeIntervalDecorator fontDataAttributeIntervalDecorator = (FontDataAttributeIntervalDecorator) theEObject;
			T1 result = caseFontDataAttributeIntervalDecorator(fontDataAttributeIntervalDecorator);
			if (result == null)
				result = caseFontDataParameterDefinition(fontDataAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(fontDataAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(fontDataAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(fontDataAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(fontDataAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(fontDataAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FONT_DATA_ATTRIBUTE_TEXT_DECORATOR: {
			FontDataAttributeTextDecorator fontDataAttributeTextDecorator = (FontDataAttributeTextDecorator) theEObject;
			T1 result = caseFontDataAttributeTextDecorator(fontDataAttributeTextDecorator);
			if (result == null)
				result = caseFontDataParameterDefinition(fontDataAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(fontDataAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(fontDataAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(fontDataAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(fontDataAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(fontDataAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR: {
			FontDataZoomDecorator fontDataZoomDecorator = (FontDataZoomDecorator) theEObject;
			T1 result = caseFontDataZoomDecorator(fontDataZoomDecorator);
			if (result == null)
				result = caseFontDataParameterDefinition(fontDataZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(fontDataZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(fontDataZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(fontDataZoomDecorator);
			if (result == null)
				result = caseDecorator(fontDataZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FOREGROUND_ATTRIBUTE_TEXT_DECORATOR: {
			ForegroundAttributeTextDecorator foregroundAttributeTextDecorator = (ForegroundAttributeTextDecorator) theEObject;
			T1 result = caseForegroundAttributeTextDecorator(foregroundAttributeTextDecorator);
			if (result == null)
				result = caseForegroundParameterDefinition(foregroundAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(foregroundAttributeTextDecorator);
			if (result == null)
				result = caseColorParameterDefinition(foregroundAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(foregroundAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(foregroundAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(foregroundAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(foregroundAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR: {
			ForegroundAttributeIntervalDecorator foregroundAttributeIntervalDecorator = (ForegroundAttributeIntervalDecorator) theEObject;
			T1 result = caseForegroundAttributeIntervalDecorator(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = caseForegroundParameterDefinition(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = caseColorParameterDefinition(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(foregroundAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR: {
			ForegroundZoomDecorator foregroundZoomDecorator = (ForegroundZoomDecorator) theEObject;
			T1 result = caseForegroundZoomDecorator(foregroundZoomDecorator);
			if (result == null)
				result = caseForegroundParameterDefinition(foregroundZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(foregroundZoomDecorator);
			if (result == null)
				result = caseColorParameterDefinition(foregroundZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(foregroundZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(foregroundZoomDecorator);
			if (result == null)
				result = caseDecorator(foregroundZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR: {
			LineAttributeAttributeIntervalDecorator lineAttributeAttributeIntervalDecorator = (LineAttributeAttributeIntervalDecorator) theEObject;
			T1 result = caseLineAttributeAttributeIntervalDecorator(lineAttributeAttributeIntervalDecorator);
			if (result == null)
				result = caseLineAttributeParameterDefinition(lineAttributeAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(lineAttributeAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(lineAttributeAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(lineAttributeAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(lineAttributeAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(lineAttributeAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR: {
			LineAttributeAttributeTextDecorator lineAttributeAttributeTextDecorator = (LineAttributeAttributeTextDecorator) theEObject;
			T1 result = caseLineAttributeAttributeTextDecorator(lineAttributeAttributeTextDecorator);
			if (result == null)
				result = caseLineAttributeParameterDefinition(lineAttributeAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(lineAttributeAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(lineAttributeAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(lineAttributeAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(lineAttributeAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(lineAttributeAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.LINE_ATTRIBUTE_ZOOM_DECORATOR: {
			LineAttributeZoomDecorator lineAttributeZoomDecorator = (LineAttributeZoomDecorator) theEObject;
			T1 result = caseLineAttributeZoomDecorator(lineAttributeZoomDecorator);
			if (result == null)
				result = caseLineAttributeParameterDefinition(lineAttributeZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(lineAttributeZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(lineAttributeZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(lineAttributeZoomDecorator);
			if (result == null)
				result = caseDecorator(lineAttributeZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR: {
			SichtbarkeitAttributeTextDecorator sichtbarkeitAttributeTextDecorator = (SichtbarkeitAttributeTextDecorator) theEObject;
			T1 result = caseSichtbarkeitAttributeTextDecorator(sichtbarkeitAttributeTextDecorator);
			if (result == null)
				result = caseSichtbarkeitParameterDefinition(sichtbarkeitAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(sichtbarkeitAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(sichtbarkeitAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(sichtbarkeitAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(sichtbarkeitAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(sichtbarkeitAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR: {
			SichtbarkeitAttributeIntervalDecorator sichtbarkeitAttributeIntervalDecorator = (SichtbarkeitAttributeIntervalDecorator) theEObject;
			T1 result = caseSichtbarkeitAttributeIntervalDecorator(sichtbarkeitAttributeIntervalDecorator);
			if (result == null)
				result = caseSichtbarkeitParameterDefinition(sichtbarkeitAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(sichtbarkeitAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(sichtbarkeitAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(sichtbarkeitAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(sichtbarkeitAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(sichtbarkeitAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.SICHTBARKEIT_ZOOM_DECORATOR: {
			SichtbarkeitZoomDecorator sichtbarkeitZoomDecorator = (SichtbarkeitZoomDecorator) theEObject;
			T1 result = caseSichtbarkeitZoomDecorator(sichtbarkeitZoomDecorator);
			if (result == null)
				result = caseSichtbarkeitParameterDefinition(sichtbarkeitZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(sichtbarkeitZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(sichtbarkeitZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(sichtbarkeitZoomDecorator);
			if (result == null)
				result = caseDecorator(sichtbarkeitZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.STRING_ATTRIBUTE_INTERVAL_DECORATOR: {
			StringAttributeIntervalDecorator stringAttributeIntervalDecorator = (StringAttributeIntervalDecorator) theEObject;
			T1 result = caseStringAttributeIntervalDecorator(stringAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(stringAttributeIntervalDecorator);
			if (result == null)
				result = caseStringParameterDefinition(stringAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(stringAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(stringAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(stringAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(stringAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.STRING_ATTRIBUTE_TEXT_DECORATOR: {
			StringAttributeTextDecorator stringAttributeTextDecorator = (StringAttributeTextDecorator) theEObject;
			T1 result = caseStringAttributeTextDecorator(stringAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(stringAttributeTextDecorator);
			if (result == null)
				result = caseStringParameterDefinition(stringAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(stringAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(stringAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(stringAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(stringAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.STRING_ZOOM_DECORATOR: {
			StringZoomDecorator stringZoomDecorator = (StringZoomDecorator) theEObject;
			T1 result = caseStringZoomDecorator(stringZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(stringZoomDecorator);
			if (result == null)
				result = caseStringParameterDefinition(stringZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(stringZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(stringZoomDecorator);
			if (result == null)
				result = caseDecorator(stringZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR: {
			ZoomVerhaltenAttributeIntervalDecorator zoomVerhaltenAttributeIntervalDecorator = (ZoomVerhaltenAttributeIntervalDecorator) theEObject;
			T1 result = caseZoomVerhaltenAttributeIntervalDecorator(zoomVerhaltenAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(zoomVerhaltenAttributeIntervalDecorator);
			if (result == null)
				result = caseZoomVerhaltenParameterDefinition(zoomVerhaltenAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(zoomVerhaltenAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(zoomVerhaltenAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(zoomVerhaltenAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(zoomVerhaltenAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR: {
			ZoomVerhaltenAttributeTextDecorator zoomVerhaltenAttributeTextDecorator = (ZoomVerhaltenAttributeTextDecorator) theEObject;
			T1 result = caseZoomVerhaltenAttributeTextDecorator(zoomVerhaltenAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(zoomVerhaltenAttributeTextDecorator);
			if (result == null)
				result = caseZoomVerhaltenParameterDefinition(zoomVerhaltenAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(zoomVerhaltenAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(zoomVerhaltenAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(zoomVerhaltenAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(zoomVerhaltenAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.ZOOM_VERHALTEN_ZOOM_DECORATOR: {
			ZoomVerhaltenZoomDecorator zoomVerhaltenZoomDecorator = (ZoomVerhaltenZoomDecorator) theEObject;
			T1 result = caseZoomVerhaltenZoomDecorator(zoomVerhaltenZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(zoomVerhaltenZoomDecorator);
			if (result == null)
				result = caseZoomVerhaltenParameterDefinition(zoomVerhaltenZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(zoomVerhaltenZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(zoomVerhaltenZoomDecorator);
			if (result == null)
				result = caseDecorator(zoomVerhaltenZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.EMBEDDED_DO_FORM: {
			EmbeddedDoForm embeddedDoForm = (EmbeddedDoForm) theEObject;
			T1 result = caseEmbeddedDoForm(embeddedDoForm);
			if (result == null)
				result = caseVisibleForm(embeddedDoForm);
			if (result == null)
				result = caseIdentidy(embeddedDoForm);
			if (result == null)
				result = caseNamed(embeddedDoForm);
			if (result == null)
				result = caseLocated(embeddedDoForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.EXTERNAL_DO_FORM: {
			ExternalDoForm externalDoForm = (ExternalDoForm) theEObject;
			T1 result = caseExternalDoForm(externalDoForm);
			if (result == null)
				result = caseVisibleForm(externalDoForm);
			if (result == null)
				result = caseIdentidy(externalDoForm);
			if (result == null)
				result = caseNamed(externalDoForm);
			if (result == null)
				result = caseLocated(externalDoForm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.DO_EDITOR_DIAGRAMM: {
			DoEditorDiagramm doEditorDiagramm = (DoEditorDiagramm) theEObject;
			T1 result = caseDoEditorDiagramm(doEditorDiagramm);
			if (result == null)
				result = caseLocated(doEditorDiagramm);
			if (result == null)
				result = caseNamed(doEditorDiagramm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.EDITOR_DO_TYP: {
			EditorDoTyp editorDoTyp = (EditorDoTyp) theEObject;
			T1 result = caseEditorDoTyp(editorDoTyp);
			if (result == null)
				result = caseNamed(editorDoTyp);
			if (result == null)
				result = caseLocated(editorDoTyp);
			if (result == null)
				result = caseSized(editorDoTyp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ: {
			EditorDoTypReferenz editorDoTypReferenz = (EditorDoTypReferenz) theEObject;
			T1 result = caseEditorDoTypReferenz(editorDoTypReferenz);
			if (result == null)
				result = caseDoTyp(editorDoTypReferenz);
			if (result == null)
				result = caseSkalierungDecorator(editorDoTypReferenz);
			if (result == null)
				result = caseDrehungDecorator(editorDoTypReferenz);
			if (result == null)
				result = caseNamed(editorDoTypReferenz);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_WIDTH_PARAMETER_DEFINITION: {
			BorderWidthParameterDefinition borderWidthParameterDefinition = (BorderWidthParameterDefinition) theEObject;
			T1 result = caseBorderWidthParameterDefinition(borderWidthParameterDefinition);
			if (result == null)
				result = caseParameterDefinition(borderWidthParameterDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR: {
			BorderColorAttributeTextDecorator borderColorAttributeTextDecorator = (BorderColorAttributeTextDecorator) theEObject;
			T1 result = caseBorderColorAttributeTextDecorator(borderColorAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(borderColorAttributeTextDecorator);
			if (result == null)
				result = caseBorderColorParameterDefinition(borderColorAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(borderColorAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(borderColorAttributeTextDecorator);
			if (result == null)
				result = caseColorParameterDefinition(borderColorAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(borderColorAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(borderColorAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR: {
			BorderColorAttributeIntervalDecorator borderColorAttributeIntervalDecorator = (BorderColorAttributeIntervalDecorator) theEObject;
			T1 result = caseBorderColorAttributeIntervalDecorator(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = caseBorderColorParameterDefinition(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = caseColorParameterDefinition(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(borderColorAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_COLOR_ZOOM_DECORATOR: {
			BorderColorZoomDecorator borderColorZoomDecorator = (BorderColorZoomDecorator) theEObject;
			T1 result = caseBorderColorZoomDecorator(borderColorZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(borderColorZoomDecorator);
			if (result == null)
				result = caseBorderColorParameterDefinition(borderColorZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(borderColorZoomDecorator);
			if (result == null)
				result = caseColorParameterDefinition(borderColorZoomDecorator);
			if (result == null)
				result = caseDecorator(borderColorZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(borderColorZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR: {
			BorderWidthAttributeTextDecorator borderWidthAttributeTextDecorator = (BorderWidthAttributeTextDecorator) theEObject;
			T1 result = caseBorderWidthAttributeTextDecorator(borderWidthAttributeTextDecorator);
			if (result == null)
				result = caseAttributeTextDecorator(borderWidthAttributeTextDecorator);
			if (result == null)
				result = caseBorderWidthParameterDefinition(borderWidthAttributeTextDecorator);
			if (result == null)
				result = caseTextDecorator(borderWidthAttributeTextDecorator);
			if (result == null)
				result = caseAttributeDecorator(borderWidthAttributeTextDecorator);
			if (result == null)
				result = caseParameterDefinition(borderWidthAttributeTextDecorator);
			if (result == null)
				result = caseDecorator(borderWidthAttributeTextDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR: {
			BorderWidthAttributeIntervalDecorator borderWidthAttributeIntervalDecorator = (BorderWidthAttributeIntervalDecorator) theEObject;
			T1 result = caseBorderWidthAttributeIntervalDecorator(borderWidthAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeIntervalDecorator(borderWidthAttributeIntervalDecorator);
			if (result == null)
				result = caseBorderWidthParameterDefinition(borderWidthAttributeIntervalDecorator);
			if (result == null)
				result = caseIntervalDecorator(borderWidthAttributeIntervalDecorator);
			if (result == null)
				result = caseAttributeDecorator(borderWidthAttributeIntervalDecorator);
			if (result == null)
				result = caseParameterDefinition(borderWidthAttributeIntervalDecorator);
			if (result == null)
				result = caseDecorator(borderWidthAttributeIntervalDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.BORDER_WIDTH_ZOOM_DECORATOR: {
			BorderWidthZoomDecorator borderWidthZoomDecorator = (BorderWidthZoomDecorator) theEObject;
			T1 result = caseBorderWidthZoomDecorator(borderWidthZoomDecorator);
			if (result == null)
				result = caseZoomDecorator(borderWidthZoomDecorator);
			if (result == null)
				result = caseBorderWidthParameterDefinition(borderWidthZoomDecorator);
			if (result == null)
				result = caseIntervalDecorator(borderWidthZoomDecorator);
			if (result == null)
				result = caseParameterDefinition(borderWidthZoomDecorator);
			if (result == null)
				result = caseDecorator(borderWidthZoomDecorator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DoeditorPackage.IDENTIDY: {
			Identidy identidy = (Identidy) theEObject;
			T1 result = caseIdentidy(identidy);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Visible Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Visible Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseVisibleForm(VisibleForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rotatable Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rotatable Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseRotatableForm(RotatableForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Bordered Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Bordered Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderedForm(BorderedForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoomable Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoomable Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomableForm(ZoomableForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Punkt Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Punkt Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 casePunktForm(PunktForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Bild Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Bild Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBildForm(BildForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Text Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Text Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTextForm(TextForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Polyline Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Polyline Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 casePolylineForm(PolylineForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Polygon Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Polygon Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 casePolygonForm(PolygonForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Flaechen Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Flaechen Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFlaechenForm(FlaechenForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ellipse Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ellipse Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseEllipseForm(EllipseForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rechteck Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rechteck Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseRechteckForm(RechteckForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Linien Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Linien Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLinienForm(LinienForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDecorator(Decorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTextDecorator(TextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseAttributeDecorator(AttributeDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseIntervalDecorator(IntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomDecorator(ZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Editor Do Model</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Editor Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseEditorDoModel(EditorDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseAttributeTextDecorator(AttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseAttributeIntervalDecorator(AttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Background Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Background Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBackgroundAttributeIntervalDecorator(BackgroundAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseParameterDefinition(ParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Color Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Color Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseColorParameterDefinition(ColorParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Background Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Background Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBackgroundParameterDefinition(BackgroundParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Foreground Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Foreground Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseForegroundParameterDefinition(ForegroundParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Color Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Color Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderColorParameterDefinition(BorderColorParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Font Data Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Font Data Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFontDataParameterDefinition(FontDataParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Drehwinkel Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Drehwinkel Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDrehwinkelParameterDefinition(DrehwinkelParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Line Attribute Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Line Attribute Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLineAttributeParameterDefinition(LineAttributeParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStringParameterDefinition(StringParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sichtbarkeit Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sichtbarkeit Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSichtbarkeitParameterDefinition(SichtbarkeitParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom Verhalten Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom Verhalten Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomVerhaltenParameterDefinition(ZoomVerhaltenParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Background Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Background Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBackgroundAttributeTextDecorator(BackgroundAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Background Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Background Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBackgroundZoomDecorator(BackgroundZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Drehwinkel Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Drehwinkel Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDrehwinkelAttributeTextDecorator(DrehwinkelAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Drehwinkel Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Drehwinkel Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDrehwinkelAttributeIntervalDecorator(DrehwinkelAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Drehwinkel Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Drehwinkel Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDrehwinkelZoomDecorator(DrehwinkelZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Font Data Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Font Data Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFontDataAttributeIntervalDecorator(FontDataAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Font Data Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Font Data Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFontDataAttributeTextDecorator(FontDataAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Font Data Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Font Data Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFontDataZoomDecorator(FontDataZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Foreground Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Foreground Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseForegroundAttributeTextDecorator(ForegroundAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Foreground Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Foreground Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseForegroundAttributeIntervalDecorator(ForegroundAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Foreground Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Foreground Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseForegroundZoomDecorator(ForegroundZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Line Attribute Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Line Attribute Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLineAttributeAttributeIntervalDecorator(LineAttributeAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Line Attribute Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Line Attribute Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLineAttributeAttributeTextDecorator(LineAttributeAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Line Attribute Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Line Attribute Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLineAttributeZoomDecorator(LineAttributeZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sichtbarkeit Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sichtbarkeit Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSichtbarkeitAttributeTextDecorator(SichtbarkeitAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sichtbarkeit Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sichtbarkeit Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSichtbarkeitAttributeIntervalDecorator(SichtbarkeitAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sichtbarkeit Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sichtbarkeit Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSichtbarkeitZoomDecorator(SichtbarkeitZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStringAttributeIntervalDecorator(StringAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStringAttributeTextDecorator(StringAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStringZoomDecorator(StringZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom Verhalten Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom Verhalten Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomVerhaltenAttributeIntervalDecorator(ZoomVerhaltenAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom Verhalten Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom Verhalten Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomVerhaltenAttributeTextDecorator(ZoomVerhaltenAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom Verhalten Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom Verhalten Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomVerhaltenZoomDecorator(ZoomVerhaltenZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Embedded Do Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Embedded Do Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseEmbeddedDoForm(EmbeddedDoForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>External Do Form</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>External Do Form</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseExternalDoForm(ExternalDoForm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Editor Diagramm</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Editor Diagramm</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoEditorDiagramm(DoEditorDiagramm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Editor Do Typ</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Editor Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseEditorDoTyp(EditorDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Editor Do Typ Referenz</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Editor Do Typ Referenz</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseEditorDoTypReferenz(EditorDoTypReferenz object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Width Parameter Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Width Parameter Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderWidthParameterDefinition(BorderWidthParameterDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Color Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Color Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderColorAttributeTextDecorator(BorderColorAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Color Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Color Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderColorAttributeIntervalDecorator(BorderColorAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Color Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Color Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderColorZoomDecorator(BorderColorZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Width Attribute Text Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Width Attribute Text Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderWidthAttributeTextDecorator(BorderWidthAttributeTextDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Width Attribute Interval Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Width Attribute Interval Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderWidthAttributeIntervalDecorator(BorderWidthAttributeIntervalDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Border Width Zoom Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Border Width Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBorderWidthZoomDecorator(BorderWidthZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identidy</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identidy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseIdentidy(Identidy object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNamed(Named object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Located</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Located</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLocated(Located object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sized</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sized</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSized(Sized object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Komponente</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Komponente</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoKomponente(DoKomponente object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Model</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoModel(DoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Kompositum</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Kompositum</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public <T extends DoKomponente> T1 caseDoKompositum(DoKompositum<T> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Skalierung Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Skalierung Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSkalierungDecorator(SkalierungDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Drehung Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Drehung Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDrehungDecorator(DrehungDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Typ</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoTyp(DoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T1 defaultCase(EObject object) {
		return null;
	}

} //DoeditorSwitch
