package de.bsvrz.buv.plugin.doeditor.model.util;

import java.io.IOException;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import de.bsvrz.buv.plugin.doeditor.util.DoEditorUtil;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellungsobjekteglobal.objekte.DarstellungsObjektTyp;

/**
 * Reagiert auf Änderung des Systemobjekts des Editor-DO-Typs und aktualisiert
 * die restlichen Eigenschaften.
 * 
 * @author BitCtrl Systems GmbH, Falko Schumann
 * 
 */
public class EditorDoTypReferenzAdapter extends AdapterImpl {

	@Override
	public boolean isAdapterForType(final Object type) {
		return type == EditorDoTypReferenz.class;
	}

	@Override
	public void notifyChanged(final Notification msg) {
		if (msg.getFeature() == DoeditorPackage.eINSTANCE
				.getEditorDoTypReferenz_SystemObjekt()) {
			switch (msg.getEventType()) {
			case Notification.SET:
			case Notification.UNSET:
				configureDoTyp(msg);
				break;
			}
		}
	}

	private void configureDoTyp(final Notification msg) {
		final EditorDoTypReferenz doTyp = (EditorDoTypReferenz) msg
				.getNotifier();
		final SystemObjekt systemObjekt = (SystemObjekt) msg.getNewValue();

		configureDoTypId(doTyp, systemObjekt);
		configureDoTypName(doTyp, systemObjekt);
		configureDoTypWrapped(doTyp, systemObjekt);
		configureDoTypSystemObjectType(doTyp, doTyp.getWrapped());
	}

	private void configureDoTypId(final EditorDoTypReferenz doTyp,
			final SystemObjekt systemObjekt) {
		doTyp.setId(systemObjekt.getPid());
	}

	private void configureDoTypName(final EditorDoTypReferenz doTyp,
			final SystemObjekt systemObjekt) {
		doTyp.setName(systemObjekt.getName());
	}

	private void configureDoTypWrapped(final EditorDoTypReferenz doTyp,
			final SystemObjekt systemObjekt) {
		try {
			doTyp.setWrapped(DoEditorUtil
					.konvertiere((DarstellungsObjektTyp) systemObjekt));
		} catch (final IOException ex) {
			throw new IllegalStateException(
					"Der Darstellungsobjekttyp konnte nicht gelesen werden: "
							+ doTyp.getSystemObjekt(), ex);
		}
	}

	private void configureDoTypSystemObjectType(
			final EditorDoTypReferenz doTyp,
			final EditorDoTyp doTypKonfiguration) {
		doTyp.setSystemObjectType(doTypKonfiguration.getSystemObjectType());
	}

}
