/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.editors;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.editparts.DarstellungEditPartFactory;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.plugin.dobj.actions.ToggleOnlineAction;
import de.bsvrz.buv.plugin.dobj.editors.DobjGraphicalEditorWithPalette;
import de.bsvrz.buv.plugin.dopositionierer.editors.DarstellungEditorPaletteFactory;
import de.bsvrz.buv.plugin.dopositionierer.internal.DoPositioniererPlugin;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDarstellungEditor<T extends Darstellung>
extends DobjGraphicalEditorWithPalette<T> {
    private PaletteRoot paletteRoot;
    private SpeicherKey einstellungsArt;

    protected AbstractDarstellungEditor(Class<T> modelClass) {
        super(modelClass);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = new DarstellungEditorPaletteFactory().createPalette();
        }
        return this.paletteRoot;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.einstellungsArt = (SpeicherKey)input.getAdapter(SpeicherKey.class);
    }

    public String getContributorId() {
        return "de.bsvrz.buv.plugin.dopositionierer.propertyContributor";
    }

    protected EditPartFactory getEditPartFactory() {
        return new DarstellungEditPartFactory();
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().setProperty("de.bsvrz.buv.plugin.dobj.editor", (Object)true);
        this.getGraphicalViewer().setProperty("de.bsvrz.buv.plugin.dobj.editorType", (Object)2);
        super.configureGraphicalViewer();
        ActionRegistry registry = this.getActionRegistry();
        ToggleOnlineAction action = new ToggleOnlineAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    public void doSave(IProgressMonitor monitor) {
        Darstellung darstellung = (Darstellung)this.getModel();
        IStatus status = EmfUtil.validate((EObject)darstellung, (String)"de.bsvrz.buv.plugin.dopositionierer");
        if (status.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Darstellung kann nicht gespeichert werden.", (String)"Die zu speichernde Darstellung ist ung\u00fcltig und kann nicht gespeichert werden.", (IStatus)status);
            DoPositioniererPlugin.getDefault().getLog().log(status);
            return;
        }
        try {
            DarstellungenEinstellungen.INSTANCE.setModellEinstellungen(this.einstellungsArt, darstellung.getName(), (Object)darstellung);
            this.getCommandStack().markSaveLocation();
        }
        catch (UrlasserDialogAbgebrochenException urlasserDialogAbgebrochenException) {
        }
        catch (IOException ex) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"FEHLER", (String)"Darstellung konnte nicht gesichert werden!", (IStatus)new Status(4, "de.bsvrz.buv.plugin.dopositionierer", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    public Object getAdapter(Class type) {
        if (type == Darstellung.class) {
            return this.getModel();
        }
        return super.getAdapter(type);
    }
}

