/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.internal;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dopositionierer.editors.MassstaeblicheDarstellungEditor;
import de.bsvrz.buv.plugin.dopositionierer.editors.StilisierteDarstellungEditor;
import de.bsvrz.buv.plugin.dopositionierer.perspectives.DoPositioniererPerspective;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public enum DarstellungsTyp {
    Massstaeblich("Ma\u00dfst\u00e4bliche Darstellung", DarstellungPackage.Literals.MASSSTAEBLICHE_DARSTELLUNG, MassstaeblicheDarstellungEditor.EDITOR_ID),
    Stilisiert("Stilisierte Darstellung", DarstellungPackage.Literals.STILISIERTE_DARSTELLUNG, StilisierteDarstellungEditor.EDITOR_ID);

    private String name;
    private EClass clazz;
    private String editorId;

    public static void openEditor(IEditorInput input) {
        DarstellungsTyp typ = DarstellungsTyp.valueOf((Darstellung)input.getAdapter(Darstellung.class));
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            if ((page.getPerspective() == null || !page.getPerspective().getId().equals(DoPositioniererPerspective.PERSPECTIVE_ID)) && MessageDialog.openQuestion((Shell)window.getShell(), (String)"Frage", (String)"Der Editor f\u00fcr eine Darstellung sollte in der Perspektive des Vorpositionierer ge\u00f6ffnet werden. Wollen Sie jetzt zur Vorpositioniererperspektive wechseln?")) {
                IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(DoPositioniererPerspective.PERSPECTIVE_ID);
                page.setPerspective(perspective);
            }
            page.openEditor(input, typ.editorId);
        }
        catch (WorkbenchException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private DarstellungsTyp(String name, EClass clazz, String editorId) {
        this.name = name;
        this.clazz = clazz;
        this.editorId = editorId;
    }

    public Darstellung create() {
        Darstellung darstellung = (Darstellung)DarstellungFactory.eINSTANCE.create(this.clazz);
        Ebene ebene = darstellung.createEbene();
        darstellung.getEbenen().add((Object)ebene);
        if (darstellung instanceof MassstaeblicheDarstellung) {
            darstellung.getZoomStufen().add((Object)1.0E-4);
            darstellung.getZoomStufen().add((Object)1.5E-4);
            darstellung.getZoomStufen().add((Object)2.0E-4);
            darstellung.getZoomStufen().add((Object)2.5E-4);
            darstellung.getZoomStufen().add((Object)5.0E-4);
            darstellung.getZoomStufen().add((Object)0.001);
            darstellung.getZoomStufen().add((Object)0.005);
            darstellung.getZoomStufen().add((Object)0.01);
            darstellung.getZoomStufen().add((Object)0.05);
            darstellung.getZoomStufen().add((Object)0.1);
            darstellung.getZoomStufen().add((Object)0.5);
            darstellung.getZoomStufen().add((Object)1.0);
            darstellung.setZoomSkalierung(5000.0);
        } else if (darstellung instanceof StilisierteDarstellung) {
            darstellung.setSize(new Dimension(1000, 1000));
            darstellung.getZoomStufen().add((Object)0.5);
            darstellung.getZoomStufen().add((Object)0.75);
            darstellung.getZoomStufen().add((Object)1.0);
            darstellung.getZoomStufen().add((Object)1.5);
            darstellung.getZoomStufen().add((Object)2.0);
            darstellung.getZoomStufen().add((Object)2.5);
            darstellung.getZoomStufen().add((Object)3.0);
            darstellung.getZoomStufen().add((Object)4.0);
        }
        return darstellung;
    }

    public String toString() {
        return this.name;
    }

    public static DarstellungsTyp valueOf(String string) {
        return Enum.valueOf(DarstellungsTyp.class, string);
    }
}

