/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.dopositionierer.internal.RahmenwerkService;
import de.bsvrz.buv.rw.bitctrl.eclipse.dialogs.SystemObjectSelectionDialog;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DarstellungSection
extends AbstractSection<Darstellung> {
    private Text netzText;
    private Button systemObjectSelectButton;
    private ComboViewer stoerfallVerfahrenComboViewer;
    private ComboViewer anzeigeVerfahrenComboViewer;
    private CLabel stoerfallVerfahrenText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite container = factory.createFlatFormComposite(parent);
        this.createNetz(container);
    }

    private void createNetz(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.netzText = factory.createText(parent, "");
        this.netzText.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment(0, 4);
        this.netzText.setLayoutData((Object)data);
        CLabel systemObjectLabel = factory.createCLabel(parent, "Netz:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.netzText, -5);
        data.top = new FormAttachment((Control)this.netzText, 0, 0x1000000);
        systemObjectLabel.setLayoutData((Object)data);
        this.systemObjectSelectButton = factory.createButton(parent, "Ausw\u00e4hlen", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.netzText, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.netzText, 0, 0x1000000);
        this.systemObjectSelectButton.setLayoutData((Object)data);
        this.systemObjectSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemObject so;
                ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
                SystemObjectType netzType = objektFactory.getDav().getDataModel().getType("typ.netz");
                SelectionDialog dialog = SystemObjectSelectionDialog.createListSelectionDialog((Shell)e.widget.getDisplay().getActiveShell(), (SystemObjectType)netzType, (int)132);
                if (((Darstellung)DarstellungSection.this.getElement()).getNetz() != null && (so = ((Darstellung)DarstellungSection.this.getElement()).getNetz().getSystemObject()) != null) {
                    dialog.setInitialElementSelections(Collections.singletonList(so));
                }
                if (dialog.open() == 0) {
                    so = SystemObjectSelectionDialog.getFirstSelectedObject((SelectionDialog)dialog);
                    Netz netz = so != null ? (Netz)objektFactory.getModellobjekt(so) : null;
                    SetCommand cmd = new SetCommand(DarstellungSection.this.getElement(), (EStructuralFeature)DarstellungPackage.Literals.DARSTELLUNG__NETZ, (Object)netz);
                    DarstellungSection.this.getCommandStack().execute((Command)cmd);
                }
            }
        });
        this.createStorefallVerfahrenControls(parent, factory);
        this.createAnzeigeVerfahrenControls(parent, factory);
    }

    private void createStorefallVerfahrenControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.stoerfallVerfahrenText = factory.createCLabel(parent, "St\u00f6rfallverfahren:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.netzText, -5);
        data.top = new FormAttachment((Control)this.netzText, 4, 16384);
        this.stoerfallVerfahrenText.setLayoutData((Object)data);
        CCombo stoerfallcombo = factory.createCCombo(parent, 8);
        this.stoerfallVerfahrenComboViewer = new ComboViewer(stoerfallcombo);
        data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.stoerfallVerfahrenText, 0, 0x1000000);
        this.stoerfallVerfahrenComboViewer.getCCombo().setLayoutData((Object)data);
        this.stoerfallVerfahrenComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ClientDavInterface dav = RahmenwerkService.getService().getObjektFactory().getDav();
        AttributeGroup atg = dav.getDataModel().getAttributeGroup("atg.st\u00f6rfallZustand");
        this.stoerfallVerfahrenComboViewer.setInput((Object)atg.getAspects());
        this.stoerfallVerfahrenComboViewer.addSelectionChangedListener((ISelectionChangedListener)new StoerfallVerfahrenChangedListener());
    }

    private void createAnzeigeVerfahrenControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        CLabel label = factory.createCLabel(parent, "Anzeigeverfahren:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.netzText, -5);
        data.top = new FormAttachment((Control)this.stoerfallVerfahrenText, 4, 16384);
        label.setLayoutData((Object)data);
        CCombo combo = factory.createCCombo(parent, 8);
        this.anzeigeVerfahrenComboViewer = new ComboViewer(combo);
        data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)label, 0, 0x1000000);
        this.anzeigeVerfahrenComboViewer.getCCombo().setLayoutData((Object)data);
        this.anzeigeVerfahrenComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.anzeigeVerfahrenComboViewer.setInput((Object)AnzeigeVerfahren.VALUES);
        this.anzeigeVerfahrenComboViewer.addSelectionChangedListener((ISelectionChangedListener)new AnzeigeVerfahrenChangedListener());
    }

    public void refresh() {
        Netz netz = ((Darstellung)this.getElement()).getNetz();
        if (netz != null) {
            this.netzText.setText(netz.toString());
        } else {
            this.netzText.setText("");
        }
        this.refresStoerfallVerfahren();
        this.refreshAnzeigeVerfahren();
    }

    private void refreshAnzeigeVerfahren() {
        AnzeigeVerfahren anzeigeVerfahren = ((Darstellung)this.getElement()).getAnzeigeVerfahren();
        if (anzeigeVerfahren != null) {
            this.anzeigeVerfahrenComboViewer.setSelection((ISelection)new StructuredSelection((Object)anzeigeVerfahren));
        } else {
            this.anzeigeVerfahrenComboViewer.setSelection((ISelection)new StructuredSelection((Object)AnzeigeVerfahren.VERFAHREN_I));
        }
    }

    private void refresStoerfallVerfahren() {
        String stoerfallverfahrenPid = ((Darstellung)this.getElement()).getStoerfallverfahren();
        ClientDavInterface dav = RahmenwerkService.getService().getObjektFactory().getDav();
        Aspect stoerfallVerfahren = dav.getDataModel().getAspect(stoerfallverfahrenPid);
        if (stoerfallVerfahren != null) {
            this.stoerfallVerfahrenComboViewer.setSelection((ISelection)new StructuredSelection((Object)stoerfallVerfahren));
        } else {
            this.stoerfallVerfahrenComboViewer.setSelection((ISelection)new StructuredSelection((Object)dav.getDataModel().getAspect("asp.st\u00f6rfallVerfahrenMARZ")));
        }
    }

    private final class AnzeigeVerfahrenChangedListener
    implements ISelectionChangedListener {
        private AnzeigeVerfahrenChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection isel = (IStructuredSelection)event.getSelection();
            Object firstElement = isel.getFirstElement();
            AnzeigeVerfahren anzeigeVerfahren = ((Darstellung)DarstellungSection.this.getElement()).getAnzeigeVerfahren();
            if (firstElement instanceof AnzeigeVerfahren && !Objects.equals(anzeigeVerfahren, firstElement)) {
                SetCommand cmd = new SetCommand(DarstellungSection.this.getElement(), (EStructuralFeature)DarstellungPackage.Literals.DARSTELLUNG__ANZEIGE_VERFAHREN, firstElement);
                DarstellungSection.this.getCommandStack().execute((Command)cmd);
            }
        }
    }

    private final class StoerfallVerfahrenChangedListener
    implements ISelectionChangedListener {
        private StoerfallVerfahrenChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection isel = (IStructuredSelection)event.getSelection();
            Object firstElement = isel.getFirstElement();
            String aktuellesStoerfallVerfahren = ((Darstellung)DarstellungSection.this.getElement()).getStoerfallverfahren();
            if (firstElement instanceof Aspect && !Objects.equals(((Aspect)firstElement).getPid(), aktuellesStoerfallVerfahren)) {
                SetCommand cmd = new SetCommand(DarstellungSection.this.getElement(), (EStructuralFeature)DarstellungPackage.Literals.DARSTELLUNG__STOERFALLVERFAHREN, (Object)((Aspect)firstElement).getPid());
                DarstellungSection.this.getCommandStack().execute((Command)cmd);
            }
        }
    }
}

