/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.dopositionierer.internal.RahmenwerkService;
import de.bsvrz.buv.rw.bitctrl.eclipse.dialogs.SystemObjectSelectionDialog;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DoSection
extends AbstractSection<DoModel> {
    private static final String REMOVE_RELATIV_ZU = "<Referenz l\u00f6schen>";
    private Text relativZuText;
    private Button doSelectButton;
    private Text systemObjectText;
    private Button systemObjectSelectButton;
    private final Map<String, SystemObject> systemObjectMap = new HashMap<String, SystemObject>();
    private SystemObjectType currentSystemObjectMapType;
    private AutoCompleteField autoCompleteField;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite container = factory.createFlatFormComposite(parent);
        this.createLocation(container);
        this.createSystemObject(container);
    }

    private void createLocation(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.relativZuText = factory.createText(parent, "");
        this.relativZuText.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment(0, 4);
        this.relativZuText.setLayoutData((Object)data);
        CLabel label = factory.createCLabel(parent, "Relativ zu:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.relativZuText, -5);
        data.top = new FormAttachment((Control)this.relativZuText, 0, 0x1000000);
        label.setLayoutData((Object)data);
        this.doSelectButton = factory.createButton(parent, "Ausw\u00e4hlen", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.relativZuText, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.relativZuText, 0, 0x1000000);
        this.doSelectButton.setLayoutData((Object)data);
        this.doSelectButton.addSelectionListener((SelectionListener)new SelectRelativZuDoAdapter());
    }

    private void createSystemObject(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.systemObjectText = factory.createText(parent, "", 384);
        this.systemObjectText.setData((Object)true);
        this.systemObjectText.setEditable(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment((Control)this.relativZuText, 4);
        this.systemObjectText.setLayoutData((Object)data);
        this.autoCompleteField = new AutoCompleteField((Control)this.systemObjectText, (IControlContentAdapter)new TextContentAdapter(), new String[0]);
        this.systemObjectText.addModifyListener((ModifyListener)new SystemObjectTextModifyListener());
        this.systemObjectText.addKeyListener((KeyListener)new SystemObjectKeyListener());
        this.systemObjectText.addFocusListener((FocusListener)new SystemObjectTextFocusListener());
        CLabel systemObjectLabel = factory.createCLabel(parent, "Systemobjekt:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.systemObjectText, -5);
        data.top = new FormAttachment((Control)this.systemObjectText, 0, 0x1000000);
        systemObjectLabel.setLayoutData((Object)data);
        this.systemObjectSelectButton = factory.createButton(parent, "Ausw\u00e4hlen", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.systemObjectText, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.systemObjectText, 0, 0x1000000);
        this.systemObjectSelectButton.setLayoutData((Object)data);
        this.systemObjectSelectButton.addSelectionListener((SelectionListener)new SelectSystemObjektAdapter());
    }

    public void refresh() {
        SystemObjectType systemObjectType = ((DoModel)this.getElement()).getDoTyp().getSystemObjectType();
        this.relativZuText.setText(EmfUtil.getText((EObject)((DoModel)this.getElement()).getRelativZu()));
        if (systemObjectType == null) {
            this.systemObjectText.setEnabled(false);
            this.systemObjectSelectButton.setEnabled(false);
        } else {
            this.systemObjectText.setEnabled(true);
            this.systemObjectSelectButton.setEnabled(true);
            SystemObject so = ((DoModel)this.getElement()).getSystemObject();
            if (so != null) {
                this.systemObjectText.setText(so.toString());
            } else if (!this.systemObjectText.getText().isEmpty()) {
                this.systemObjectText.setText("");
            }
            this.systemObjectText.setData((Object)true);
            this.systemObjectText.setBackground(null);
            if (this.currentSystemObjectMapType != systemObjectType) {
                this.currentSystemObjectMapType = systemObjectType;
                this.systemObjectMap.clear();
                ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
                List modellobjekte = objektFactory.bestimmeModellobjekte(new String[]{systemObjectType.getPid()});
                StringBuilder sb = new StringBuilder();
                for (SystemObjekt o : modellobjekte) {
                    sb.setLength(0);
                    SystemObject sysobj = o.getSystemObject();
                    String pid = o.getPid();
                    this.systemObjectMap.put(o.toString(), sysobj);
                    if (pid != null && !pid.isEmpty()) {
                        sb.append(pid);
                    } else {
                        sb.append(o.getId());
                    }
                    this.systemObjectMap.put(sb.toString(), sysobj);
                }
                String[] keys = new ArrayList<String>(this.systemObjectMap.keySet()){
                    {
                        Collections.sort(this);
                    }
                }.toArray(new String[this.systemObjectMap.size()]);
                this.autoCompleteField.setProposals(keys);
            }
        }
    }

    private final class SelectRelativZuDoAdapter
    extends SelectionAdapter {
        private SelectRelativZuDoAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)DoSection.this.getElement());
            TreeIterator allContents = EcoreUtil.getAllContents((EObject)rootContainer, (boolean)true);
            ArrayList<Object> contents = new ArrayList<Object>();
            while (allContents.hasNext()) {
                Object o = allContents.next();
                if (!(o instanceof DoModel)) continue;
                contents.add(o);
            }
            contents.remove(DoSection.this.getElement());
            if (contents.isEmpty()) {
                MessageDialog.openInformation((Shell)e.widget.getDisplay().getActiveShell(), (String)"Information", (String)"Es gibt keine anderen Darstellungsobjekte auf die referenziert werden kann.");
                return;
            }
            contents.add(0, DoSection.REMOVE_RELATIV_ZU);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(e.widget.getDisplay().getActiveShell(), (ILabelProvider)new EmfLabelProvider());
            dialog.setTitle("Darstellungsobjekt ausw\u00e4hlen");
            dialog.setMessage("Bitte w\u00e4hlen ein anderes Darstellungsobjekt zu dem dieses relativ positioniert werden soll.");
            dialog.setMultipleSelection(false);
            dialog.setElements(contents.toArray());
            DoModel doModel = ((DoModel)DoSection.this.getElement()).getRelativZu();
            if (doModel != null) {
                dialog.setInitialElementSelections(Collections.singletonList(doModel));
            }
            if (dialog.open() == 0) {
                Object value = DoSection.REMOVE_RELATIV_ZU.equals(dialog.getFirstResult()) ? null : dialog.getFirstResult();
                CompoundCommand cmd = new CompoundCommand();
                cmd.add((Command)new SetCommand(DoSection.this.getElement(), (EStructuralFeature)DobjPackage.Literals.DO_MODEL__RELATIV_ZU, value));
                if (value != null) {
                    Point location = ((DoModel)DoSection.this.getElement()).getAbsoluteLocation();
                    Dimension difference = location.getDifference(((DoModel)value).getLocation());
                    cmd.add((Command)new SetCommand(DoSection.this.getElement(), (EStructuralFeature)GefPackage.Literals.LOCATED__LOCATION, (Object)new Point(difference.width, difference.height)));
                } else {
                    Point location = ((DoModel)DoSection.this.getElement()).getRelativZu().getAbsoluteLocation().getCopy();
                    Point difference = ((DoModel)DoSection.this.getElement()).getLocation();
                    location.translate(difference);
                    cmd.add((Command)new SetCommand(DoSection.this.getElement(), (EStructuralFeature)GefPackage.Literals.LOCATED__LOCATION, (Object)location));
                }
                DoSection.this.getCommandStack().execute(cmd.unwrap());
            }
        }
    }

    private final class SelectSystemObjektAdapter
    extends SelectionAdapter {
        private SelectSystemObjektAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            SelectionDialog dialog = SystemObjectSelectionDialog.createListSelectionDialog((Shell)e.widget.getDisplay().getActiveShell(), (SystemObjectType)((DoModel)DoSection.this.getElement()).getDoTyp().getSystemObjectType(), (int)132);
            SystemObject so = ((DoModel)DoSection.this.getElement()).getSystemObject();
            if (so != null) {
                dialog.setInitialElementSelections(Collections.singletonList(so));
            }
            if (dialog.open() == 0) {
                SetCommand cmd = new SetCommand(DoSection.this.getElement(), (EStructuralFeature)DobjPackage.Literals.DO_MODEL__SYSTEM_OBJECT, (Object)SystemObjectSelectionDialog.getFirstSelectedObject((SelectionDialog)dialog));
                DoSection.this.getCommandStack().execute((Command)cmd);
            }
        }
    }

    private final class SystemObjectKeyListener
    extends KeyAdapter {
        private SystemObjectKeyListener() {
        }

        private void resetText() {
            String string;
            SystemObject sysObj = ((DoModel)DoSection.this.getElement()).getSystemObject();
            String string2 = string = sysObj == null ? "" : sysObj.toString();
            if (!string.equals(DoSection.this.systemObjectText.getText())) {
                DoSection.this.systemObjectText.setText(string);
            }
            DoSection.this.systemObjectText.setBackground(null);
        }

        public void keyPressed(KeyEvent event) {
            switch (event.character) {
                case '\u001b': {
                    DoSection.this.systemObjectText.setData((Object)true);
                    this.resetText();
                    break;
                }
                case '\r': {
                    Object data = DoSection.this.systemObjectText.getData();
                    if (data == null || data instanceof SystemObject) {
                        SetCommand cmd = new SetCommand(DoSection.this.getElement(), (EStructuralFeature)DobjPackage.Literals.DO_MODEL__SYSTEM_OBJECT, data);
                        DoSection.this.getCommandStack().execute((Command)cmd);
                        break;
                    }
                    if (Boolean.FALSE.equals(data)) {
                        DoSection.this.systemObjectText.setBackground(ColorConstants.red);
                        break;
                    }
                    if (!Boolean.TRUE.equals(data)) break;
                    this.resetText();
                }
            }
        }
    }

    private final class SystemObjectTextFocusListener
    extends FocusAdapter {
        private SystemObjectTextFocusListener() {
        }

        public void focusLost(FocusEvent event) {
            Object data = DoSection.this.systemObjectText.getData();
            if (data == null || data instanceof SystemObject) {
                SetCommand cmd = new SetCommand(DoSection.this.getElement(), (EStructuralFeature)DobjPackage.Literals.DO_MODEL__SYSTEM_OBJECT, data);
                DoSection.this.getCommandStack().execute((Command)cmd);
            }
        }
    }

    private final class SystemObjectTextModifyListener
    implements ModifyListener {
        private final Pattern trimPattern = Pattern.compile("^(\\s+)?(.*?)(\\s+)?$", 32);

        private SystemObjectTextModifyListener() {
        }

        private boolean checkInput(String string) {
            SystemObject sysObj = ((DoModel)DoSection.this.getElement()).getSystemObject();
            SystemObject newSysObj = (SystemObject)DoSection.this.systemObjectMap.get(string);
            if (string.isEmpty() || newSysObj != null) {
                if (sysObj != newSysObj) {
                    DoSection.this.systemObjectText.setBackground(ColorConstants.green);
                    DoSection.this.systemObjectText.setData((Object)newSysObj);
                    DoSection.this.systemObjectText.forceFocus();
                } else {
                    DoSection.this.systemObjectText.setBackground(null);
                    DoSection.this.systemObjectText.setData((Object)true);
                }
                return true;
            }
            return false;
        }

        public void modifyText(ModifyEvent event) {
            if (DoSection.this.systemObjectMap.size() == 0) {
                return;
            }
            String txt = DoSection.this.systemObjectText.getText();
            if (this.checkInput(txt)) {
                return;
            }
            Matcher m = this.trimPattern.matcher(txt);
            m.matches();
            if ((m.start(1) != -1 || m.start(3) != -1) && this.checkInput(txt = m.group(2))) {
                return;
            }
            int len = txt.length();
            char lastChar = txt.charAt(len - 1);
            char[][] cArrayArray = new char[][]{{'(', ')'}, {'[', ']'}};
            int n = cArrayArray.length;
            int n2 = 0;
            while (n2 < n) {
                char[] c = cArrayArray[n2];
                if (lastChar == c[1]) {
                    int pos = txt.lastIndexOf(c[0]);
                    StringBuilder sb = new StringBuilder();
                    String[] parts = new String[]{m.reset(txt.substring(0, pos)).matches() ? m.group(2) : "", m.reset(txt.substring(pos + 1, len - 1)).matches() ? m.group(2) : ""};
                    if (!parts[0].isEmpty()) {
                        sb.append(parts[0]);
                        if (!parts[1].isEmpty()) {
                            sb.append(' ').append(c[0]).append(parts[1]).append(c[1]);
                        }
                    } else {
                        sb.append(parts[1]);
                    }
                    if (this.checkInput(sb.toString())) {
                        return;
                    }
                    DoSection.this.systemObjectText.setText(parts[((DoSection)DoSection.this).systemObjectText.getSelection().x < pos ? 0 : 1]);
                    break;
                }
                ++n2;
            }
            DoSection.this.systemObjectText.setBackground(ColorConstants.yellow);
            DoSection.this.systemObjectText.setData((Object)false);
        }
    }
}

