/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.widgets.TextChangeHelper;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjFactory;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DoTypSection
extends AbstractSection<DoTyp> {
    private final TextChangeHelper textListener = new TextChangeHelper(){

        public void textChanged(Text text) {
            Object value;
            EReference feature;
            if (text == DoTypSection.this.vonLevelText || text == DoTypSection.this.bisLevelText) {
                ZoomStufe zoomStufe = (ZoomStufe)EcoreUtil.copy((EObject)((DoTyp)DoTypSection.this.getElement()).getZoomStufe());
                if (zoomStufe == null) {
                    zoomStufe = DobjFactory.eINSTANCE.createZoomStufe();
                    zoomStufe.setVonLevel(Integer.MIN_VALUE);
                    zoomStufe.setBisLevel(Integer.MAX_VALUE);
                }
                feature = DobjPackage.Literals.DO_TYP__ZOOM_STUFE;
                if (text == DoTypSection.this.vonLevelText) {
                    int vonLevel;
                    try {
                        vonLevel = Integer.parseInt(text.getText());
                    }
                    catch (NumberFormatException ex) {
                        vonLevel = Integer.MIN_VALUE;
                    }
                    zoomStufe.setVonLevel(vonLevel);
                } else if (text == DoTypSection.this.bisLevelText) {
                    int bisLevel;
                    try {
                        bisLevel = Integer.parseInt(text.getText());
                    }
                    catch (NumberFormatException ex) {
                        bisLevel = Integer.MAX_VALUE;
                    }
                    zoomStufe.setBisLevel(bisLevel);
                }
                value = zoomStufe.getVonLevel() == Integer.MIN_VALUE && zoomStufe.getBisLevel() == Integer.MAX_VALUE ? null : zoomStufe;
            } else {
                return;
            }
            SetCommand cmd = new SetCommand(DoTypSection.this.getElement(), (EStructuralFeature)feature, value);
            DoTypSection.this.getCommandStack().execute((Command)cmd);
        }
    };
    private Text vonLevelText;
    private Text bisLevelText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite container = factory.createFlatFormComposite(parent);
        this.createZoomStufe(container);
    }

    private void createZoomStufe(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.vonLevelText = factory.createText(parent, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(0, 4);
        this.vonLevelText.setLayoutData((Object)data);
        CLabel label = factory.createCLabel(parent, "Zoomlevel von (in %):");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.vonLevelText, -5);
        data.top = new FormAttachment((Control)this.vonLevelText, 0, 0x1000000);
        label.setLayoutData((Object)data);
        this.bisLevelText = factory.createText(parent, "");
        data = new FormData();
        data.left = new FormAttachment((Control)this.vonLevelText, 170);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.vonLevelText, 0, 0x1000000);
        this.bisLevelText.setLayoutData((Object)data);
        label = factory.createCLabel(parent, "Zoomlevel bis (in %):");
        data = new FormData();
        data.left = new FormAttachment(50, 5);
        data.right = new FormAttachment((Control)this.bisLevelText, -5);
        data.top = new FormAttachment((Control)this.bisLevelText, 0, 0x1000000);
        label.setLayoutData((Object)data);
        this.textListener.startListeningTo(this.vonLevelText);
        this.textListener.startListeningTo(this.bisLevelText);
    }

    public void refresh() {
        this.textListener.startNonUserChange();
        try {
            if (((DoTyp)this.getElement()).getZoomStufe() != null) {
                int vonLevel = ((DoTyp)this.getElement()).getZoomStufe().getVonLevel();
                if (vonLevel > Integer.MIN_VALUE) {
                    this.vonLevelText.setText(String.valueOf(vonLevel));
                } else {
                    this.vonLevelText.setText("");
                }
                int bisLevel = ((DoTyp)this.getElement()).getZoomStufe().getBisLevel();
                if (bisLevel < Integer.MAX_VALUE) {
                    this.bisLevelText.setText(String.valueOf(bisLevel));
                } else {
                    this.bisLevelText.setText("");
                }
            } else {
                this.vonLevelText.setText("");
                this.bisLevelText.setText("");
            }
        }
        finally {
            this.textListener.finishNonUserChange();
        }
    }
}

