/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.widgets.TextChangeHelper;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.dobj.util.BildManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EbeneHintergrundSection
extends AbstractSection<Ebene> {
    private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object value;
            EAttribute feature;
            if (event.getSelectionProvider() == EbeneHintergrundSection.this.hintergrundComboBox) {
                feature = DarstellungPackage.Literals.EBENE__HINTERGRUND;
                value = !event.getSelection().isEmpty() ? ((IStructuredSelection)event.getSelection()).getFirstElement() : null;
            } else {
                return;
            }
            SetCommand cmd = new SetCommand(EbeneHintergrundSection.this.getElement(), (EStructuralFeature)feature, value);
            EbeneHintergrundSection.this.getCommandStack().execute((Command)cmd);
        }
    };
    private final SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Point hintergrundLocation;
            Point value;
            EAttribute feature;
            if (e.widget == EbeneHintergrundSection.this.enableCheckBox) {
                EbeneHintergrundSection.this.setEnable(EbeneHintergrundSection.this.enableCheckBox.getSelection());
                if (EbeneHintergrundSection.this.enableCheckBox.getSelection()) {
                    return;
                }
                feature = DarstellungPackage.Literals.EBENE__HINTERGRUND;
                value = null;
            } else if (e.widget == EbeneHintergrundSection.this.hintergrundXSpinner) {
                feature = DarstellungPackage.Literals.EBENE__HINTERGRUND_LOCATION;
                hintergrundLocation = ((Ebene)EbeneHintergrundSection.this.getElement()).getHintergrundLocation();
                if (hintergrundLocation == null) {
                    hintergrundLocation = new Point();
                }
                value = new Point(EbeneHintergrundSection.this.hintergrundXSpinner.getSelection(), hintergrundLocation.y);
            } else if (e.widget == EbeneHintergrundSection.this.hintergrundYSpinner) {
                feature = DarstellungPackage.Literals.EBENE__HINTERGRUND_LOCATION;
                hintergrundLocation = ((Ebene)EbeneHintergrundSection.this.getElement()).getHintergrundLocation();
                if (hintergrundLocation == null) {
                    hintergrundLocation = new Point();
                }
                value = new Point(hintergrundLocation.x, EbeneHintergrundSection.this.hintergrundYSpinner.getSelection());
            } else {
                return;
            }
            SetCommand cmd = new SetCommand(EbeneHintergrundSection.this.getElement(), (EStructuralFeature)feature, value);
            EbeneHintergrundSection.this.getCommandStack().execute((Command)cmd);
        }
    };
    private final TextChangeHelper textListener = new TextChangeHelper(){

        public void textChanged(Text text) {
            if (text != EbeneHintergrundSection.this.hintergrundSkalierungText) {
                return;
            }
            EAttribute feature = DarstellungPackage.Literals.EBENE__HINTERGRUND_SKALIERUNG;
            Double value = Double.valueOf(text.getText());
            SetCommand cmd = new SetCommand(EbeneHintergrundSection.this.getElement(), (EStructuralFeature)feature, (Object)value);
            EbeneHintergrundSection.this.getCommandStack().execute((Command)cmd);
        }
    };
    private Button enableCheckBox;
    private ComboViewer hintergrundComboBox;
    private Label hintergrundLabel;
    private Text hintergrundSkalierungText;
    private Label hintergrundSkalierungLabel;
    private Spinner hintergrundXSpinner;
    private Label hintergrundXLabel;
    private Spinner hintergrundYSpinner;
    private Label hintergrundYLabel;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite container = factory.createFlatFormComposite(parent);
        this.createHintergrund(container);
        this.createHintergrundSkalierung(container);
        this.createHintergrundPosition(container);
    }

    private void setEnable(boolean enable) {
        this.hintergrundLabel.setEnabled(enable);
        this.hintergrundComboBox.getControl().setEnabled(enable);
        this.hintergrundSkalierungLabel.setEnabled(enable);
        this.hintergrundSkalierungText.setEnabled(enable);
        this.hintergrundXLabel.setEnabled(enable);
        this.hintergrundXSpinner.setEnabled(enable);
        this.hintergrundYSpinner.setEnabled(enable);
        this.hintergrundYLabel.setEnabled(enable);
    }

    private void createHintergrund(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.enableCheckBox = factory.createButton(parent, "Ein Hintergrundbild f\u00fcr diese Ebene verwenden", 32);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.enableCheckBox.setLayoutData((Object)data);
        CCombo comboBox = factory.createCCombo(parent);
        data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.enableCheckBox, 4);
        comboBox.setLayoutData((Object)data);
        this.hintergrundComboBox = new ComboViewer(comboBox);
        this.hintergrundComboBox.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.hintergrundComboBox.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hintergrundComboBox.setInput((Object)BildManager.INSTANCE.getBilder());
        this.hintergrundLabel = factory.createLabel(parent, "Hintergrundbild:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(this.hintergrundComboBox.getControl(), -5);
        data.top = new FormAttachment(this.hintergrundComboBox.getControl(), 0, 0x1000000);
        this.hintergrundLabel.setLayoutData((Object)data);
        this.enableCheckBox.addSelectionListener(this.selectionListener);
        this.hintergrundComboBox.addSelectionChangedListener(this.selectionChangedListener);
    }

    private void createHintergrundSkalierung(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.hintergrundSkalierungText = factory.createText(parent, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(this.hintergrundComboBox.getControl(), 4);
        this.hintergrundSkalierungText.setLayoutData((Object)data);
        this.hintergrundSkalierungLabel = factory.createLabel(parent, "Skalierung:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.hintergrundSkalierungText, -5);
        data.top = new FormAttachment((Control)this.hintergrundSkalierungText, 0, 0x1000000);
        this.hintergrundSkalierungLabel.setLayoutData((Object)data);
        this.textListener.startListeningTo(this.hintergrundSkalierungText);
    }

    private void createHintergrundPosition(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.hintergrundXSpinner = new Spinner(parent, 2048);
        this.hintergrundXSpinner.setMaximum(Integer.MAX_VALUE);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment((Control)this.hintergrundSkalierungText, 4);
        this.hintergrundXSpinner.setLayoutData((Object)data);
        factory.adapt((Control)this.hintergrundXSpinner, true, true);
        this.hintergrundXLabel = factory.createLabel(parent, "X-Position:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.hintergrundXSpinner, -5);
        data.top = new FormAttachment((Control)this.hintergrundXSpinner, 0, 0x1000000);
        this.hintergrundXLabel.setLayoutData((Object)data);
        this.hintergrundYSpinner = new Spinner(parent, 2048);
        this.hintergrundYSpinner.setMaximum(Integer.MAX_VALUE);
        data = new FormData();
        data.left = new FormAttachment((Control)this.hintergrundXSpinner, 170);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.hintergrundXSpinner, 0, 0x1000000);
        this.hintergrundYSpinner.setLayoutData((Object)data);
        factory.adapt((Control)this.hintergrundYSpinner, true, true);
        this.hintergrundYLabel = factory.createLabel(parent, "Y-Position:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.hintergrundXSpinner, 0);
        data.right = new FormAttachment((Control)this.hintergrundYSpinner, -5);
        data.top = new FormAttachment((Control)this.hintergrundYSpinner, 0, 0x1000000);
        this.hintergrundYLabel.setLayoutData((Object)data);
        this.hintergrundXSpinner.addSelectionListener(this.selectionListener);
        this.hintergrundYSpinner.addSelectionListener(this.selectionListener);
    }

    public void refresh() {
        IStructuredSelection selection = (IStructuredSelection)this.hintergrundComboBox.getSelection();
        if (((Ebene)this.getElement()).getHintergrund() != null) {
            this.enableCheckBox.setSelection(true);
            this.setEnable(true);
            if (selection.getFirstElement() != ((Ebene)this.getElement()).getHintergrund()) {
                this.hintergrundComboBox.setSelection((ISelection)new StructuredSelection((Object)((Ebene)this.getElement()).getHintergrund()));
            }
        } else {
            this.enableCheckBox.setSelection(false);
            this.setEnable(false);
            if (!selection.isEmpty()) {
                this.hintergrundComboBox.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
        this.textListener.startNonUserChange();
        try {
            this.hintergrundSkalierungText.setText(String.valueOf(((Ebene)this.getElement()).getHintergrundSkalierung()));
            if (((Ebene)this.getElement()).getHintergrundLocation() != null) {
                this.hintergrundXSpinner.setSelection(((Ebene)this.getElement()).getHintergrundLocation().x);
                this.hintergrundYSpinner.setSelection(((Ebene)this.getElement()).getHintergrundLocation().y);
            } else {
                this.hintergrundXSpinner.setSelection(0);
                this.hintergrundYSpinner.setSelection(0);
            }
        }
        finally {
            this.textListener.finishNonUserChange();
        }
    }
}

