/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.util;

import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjektComparator;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class StrassenCache {
    private final Map<Strasse, SortedSet<StrassenSegment>> strassen = new HashMap<Strasse, SortedSet<StrassenSegment>>();

    public StrassenCache(ObjektFactory objektFactory) {
        List strassensegmente = objektFactory.bestimmeModellobjekte(new String[]{"typ.stra\u00dfenSegment"});
        for (StrassenSegment ss : strassensegmente) {
            Strasse strasse;
            KdStrassenSegment.Daten strassenSegmentDaten = (KdStrassenSegment.Daten)ss.getKdStrassenSegment().getDatum();
            if (strassenSegmentDaten == null || (strasse = strassenSegmentDaten.getGehoertZuStrasse()) == null) continue;
            if (!this.strassen.containsKey(strasse)) {
                this.strassen.put(strasse, new TreeSet(new SystemObjektComparator()));
            }
            this.strassen.get(strasse).add(ss);
        }
    }

    Set<Strasse> getStrassen() {
        return this.strassen.keySet();
    }

    public SortedSet<StrassenSegment> getStrassenSegmente(Strasse strasse) {
        return this.strassen.get(strasse);
    }
}

