/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.util.DoTypenUtil;
import de.bsvrz.buv.plugin.dobj.viewers.DoTypenTreeContentProvider;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

public class DoTypWizardPage
extends WizardPage {
    public static final String PROP_DO_TYP = "doTyp";
    private final PropertyChangeSupport pcsDelegate = new PropertyChangeSupport((Object)this);
    private TreeViewer viewer;
    private DoTyp doTyp;

    public DoTypWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Darstellungsobjekttyp");
        this.setDescription("Bitte w\u00e4hlen Sie den zu verwendenden Darstellungsobjekttyp aus.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2052);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EmfLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new DoTypenTreeContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DoTypWizardPage.this.viewer.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof DoTyp) {
                    DoTypWizardPage.this.doTyp = (DoTyp)selection.getFirstElement();
                } else {
                    DoTypWizardPage.this.doTyp = null;
                }
                DoTypWizardPage.this.updatePageComplete();
                DoTypWizardPage.this.fireDoTypChanged();
            }
        });
        this.setControl(this.viewer.getControl());
    }

    private void updatePageComplete() {
        boolean pageComplete = true;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        pageComplete &= !selection.isEmpty();
        pageComplete &= this.doTyp != null;
        if (this.doTyp != null) {
            pageComplete &= this.doTyp.getSystemObjectType() != null;
        }
        this.setPageComplete(pageComplete);
    }

    public DoTyp getDoTyp() {
        return this.doTyp;
    }

    public void setSystemObjectType(SystemObjectType systemObjectType) {
        ArrayList<DoTyp> doTypen = new ArrayList<DoTyp>();
        if (systemObjectType != null) {
            for (DoTyp e : DoTypenUtil.getDoTypen()) {
                if (e.getSystemObjectType() == null || !e.getSystemObjectType().inheritsFrom(systemObjectType)) continue;
                doTypen.add(e);
            }
        }
        this.viewer.setInput(doTypen);
        this.updatePageComplete();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.removePropertyChangeListener(listener);
    }

    protected synchronized void fireDoTypChanged() {
        this.pcsDelegate.firePropertyChange(PROP_DO_TYP, null, this.doTyp);
    }
}

