/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import de.bsvrz.buv.plugin.dopositionierer.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dopositionierer.util.StrassenCache;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjektComparator;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StrassenSegmentWizardPage
extends WizardPage {
    public static final String PROP_STRASSE = "strasse";
    public static final String PROP_STRASSEN_SEGMENT = "strassenSegment";
    private final PropertyChangeSupport pcsDelegate = new PropertyChangeSupport((Object)this);
    private final StrassenCache strassenCache;
    private ComboViewer strassenViewer;
    private ComboViewer strassenSegmentViewer;
    private Strasse strasse;
    private StrassenSegment strassenSegment;

    public StrassenSegmentWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Stra\u00dfensegment");
        this.setDescription("Bitte w\u00e4hlen Sie hier ein Stra\u00dfensegment aus. Die Objekte auf diesen Stra\u00dfensegment stehen dann zur Auswahl.");
        this.setPageComplete(false);
        this.strassenCache = new StrassenCache(RahmenwerkService.getService().getObjektFactory());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)new GridLayout(2, false));
        this.createStrasse(container);
        this.createStrassenSegment(container);
        this.setControl((Control)container);
    }

    private void createStrasse(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Stra\u00dfe");
        this.strassenViewer = new ComboViewer(parent, 2048);
        this.strassenViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.strassenViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.strassenViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List strassen = RahmenwerkService.getService().getObjektFactory().bestimmeModellobjekte(new String[]{"typ.stra\u00dfe"});
        Collections.sort(strassen, new SystemObjektComparator());
        this.strassenViewer.setInput((Object)strassen);
        this.strassenViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Strasse oldValue = StrassenSegmentWizardPage.this.strasse;
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StrassenSegmentWizardPage.this.strasse = (Strasse)selection.getFirstElement();
                } else {
                    StrassenSegmentWizardPage.this.strasse = null;
                }
                StrassenSegmentWizardPage.this.strassenSegmentViewer.setInput((Object)StrassenSegmentWizardPage.this.strasse);
                StrassenSegmentWizardPage.this.updatePageComplete();
                StrassenSegmentWizardPage.this.pcsDelegate.firePropertyChange(StrassenSegmentWizardPage.PROP_STRASSE, oldValue, StrassenSegmentWizardPage.this.strasse);
            }
        });
    }

    private void createStrassenSegment(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Stra\u00dfensegment");
        this.strassenSegmentViewer = new ComboViewer(parent, 2048);
        this.strassenSegmentViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.strassenSegmentViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                InneresStrassenSegment iss;
                KdInneresStrassenSegment.Daten inneresStrassenSegmentDaten;
                if (element instanceof AeusseresStrassenSegment) {
                    AeusseresStrassenSegment aess = (AeusseresStrassenSegment)element;
                    KdAeusseresStrassenSegment.Daten aeusseresStrassenSegmentDaten = (KdAeusseresStrassenSegment.Daten)aess.getKdAeusseresStrassenSegment().getDatum();
                    if (aeusseresStrassenSegmentDaten != null) {
                        String result = aess.toString();
                        result = String.valueOf(result) + " von " + aeusseresStrassenSegmentDaten.getVonKnoten();
                        result = String.valueOf(result) + " nach " + aeusseresStrassenSegmentDaten.getNachKnoten();
                        return result;
                    }
                } else if (element instanceof InneresStrassenSegment && (inneresStrassenSegmentDaten = (KdInneresStrassenSegment.Daten)(iss = (InneresStrassenSegment)element).getKdInneresStrassenSegment().getDatum()) != null) {
                    String result = iss.toString();
                    result = String.valueOf(result) + " von " + inneresStrassenSegmentDaten.getVonStrassenSegment();
                    result = String.valueOf(result) + " nach " + inneresStrassenSegmentDaten.getNachStrassenSegment();
                    return result;
                }
                return super.getText(element);
            }
        });
        this.strassenSegmentViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                SortedSet<StrassenSegment> strassenSegmente;
                if (inputElement instanceof Strasse && (strassenSegmente = StrassenSegmentWizardPage.this.strassenCache.getStrassenSegmente((Strasse)inputElement)) != null) {
                    return strassenSegmente.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.strassenSegmentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StrassenSegment oldValue = StrassenSegmentWizardPage.this.strassenSegment;
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StrassenSegmentWizardPage.this.strassenSegment = (StrassenSegment)selection.getFirstElement();
                } else {
                    StrassenSegmentWizardPage.this.strassenSegment = null;
                }
                StrassenSegmentWizardPage.this.updatePageComplete();
                StrassenSegmentWizardPage.this.pcsDelegate.firePropertyChange(StrassenSegmentWizardPage.PROP_STRASSEN_SEGMENT, oldValue, StrassenSegmentWizardPage.this.strassenSegment);
            }
        });
    }

    private void updatePageComplete() {
        boolean pageComplete = true;
        pageComplete &= this.strasse != null;
        this.setPageComplete(pageComplete &= this.strassenSegment != null);
    }

    public Strasse getStrasse() {
        return this.strasse;
    }

    public StrassenSegment getStrassenSegment() {
        return this.strassenSegment;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.removePropertyChangeListener(listener);
    }
}

