/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import de.bsvrz.buv.plugin.dopositionierer.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjektComparator;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

public class SystemObjectsWizardPage
extends WizardPage {
    private TableViewer viewer;
    private final Set<SystemObjekt> systemObjekte = new HashSet<SystemObjekt>();
    private SystemObjectType systemObjectType;

    public SystemObjectsWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Systemobjekte");
        this.setDescription("Bitte w\u00e4hlen Sie die anzuzeigenden Systemobjekte aus.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.viewer = new TableViewer(parent);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SystemObjectsWizardPage.this.systemObjekte.clear();
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    for (Object e : selection.toList()) {
                        if (!(e instanceof SystemObjekt)) continue;
                        SystemObjectsWizardPage.this.systemObjekte.add((SystemObjekt)e);
                    }
                }
                SystemObjectsWizardPage.this.updatePageComplete();
            }
        });
        this.setControl(this.viewer.getControl());
    }

    private void updatePageComplete() {
        boolean pageComplete = true;
        this.setPageComplete(pageComplete &= !this.systemObjekte.isEmpty());
    }

    public Set<SystemObjekt> getSystemObjekte() {
        return this.systemObjekte;
    }

    public void setSystemObjectType(SystemObjectType systemObjectType) {
        this.systemObjectType = systemObjectType;
        ArrayList objekte = new ArrayList();
        if (systemObjectType != null) {
            ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
            objekte.addAll(objektFactory.bestimmeModellobjekte(new String[]{systemObjectType.getPid()}));
            Collections.sort(objekte, new SystemObjektComparator());
        }
        this.viewer.setInput(objekte);
        this.updatePageComplete();
    }

    public void setStrassenSegment(StrassenSegment strassenSegment) {
        ArrayList<PunktLiegtAufLinienObjekt> objekte = new ArrayList<PunktLiegtAufLinienObjekt>();
        if (this.systemObjectType != null && strassenSegment != null) {
            ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
            for (SystemObjekt so : objektFactory.bestimmeModellobjekte(new String[]{this.systemObjectType.getPid()})) {
                PunktLiegtAufLinienObjekt p = (PunktLiegtAufLinienObjekt)so;
                KdPunktLiegtAufLinienObjekt.Daten punktLiegtAufLinienObjektDaten = (KdPunktLiegtAufLinienObjekt.Daten)p.getKdPunktLiegtAufLinienObjekt().getDatum();
                if (punktLiegtAufLinienObjektDaten == null || !strassenSegment.equals(punktLiegtAufLinienObjektDaten.getLinienReferenz())) continue;
                objekte.add(p);
            }
            Collections.sort(objekte, new SystemObjektComparator());
        }
        this.viewer.setInput(objekte);
        this.updatePageComplete();
    }
}

