/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz;

public class DynamicScaleProvider implements IScaleProvider<Integer> {

	private final double groesseBeiMinZoom;
	private final double zoomFactorMin;
	private final double groesseBeiMaxZoom;
	private final double zoomFactorMax;
	private Double anstieg;
	private Double durchgangDurchY;

	/**
	 * Konstruktor.
	 *
	 * @param groesseBeiMinZoom
	 *            die Groesse des Objektes bzw. der hier referenzierten Laenge,
	 *            Breite, etc. bei minimaler Zoomstufe.
	 * @param zoomFactorMin
	 *            der Zoomfaktor, unterhalb dem nicht mehr weiter skaliert
	 *            werden soll.
	 * @param groesseBeiMaxZoom
	 *            die Groesse des Objektes bzw. der hier referenzierten Laenge,
	 *            Breite, etc. bei maximaler Zoomstufe.
	 * @param zoomFactorMax
	 *            der Zoomfaktor, oberhalb dem nicht mehr weiter skaliert werden
	 *            soll.
	 */
	public DynamicScaleProvider(final double groesseBeiMinZoom,
			final double zoomFactorMin, final double groesseBeiMaxZoom,
			final double zoomFactorMax) {
		this.groesseBeiMinZoom = groesseBeiMinZoom;
		this.groesseBeiMaxZoom = groesseBeiMaxZoom;
		this.zoomFactorMin = zoomFactorMin;
		this.zoomFactorMax = zoomFactorMax;

	}

	@Override
	public Integer getValueAt(final double scale) {
		if (scale > zoomFactorMax) {
			return Math.round((float) (groesseBeiMaxZoom / scale));
		} else if (scale < zoomFactorMin) {
			return Math.round((float) (groesseBeiMinZoom / scale));
		}

		if (anstieg == null) {
			anstieg = (groesseBeiMaxZoom - groesseBeiMinZoom)
					/ (zoomFactorMax - zoomFactorMin);
		}

		if (durchgangDurchY == null) {
			durchgangDurchY = groesseBeiMaxZoom - anstieg * zoomFactorMax;
		}

		// y = m*x+n
		return Math
				.round((float) ((anstieg * scale + durchgangDurchY) / scale));
	}

	@Override
	public int size() {
		return 1;
	}

}
