/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz;

/**
 * Schnittstelle zu einem Objekt, das abhaengig von einem Realwert (bzw. einer
 * Skalierung) ein bestimmtes Objekt bereitstellt.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 * @param <T>
 *            Der Typ der bereitgestellten Objekte.
 */
public interface IScaleProvider<T> {

	/**
	 * Erfragt ein Objekt zu einer bestimmten Skalierung.
	 *
	 * @param scale
	 *            die Skalierung.
	 * @return das Objekt oder <code>null</code>, wenn zur uebergebenen
	 *         Skalierung kein Objekt existiert.
	 */
	T getValueAt(final double scale);

	/**
	 * Erfragt die Menge der Objekte innerhalb dieser Ordnung.
	 *
	 * @return die Menge der Objekte innerhalb dieser Ordnung.
	 */
	int size();

	/**
	 * ID.
	 *
	 * @author BitCtrl Systems GmbH, thierfelder
	 *
	 */
	public static class IdLong implements IScaleProvider<Long> {

		@Override
		public Long getValueAt(final double scale) {
			return 0L;
		}

		@Override
		public int size() {
			return 1;
		}

	}

	/**
	 * ID.
	 *
	 * @author BitCtrl Systems GmbH, thierfelder
	 *
	 */
	public static class IdInt implements IScaleProvider<Integer> {

		@Override
		public Integer getValueAt(final double scale) {
			return 0;
		}

		@Override
		public int size() {
			return 1;
		}

	}

	/**
	 * ID.
	 *
	 * @author BitCtrl Systems GmbH, thierfelder
	 *
	 */
	public static class IdDouble implements IScaleProvider<Double> {

		@Override
		public Double getValueAt(final double scale) {
			return 0.0;
		}

		@Override
		public int size() {
			return 1;
		}

	}

}
