/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

import de.bsvrz.buv.plugin.dobj.decorator.LinienstaerkeFigure;
import de.bsvrz.buv.plugin.dobj.decorator.legende.FarbeDoLegendeBaustein;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;

public final class LinieLegendeBaustein extends FarbeDoLegendeBaustein {

	public LinieLegendeBaustein(final DoTyp doTyp, final LinieFigure figure) {
		super(doTyp, figure);
		assignGeometrie(figure);
		assignLinienstaerke(doTyp, figure);
	}

	private void assignGeometrie(final LinieFigure figure) {
		final PointList points = new PointList();
		points.addPoint(new Point(0, 15));
		points.addPoint(new Point(4, 8));
		points.addPoint(new Point(12, 6));
		points.addPoint(new Point(15, 0));
		figure.setBasePoints(points);
	}

	private void assignLinienstaerke(final DoTyp decorator,
			final LinienstaerkeFigure figure) {

		if (decorator instanceof LinienstaerkeDecorator) {
			figure.setLinienstaerke(
					((LinienstaerkeDecorator) decorator).getLinienstaerke());
		} else if (decorator instanceof LinienstaerkeZoomDecorator) {
			figure.setLinienstaerke(((LinienstaerkeZoomDecorator) decorator)
					.getLinienstaerke());
		} else {
			figure.setLinienstaerke(1);
		}
	}

}
