/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.anzeigequerschnitt;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.dobj.decorator.DrehungMediator;
import de.bsvrz.buv.plugin.dobj.editparts.PunktEditPart;
import de.bsvrz.buv.plugin.dobj.legende.DoLegendeBaustein;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten;

/**
 * MVC-Controller für einen Anzeigequerschnitt.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public final class AnzeigeQuerschnittEditPart
		extends PunktEditPart<AnzeigeQuerschnitt, AnzeigeQuerschnittFigure> {

	private DoLegendeBaustein legendeBaustein;

	@Override
	public AnzeigeQuerschnittDoModel getModel() {
		return (AnzeigeQuerschnittDoModel) super.getModel();
	}

	@Override
	protected AnzeigeQuerschnittFigure createFigure() {
		return new AnzeigeQuerschnittFigure(getResourceManager());
	}

	@Override
	public void deactivate() {
		disposeLegende();

		super.deactivate();
	}

	@Override
	protected Point getWgs84Location() {
		vorladen(AnzeigeQuerschnitt.PID, KdPunktKoordinaten.PID);

		return super.getWgs84Location();
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof AnzeigeQuerschnittDoTyp
						|| notifier instanceof AnzeigeQuerschnittDoModel)) {
			refreshVisuals();
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		new DrehungMediator(this).mediate();
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") final Class key) {
		if (ILegendeBaustein.class.equals(key)) {
			return getLegendeBaustein();
		}

		return super.getAdapter(key);
	}

	private ILegendeBaustein getLegendeBaustein() {
		disposeLegende();
		final AnzeigeQuerschnittFigure f = createFigure();
		legendeBaustein = new DoLegendeBaustein(getModel().getDoTyp(), f,
				f.getSize());
		return legendeBaustein;
	}

	private void disposeLegende() {
		if (legendeBaustein != null) {
			legendeBaustein.dispose();
			legendeBaustein = null;
		}
	}

}
