/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.anzeigequerschnitt;

import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.draw2d.FixedSizeFigure;
import com.bitctrl.lib.eclipse.draw2d.RotatableFigure;

import de.bsvrz.buv.plugin.dobj.DoFigure;
import de.bsvrz.buv.plugin.dobj.decorator.DrehungFigure;
import de.bsvrz.buv.plugin.netz.internal.NetzPlugin;

/**
 * MVC-View für einen Anzeigequerschnitt.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
final class AnzeigeQuerschnittFigure extends RotatableFigure
		implements DoFigure, DrehungFigure {

	private static final ImageDescriptor IMAGE_DESCRIPTOR = NetzPlugin
			.getDefault()
			.getImageDescriptor("images/dot/anzeigequerschnitt.png");

	private final Image image;
	private final int originalWidth;
	private final int originalHeight;

	private double zoom = 1.0;
	private double vonZoom;
	private double bisZoom = Double.MAX_VALUE;

	AnzeigeQuerschnittFigure(final ResourceManager resourceManager) {
		image = resourceManager.createImage(IMAGE_DESCRIPTOR);
		originalWidth = image.getBounds().width;
		originalHeight = image.getBounds().height;

		final FixedSizeFigure figure = new FixedSizeFigure(
				new Dimension(originalWidth, originalHeight));
		final ImageFigure imageFigure = new ImageFigure(image);
		imageFigure.setSize(originalWidth, originalHeight);
		figure.add(imageFigure);
		setContent(figure);
	}

	@Override
	public Point getHotspot() {
		return getContent().getBounds().getLocation();
	}

	@Override
	public void setHotspot(final Point hotspot) {
		getContent().setLocation(hotspot);
	}

	@Override
	public float getDrehwinkel() {
		return getAngleOfRotation();
	}

	@Override
	public void setDrehwinkel(final float drehwinkel) {
		setAngleOfRotation(drehwinkel);
	}

	@Override
	public void setSichtbareZoomStufe(final double vonZoom,
			final double bisZoom) {
		if (this.vonZoom == vonZoom && this.bisZoom == bisZoom) {
			return;
		}

		this.vonZoom = vonZoom;
		this.bisZoom = bisZoom;

		updateFigure();
	}

	@Override
	public void handleZoomChanged(final double newZoom) {
		if (zoom == newZoom) {
			return;
		}

		zoom = newZoom;

		updateFigure();
	}

	@Override
	protected void updateFigure() {
		setVisible(vonZoom <= zoom && zoom <= bisZoom);
		((FixedSizeFigure) getContent()).setZoom(zoom);
		super.updateFigure();
	}

}
