/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.baustelle;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.netz.situation.SituationPopUp;
import de.bsvrz.buv.plugin.netz.ui.AbstractPopUpEditPolicy;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle;

/**
 * Edit Policy zum Öffnen eines Pop-Ups für eine Baustelle.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 */
final class BaustellePopUpEditPolicy
		extends AbstractPopUpEditPolicy<Baustelle> {

	@Override
	protected PopupDialog getPopupDialog(final Shell shell,
			final Baustelle systemObjekt) {
		return new SituationPopUp(shell, systemObjekt, getDoModel());
	}

	@SuppressWarnings("unchecked")
	@Override
	protected Baustelle getSystemObjekt() {
		return ((BitCtrlDoModel<Baustelle>) getHost().getModel())
				.getSystemObjekt();
	}

}
