/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.baustelle;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.netz.internal.NetzPlugin;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.situation.SituationEmpfaenger;
import de.bsvrz.buv.plugin.netz.situation.SituationSymbolEditPart;
import de.bsvrz.buv.plugin.netz.situation.SituationSymbolFigure;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle;

/**
 * MVC-Controller für die Darstellung einer Baustelle als Symbol.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 */
public class BaustelleSymbolEditPart
		extends SituationSymbolEditPart<Baustelle> {

	private final ImageDescriptor baustelleSymbol = NetzPlugin.getDefault()
			.getImageDescriptor("images/dot/baustelle.png");

	protected final ImageDescriptor getBaustelleSymbol() {
		return baustelleSymbol;
	}

	@Override
	protected SituationSymbolFigure createFigure() {
		final Image image = getResourceManager().createImage(baustelleSymbol);
		return new BaustelleSymbolFigure(getKollisionsManager(), image);
	}

	@Override
	protected SituationEmpfaenger createSituationEmpfaenger() {
		return new BaustelleSymbolEmpfaenger(this);
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();

		if (!isEditor()) {
			installEditPolicy(EditPolicy.SELECTION_FEEDBACK_ROLE,
					new BaustellePopUpEditPolicy());
		}
	}

	@Override
	protected final IFigure getToolTip() {
		if (isEditor()) {
			return super.getToolTip();
		}

		return null;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		final BaustelleFigure f = (BaustelleFigure) getFigure();
		f.setNurAktuelleUndGueltigeBaustellenAnzeigen(
				isNurGueltigeBaustellenAnzeigen());
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof BaustelleSymbolDoTyp
						|| notifier instanceof BaustelleSymbolDoModel)) {
			refreshVisuals();
		}
	}

}
