/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.baustelle;

import de.bsvrz.buv.plugin.netz.situation.SituationEditPart;
import de.bsvrz.buv.plugin.netz.situation.SituationFigure;
import de.bsvrz.buv.plugin.netz.situation.SituationSymbolEmpfaenger;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStatusBaustelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBaustellenEigenschaften;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBaustellenEigenschaften.Daten;

public class BaustelleSymbolEmpfaenger extends SituationSymbolEmpfaenger {

	public BaustelleSymbolEmpfaenger(
			final SituationEditPart<? extends Situation, ? extends SituationFigure> editPart) {
		super(editPart);
	}

	protected final Baustelle getBaustelle() {
		return (Baustelle) getSituation();
	}

	@Override
	public void anmelden() {
		super.anmelden();
		getBaustelle().getPdBaustellenEigenschaften().addUpdateListener(this);
	}

	@Override
	public void abmelden() {
		getBaustelle().getPdBaustellenEigenschaften()
				.removeUpdateListener(this);
		super.abmelden();
	}

	@Override
	protected void handleDatensatzAktualisiert(final OnlineDatum datum) {
		super.handleDatensatzAktualisiert(datum);

		if (datum instanceof PdBaustellenEigenschaften.Daten) {
			baustellenEigenschaftenAktualisiert(
					(PdBaustellenEigenschaften.Daten) datum);
		}
	}

	private void baustellenEigenschaftenAktualisiert(final Daten datum) {
		final AttStatusBaustelle status = datum.getStatus();
		final boolean gueltig = AttStatusBaustelle.ZUSTAND_2_GUELTIG
				.equals(status);
		final BaustelleFigure f = (BaustelleFigure) getFigure();
		f.setBaustelleGueltig(gueltig);
	}

}
