/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.baustelle;

import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.dobj.kollision.KollisionsManager;
import de.bsvrz.buv.plugin.netz.situation.SituationSymbolFigure;

public class BaustelleSymbolFigure extends SituationSymbolFigure
		implements BaustelleFigure {

	private boolean baustelleGueltig;
	private boolean nurAktuelleUndGueltigeBaustellenAnzeigen;

	BaustelleSymbolFigure(final KollisionsManager kollisionsManager,
			final Image image) {
		super(kollisionsManager, image);
	}

	@Override
	public final boolean isBaustelleGueltig() {
		return baustelleGueltig;
	}

	@Override
	public final void setBaustelleGueltig(final boolean baustelleGueltig) {
		if (this.baustelleGueltig == baustelleGueltig) {
			return;
		}

		this.baustelleGueltig = baustelleGueltig;

		updateFigure();
	}

	@Override
	public final boolean isNurAktuelleUndGueltigeBaustellenAnzeigen() {
		return nurAktuelleUndGueltigeBaustellenAnzeigen;
	}

	@Override
	public final void setNurAktuelleUndGueltigeBaustellenAnzeigen(
			final boolean nurAktuelleUndGueltigeBaustellenAnzeigen) {
		if (this.nurAktuelleUndGueltigeBaustellenAnzeigen == nurAktuelleUndGueltigeBaustellenAnzeigen) {
			return;
		}

		this.nurAktuelleUndGueltigeBaustellenAnzeigen = nurAktuelleUndGueltigeBaustellenAnzeigen;

		updateFigure();
	}

	@Override
	protected void updateVisible() {
		if (isNurAktuelleUndGueltigeBaustellenAnzeigen()) {
			setVisible(isZoomInSichtbareZoomStufe() && isBaustelleGueltig()
					&& isSituationGueltig());
		} else {
			setVisible(isZoomInSichtbareZoomStufe() && isBaustelleGueltig());
		}
	}

}
