/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.baustelle;

import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.situation.SituationEmpfaenger;
import de.bsvrz.buv.plugin.netz.situation.SituationVerlaufEditPart;
import de.bsvrz.buv.plugin.netz.situation.SituationVerlaufFigure;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle;

/**
 * MVC-Controller für die Darstellung des Verlaufs einer Baustelle.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 */
public final class BaustelleVerlaufEditPart
		extends SituationVerlaufEditPart<Baustelle> {

	@Override
	protected SituationVerlaufFigure createFigure() {
		return new BaustelleVerlaufFigure();
	}

	@Override
	public BaustelleVerlaufFigure getFigure() {
		return (BaustelleVerlaufFigure) super.getFigure();
	}

	@Override
	protected SituationEmpfaenger createSituationEmpfaenger() {
		return new BaustelleVerlaufEmpfaenger(this);
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		getFigure().setNurAktuelleUndGueltigeBaustellenAnzeigen(
				isNurGueltigeBaustellenAnzeigen());
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof BaustelleVerlaufDoTyp
						|| notifier instanceof BaustelleVerlaufDoModel)) {
			refreshVisuals();
		}
	}

}
