/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.fahrstreifen;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;

/**
 * Erlaubt die Parametrierung des Abstands der Fahrstreifen zueinander.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public final class FahrStreifenPropertySection
		extends AbstractSection<FahrStreifenStoerfallIndikatorDoTyp> {

	private Label fahrStreifenAbstandLabel;
	private Spinner fahrStreifenAbstand;
	private Button fahrStreifenAbstandUseDefault;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createLinienabstand(container);
	}

	private void createLinienabstand(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		fahrStreifenAbstandLabel = factory.createLabel(parent,
				"Fahrstreifenabstand:", BORDER);
		fahrStreifenAbstand = new Spinner(parent, BORDER);
		fahrStreifenAbstand.setMinimum(Integer.MIN_VALUE);
		fahrStreifenAbstand.setMaximum(Integer.MAX_VALUE);
		fahrStreifenAbstand.setIncrement(1);
		fahrStreifenAbstand.setPageIncrement(10);
		factory.adapt(parent);
		fahrStreifenAbstandUseDefault = factory.createButton(parent,
				"Defaultwert verwenden", CHECK);

		// Widgets layouten
		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(fahrStreifenAbstandLabel, HSPACE);
		spinnerData.width = 150;
		spinnerData.top = new FormAttachment(0, 0);
		fahrStreifenAbstand.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(fahrStreifenAbstand, 0, CENTER);
		fahrStreifenAbstandLabel.setLayoutData(labelData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(fahrStreifenAbstand, 0,
				HSPACE);
		useDefaultData.top = new FormAttachment(fahrStreifenAbstand, 0, CENTER);
		fahrStreifenAbstandUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden
		fahrStreifenAbstand.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = fahrStreifenAbstand.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						NetzPackage.Literals.FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__FAHRSTREIFENABSTAND,
						value);
				getCommandStack().execute(cmd);
			}

		});
		fahrStreifenAbstandUseDefault
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						if (fahrStreifenAbstandUseDefault.getSelection()) {
							final UnsetCommand cmd = new UnsetCommand(
									getElement(),
									NetzPackage.Literals.FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__FAHRSTREIFENABSTAND);
							getCommandStack().execute(cmd);
						} else {
							final int value = getElement()
									.getFahrstreifenabstand();
							final SetCommand cmd = new SetCommand(getElement(),
									NetzPackage.Literals.FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__FAHRSTREIFENABSTAND,
									value);
							getCommandStack().execute(cmd);
						}
					}

				});
	}

	@Override
	public void refresh() {
		setLinienabstandToWidget();
		disableLinienabstandIfNecessary();
	}

	private void setLinienabstandToWidget() {
		final boolean isChanged = fahrStreifenAbstand
				.getSelection() != getElement().getFahrstreifenabstand();
		if (isChanged) {
			fahrStreifenAbstand
					.setSelection(getElement().getFahrstreifenabstand());
		}
	}

	private void disableLinienabstandIfNecessary() {
		final boolean isDoKomponente = getElement()
				.eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetFahrstreifenabstand();

		fahrStreifenAbstandUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		fahrStreifenAbstand.setEnabled(enabled);
		fahrStreifenAbstandLabel.setEnabled(enabled);
	}

}
