/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.fahrstreifen;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.netz.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.stoerfall.BaseStoerfallIndikatorFigure;
import de.bsvrz.buv.plugin.netz.stoerfall.anzeigeverfahren.StoerfallIndikatorMitAnzeigeVerfahrenEditPart;
import de.bsvrz.buv.rw.bitctrl.CacheService;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdFahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AbstractCache;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.MqCache;

/**
 * MVC-Controller für den Störfallindikator Fahrstreifen.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 */
public final class FahrStreifenStoerfallIndikatorEditPart
		extends StoerfallIndikatorMitAnzeigeVerfahrenEditPart<FahrStreifen> {

	private static final CacheService CACHE_SERVICE = RahmenwerkService
			.getService().getCacheService();

	private static final MqCache MQ_CACHE = CACHE_SERVICE
			.getMqCache(CACHE_SERVICE.getDefaultNetzPid());

	private PropertyChangeListener cacheListener;

	@Override
	protected FahrStreifenStoerfallIndikatorDoTyp getDoTyp() {
		return (FahrStreifenStoerfallIndikatorDoTyp) super.getDoTyp();
	}

	@Override
	protected MessQuerschnittAllgemein getMessQuerschnitt() {
		if (MQ_CACHE.isInitialisiert()) {
			return MQ_CACHE.getMessquerschnitt(getSystemObjekt());
		}
		return null;
	}

	@Override
	protected BaseStoerfallIndikatorFigure createFigure() {
		return new FahrStreifenStoerfallIndikatorFigure();
	}

	@Override
	public FahrStreifenStoerfallIndikatorFigure getFigure() {
		return (FahrStreifenStoerfallIndikatorFigure) super.getFigure();
	}

	@Override
	public void activate() {
		super.activate();

		if (!MQ_CACHE.isInitialisiert()) {
			cacheListener = new PropertyChangeListener() {

				@Override
				public void propertyChange(final PropertyChangeEvent evt) {
					if (MQ_CACHE.isInitialisiert()) {
						MQ_CACHE.removePropertyChangeListener(
								AbstractCache.PROP_STATE, this);
						refreshVisuals();
					}
				}

			};
			MQ_CACHE.addPropertyChangeListener(AbstractCache.PROP_STATE,
					cacheListener);
		}
	}

	@Override
	public void deactivate() {
		if (cacheListener != null) {
			MQ_CACHE.removePropertyChangeListener(AbstractCache.PROP_STATE,
					cacheListener);
		}
		super.deactivate();
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof FahrStreifenStoerfallIndikatorDoTyp)) {
			refreshVisuals();
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		refreshFahrStreifen();
		refreshFahrStreifenAbstand();
	}

	private void refreshFahrStreifen() {
		getFigure().setFahrStreifenAbstand(getDoTyp().getFahrstreifenabstand());
	}

	private void refreshFahrStreifenAbstand() {
		vorladen(FahrStreifen.PID, KdFahrStreifen.PID);

		final FahrStreifenStoerfallIndikatorFigure f = getFigure();

		if (getSystemObjekt() != null) {
			final KdFahrStreifen.Daten datum = getSystemObjekt()
					.getKdFahrStreifen().getDatum();
			final int fahrStreifenLage = datum.getLage().intValue();
			getViewer().getControl().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					f.setFahrStreifenLage(fahrStreifenLage);
				}
			});

		}

		final MessQuerschnitt mq = (MessQuerschnitt) getMessQuerschnitt();
		if (mq != null) {
			final int anzahlFahrStreifen = mq.getFahrStreifen().size();
			getViewer().getControl().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					f.setAnzahlFahrStreifen(anzahlFahrStreifen);
				}
			});

		}
	}
}
