/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.fahrstreifen;

import de.bsvrz.buv.plugin.netz.ConstantScaleProvider;
import de.bsvrz.buv.plugin.netz.IScaleProvider;
import de.bsvrz.buv.plugin.netz.stoerfall.BaseStoerfallIndikatorFigure;

/**
 * MVC-View für die Darstellung der Situation eines <em>Störfallindikators</em>
 * vom Typ <em>Fahrstreifen</em>.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 *
 */
final class FahrStreifenStoerfallIndikatorFigure
		extends BaseStoerfallIndikatorFigure {

	private int anzahlFahrStreifen;
	private int fahrStreifenLage;

	private IScaleProvider<Integer> fahrStreifenAbstandProvider = new ConstantScaleProvider(
			0, 0.0001, 1.0);

	int getAnzahlFahrStreifen() {
		return anzahlFahrStreifen;
	}

	void setAnzahlFahrStreifen(final int anzahlFahrStreifen) {
		if (this.anzahlFahrStreifen == anzahlFahrStreifen) {
			return;
		}

		this.anzahlFahrStreifen = anzahlFahrStreifen;

		updateFigure();
	}

	int getFahrStreifenLage() {
		return fahrStreifenLage;
	}

	void setFahrStreifenLage(final int fahrStreifenLage) {
		if (this.fahrStreifenLage == fahrStreifenLage) {
			return;
		}

		this.fahrStreifenLage = fahrStreifenLage;

		updateFigure();
	}

	int getFahrStreifenAbstand() {
		return fahrStreifenAbstandProvider.getValueAt(getZoom());
	}

	void setFahrStreifenAbstand(final int fahrStreifenAbstand) {
		fahrStreifenAbstandProvider = new ConstantScaleProvider(
				fahrStreifenAbstand, 0.0001, 1.0);
		updateFigure();
	}

	@Override
	protected int getVerschobeneBasePointsAbstand() {
		final int fahrStreifenAbstand = getFahrStreifenAbstand();
		final int gesamtbreite = (anzahlFahrStreifen - 1) * fahrStreifenAbstand;
		final int fahrStreifenOffset = fahrStreifenAbstand * fahrStreifenLage;
		final int linienabstand = getLinienabstand();
		final int abstand = linienabstand + (gesamtbreite / 2)
				- fahrStreifenOffset;
		return abstand;
	}

	@Override
	protected void updateVisible() {
		setVisible(isZoomInSichtbareZoomStufe() && anzahlFahrStreifen > 0);
	}

}
