/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.geo;

import java.util.Collections;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

import de.bsvrz.buv.plugin.dobj.decorator.legende.FarbeDoLegendeBaustein;
import de.bsvrz.buv.plugin.netz.model.KomplexDoTyp;

final class KomplexLegendeBaustein extends FarbeDoLegendeBaustein {

	KomplexLegendeBaustein(final KomplexDoTyp doTyp,
			final KomplexFigure figure) {
		super(doTyp, figure);
		assignGeometrie(figure);
	}

	private void assignGeometrie(final KomplexFigure figure) {
		final PointList polygon = new PointList();
		polygon.addPoint(new Point(1, 1));
		polygon.addPoint(new Point(14, 1));
		polygon.addPoint(new Point(14, 14));
		polygon.addPoint(new Point(1, 14));
		figure.setFlaechen(Collections.singletonList(polygon));
	}

}
