/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.geo;

import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.dobj.decorator.HintergrundfarbeMediator;
import de.bsvrz.buv.plugin.dobj.decorator.VordergrundfarbeMediator;
import de.bsvrz.buv.plugin.dobj.editparts.KomplexEditPart;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.netz.model.KomplexDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex;

/**
 * MVC-Controller für Systemobjekte vom Typ <em>Komplex</em>.
 *
 * <p>
 * Der Edit Part kümmert sich um die Darstellung der Geometrie des
 * Komplex-Objekts, sowie dessen Vorder- und Hintergrundfarbe. Auch die Legende
 * wird mit einem passenden Legendenbaustein versorgt.
 *
 * <p>
 * Damit dieser Edit Part funktioniert, muss folgende Bedingung erfüllt sein:
 * <ul>
 * <li>Der {@link DoTyp} des Darstellungsobjekts muss {@link KomplexDoTyp}
 * implementieren.</li>
 * </ul>
 *
 * @author BitCtrl Systems GmbH, bitcontrol
 *
 */
public abstract class NetzKomplexEditPart<T extends Komplex>
		extends KomplexEditPart<T, KomplexFigure> {

	private KomplexLegendeBaustein legendeBaustein;

	/**
	 * Vereinfachung für <code>{@link #getModel()}.getDoTyp()</code>.
	 */
	protected final KomplexDoTyp getDoTyp() {
		return (KomplexDoTyp) getModel().getDoTyp();
	}

	@Override
	protected KomplexFigure createFigure() {
		return new KomplexFigure();
	}

	@Override
	public void deactivate() {
		disposeLegende();

		super.deactivate();
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof KomplexDoTyp)) {
			refreshVisuals();
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		refreshGeometrieKomplex();

		new VordergrundfarbeMediator(this).mediate();
		new HintergrundfarbeMediator(this).mediate();
	}

	private void refreshGeometrieKomplex() {
		final KomplexFigure f = getFigure();
		if (getModel().getSystemObjekt() != null) {
			f.setFlaechen(getFlaechen());
			f.setLinien(getLinien());
		} else {
			f.setFlaechen(null);
			f.setLinien(null);
		}
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") final Class key) {
		if (ILegendeBaustein.class.equals(key)) {
			return getLegendeBaustein();
		}

		return super.getAdapter(key);
	}

	private ILegendeBaustein getLegendeBaustein() {
		disposeLegende();
		legendeBaustein = new KomplexLegendeBaustein(getDoTyp(),
				createFigure());
		return legendeBaustein;
	}

	private void disposeLegende() {
		if (legendeBaustein != null) {
			legendeBaustein.dispose();
			legendeBaustein = null;
		}
	}

}
