/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.kreis;

import java.util.List;

import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPolicy;

import de.bsvrz.buv.plugin.netz.geo.NetzKomplexEditPart;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdKomplexKoordinaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY;

/**
 * MVC-Controller für einen Kreis (Kreisgrenzen).
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public final class KreisEditPart extends NetzKomplexEditPart<KomplexXY> {

	@Override
	protected List<PointList> getFlaechen() {
		vorladen(KomplexXY.PID, KdKomplexKoordinaten.PID);

		return super.getFlaechen();
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		if (!isEditor()) {
			removeEditPolicy(EditPolicy.LAYOUT_ROLE);
		}
	}

}
