/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.messquerschnitt;

import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.dobj.decorator.Datenstatus;
import de.bsvrz.buv.plugin.dobj.decorator.DatenstatusFigure;
import de.bsvrz.buv.plugin.dobj.util.IDavZeitStempelManager;
import de.bsvrz.buv.plugin.netz.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;

final class MessQuerschnittEmpfaenger implements ClientReceiverInterface {

	private final SystemObject systemObject;
	private final DatenstatusFigure figure;
	private final IDavZeitStempelManager davZeitStempelManager;

	private final DataDescription dataDescription;

	MessQuerschnittEmpfaenger(final SystemObject systemObject,
			final DatenstatusFigure figure,
			final IDavZeitStempelManager davZeitStempelManager) {
		this.systemObject = systemObject;
		this.figure = figure;
		this.davZeitStempelManager = davZeitStempelManager;

		dataDescription = createDataDescription();
	}

	void anmelden() {
		getClientDavInterface().subscribeReceiver(this, systemObject,
				dataDescription, ReceiveOptions.normal(),
				ReceiverRole.receiver());
	}

	void abmelden() {
		final ClientDavInterface clientDavInterface = getClientDavInterface();
		if (clientDavInterface != null) {
			clientDavInterface.unsubscribeReceiver(this, systemObject,
					dataDescription);
		}
	}

	private ClientDavInterface getClientDavInterface() {
		return RahmenwerkService.getService().getRahmenwerk()
				.getDavVerbindung();
	}

	private DataDescription createDataDescription() {
		final DataModel model = getClientDavInterface().getDataModel();
		final AttributeGroup atg = model
				.getAttributeGroup("atg.verkehrsDatenKurzZeitMq");
		final Aspect asp = model.getAspect("asp.analyse");
		return new DataDescription(atg, asp);
	}

	@Override
	public void update(final ResultData[] resultDatas) {
		for (final ResultData resultData : resultDatas) {
			updateZeitstempelLetzterDatensatz(resultData);

			PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					final DataState dataState = resultData.getDataState();
					if (dataState.equals(DataState.DATA)) {
						figure.setDatenstatus(Datenstatus.Nutzdaten);
					} else if (dataState.equals(DataState.NO_DATA)) {
						figure.setDatenstatus(Datenstatus.KeineDaten);
					} else {
						figure.setDatenstatus(Datenstatus.KeineQuelle);
					}
				}

			});
		}
	}

	private void updateZeitstempelLetzterDatensatz(
			final ResultData resultData) {
		if (resultData.hasData() && davZeitStempelManager != null) {
			davZeitStempelManager.setLetztenEmpfangenenZeitStempel(
					resultData.getDataTime(), resultData.getObject());
		}
	}

}
