/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.messquerschnitt;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

import com.bitctrl.lib.eclipse.draw2d.FigureUtilities2;

import de.bsvrz.buv.plugin.dobj.decorator.Datenstatus;
import de.bsvrz.buv.plugin.dobj.decorator.DatenstatusFigure;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.buv.rw.basislib.legende.LegendeBaustein;

final class MessQuerschnittLegendeBaustein implements ILegendeBaustein {

	private final DoTyp doTyp;
	private final DatenstatusFigure figure;

	private List<ILegendeBaustein> legendenBausteine;
	private Image image;
	private final Color keineQuelleColor;
	private final Color keineDatenColor;
	private final Color nutzdatenColor;

	MessQuerschnittLegendeBaustein(final MessQuerschnittDoTyp doTyp,
			final DatenstatusFigure figure) {
		this.doTyp = doTyp;
		this.figure = figure;

		final Display display = PlatformUI.getWorkbench().getDisplay();
		keineQuelleColor = new Color(display, doTyp.getKeineQuelleFarbe());
		figure.setKeineQuelleFarbe(keineQuelleColor);
		keineDatenColor = new Color(display, doTyp.getKeineDatenFarbe());
		figure.setKeineDatenFarbe(keineDatenColor);
		nutzdatenColor = new Color(display, doTyp.getNutzdatenFarbe());
		figure.setNutzdatenFarbe(nutzdatenColor);
	}

	@Override
	public List<ILegendeBaustein> getBausteine() {
		if (legendenBausteine == null) {
			legendenBausteine = new ArrayList<>();

			for (final Datenstatus e : Datenstatus.values()) {
				final Image img = createImage(e);
				legendenBausteine.add(new LegendeBaustein(img, e.toString()));
			}

		}

		return legendenBausteine;
	}

	private Image createImage(final Datenstatus datenstatus) {
		figure.setDatenstatus(datenstatus);
		return FigureUtilities2.createImage(figure, new Dimension(16, 16));
	}

	@Override
	public Image getIcon() {
		if (image == null) {
			image = createImage(Datenstatus.Nutzdaten);
		}

		return image;
	}

	@Override
	public String getText() {
		return doTyp.getName();
	}

	void dispose() {
		if (legendenBausteine != null) {
			for (final ILegendeBaustein e : legendenBausteine) {
				e.getIcon().dispose();
			}
			legendenBausteine = null;
		}

		if (image != null) {
			image.dispose();
			image = null;
		}

		keineQuelleColor.dispose();
		keineDatenColor.dispose();
		nutzdatenColor.dispose();
	}

}
