/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.messquerschnitt;

import java.text.SimpleDateFormat;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.widgets.TextChangeHelper;

import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;

/**
 * Section für Properties des {@link MessQuerschnittDoTyp}s.
 *
 * @author BitCtrl Systems GmbH, Christian Hösel
 * @version $$Id$$
 */
public class MessQuerschnittTypPropertySection
		extends AbstractSection<MessQuerschnittDoTyp> {

	private final TextChangeHelper textListener = new TextChangeHelper() {

		@Override
		public void textChanged(final Text text) {
			EStructuralFeature feature;
			Object value;
			if (text == zeitStempelFormatText) {
				feature = NetzPackage.Literals.MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT;
				value = text.getText();
			} else {
				return;
			}

			final SetCommand cmd = new SetCommand(getElement(), feature, value);
			getCommandStack().execute(cmd);
		}

	};

	private Text zeitStempelFormatText;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createZeitStempelFormat(container);
		// Listener aktivieren
		textListener.startListeningTo(zeitStempelFormatText);
	}

	private void createZeitStempelFormat(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;

		zeitStempelFormatText = factory.createText(parent, "");
		zeitStempelFormatText.setToolTipText("y\tJahr\n"
				+ "M\tMonat des Jahres\n" + "w\tWoche des Jahres\n"
				+ "W\tWoche des Monats\n" + "D\tTag des Jahres\n"
				+ "d\tTag des Monats\n" + "F\tTag der Woche dieses Monats\n"
				+ "E\tName des Wochentages\n" + "a\tAM/PM\nH\tStunde (0-23)\n"
				+ "k\tStunde (1-24)\n" + "K\tStunde AM/PM (0-11)\n"
				+ "h\tStunde AM/PM (1-12)\n" + "m\tMinute der Stunde\n"
				+ "s\tSekunde der Minute\n" + "S\tMillisekunde\n"
				+ "z\tZeitzone als Text\n"
				+ "Z\tZeitzone als Zeitverschiebung");
		zeitStempelFormatText.addListener(SWT.Verify, new Listener() {

			@Override
			public void handleEvent(final Event event) {
				final String string = event.text;
				try {
					new SimpleDateFormat(string);
					event.doit = true;
				} catch (final IllegalArgumentException e) {
					event.doit = false;
				} catch (final NullPointerException e) {
					event.doit = false;
				}
			}

		});
		data = new FormData();
		data.left = new FormAttachment(0, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		zeitStempelFormatText.setLayoutData(data);

		final CLabel label = factory.createCLabel(parent, "Datumsformat:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(zeitStempelFormatText,
				-ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(zeitStempelFormatText, 0, SWT.CENTER);
		label.setLayoutData(data);
	}

	@Override
	public void refresh() {
		textListener.startNonUserChange();
		try {
			if (getElement().getName() != null) {
				zeitStempelFormatText
						.setText(getElement().getTooltipZeitstempelFormat());
			} else {
				zeitStempelFormatText.setText("");
			}
		} finally {
			textListener.finishNonUserChange();
		}
	}

}
