/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model;

import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Mess
 * Querschnitt Do Typ</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp#getTooltipZeitstempelFormat
 * <em>Tooltip Zeitstempel Format</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getMessQuerschnittDoTyp()
 * @model
 * @generated
 */
public interface MessQuerschnittDoTyp extends ConfiguratedDoTyp,
		SkalierungDecorator, DatenstatusDecorator, LinienabstandZoomDecorator {
	/**
	 * Returns the value of the '<em><b>Tooltip Zeitstempel Format</b></em>'
	 * attribute. The default value is <code>"dd.MM.yyyy HH:mm:ss,SSS"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Tooltip Zeitstempel Format</em>' attribute.
	 * @see #setTooltipZeitstempelFormat(String)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getMessQuerschnittDoTyp_TooltipZeitstempelFormat()
	 * @model default="dd.MM.yyyy HH:mm:ss,SSS"
	 * @generated
	 */
	String getTooltipZeitstempelFormat();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp#getTooltipZeitstempelFormat
	 * <em>Tooltip Zeitstempel Format</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Tooltip Zeitstempel Format</em>'
	 *            attribute.
	 * @see #getTooltipZeitstempelFormat()
	 * @generated
	 */
	void setTooltipZeitstempelFormat(String value);

} // MessQuerschnittDoTyp
