/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;

import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.netz.model.NetzFactory
 * @model kind="package"
 * @generated
 */
public interface NetzPackage extends EPackage {
	/**
	 * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNAME = "netz";

	/**
	 * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_URI = "http://de.bsvrz.buv.plugin.netz/2.0";

	/**
	 * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_PREFIX = "netz";

	/**
	 * The singleton instance of the package. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	NetzPackage eINSTANCE = de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl
			.init();

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl
	 * <em>Mess Querschnitt Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittDoTyp()
	 * @generated
	 */
	int MESS_QUERSCHNITT_DO_TYP = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Skalierungsfaktor</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Keine Quelle Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Keine Daten Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Nutzdaten Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 9;

	/**
	 * The feature id for the '<em><b>Tooltip Zeitstempel Format</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 10;

	/**
	 * The number of structural features of the '<em>Mess Querschnitt Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 11;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoModelImpl
	 * <em>Mess Querschnitt Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittDoModel()
	 * @generated
	 */
	int MESS_QUERSCHNITT_DO_MODEL = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The feature id for the '<em><b>Skalierungsfaktor</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__SKALIERUNGSFAKTOR = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Drehwinkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL__DREHWINKEL = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 1;

	/**
	 * The number of structural features of the '<em>Mess Querschnitt Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 2;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl
	 * <em>Strassen Segment Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentDoTyp()
	 * @generated
	 */
	int STRASSEN_SEGMENT_DO_TYP = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 9;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 10;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 11;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 12;

	/**
	 * The feature id for the '<em><b>Default Darstellung Autobahn</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 13;

	/**
	 * The feature id for the '<em><b>Vordergrund Farbe Autobahn</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 14;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten
	 * Autobahn</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 15;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Autobahn</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 16;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Autobahn</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 17;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum Autobahn</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 18;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum Autobahn</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 19;

	/**
	 * The feature id for the '<em><b>Linienstaerke Autobahn</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 20;

	/**
	 * The feature id for the '<em><b>Linienabstand Autobahn</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 21;

	/**
	 * The feature id for the '<em><b>Default Darstellung
	 * Bundesstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 22;

	/**
	 * The feature id for the '<em><b>Vordergrund Farbe Bundesstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 23;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten
	 * Bundesstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 24;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Bundesstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 25;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Bundesstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 26;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum
	 * Bundesstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 27;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum
	 * Bundesstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 28;

	/**
	 * The feature id for the '<em><b>Linienstaerke Bundesstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 29;

	/**
	 * The feature id for the '<em><b>Linienabstand Bundesstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 30;

	/**
	 * The feature id for the '<em><b>Default Darstellung Landstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 31;

	/**
	 * The feature id for the '<em><b>Vordergrund Farbe Landstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 32;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten
	 * Landstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 33;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Landstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 34;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Landstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 35;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum
	 * Landstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 36;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum
	 * Landstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 37;

	/**
	 * The feature id for the '<em><b>Linienstaerke Landstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 38;

	/**
	 * The feature id for the '<em><b>Linienabstand Landstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 39;

	/**
	 * The feature id for the '<em><b>Vordergrund Farbe Kreisstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 40;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten
	 * Kreisstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 41;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Kreisstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 42;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Kreisstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 43;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum
	 * Kreisstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 44;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum
	 * Kreisstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 45;

	/**
	 * The feature id for the '<em><b>Linienstaerke Kreisstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 46;

	/**
	 * The feature id for the '<em><b>Linienabstand Kreisstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 47;

	/**
	 * The feature id for the '<em><b>Default Darstellung Kreisstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 48;

	/**
	 * The number of structural features of the '<em>Strassen Segment Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 49;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoModelImpl
	 * <em>Strassen Segment Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentDoModel()
	 * @generated
	 */
	int STRASSEN_SEGMENT_DO_MODEL = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Strassen Segment Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.KomplexDoTyp <em>Komplex Do
	 * Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.KomplexDoTyp
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getKomplexDoTyp()
	 * @generated
	 */
	int KOMPLEX_DO_TYP = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__VORDERGRUNDFARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Hintergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP__HINTERGRUNDFARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The number of structural features of the '<em>Komplex Do Typ</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KOMPLEX_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.KreisDoTypImpl <em>Kreis Do
	 * Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.KreisDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getKreisDoTyp()
	 * @generated
	 */
	int KREIS_DO_TYP = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__NAME = KOMPLEX_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__ID = KOMPLEX_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__DESCRIPTION = KOMPLEX_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__SYSTEM_OBJECT_TYPE = KOMPLEX_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__ICON = KOMPLEX_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__ZOOM_STUFE = KOMPLEX_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__CONFIGURATION_ELEMENT = KOMPLEX_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = KOMPLEX_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__VORDERGRUNDFARBE = KOMPLEX_DO_TYP__VORDERGRUNDFARBE;

	/**
	 * The feature id for the '<em><b>Hintergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP__HINTERGRUNDFARBE = KOMPLEX_DO_TYP__HINTERGRUNDFARBE;

	/**
	 * The number of structural features of the '<em>Kreis Do Typ</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_TYP_FEATURE_COUNT = KOMPLEX_DO_TYP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.KreisDoModelImpl <em>Kreis Do
	 * Model</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.KreisDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getKreisDoModel()
	 * @generated
	 */
	int KREIS_DO_MODEL = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Kreis Do Model</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int KREIS_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoTypImpl
	 * <em>Ortslage Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtslageDoTyp()
	 * @generated
	 */
	int ORTSLAGE_DO_TYP = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__NAME = KOMPLEX_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__ID = KOMPLEX_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__DESCRIPTION = KOMPLEX_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__SYSTEM_OBJECT_TYPE = KOMPLEX_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__ICON = KOMPLEX_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__ZOOM_STUFE = KOMPLEX_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__CONFIGURATION_ELEMENT = KOMPLEX_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = KOMPLEX_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__VORDERGRUNDFARBE = KOMPLEX_DO_TYP__VORDERGRUNDFARBE;

	/**
	 * The feature id for the '<em><b>Hintergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP__HINTERGRUNDFARBE = KOMPLEX_DO_TYP__HINTERGRUNDFARBE;

	/**
	 * The number of structural features of the '<em>Ortslage Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_TYP_FEATURE_COUNT = KOMPLEX_DO_TYP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoModelImpl
	 * <em>Ortslage Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtslageDoModel()
	 * @generated
	 */
	int ORTSLAGE_DO_MODEL = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Ortslage Do Model</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSLAGE_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoTypImpl
	 * <em>Ortsname Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtsnameDoTyp()
	 * @generated
	 */
	int ORTSNAME_DO_TYP = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Schrift</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP__SCHRIFT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Ortsname Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoModelImpl
	 * <em>Ortsname Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtsnameDoModel()
	 * @generated
	 */
	int ORTSNAME_DO_MODEL = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Ortsname Do Model</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ORTSNAME_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoTypImpl
	 * <em>Strassen Knoten Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenKnotenDoTyp()
	 * @generated
	 */
	int STRASSEN_KNOTEN_DO_TYP = 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Hintergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__HINTERGRUNDFARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__VORDERGRUNDFARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Ausgangsdurchmesser In Meter</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__AUSGANGSDURCHMESSER_IN_METER = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Minimaler Durchmesser In Pixel</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP__MINIMALER_DURCHMESSER_IN_PIXEL = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The number of structural features of the '<em>Strassen Knoten Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoModelImpl
	 * <em>Strassen Knoten Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenKnotenDoModel()
	 * @generated
	 */
	int STRASSEN_KNOTEN_DO_MODEL = 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Strassen Knoten Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_KNOTEN_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl
	 * <em>Stoerfall Indikator Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStoerfallIndikatorDoTyp()
	 * @generated
	 */
	int STOERFALL_INDIKATOR_DO_TYP = 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Stoerung Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Keine Aussage Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Freier Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Lebhafter Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Dichter Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Zaehfliessender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Stockender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Stau Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The number of structural features of the '<em>Stoerfall Indikator Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoModelImpl
	 * <em>Stoerfall Indikator Do Model</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStoerfallIndikatorDoModel()
	 * @generated
	 */
	int STOERFALL_INDIKATOR_DO_MODEL = 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Stoerfall Indikator Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl
	 * <em>Strassen Segment Stoerfall Indikator Do Typ</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentStoerfallIndikatorDoTyp()
	 * @generated
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP = 15;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__NAME = STOERFALL_INDIKATOR_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ID = STOERFALL_INDIKATOR_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION = STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE = STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ICON = STOERFALL_INDIKATOR_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE = STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT = STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Stoerung Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE;

	/**
	 * The feature id for the '<em><b>Keine Aussage Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE = STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE;

	/**
	 * The feature id for the '<em><b>Freier Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Lebhafter Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Dichter Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Zaehfliessender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stockender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stau Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE = STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 9;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 10;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 11;

	/**
	 * The number of structural features of the '<em>Strassen Segment Stoerfall
	 * Indikator Do Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 12;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoModelImpl
	 * <em>Strassen Segment Stoerfall Indikator Do Model</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentStoerfallIndikatorDoModel()
	 * @generated
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL = 16;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__NAME = STOERFALL_INDIKATOR_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__LOCATION = STOERFALL_INDIKATOR_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID = STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__DO_TYP = STOERFALL_INDIKATOR_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU = STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION = STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Strassen Segment Stoerfall
	 * Indikator Do Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoTypImpl
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Typ</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenTeilSegmentStoerfallIndikatorDoTyp()
	 * @generated
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP = 17;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__NAME = STOERFALL_INDIKATOR_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ID = STOERFALL_INDIKATOR_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION = STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE = STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ICON = STOERFALL_INDIKATOR_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE = STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT = STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Stoerung Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE;

	/**
	 * The feature id for the '<em><b>Keine Aussage Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE = STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE;

	/**
	 * The feature id for the '<em><b>Freier Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Lebhafter Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Dichter Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Zaehfliessender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stockender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stau Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE = STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 9;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 10;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 11;

	/**
	 * The number of structural features of the '<em>Strassen Teil Segment
	 * Stoerfall Indikator Do Typ</em>' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 12;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoModelImpl
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Model</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenTeilSegmentStoerfallIndikatorDoModel()
	 * @generated
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL = 18;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__NAME = STOERFALL_INDIKATOR_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__LOCATION = STOERFALL_INDIKATOR_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID = STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__DO_TYP = STOERFALL_INDIKATOR_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU = STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION = STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Strassen Teil Segment
	 * Stoerfall Indikator Do Model</em>' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoTypImpl
	 * <em>Mess Querschnitt Stoerfall Indikator Do Typ</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittStoerfallIndikatorDoTyp()
	 * @generated
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP = 19;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__NAME = STOERFALL_INDIKATOR_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__ID = STOERFALL_INDIKATOR_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION = STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE = STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__ICON = STOERFALL_INDIKATOR_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE = STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT = STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Stoerung Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE;

	/**
	 * The feature id for the '<em><b>Keine Aussage Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE = STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE;

	/**
	 * The feature id for the '<em><b>Freier Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Lebhafter Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Dichter Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Zaehfliessender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stockender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stau Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE = STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 9;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 10;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 11;

	/**
	 * The number of structural features of the '<em>Mess Querschnitt Stoerfall
	 * Indikator Do Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 12;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoModelImpl
	 * <em>Mess Querschnitt Stoerfall Indikator Do Model</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittStoerfallIndikatorDoModel()
	 * @generated
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL = 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__NAME = STOERFALL_INDIKATOR_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__LOCATION = STOERFALL_INDIKATOR_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID = STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__DO_TYP = STOERFALL_INDIKATOR_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU = STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION = STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Mess Querschnitt Stoerfall
	 * Indikator Do Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoTypImpl
	 * <em>Fahr Streifen Stoerfall Indikator Do Typ</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getFahrStreifenStoerfallIndikatorDoTyp()
	 * @generated
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP = 21;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__NAME = STOERFALL_INDIKATOR_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__ID = STOERFALL_INDIKATOR_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION = STOERFALL_INDIKATOR_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE = STOERFALL_INDIKATOR_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__ICON = STOERFALL_INDIKATOR_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE = STOERFALL_INDIKATOR_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT = STOERFALL_INDIKATOR_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = STOERFALL_INDIKATOR_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Stoerung Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE;

	/**
	 * The feature id for the '<em><b>Keine Aussage Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE = STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE;

	/**
	 * The feature id for the '<em><b>Freier Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Lebhafter Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Dichter Verkehr Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Zaehfliessender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stockender Verkehr Farbe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE = STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE;

	/**
	 * The feature id for the '<em><b>Stau Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE = STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 9;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 10;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 11;

	/**
	 * The feature id for the '<em><b>Fahrstreifenabstand</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__FAHRSTREIFENABSTAND = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 12;

	/**
	 * The number of structural features of the '<em>Fahr Streifen Stoerfall
	 * Indikator Do Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_TYP_FEATURE_COUNT
			+ 13;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoModelImpl
	 * <em>Fahr Streifen Stoerfall Indikator Do Model</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getFahrStreifenStoerfallIndikatorDoModel()
	 * @generated
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL = 22;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__NAME = STOERFALL_INDIKATOR_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__LOCATION = STOERFALL_INDIKATOR_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID = STOERFALL_INDIKATOR_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__DO_TYP = STOERFALL_INDIKATOR_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU = STOERFALL_INDIKATOR_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION = STOERFALL_INDIKATOR_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN = STOERFALL_INDIKATOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT = STOERFALL_INDIKATOR_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Fahr Streifen Stoerfall
	 * Indikator Do Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT = STOERFALL_INDIKATOR_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoTypImpl
	 * <em>Umfeld Daten Mess Stelle Do Typ</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUmfeldDatenMessStelleDoTyp()
	 * @generated
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP = 23;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The number of structural features of the '<em>Umfeld Daten Mess Stelle Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoModelImpl
	 * <em>Umfeld Daten Mess Stelle Do Model</em>}' class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUmfeldDatenMessStelleDoModel()
	 * @generated
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL = 24;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The feature id for the '<em><b>Image Typ</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL__IMAGE_TYP = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Umfeld Daten Mess Stelle Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UMFELD_DATEN_MESS_STELLE_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoTypImpl
	 * <em>Anzeige Querschnitt Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getAnzeigeQuerschnittDoTyp()
	 * @generated
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP = 25;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The number of structural features of the '<em>Anzeige Querschnitt Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoModelImpl
	 * <em>Anzeige Querschnitt Do Model</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getAnzeigeQuerschnittDoModel()
	 * @generated
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL = 26;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The feature id for the '<em><b>Drehwinkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL__DREHWINKEL = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Anzeige Querschnitt Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANZEIGE_QUERSCHNITT_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoTypImpl
	 * <em>Gewaesser Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getGewaesserDoTyp()
	 * @generated
	 */
	int GEWAESSER_DO_TYP = 27;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__NAME = KOMPLEX_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__ID = KOMPLEX_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__DESCRIPTION = KOMPLEX_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__SYSTEM_OBJECT_TYPE = KOMPLEX_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__ICON = KOMPLEX_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__ZOOM_STUFE = KOMPLEX_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__CONFIGURATION_ELEMENT = KOMPLEX_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = KOMPLEX_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__VORDERGRUNDFARBE = KOMPLEX_DO_TYP__VORDERGRUNDFARBE;

	/**
	 * The feature id for the '<em><b>Hintergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP__HINTERGRUNDFARBE = KOMPLEX_DO_TYP__HINTERGRUNDFARBE;

	/**
	 * The number of structural features of the '<em>Gewaesser Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_TYP_FEATURE_COUNT = KOMPLEX_DO_TYP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoModelImpl
	 * <em>Gewaesser Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getGewaesserDoModel()
	 * @generated
	 */
	int GEWAESSER_DO_MODEL = 28;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Gewaesser Do Model</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GEWAESSER_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.SituationDoModelImpl
	 * <em>Situation Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.SituationDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getSituationDoModel()
	 * @generated
	 */
	int SITUATION_DO_MODEL = 29;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Situation Do Model</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp <em>Situation
	 * Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getSituationSymbolDoTyp()
	 * @generated
	 */
	int SITUATION_SYMBOL_DO_TYP = 30;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Antikollisionsalgorithmus
	 * Anwenden</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The number of structural features of the '<em>Situation Symbol Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_SYMBOL_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
	 * <em>Situation Verlauf Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getSituationVerlaufDoTyp()
	 * @generated
	 */
	int SITUATION_VERLAUF_DO_TYP = 31;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__VORDERGRUNDFARBE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENSTAERKE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 8;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 9;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 10;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 11;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 12;

	/**
	 * The number of structural features of the '<em>Situation Verlauf Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SITUATION_VERLAUF_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 13;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleDoTypImpl
	 * <em>Baustelle Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleDoTyp()
	 * @generated
	 */
	int BAUSTELLE_DO_TYP = 32;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The number of structural features of the '<em>Baustelle Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoTypImpl
	 * <em>Baustelle Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleSymbolDoTyp()
	 * @generated
	 */
	int BAUSTELLE_SYMBOL_DO_TYP = 33;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__NAME = BAUSTELLE_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__ID = BAUSTELLE_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__DESCRIPTION = BAUSTELLE_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__SYSTEM_OBJECT_TYPE = BAUSTELLE_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__ICON = BAUSTELLE_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__ZOOM_STUFE = BAUSTELLE_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__CONFIGURATION_ELEMENT = BAUSTELLE_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = BAUSTELLE_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = BAUSTELLE_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = BAUSTELLE_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = BAUSTELLE_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMUM = BAUSTELLE_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__LINIENABSTAND_MINIMUM = BAUSTELLE_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__LINIENABSTAND = BAUSTELLE_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Antikollisionsalgorithmus
	 * Anwenden</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Baustelle Symbol Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_TYP_FEATURE_COUNT = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoModelImpl
	 * <em>Baustelle Symbol Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleSymbolDoModel()
	 * @generated
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL = 34;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__NAME = SITUATION_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__LOCATION = SITUATION_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__KOMPONENTEN_ID = SITUATION_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__DO_TYP = SITUATION_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__SYSTEM_OBJECT = SITUATION_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__RELATIV_ZU = SITUATION_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__ABSOLUTE_LOCATION = SITUATION_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__EINGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL__SYSTEM_OBJEKT = SITUATION_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Baustelle Symbol Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_SYMBOL_DO_MODEL_FEATURE_COUNT = SITUATION_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoTypImpl
	 * <em>Baustelle Verlauf Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleVerlaufDoTyp()
	 * @generated
	 */
	int BAUSTELLE_VERLAUF_DO_TYP = 35;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__NAME = BAUSTELLE_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__ID = BAUSTELLE_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__DESCRIPTION = BAUSTELLE_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__SYSTEM_OBJECT_TYPE = BAUSTELLE_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__ICON = BAUSTELLE_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__ZOOM_STUFE = BAUSTELLE_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__CONFIGURATION_ELEMENT = BAUSTELLE_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = BAUSTELLE_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = BAUSTELLE_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = BAUSTELLE_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = BAUSTELLE_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMUM = BAUSTELLE_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENABSTAND_MINIMUM = BAUSTELLE_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENABSTAND = BAUSTELLE_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__VORDERGRUNDFARBE = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMUM = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMUM = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP__LINIENSTAERKE = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The number of structural features of the '<em>Baustelle Verlauf Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_TYP_FEATURE_COUNT = BAUSTELLE_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoModelImpl
	 * <em>Baustelle Verlauf Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleVerlaufDoModel()
	 * @generated
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL = 36;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__NAME = SITUATION_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__LOCATION = SITUATION_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__KOMPONENTEN_ID = SITUATION_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__DO_TYP = SITUATION_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__SYSTEM_OBJECT = SITUATION_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__RELATIV_ZU = SITUATION_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__ABSOLUTE_LOCATION = SITUATION_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__EINGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL__SYSTEM_OBJEKT = SITUATION_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Baustelle Verlauf Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BAUSTELLE_VERLAUF_DO_MODEL_FEATURE_COUNT = SITUATION_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauDoTypImpl <em>Stau Do
	 * Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StauDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauDoTyp()
	 * @generated
	 */
	int STAU_DO_TYP = 37;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The number of structural features of the '<em>Stau Do Typ</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoTypImpl <em>Stau
	 * Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauSymbolDoTyp()
	 * @generated
	 */
	int STAU_SYMBOL_DO_TYP = 38;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__NAME = STAU_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__ID = STAU_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__DESCRIPTION = STAU_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__SYSTEM_OBJECT_TYPE = STAU_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__ICON = STAU_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__ZOOM_STUFE = STAU_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__CONFIGURATION_ELEMENT = STAU_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = STAU_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = STAU_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = STAU_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = STAU_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMUM = STAU_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__LINIENABSTAND_MINIMUM = STAU_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__LINIENABSTAND = STAU_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Antikollisionsalgorithmus
	 * Anwenden</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = STAU_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Stau Symbol Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_TYP_FEATURE_COUNT = STAU_DO_TYP_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoModelImpl
	 * <em>Stau Symbol Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauSymbolDoModel()
	 * @generated
	 */
	int STAU_SYMBOL_DO_MODEL = 39;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__NAME = SITUATION_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__LOCATION = SITUATION_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__KOMPONENTEN_ID = SITUATION_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__DO_TYP = SITUATION_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__SYSTEM_OBJECT = SITUATION_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__RELATIV_ZU = SITUATION_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__ABSOLUTE_LOCATION = SITUATION_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__EINGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL__SYSTEM_OBJEKT = SITUATION_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Stau Symbol Do Model</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_SYMBOL_DO_MODEL_FEATURE_COUNT = SITUATION_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoTypImpl <em>Stau
	 * Verlauf Do Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauVerlaufDoTyp()
	 * @generated
	 */
	int STAU_VERLAUF_DO_TYP = 40;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__NAME = STAU_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__ID = STAU_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__DESCRIPTION = STAU_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__SYSTEM_OBJECT_TYPE = STAU_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__ICON = STAU_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__ZOOM_STUFE = STAU_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__CONFIGURATION_ELEMENT = STAU_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = STAU_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = STAU_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = STAU_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = STAU_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMUM = STAU_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENABSTAND_MINIMUM = STAU_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENABSTAND = STAU_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__VORDERGRUNDFARBE = STAU_DO_TYP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = STAU_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = STAU_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = STAU_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMUM = STAU_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMUM = STAU_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP__LINIENSTAERKE = STAU_DO_TYP_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Stau Verlauf Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_TYP_FEATURE_COUNT = STAU_DO_TYP_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoModelImpl
	 * <em>Stau Verlauf Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauVerlaufDoModel()
	 * @generated
	 */
	int STAU_VERLAUF_DO_MODEL = 41;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__NAME = SITUATION_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__LOCATION = SITUATION_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__KOMPONENTEN_ID = SITUATION_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__DO_TYP = SITUATION_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__SYSTEM_OBJECT = SITUATION_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__RELATIV_ZU = SITUATION_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__ABSOLUTE_LOCATION = SITUATION_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__EINGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL__SYSTEM_OBJEKT = SITUATION_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Stau Verlauf Do Model</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STAU_VERLAUF_DO_MODEL_FEATURE_COUNT = SITUATION_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoTypImpl
	 * <em>Unfall Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUnfallSymbolDoTyp()
	 * @generated
	 */
	int UNFALL_SYMBOL_DO_TYP = 42;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__NAME = SITUATION_SYMBOL_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__ID = SITUATION_SYMBOL_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__DESCRIPTION = SITUATION_SYMBOL_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__SYSTEM_OBJECT_TYPE = SITUATION_SYMBOL_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__ICON = SITUATION_SYMBOL_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__ZOOM_STUFE = SITUATION_SYMBOL_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__CONFIGURATION_ELEMENT = SITUATION_SYMBOL_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = SITUATION_SYMBOL_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Antikollisionsalgorithmus
	 * Anwenden</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = SITUATION_SYMBOL_DO_TYP__ANTIKOLLISIONSALGORITHMUS_ANWENDEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMUM = SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__LINIENABSTAND_MINIMUM = SITUATION_SYMBOL_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP__LINIENABSTAND = SITUATION_SYMBOL_DO_TYP__LINIENABSTAND;

	/**
	 * The number of structural features of the '<em>Unfall Symbol Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_TYP_FEATURE_COUNT = SITUATION_SYMBOL_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoModelImpl
	 * <em>Unfall Symbol Do Model</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUnfallSymbolDoModel()
	 * @generated
	 */
	int UNFALL_SYMBOL_DO_MODEL = 43;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__NAME = SITUATION_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__LOCATION = SITUATION_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__KOMPONENTEN_ID = SITUATION_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__DO_TYP = SITUATION_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__SYSTEM_OBJECT = SITUATION_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__RELATIV_ZU = SITUATION_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__ABSOLUTE_LOCATION = SITUATION_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__EINGEHENDE_VERBINDUNGEN = SITUATION_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL__SYSTEM_OBJEKT = SITUATION_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Unfall Symbol Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UNFALL_SYMBOL_DO_MODEL_FEATURE_COUNT = SITUATION_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl <em>Rds
	 * Meldung Do Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungDoTyp()
	 * @generated
	 */
	int RDS_MELDUNG_DO_TYP = 44;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The number of structural features of the '<em>Rds Meldung Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoTypImpl
	 * <em>Rds Meldung Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungSymbolDoTyp()
	 * @generated
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP = 45;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__NAME = RDS_MELDUNG_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__ID = RDS_MELDUNG_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__DESCRIPTION = RDS_MELDUNG_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__SYSTEM_OBJECT_TYPE = RDS_MELDUNG_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__ICON = RDS_MELDUNG_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__ZOOM_STUFE = RDS_MELDUNG_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__CONFIGURATION_ELEMENT = RDS_MELDUNG_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = RDS_MELDUNG_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMUM = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MINIMUM = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND = RDS_MELDUNG_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Antikollisionsalgorithmus
	 * Anwenden</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Rds Meldung Symbol Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_TYP_FEATURE_COUNT = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoModelImpl
	 * <em>Rds Meldung Symbol Do Model</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungSymbolDoModel()
	 * @generated
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL = 46;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Rds Meldung Symbol Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_SYMBOL_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoTypImpl
	 * <em>Rds Meldung Verlauf Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungVerlaufDoTyp()
	 * @generated
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP = 47;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__NAME = RDS_MELDUNG_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__ID = RDS_MELDUNG_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__DESCRIPTION = RDS_MELDUNG_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__SYSTEM_OBJECT_TYPE = RDS_MELDUNG_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__ICON = RDS_MELDUNG_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__ZOOM_STUFE = RDS_MELDUNG_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__CONFIGURATION_ELEMENT = RDS_MELDUNG_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = RDS_MELDUNG_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMUM = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MINIMUM = RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND = RDS_MELDUNG_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__VORDERGRUNDFARBE = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMUM = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMUM = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The number of structural features of the '<em>Rds Meldung Verlauf Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_TYP_FEATURE_COUNT = RDS_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoModelImpl
	 * <em>Rds Meldung Verlauf Do Model</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungVerlaufDoModel()
	 * @generated
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL = 48;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Rds Meldung Verlauf Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RDS_MELDUNG_VERLAUF_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoTypImpl
	 * <em>Mess Querschnitt NBA Han Do Typ</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittNBAHanDoTyp()
	 * @generated
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP = 49;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__NAME = MESS_QUERSCHNITT_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__ID = MESS_QUERSCHNITT_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__DESCRIPTION = MESS_QUERSCHNITT_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__SYSTEM_OBJECT_TYPE = MESS_QUERSCHNITT_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__ICON = MESS_QUERSCHNITT_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__ZOOM_STUFE = MESS_QUERSCHNITT_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__CONFIGURATION_ELEMENT = MESS_QUERSCHNITT_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = MESS_QUERSCHNITT_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Skalierungsfaktor</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__SKALIERUNGSFAKTOR = MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR;

	/**
	 * The feature id for the '<em><b>Keine Quelle Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__KEINE_QUELLE_FARBE = MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE;

	/**
	 * The feature id for the '<em><b>Keine Daten Farbe</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__KEINE_DATEN_FARBE = MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE;

	/**
	 * The feature id for the '<em><b>Nutzdaten Farbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__NUTZDATEN_FARBE = MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__LINIENABSTAND_MAXIMUM = MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__LINIENABSTAND_MINIMUM = MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__LINIENABSTAND = MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Tooltip Zeitstempel Format</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT = MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten Fix</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP__ZOOM_VERHALTEN_FIX = MESS_QUERSCHNITT_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Mess Querschnitt NBA Han Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_TYP_FEATURE_COUNT = MESS_QUERSCHNITT_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoModelImpl
	 * <em>Mess Querschnitt NBA Han Do Model</em>}' class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittNBAHanDoModel()
	 * @generated
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL = 50;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__NAME = MESS_QUERSCHNITT_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__LOCATION = MESS_QUERSCHNITT_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__KOMPONENTEN_ID = MESS_QUERSCHNITT_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__DO_TYP = MESS_QUERSCHNITT_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__SYSTEM_OBJECT = MESS_QUERSCHNITT_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__RELATIV_ZU = MESS_QUERSCHNITT_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__ABSOLUTE_LOCATION = MESS_QUERSCHNITT_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = MESS_QUERSCHNITT_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__EINGEHENDE_VERBINDUNGEN = MESS_QUERSCHNITT_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__SYSTEM_OBJEKT = MESS_QUERSCHNITT_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The feature id for the '<em><b>Skalierungsfaktor</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__SKALIERUNGSFAKTOR = MESS_QUERSCHNITT_DO_MODEL__SKALIERUNGSFAKTOR;

	/**
	 * The feature id for the '<em><b>Drehwinkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL__DREHWINKEL = MESS_QUERSCHNITT_DO_MODEL__DREHWINKEL;

	/**
	 * The number of structural features of the '<em>Mess Querschnitt NBA Han Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESS_QUERSCHNITT_NBA_HAN_DO_MODEL_FEATURE_COUNT = MESS_QUERSCHNITT_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp <em>Tmc Meldung Do
	 * Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungDoTyp()
	 * @generated
	 */
	int TMC_MELDUNG_DO_TYP = 51;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__NAME = DobjPackage.CONFIGURATED_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__ID = DobjPackage.CONFIGURATED_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__DESCRIPTION = DobjPackage.CONFIGURATED_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__SYSTEM_OBJECT_TYPE = DobjPackage.CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__ICON = DobjPackage.CONFIGURATED_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__ZOOM_STUFE = DobjPackage.CONFIGURATED_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__CONFIGURATION_ELEMENT = DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP__LINIENABSTAND = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The number of structural features of the '<em>Tmc Meldung Do Typ</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_DO_TYP_FEATURE_COUNT = DobjPackage.CONFIGURATED_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoTypImpl
	 * <em>Tmc Meldung Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungSymbolDoTyp()
	 * @generated
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP = 52;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__NAME = TMC_MELDUNG_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__ID = TMC_MELDUNG_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__DESCRIPTION = TMC_MELDUNG_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__SYSTEM_OBJECT_TYPE = TMC_MELDUNG_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__ICON = TMC_MELDUNG_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__ZOOM_STUFE = TMC_MELDUNG_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__CONFIGURATION_ELEMENT = TMC_MELDUNG_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = TMC_MELDUNG_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = TMC_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MAXIMUM = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND_MINIMUM = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__LINIENABSTAND = TMC_MELDUNG_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Antikollisionsalgorithmus
	 * Anwenden</b></em>' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP__ANTIKOLLISIONSALGORITHMUS_ANWENDEN = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The number of structural features of the '<em>Tmc Meldung Symbol Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_TYP_FEATURE_COUNT = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoModelImpl
	 * <em>Tmc Meldung Symbol Do Model</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungSymbolDoModel()
	 * @generated
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL = 53;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Tmc Meldung Symbol Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_SYMBOL_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoTypImpl
	 * <em>Tmc Meldung Verlauf Do Typ</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoTypImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungVerlaufDoTyp()
	 * @generated
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP = 54;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__NAME = TMC_MELDUNG_DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__ID = TMC_MELDUNG_DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__DESCRIPTION = TMC_MELDUNG_DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__SYSTEM_OBJECT_TYPE = TMC_MELDUNG_DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__ICON = TMC_MELDUNG_DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__ZOOM_STUFE = TMC_MELDUNG_DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__CONFIGURATION_ELEMENT = TMC_MELDUNG_DO_TYP__CONFIGURATION_ELEMENT;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = TMC_MELDUNG_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Linienabstand Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN = TMC_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;

	/**
	 * The feature id for the '<em><b>Linienabstand Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMUM = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MINIMUM = TMC_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM;

	/**
	 * The feature id for the '<em><b>Linienabstand</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND = TMC_MELDUNG_DO_TYP__LINIENABSTAND;

	/**
	 * The feature id for the '<em><b>Vordergrundfarbe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__VORDERGRUNDFARBE = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 0;

	/**
	 * The feature id for the '<em><b>Linienstaerke Zoomverhalten</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximale Zoomstufe</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 3;

	/**
	 * The feature id for the '<em><b>Linienstaerke Maximum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMUM = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 4;

	/**
	 * The feature id for the '<em><b>Linienstaerke Minimum</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMUM = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 5;

	/**
	 * The feature id for the '<em><b>Linienstaerke</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 6;

	/**
	 * The number of structural features of the '<em>Tmc Meldung Verlauf Do
	 * Typ</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_TYP_FEATURE_COUNT = TMC_MELDUNG_DO_TYP_FEATURE_COUNT
			+ 7;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoModelImpl
	 * <em>Tmc Meldung Verlauf Do Model</em>}' class. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoModelImpl
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungVerlaufDoModel()
	 * @generated
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL = 55;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__NAME = DobjPackage.BIT_CTRL_DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__KOMPONENTEN_ID = DobjPackage.BIT_CTRL_DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__DO_TYP = DobjPackage.BIT_CTRL_DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__SYSTEM_OBJECT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__RELATIV_ZU = DobjPackage.BIT_CTRL_DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>'
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL__SYSTEM_OBJEKT = DobjPackage.BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT;

	/**
	 * The number of structural features of the '<em>Tmc Meldung Verlauf Do
	 * Model</em>' class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TMC_MELDUNG_VERLAUF_DO_MODEL_FEATURE_COUNT = DobjPackage.BIT_CTRL_DO_MODEL_FEATURE_COUNT
			+ 0;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp
	 * <em>Umfeld Daten Messstelle Image Typ</em>}' enum. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUmfeldDatenMessstelleImageTyp()
	 * @generated
	 */
	int UMFELD_DATEN_MESSSTELLE_IMAGE_TYP = 56;

	/**
	 * The meta object id for the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenTyp <em>Strassen
	 * Typ</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenTyp
	 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenTyp()
	 * @generated
	 */
	int STRASSEN_TYP = 57;

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp <em>Mess
	 * Querschnitt Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Mess Querschnitt Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp
	 * @generated
	 */
	EClass getMessQuerschnittDoTyp();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp#getTooltipZeitstempelFormat
	 * <em>Tooltip Zeitstempel Format</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Tooltip Zeitstempel
	 *         Format</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp#getTooltipZeitstempelFormat()
	 * @see #getMessQuerschnittDoTyp()
	 * @generated
	 */
	EAttribute getMessQuerschnittDoTyp_TooltipZeitstempelFormat();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel <em>Mess
	 * Querschnitt Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Mess Querschnitt Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel
	 * @generated
	 */
	EClass getMessQuerschnittDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp <em>Strassen
	 * Segment Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Strassen Segment Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp
	 * @generated
	 */
	EClass getStrassenSegmentDoTyp();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungAutobahn
	 * <em>Default Darstellung Autobahn</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Default Darstellung
	 *         Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_DefaultDarstellungAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeAutobahn
	 * <em>Vordergrund Farbe Autobahn</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Vordergrund Farbe
	 *         Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_VordergrundFarbeAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenAutobahn
	 * <em>Linienstaerke Zoomverhalten Autobahn</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Zoomverhalten Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeAutobahn
	 * <em>Linienstaerke Minimale Zoomstufe Autobahn</em>}'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Minimale
	 *         Zoomstufe Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeAutobahn
	 * <em>Linienstaerke Maximale Zoomstufe Autobahn</em>}'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Maximale
	 *         Zoomstufe Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumAutobahn
	 * <em>Linienstaerke Maximum Autobahn</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Maximum
	 *         Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumAutobahn
	 * <em>Linienstaerke Minimum Autobahn</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Minimum
	 *         Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeAutobahn
	 * <em>Linienstaerke Autobahn</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandAutobahn
	 * <em>Linienabstand Autobahn</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand
	 *         Autobahn</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandAutobahn()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienabstandAutobahn();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungBundesstrasse
	 * <em>Default Darstellung Bundesstrasse</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Default Darstellung
	 *         Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_DefaultDarstellungBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeBundesstrasse
	 * <em>Vordergrund Farbe Bundesstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Vordergrund Farbe
	 *         Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_VordergrundFarbeBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenBundesstrasse
	 * <em>Linienstaerke Zoomverhalten Bundesstrasse</em>}'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Zoomverhalten Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Linienstaerke Minimale
	 *         Zoomstufe Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Linienstaerke Maximale
	 *         Zoomstufe Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumBundesstrasse
	 * <em>Linienstaerke Maximum Bundesstrasse</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Maximum
	 *         Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumBundesstrasse
	 * <em>Linienstaerke Minimum Bundesstrasse</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Minimum
	 *         Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeBundesstrasse
	 * <em>Linienstaerke Bundesstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandBundesstrasse
	 * <em>Linienabstand Bundesstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand
	 *         Bundesstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandBundesstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienabstandBundesstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungLandstrasse
	 * <em>Default Darstellung Landstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Default Darstellung
	 *         Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_DefaultDarstellungLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeLandstrasse
	 * <em>Vordergrund Farbe Landstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Vordergrund Farbe
	 *         Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_VordergrundFarbeLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenLandstrasse
	 * <em>Linienstaerke Zoomverhalten Landstrasse</em>}'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Zoomverhalten Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeLandstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Landstrasse</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Linienstaerke Minimale
	 *         Zoomstufe Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeLandstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Landstrasse</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Linienstaerke Maximale
	 *         Zoomstufe Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumLandstrasse
	 * <em>Linienstaerke Maximum Landstrasse</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Maximum
	 *         Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumLandstrasse
	 * <em>Linienstaerke Minimum Landstrasse</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Minimum
	 *         Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeLandstrasse
	 * <em>Linienstaerke Landstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandLandstrasse
	 * <em>Linienabstand Landstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand
	 *         Landstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandLandstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienabstandLandstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeKreisstrasse
	 * <em>Vordergrund Farbe Kreisstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Vordergrund Farbe
	 *         Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_VordergrundFarbeKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenKreisstrasse
	 * <em>Linienstaerke Zoomverhalten Kreisstrasse</em>}'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Zoomverhalten Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Linienstaerke Minimale
	 *         Zoomstufe Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Linienstaerke Maximale
	 *         Zoomstufe Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumKreisstrasse
	 * <em>Linienstaerke Maximum Kreisstrasse</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Maximum
	 *         Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumKreisstrasse
	 * <em>Linienstaerke Minimum Kreisstrasse</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke Minimum
	 *         Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeKreisstrasse
	 * <em>Linienstaerke Kreisstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienstaerke
	 *         Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienstaerkeKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandKreisstrasse
	 * <em>Linienabstand Kreisstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Linienabstand
	 *         Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_LinienabstandKreisstrasse();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungKreisstrasse
	 * <em>Default Darstellung Kreisstrasse</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Default Darstellung
	 *         Kreisstrasse</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungKreisstrasse()
	 * @see #getStrassenSegmentDoTyp()
	 * @generated
	 */
	EAttribute getStrassenSegmentDoTyp_DefaultDarstellungKreisstrasse();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel
	 * <em>Strassen Segment Do Model</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Strassen Segment Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel
	 * @generated
	 */
	EClass getStrassenSegmentDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.KreisDoTyp <em>Kreis Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Kreis Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.KreisDoTyp
	 * @generated
	 */
	EClass getKreisDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.KreisDoModel <em>Kreis Do
	 * Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Kreis Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.KreisDoModel
	 * @generated
	 */
	EClass getKreisDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp <em>Ortslage Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Ortslage Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp
	 * @generated
	 */
	EClass getOrtslageDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtslageDoModel <em>Ortslage Do
	 * Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Ortslage Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtslageDoModel
	 * @generated
	 */
	EClass getOrtslageDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.KomplexDoTyp <em>Komplex Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Komplex Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.KomplexDoTyp
	 * @generated
	 */
	EClass getKomplexDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp <em>Ortsname Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Ortsname Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp
	 * @generated
	 */
	EClass getOrtsnameDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel <em>Ortsname Do
	 * Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Ortsname Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel
	 * @generated
	 */
	EClass getOrtsnameDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp <em>Strassen
	 * Knoten Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Strassen Knoten Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp
	 * @generated
	 */
	EClass getStrassenKnotenDoTyp();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getAusgangsdurchmesserInMeter
	 * <em>Ausgangsdurchmesser In Meter</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Ausgangsdurchmesser In
	 *         Meter</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getAusgangsdurchmesserInMeter()
	 * @see #getStrassenKnotenDoTyp()
	 * @generated
	 */
	EAttribute getStrassenKnotenDoTyp_AusgangsdurchmesserInMeter();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getMinimalerDurchmesserInPixel
	 * <em>Minimaler Durchmesser In Pixel</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Minimaler Durchmesser In
	 *         Pixel</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getMinimalerDurchmesserInPixel()
	 * @see #getStrassenKnotenDoTyp()
	 * @generated
	 */
	EAttribute getStrassenKnotenDoTyp_MinimalerDurchmesserInPixel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel <em>Strassen
	 * Knoten Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Strassen Knoten Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel
	 * @generated
	 */
	EClass getStrassenKnotenDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp
	 * <em>Stoerfall Indikator Do Typ</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stoerfall Indikator Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp
	 * @generated
	 */
	EClass getStoerfallIndikatorDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel
	 * <em>Stoerfall Indikator Do Model</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stoerfall Indikator Do
	 *         Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel
	 * @generated
	 */
	EClass getStoerfallIndikatorDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp
	 * <em>Strassen Segment Stoerfall Indikator Do Typ</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Strassen Segment Stoerfall
	 *         Indikator Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp
	 * @generated
	 */
	EClass getStrassenSegmentStoerfallIndikatorDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel
	 * <em>Strassen Segment Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Strassen Segment Stoerfall
	 *         Indikator Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel
	 * @generated
	 */
	EClass getStrassenSegmentStoerfallIndikatorDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Typ</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Strassen Teil Segment Stoerfall
	 *         Indikator Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp
	 * @generated
	 */
	EClass getStrassenTeilSegmentStoerfallIndikatorDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Strassen Teil Segment Stoerfall
	 *         Indikator Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel
	 * @generated
	 */
	EClass getStrassenTeilSegmentStoerfallIndikatorDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp
	 * <em>Mess Querschnitt Stoerfall Indikator Do Typ</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Mess Querschnitt Stoerfall
	 *         Indikator Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp
	 * @generated
	 */
	EClass getMessQuerschnittStoerfallIndikatorDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel
	 * <em>Mess Querschnitt Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Mess Querschnitt Stoerfall
	 *         Indikator Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel
	 * @generated
	 */
	EClass getMessQuerschnittStoerfallIndikatorDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp
	 * <em>Fahr Streifen Stoerfall Indikator Do Typ</em>}'. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Fahr Streifen Stoerfall Indikator
	 *         Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp
	 * @generated
	 */
	EClass getFahrStreifenStoerfallIndikatorDoTyp();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp#getFahrstreifenabstand
	 * <em>Fahrstreifenabstand</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for the attribute '<em>Fahrstreifenabstand</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp#getFahrstreifenabstand()
	 * @see #getFahrStreifenStoerfallIndikatorDoTyp()
	 * @generated
	 */
	EAttribute getFahrStreifenStoerfallIndikatorDoTyp_Fahrstreifenabstand();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel
	 * <em>Fahr Streifen Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Fahr Streifen Stoerfall Indikator
	 *         Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel
	 * @generated
	 */
	EClass getFahrStreifenStoerfallIndikatorDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp
	 * <em>Umfeld Daten Mess Stelle Do Typ</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Umfeld Daten Mess Stelle Do
	 *         Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp
	 * @generated
	 */
	EClass getUmfeldDatenMessStelleDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel
	 * <em>Umfeld Daten Mess Stelle Do Model</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Umfeld Daten Mess Stelle Do
	 *         Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel
	 * @generated
	 */
	EClass getUmfeldDatenMessStelleDoModel();

	/**
	 * Returns the meta object for the attribute
	 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel#getImageTyp
	 * <em>Image Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Image Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel#getImageTyp()
	 * @see #getUmfeldDatenMessStelleDoModel()
	 * @generated
	 */
	EAttribute getUmfeldDatenMessStelleDoModel_ImageTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp
	 * <em>Anzeige Querschnitt Do Typ</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Anzeige Querschnitt Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp
	 * @generated
	 */
	EClass getAnzeigeQuerschnittDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel
	 * <em>Anzeige Querschnitt Do Model</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Anzeige Querschnitt Do
	 *         Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel
	 * @generated
	 */
	EClass getAnzeigeQuerschnittDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp <em>Gewaesser Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Gewaesser Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp
	 * @generated
	 */
	EClass getGewaesserDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.GewaesserDoModel <em>Gewaesser Do
	 * Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Gewaesser Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.GewaesserDoModel
	 * @generated
	 */
	EClass getGewaesserDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationDoModel <em>Situation Do
	 * Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Situation Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.SituationDoModel
	 * @generated
	 */
	EClass getSituationDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp <em>Situation
	 * Symbol Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Situation Symbol Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp
	 * @generated
	 */
	EClass getSituationSymbolDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
	 * <em>Situation Verlauf Do Typ</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Situation Verlauf Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
	 * @generated
	 */
	EClass getSituationVerlaufDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleDoTyp <em>Baustelle Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Baustelle Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleDoTyp
	 * @generated
	 */
	EClass getBaustelleDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp <em>Baustelle
	 * Symbol Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Baustelle Symbol Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp
	 * @generated
	 */
	EClass getBaustelleSymbolDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel
	 * <em>Baustelle Symbol Do Model</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Baustelle Symbol Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel
	 * @generated
	 */
	EClass getBaustelleSymbolDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp
	 * <em>Baustelle Verlauf Do Typ</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Baustelle Verlauf Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp
	 * @generated
	 */
	EClass getBaustelleVerlaufDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel
	 * <em>Baustelle Verlauf Do Model</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Baustelle Verlauf Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel
	 * @generated
	 */
	EClass getBaustelleVerlaufDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauDoTyp <em>Stau Do Typ</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stau Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StauDoTyp
	 * @generated
	 */
	EClass getStauDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp <em>Stau Symbol Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stau Symbol Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp
	 * @generated
	 */
	EClass getStauSymbolDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel <em>Stau Symbol
	 * Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stau Symbol Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel
	 * @generated
	 */
	EClass getStauSymbolDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp <em>Stau Verlauf
	 * Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stau Verlauf Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp
	 * @generated
	 */
	EClass getStauVerlaufDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel <em>Stau
	 * Verlauf Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Stau Verlauf Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel
	 * @generated
	 */
	EClass getStauVerlaufDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp <em>Unfall
	 * Symbol Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Unfall Symbol Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp
	 * @generated
	 */
	EClass getUnfallSymbolDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel <em>Unfall
	 * Symbol Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Unfall Symbol Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel
	 * @generated
	 */
	EClass getUnfallSymbolDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp <em>Rds Meldung Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Rds Meldung Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp
	 * @generated
	 */
	EClass getRdsMeldungDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp <em>Rds
	 * Meldung Symbol Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Rds Meldung Symbol Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp
	 * @generated
	 */
	EClass getRdsMeldungSymbolDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel <em>Rds
	 * Meldung Symbol Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Rds Meldung Symbol Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel
	 * @generated
	 */
	EClass getRdsMeldungSymbolDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp <em>Rds
	 * Meldung Verlauf Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Rds Meldung Verlauf Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp
	 * @generated
	 */
	EClass getRdsMeldungVerlaufDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel <em>Rds
	 * Meldung Verlauf Do Model</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Rds Meldung Verlauf Do
	 *         Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel
	 * @generated
	 */
	EClass getRdsMeldungVerlaufDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp
	 * <em>Mess Querschnitt NBA Han Do Typ</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Mess Querschnitt NBA Han Do
	 *         Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp
	 * @generated
	 */
	EClass getMessQuerschnittNBAHanDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel
	 * <em>Mess Querschnitt NBA Han Do Model</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Mess Querschnitt NBA Han Do
	 *         Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel
	 * @generated
	 */
	EClass getMessQuerschnittNBAHanDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp <em>Tmc Meldung Do
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Tmc Meldung Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp
	 * @generated
	 */
	EClass getTmcMeldungDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp <em>Tmc
	 * Meldung Symbol Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Tmc Meldung Symbol Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp
	 * @generated
	 */
	EClass getTmcMeldungSymbolDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel <em>Tmc
	 * Meldung Symbol Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Tmc Meldung Symbol Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel
	 * @generated
	 */
	EClass getTmcMeldungSymbolDoModel();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp <em>Tmc
	 * Meldung Verlauf Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @return the meta object for class '<em>Tmc Meldung Verlauf Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp
	 * @generated
	 */
	EClass getTmcMeldungVerlaufDoTyp();

	/**
	 * Returns the meta object for class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel <em>Tmc
	 * Meldung Verlauf Do Model</em>}'. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Tmc Meldung Verlauf Do
	 *         Model</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel
	 * @generated
	 */
	EClass getTmcMeldungVerlaufDoModel();

	/**
	 * Returns the meta object for enum
	 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp
	 * <em>Umfeld Daten Messstelle Image Typ</em>}'. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the meta object for enum '<em>Umfeld Daten Messstelle Image
	 *         Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp
	 * @generated
	 */
	EEnum getUmfeldDatenMessstelleImageTyp();

	/**
	 * Returns the meta object for enum
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenTyp <em>Strassen
	 * Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for enum '<em>Strassen Typ</em>'.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenTyp
	 * @generated
	 */
	EEnum getStrassenTyp();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	NetzFactory getNetzFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl
		 * <em>Mess Querschnitt Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittDoTyp()
		 * @generated
		 */
		EClass MESS_QUERSCHNITT_DO_TYP = eINSTANCE.getMessQuerschnittDoTyp();

		/**
		 * The meta object literal for the '<em><b>Tooltip Zeitstempel
		 * Format</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT = eINSTANCE
				.getMessQuerschnittDoTyp_TooltipZeitstempelFormat();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoModelImpl
		 * <em>Mess Querschnitt Do Model</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittDoModel()
		 * @generated
		 */
		EClass MESS_QUERSCHNITT_DO_MODEL = eINSTANCE
				.getMessQuerschnittDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl
		 * <em>Strassen Segment Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentDoTyp()
		 * @generated
		 */
		EClass STRASSEN_SEGMENT_DO_TYP = eINSTANCE.getStrassenSegmentDoTyp();

		/**
		 * The meta object literal for the '<em><b>Default Darstellung
		 * Autobahn</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_DefaultDarstellungAutobahn();

		/**
		 * The meta object literal for the '<em><b>Vordergrund Farbe
		 * Autobahn</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_VordergrundFarbeAutobahn();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Zoomverhalten
		 * Autobahn</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenAutobahn();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimale
		 * Zoomstufe Autobahn</b></em>' attribute feature. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeAutobahn();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximale
		 * Zoomstufe Autobahn</b></em>' attribute feature. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeAutobahn();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximum
		 * Autobahn</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximumAutobahn();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimum
		 * Autobahn</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimumAutobahn();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke
		 * Autobahn</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeAutobahn();

		/**
		 * The meta object literal for the '<em><b>Linienabstand
		 * Autobahn</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN = eINSTANCE
				.getStrassenSegmentDoTyp_LinienabstandAutobahn();

		/**
		 * The meta object literal for the '<em><b>Default Darstellung
		 * Bundesstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_DefaultDarstellungBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Vordergrund Farbe
		 * Bundesstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_VordergrundFarbeBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Zoomverhalten
		 * Bundesstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimale
		 * Zoomstufe Bundesstrasse</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximale
		 * Zoomstufe Bundesstrasse</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximum
		 * Bundesstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximumBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimum
		 * Bundesstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimumBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke
		 * Bundesstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienabstand
		 * Bundesstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienabstandBundesstrasse();

		/**
		 * The meta object literal for the '<em><b>Default Darstellung
		 * Landstrasse</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_DefaultDarstellungLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Vordergrund Farbe
		 * Landstrasse</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_VordergrundFarbeLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Zoomverhalten
		 * Landstrasse</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimale
		 * Zoomstufe Landstrasse</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximale
		 * Zoomstufe Landstrasse</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximum
		 * Landstrasse</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximumLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimum
		 * Landstrasse</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimumLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke
		 * Landstrasse</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienabstand
		 * Landstrasse</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienabstandLandstrasse();

		/**
		 * The meta object literal for the '<em><b>Vordergrund Farbe
		 * Kreisstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_VordergrundFarbeKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Zoomverhalten
		 * Kreisstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimale
		 * Zoomstufe Kreisstrasse</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximale
		 * Zoomstufe Kreisstrasse</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Maximum
		 * Kreisstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMaximumKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke Minimum
		 * Kreisstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeMinimumKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienstaerke
		 * Kreisstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienstaerkeKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Linienabstand
		 * Kreisstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_LinienabstandKreisstrasse();

		/**
		 * The meta object literal for the '<em><b>Default Darstellung
		 * Kreisstrasse</b></em>' attribute feature. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE = eINSTANCE
				.getStrassenSegmentDoTyp_DefaultDarstellungKreisstrasse();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoModelImpl
		 * <em>Strassen Segment Do Model</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentDoModel()
		 * @generated
		 */
		EClass STRASSEN_SEGMENT_DO_MODEL = eINSTANCE
				.getStrassenSegmentDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.KreisDoTypImpl <em>Kreis
		 * Do Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.KreisDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getKreisDoTyp()
		 * @generated
		 */
		EClass KREIS_DO_TYP = eINSTANCE.getKreisDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.KreisDoModelImpl
		 * <em>Kreis Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.KreisDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getKreisDoModel()
		 * @generated
		 */
		EClass KREIS_DO_MODEL = eINSTANCE.getKreisDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoTypImpl
		 * <em>Ortslage Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtslageDoTyp()
		 * @generated
		 */
		EClass ORTSLAGE_DO_TYP = eINSTANCE.getOrtslageDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoModelImpl
		 * <em>Ortslage Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtslageDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtslageDoModel()
		 * @generated
		 */
		EClass ORTSLAGE_DO_MODEL = eINSTANCE.getOrtslageDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.KomplexDoTyp <em>Komplex Do
		 * Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.KomplexDoTyp
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getKomplexDoTyp()
		 * @generated
		 */
		EClass KOMPLEX_DO_TYP = eINSTANCE.getKomplexDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoTypImpl
		 * <em>Ortsname Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtsnameDoTyp()
		 * @generated
		 */
		EClass ORTSNAME_DO_TYP = eINSTANCE.getOrtsnameDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoModelImpl
		 * <em>Ortsname Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.OrtsnameDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getOrtsnameDoModel()
		 * @generated
		 */
		EClass ORTSNAME_DO_MODEL = eINSTANCE.getOrtsnameDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoTypImpl
		 * <em>Strassen Knoten Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenKnotenDoTyp()
		 * @generated
		 */
		EClass STRASSEN_KNOTEN_DO_TYP = eINSTANCE.getStrassenKnotenDoTyp();

		/**
		 * The meta object literal for the '<em><b>Ausgangsdurchmesser In
		 * Meter</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_KNOTEN_DO_TYP__AUSGANGSDURCHMESSER_IN_METER = eINSTANCE
				.getStrassenKnotenDoTyp_AusgangsdurchmesserInMeter();

		/**
		 * The meta object literal for the '<em><b>Minimaler Durchmesser In
		 * Pixel</b></em>' attribute feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute STRASSEN_KNOTEN_DO_TYP__MINIMALER_DURCHMESSER_IN_PIXEL = eINSTANCE
				.getStrassenKnotenDoTyp_MinimalerDurchmesserInPixel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoModelImpl
		 * <em>Strassen Knoten Do Model</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenKnotenDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenKnotenDoModel()
		 * @generated
		 */
		EClass STRASSEN_KNOTEN_DO_MODEL = eINSTANCE.getStrassenKnotenDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl
		 * <em>Stoerfall Indikator Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStoerfallIndikatorDoTyp()
		 * @generated
		 */
		EClass STOERFALL_INDIKATOR_DO_TYP = eINSTANCE
				.getStoerfallIndikatorDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoModelImpl
		 * <em>Stoerfall Indikator Do Model</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStoerfallIndikatorDoModel()
		 * @generated
		 */
		EClass STOERFALL_INDIKATOR_DO_MODEL = eINSTANCE
				.getStoerfallIndikatorDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl
		 * <em>Strassen Segment Stoerfall Indikator Do Typ</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentStoerfallIndikatorDoTyp()
		 * @generated
		 */
		EClass STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP = eINSTANCE
				.getStrassenSegmentStoerfallIndikatorDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoModelImpl
		 * <em>Strassen Segment Stoerfall Indikator Do Model</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenSegmentStoerfallIndikatorDoModel()
		 * @generated
		 */
		EClass STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL = eINSTANCE
				.getStrassenSegmentStoerfallIndikatorDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoTypImpl
		 * <em>Strassen Teil Segment Stoerfall Indikator Do Typ</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenTeilSegmentStoerfallIndikatorDoTyp()
		 * @generated
		 */
		EClass STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP = eINSTANCE
				.getStrassenTeilSegmentStoerfallIndikatorDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoModelImpl
		 * <em>Strassen Teil Segment Stoerfall Indikator Do Model</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StrassenTeilSegmentStoerfallIndikatorDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenTeilSegmentStoerfallIndikatorDoModel()
		 * @generated
		 */
		EClass STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL = eINSTANCE
				.getStrassenTeilSegmentStoerfallIndikatorDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoTypImpl
		 * <em>Mess Querschnitt Stoerfall Indikator Do Typ</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittStoerfallIndikatorDoTyp()
		 * @generated
		 */
		EClass MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP = eINSTANCE
				.getMessQuerschnittStoerfallIndikatorDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoModelImpl
		 * <em>Mess Querschnitt Stoerfall Indikator Do Model</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittStoerfallIndikatorDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittStoerfallIndikatorDoModel()
		 * @generated
		 */
		EClass MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL = eINSTANCE
				.getMessQuerschnittStoerfallIndikatorDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoTypImpl
		 * <em>Fahr Streifen Stoerfall Indikator Do Typ</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getFahrStreifenStoerfallIndikatorDoTyp()
		 * @generated
		 */
		EClass FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP = eINSTANCE
				.getFahrStreifenStoerfallIndikatorDoTyp();

		/**
		 * The meta object literal for the '<em><b>Fahrstreifenabstand</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__FAHRSTREIFENABSTAND = eINSTANCE
				.getFahrStreifenStoerfallIndikatorDoTyp_Fahrstreifenabstand();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoModelImpl
		 * <em>Fahr Streifen Stoerfall Indikator Do Model</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.FahrStreifenStoerfallIndikatorDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getFahrStreifenStoerfallIndikatorDoModel()
		 * @generated
		 */
		EClass FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL = eINSTANCE
				.getFahrStreifenStoerfallIndikatorDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoTypImpl
		 * <em>Umfeld Daten Mess Stelle Do Typ</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUmfeldDatenMessStelleDoTyp()
		 * @generated
		 */
		EClass UMFELD_DATEN_MESS_STELLE_DO_TYP = eINSTANCE
				.getUmfeldDatenMessStelleDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoModelImpl
		 * <em>Umfeld Daten Mess Stelle Do Model</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.UmfeldDatenMessStelleDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUmfeldDatenMessStelleDoModel()
		 * @generated
		 */
		EClass UMFELD_DATEN_MESS_STELLE_DO_MODEL = eINSTANCE
				.getUmfeldDatenMessStelleDoModel();

		/**
		 * The meta object literal for the '<em><b>Image Typ</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute UMFELD_DATEN_MESS_STELLE_DO_MODEL__IMAGE_TYP = eINSTANCE
				.getUmfeldDatenMessStelleDoModel_ImageTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoTypImpl
		 * <em>Anzeige Querschnitt Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getAnzeigeQuerschnittDoTyp()
		 * @generated
		 */
		EClass ANZEIGE_QUERSCHNITT_DO_TYP = eINSTANCE
				.getAnzeigeQuerschnittDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoModelImpl
		 * <em>Anzeige Querschnitt Do Model</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.AnzeigeQuerschnittDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getAnzeigeQuerschnittDoModel()
		 * @generated
		 */
		EClass ANZEIGE_QUERSCHNITT_DO_MODEL = eINSTANCE
				.getAnzeigeQuerschnittDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoTypImpl
		 * <em>Gewaesser Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getGewaesserDoTyp()
		 * @generated
		 */
		EClass GEWAESSER_DO_TYP = eINSTANCE.getGewaesserDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoModelImpl
		 * <em>Gewaesser Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.GewaesserDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getGewaesserDoModel()
		 * @generated
		 */
		EClass GEWAESSER_DO_MODEL = eINSTANCE.getGewaesserDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.SituationDoModelImpl
		 * <em>Situation Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.SituationDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getSituationDoModel()
		 * @generated
		 */
		EClass SITUATION_DO_MODEL = eINSTANCE.getSituationDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp
		 * <em>Situation Symbol Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getSituationSymbolDoTyp()
		 * @generated
		 */
		EClass SITUATION_SYMBOL_DO_TYP = eINSTANCE.getSituationSymbolDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
		 * <em>Situation Verlauf Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getSituationVerlaufDoTyp()
		 * @generated
		 */
		EClass SITUATION_VERLAUF_DO_TYP = eINSTANCE.getSituationVerlaufDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleDoTypImpl
		 * <em>Baustelle Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleDoTyp()
		 * @generated
		 */
		EClass BAUSTELLE_DO_TYP = eINSTANCE.getBaustelleDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoTypImpl
		 * <em>Baustelle Symbol Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleSymbolDoTyp()
		 * @generated
		 */
		EClass BAUSTELLE_SYMBOL_DO_TYP = eINSTANCE.getBaustelleSymbolDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoModelImpl
		 * <em>Baustelle Symbol Do Model</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleSymbolDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleSymbolDoModel()
		 * @generated
		 */
		EClass BAUSTELLE_SYMBOL_DO_MODEL = eINSTANCE
				.getBaustelleSymbolDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoTypImpl
		 * <em>Baustelle Verlauf Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleVerlaufDoTyp()
		 * @generated
		 */
		EClass BAUSTELLE_VERLAUF_DO_TYP = eINSTANCE.getBaustelleVerlaufDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoModelImpl
		 * <em>Baustelle Verlauf Do Model</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.BaustelleVerlaufDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getBaustelleVerlaufDoModel()
		 * @generated
		 */
		EClass BAUSTELLE_VERLAUF_DO_MODEL = eINSTANCE
				.getBaustelleVerlaufDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauDoTypImpl <em>Stau Do
		 * Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StauDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauDoTyp()
		 * @generated
		 */
		EClass STAU_DO_TYP = eINSTANCE.getStauDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoTypImpl
		 * <em>Stau Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauSymbolDoTyp()
		 * @generated
		 */
		EClass STAU_SYMBOL_DO_TYP = eINSTANCE.getStauSymbolDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoModelImpl
		 * <em>Stau Symbol Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StauSymbolDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauSymbolDoModel()
		 * @generated
		 */
		EClass STAU_SYMBOL_DO_MODEL = eINSTANCE.getStauSymbolDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoTypImpl
		 * <em>Stau Verlauf Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauVerlaufDoTyp()
		 * @generated
		 */
		EClass STAU_VERLAUF_DO_TYP = eINSTANCE.getStauVerlaufDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoModelImpl
		 * <em>Stau Verlauf Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.StauVerlaufDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStauVerlaufDoModel()
		 * @generated
		 */
		EClass STAU_VERLAUF_DO_MODEL = eINSTANCE.getStauVerlaufDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoTypImpl
		 * <em>Unfall Symbol Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUnfallSymbolDoTyp()
		 * @generated
		 */
		EClass UNFALL_SYMBOL_DO_TYP = eINSTANCE.getUnfallSymbolDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoModelImpl
		 * <em>Unfall Symbol Do Model</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.UnfallSymbolDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUnfallSymbolDoModel()
		 * @generated
		 */
		EClass UNFALL_SYMBOL_DO_MODEL = eINSTANCE.getUnfallSymbolDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl
		 * <em>Rds Meldung Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungDoTyp()
		 * @generated
		 */
		EClass RDS_MELDUNG_DO_TYP = eINSTANCE.getRdsMeldungDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoTypImpl
		 * <em>Rds Meldung Symbol Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungSymbolDoTyp()
		 * @generated
		 */
		EClass RDS_MELDUNG_SYMBOL_DO_TYP = eINSTANCE.getRdsMeldungSymbolDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoModelImpl
		 * <em>Rds Meldung Symbol Do Model</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungSymbolDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungSymbolDoModel()
		 * @generated
		 */
		EClass RDS_MELDUNG_SYMBOL_DO_MODEL = eINSTANCE
				.getRdsMeldungSymbolDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoTypImpl
		 * <em>Rds Meldung Verlauf Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungVerlaufDoTyp()
		 * @generated
		 */
		EClass RDS_MELDUNG_VERLAUF_DO_TYP = eINSTANCE
				.getRdsMeldungVerlaufDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoModelImpl
		 * <em>Rds Meldung Verlauf Do Model</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungVerlaufDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getRdsMeldungVerlaufDoModel()
		 * @generated
		 */
		EClass RDS_MELDUNG_VERLAUF_DO_MODEL = eINSTANCE
				.getRdsMeldungVerlaufDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoTypImpl
		 * <em>Mess Querschnitt NBA Han Do Typ</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittNBAHanDoTyp()
		 * @generated
		 */
		EClass MESS_QUERSCHNITT_NBA_HAN_DO_TYP = eINSTANCE
				.getMessQuerschnittNBAHanDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoModelImpl
		 * <em>Mess Querschnitt NBA Han Do Model</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittNBAHanDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getMessQuerschnittNBAHanDoModel()
		 * @generated
		 */
		EClass MESS_QUERSCHNITT_NBA_HAN_DO_MODEL = eINSTANCE
				.getMessQuerschnittNBAHanDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp <em>Tmc
		 * Meldung Do Typ</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungDoTyp()
		 * @generated
		 */
		EClass TMC_MELDUNG_DO_TYP = eINSTANCE.getTmcMeldungDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoTypImpl
		 * <em>Tmc Meldung Symbol Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungSymbolDoTyp()
		 * @generated
		 */
		EClass TMC_MELDUNG_SYMBOL_DO_TYP = eINSTANCE.getTmcMeldungSymbolDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoModelImpl
		 * <em>Tmc Meldung Symbol Do Model</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungSymbolDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungSymbolDoModel()
		 * @generated
		 */
		EClass TMC_MELDUNG_SYMBOL_DO_MODEL = eINSTANCE
				.getTmcMeldungSymbolDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoTypImpl
		 * <em>Tmc Meldung Verlauf Do Typ</em>}' class. <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoTypImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungVerlaufDoTyp()
		 * @generated
		 */
		EClass TMC_MELDUNG_VERLAUF_DO_TYP = eINSTANCE
				.getTmcMeldungVerlaufDoTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoModelImpl
		 * <em>Tmc Meldung Verlauf Do Model</em>}' class. <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.impl.TmcMeldungVerlaufDoModelImpl
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getTmcMeldungVerlaufDoModel()
		 * @generated
		 */
		EClass TMC_MELDUNG_VERLAUF_DO_MODEL = eINSTANCE
				.getTmcMeldungVerlaufDoModel();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp
		 * <em>Umfeld Daten Messstelle Image Typ</em>}' enum. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 *
		 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getUmfeldDatenMessstelleImageTyp()
		 * @generated
		 */
		EEnum UMFELD_DATEN_MESSSTELLE_IMAGE_TYP = eINSTANCE
				.getUmfeldDatenMessstelleImageTyp();

		/**
		 * The meta object literal for the
		 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenTyp <em>Strassen
		 * Typ</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.netz.model.StrassenTyp
		 * @see de.bsvrz.buv.plugin.netz.model.impl.NetzPackageImpl#getStrassenTyp()
		 * @generated
		 */
		EEnum STRASSEN_TYP = eINSTANCE.getStrassenTyp();

	}

} // NetzPackage
