/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model;

import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Strassen
 * Knoten Do Typ</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getAusgangsdurchmesserInMeter
 * <em>Ausgangsdurchmesser In Meter</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getMinimalerDurchmesserInPixel
 * <em>Minimaler Durchmesser In Pixel</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenKnotenDoTyp()
 * @model
 * @generated
 */
public interface StrassenKnotenDoTyp extends ConfiguratedDoTyp,
		HintergrundfarbeDecorator, VordergrundfarbeDecorator {
	/**
	 * Returns the value of the '<em><b>Ausgangsdurchmesser In Meter</b></em>'
	 * attribute. The default value is <code>"2000"</code>. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Ausgangsdurchmesser In Meter</em>'
	 *         attribute.
	 * @see #isSetAusgangsdurchmesserInMeter()
	 * @see #unsetAusgangsdurchmesserInMeter()
	 * @see #setAusgangsdurchmesserInMeter(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenKnotenDoTyp_AusgangsdurchmesserInMeter()
	 * @model default="2000" unsettable="true"
	 * @generated
	 */
	int getAusgangsdurchmesserInMeter();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getAusgangsdurchmesserInMeter
	 * <em>Ausgangsdurchmesser In Meter</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Ausgangsdurchmesser In Meter</em>'
	 *            attribute.
	 * @see #isSetAusgangsdurchmesserInMeter()
	 * @see #unsetAusgangsdurchmesserInMeter()
	 * @see #getAusgangsdurchmesserInMeter()
	 * @generated
	 */
	void setAusgangsdurchmesserInMeter(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getAusgangsdurchmesserInMeter
	 * <em>Ausgangsdurchmesser In Meter</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isSetAusgangsdurchmesserInMeter()
	 * @see #getAusgangsdurchmesserInMeter()
	 * @see #setAusgangsdurchmesserInMeter(int)
	 * @generated
	 */
	void unsetAusgangsdurchmesserInMeter();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getAusgangsdurchmesserInMeter
	 * <em>Ausgangsdurchmesser In Meter</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Ausgangsdurchmesser In Meter</em>'
	 *         attribute is set.
	 * @see #unsetAusgangsdurchmesserInMeter()
	 * @see #getAusgangsdurchmesserInMeter()
	 * @see #setAusgangsdurchmesserInMeter(int)
	 * @generated
	 */
	boolean isSetAusgangsdurchmesserInMeter();

	/**
	 * Returns the value of the '<em><b>Minimaler Durchmesser In Pixel</b></em>'
	 * attribute. The default value is <code>"5"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Minimaler Durchmesser In Pixel</em>'
	 *         attribute.
	 * @see #isSetMinimalerDurchmesserInPixel()
	 * @see #unsetMinimalerDurchmesserInPixel()
	 * @see #setMinimalerDurchmesserInPixel(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenKnotenDoTyp_MinimalerDurchmesserInPixel()
	 * @model default="5" unsettable="true"
	 * @generated
	 */
	int getMinimalerDurchmesserInPixel();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getMinimalerDurchmesserInPixel
	 * <em>Minimaler Durchmesser In Pixel</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Minimaler Durchmesser In Pixel</em>'
	 *            attribute.
	 * @see #isSetMinimalerDurchmesserInPixel()
	 * @see #unsetMinimalerDurchmesserInPixel()
	 * @see #getMinimalerDurchmesserInPixel()
	 * @generated
	 */
	void setMinimalerDurchmesserInPixel(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getMinimalerDurchmesserInPixel
	 * <em>Minimaler Durchmesser In Pixel</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isSetMinimalerDurchmesserInPixel()
	 * @see #getMinimalerDurchmesserInPixel()
	 * @see #setMinimalerDurchmesserInPixel(int)
	 * @generated
	 */
	void unsetMinimalerDurchmesserInPixel();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp#getMinimalerDurchmesserInPixel
	 * <em>Minimaler Durchmesser In Pixel</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Minimaler Durchmesser In
	 *         Pixel</em>' attribute is set.
	 * @see #unsetMinimalerDurchmesserInPixel()
	 * @see #getMinimalerDurchmesserInPixel()
	 * @see #setMinimalerDurchmesserInPixel(int)
	 * @generated
	 */
	boolean isSetMinimalerDurchmesserInPixel();

} // StrassenKnotenDoTyp
