/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model;

import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Strassen
 * Segment Do Typ</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungAutobahn
 * <em>Default Darstellung Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeAutobahn
 * <em>Vordergrund Farbe Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenAutobahn
 * <em>Linienstaerke Zoomverhalten Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeAutobahn
 * <em>Linienstaerke Minimale Zoomstufe Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeAutobahn
 * <em>Linienstaerke Maximale Zoomstufe Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumAutobahn
 * <em>Linienstaerke Maximum Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumAutobahn
 * <em>Linienstaerke Minimum Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeAutobahn
 * <em>Linienstaerke Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandAutobahn
 * <em>Linienabstand Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungBundesstrasse
 * <em>Default Darstellung Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeBundesstrasse
 * <em>Vordergrund Farbe Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenBundesstrasse
 * <em>Linienstaerke Zoomverhalten Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeBundesstrasse
 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeBundesstrasse
 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumBundesstrasse
 * <em>Linienstaerke Maximum Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumBundesstrasse
 * <em>Linienstaerke Minimum Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeBundesstrasse
 * <em>Linienstaerke Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandBundesstrasse
 * <em>Linienabstand Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungLandstrasse
 * <em>Default Darstellung Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeLandstrasse
 * <em>Vordergrund Farbe Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenLandstrasse
 * <em>Linienstaerke Zoomverhalten Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeLandstrasse
 * <em>Linienstaerke Minimale Zoomstufe Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeLandstrasse
 * <em>Linienstaerke Maximale Zoomstufe Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumLandstrasse
 * <em>Linienstaerke Maximum Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumLandstrasse
 * <em>Linienstaerke Minimum Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeLandstrasse
 * <em>Linienstaerke Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandLandstrasse
 * <em>Linienabstand Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeKreisstrasse
 * <em>Vordergrund Farbe Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenKreisstrasse
 * <em>Linienstaerke Zoomverhalten Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeKreisstrasse
 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeKreisstrasse
 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumKreisstrasse
 * <em>Linienstaerke Maximum Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumKreisstrasse
 * <em>Linienstaerke Minimum Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeKreisstrasse
 * <em>Linienstaerke Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandKreisstrasse
 * <em>Linienabstand Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungKreisstrasse
 * <em>Default Darstellung Kreisstrasse</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp()
 * @model
 * @generated
 */
public interface StrassenSegmentDoTyp
		extends ConfiguratedDoTyp, VordergrundfarbeDecorator,
		LinienstaerkeZoomDecorator, LinienabstandZoomDecorator {
	/**
	 * Returns the value of the '<em><b>Default Darstellung Autobahn</b></em>'
	 * attribute. The default value is <code>"true"</code>. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Default Darstellung Autobahn</em>'
	 *         attribute.
	 * @see #setDefaultDarstellungAutobahn(boolean)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_DefaultDarstellungAutobahn()
	 * @model default="true"
	 * @generated
	 */
	boolean isDefaultDarstellungAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungAutobahn
	 * <em>Default Darstellung Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Default Darstellung Autobahn</em>'
	 *            attribute.
	 * @see #isDefaultDarstellungAutobahn()
	 * @generated
	 */
	void setDefaultDarstellungAutobahn(boolean value);

	/**
	 * Returns the value of the '<em><b>Vordergrund Farbe Autobahn</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Vordergrund Farbe Autobahn</em>' attribute.
	 * @see #setVordergrundFarbeAutobahn(RGB)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_VordergrundFarbeAutobahn()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.eclipse.model.RGB"
	 * @generated
	 */
	RGB getVordergrundFarbeAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeAutobahn
	 * <em>Vordergrund Farbe Autobahn</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Vordergrund Farbe Autobahn</em>'
	 *            attribute.
	 * @see #getVordergrundFarbeAutobahn()
	 * @generated
	 */
	void setVordergrundFarbeAutobahn(RGB value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Zoomverhalten
	 * Autobahn</b></em>' attribute. The default value is
	 * <code>"statisches Zoomverhalten"</code>. The literals are from the
	 * enumeration
	 * {@link de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Linienstaerke Zoomverhalten Autobahn</em>'
	 *         attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #setLinienstaerkeZoomverhaltenAutobahn(Zoomverhalten)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenAutobahn()
	 * @model default="statisches Zoomverhalten"
	 * @generated
	 */
	Zoomverhalten getLinienstaerkeZoomverhaltenAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenAutobahn
	 * <em>Linienstaerke Zoomverhalten Autobahn</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Zoomverhalten
	 *            Autobahn</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #getLinienstaerkeZoomverhaltenAutobahn()
	 * @generated
	 */
	void setLinienstaerkeZoomverhaltenAutobahn(Zoomverhalten value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Autobahn</b></em>' attribute. The default value is <code>"1"</code>. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Autobahn</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #setLinienstaerkeMinimaleZoomstufeAutobahn(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeAutobahn()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimaleZoomstufeAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeAutobahn
	 * <em>Linienstaerke Minimale Zoomstufe Autobahn</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimale Zoomstufe
	 *            Autobahn</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #getLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @generated
	 */
	void setLinienstaerkeMinimaleZoomstufeAutobahn(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeAutobahn
	 * <em>Linienstaerke Minimale Zoomstufe Autobahn</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #getLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #setLinienstaerkeMinimaleZoomstufeAutobahn(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimaleZoomstufeAutobahn();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeAutobahn
	 * <em>Linienstaerke Minimale Zoomstufe Autobahn</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Autobahn</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #getLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @see #setLinienstaerkeMinimaleZoomstufeAutobahn(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimaleZoomstufeAutobahn();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Autobahn</b></em>' attribute. The default value is <code>"5000"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Autobahn</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #setLinienstaerkeMaximaleZoomstufeAutobahn(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeAutobahn()
	 * @model default="5000" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximaleZoomstufeAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeAutobahn
	 * <em>Linienstaerke Maximale Zoomstufe Autobahn</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximale Zoomstufe
	 *            Autobahn</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #getLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @generated
	 */
	void setLinienstaerkeMaximaleZoomstufeAutobahn(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeAutobahn
	 * <em>Linienstaerke Maximale Zoomstufe Autobahn</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #getLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #setLinienstaerkeMaximaleZoomstufeAutobahn(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximaleZoomstufeAutobahn();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeAutobahn
	 * <em>Linienstaerke Maximale Zoomstufe Autobahn</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Autobahn</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #getLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @see #setLinienstaerkeMaximaleZoomstufeAutobahn(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximaleZoomstufeAutobahn();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximum Autobahn</b></em>'
	 * attribute. The default value is <code>"1"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximum Autobahn</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMaximumAutobahn()
	 * @see #unsetLinienstaerkeMaximumAutobahn()
	 * @see #setLinienstaerkeMaximumAutobahn(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximumAutobahn()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximumAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumAutobahn
	 * <em>Linienstaerke Maximum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximum Autobahn</em>'
	 *            attribute.
	 * @see #isSetLinienstaerkeMaximumAutobahn()
	 * @see #unsetLinienstaerkeMaximumAutobahn()
	 * @see #getLinienstaerkeMaximumAutobahn()
	 * @generated
	 */
	void setLinienstaerkeMaximumAutobahn(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumAutobahn
	 * <em>Linienstaerke Maximum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isSetLinienstaerkeMaximumAutobahn()
	 * @see #getLinienstaerkeMaximumAutobahn()
	 * @see #setLinienstaerkeMaximumAutobahn(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximumAutobahn();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumAutobahn
	 * <em>Linienstaerke Maximum Autobahn</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Maximum
	 *         Autobahn</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximumAutobahn()
	 * @see #getLinienstaerkeMaximumAutobahn()
	 * @see #setLinienstaerkeMaximumAutobahn(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximumAutobahn();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimum Autobahn</b></em>'
	 * attribute. The default value is <code>"1"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Minimum Autobahn</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMinimumAutobahn()
	 * @see #unsetLinienstaerkeMinimumAutobahn()
	 * @see #setLinienstaerkeMinimumAutobahn(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimumAutobahn()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimumAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumAutobahn
	 * <em>Linienstaerke Minimum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimum Autobahn</em>'
	 *            attribute.
	 * @see #isSetLinienstaerkeMinimumAutobahn()
	 * @see #unsetLinienstaerkeMinimumAutobahn()
	 * @see #getLinienstaerkeMinimumAutobahn()
	 * @generated
	 */
	void setLinienstaerkeMinimumAutobahn(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumAutobahn
	 * <em>Linienstaerke Minimum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isSetLinienstaerkeMinimumAutobahn()
	 * @see #getLinienstaerkeMinimumAutobahn()
	 * @see #setLinienstaerkeMinimumAutobahn(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimumAutobahn();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumAutobahn
	 * <em>Linienstaerke Minimum Autobahn</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Minimum
	 *         Autobahn</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimumAutobahn()
	 * @see #getLinienstaerkeMinimumAutobahn()
	 * @see #setLinienstaerkeMinimumAutobahn(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimumAutobahn();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Autobahn</b></em>'
	 * attribute. The default value is <code>"1"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Autobahn</em>' attribute.
	 * @see #isSetLinienstaerkeAutobahn()
	 * @see #unsetLinienstaerkeAutobahn()
	 * @see #setLinienstaerkeAutobahn(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeAutobahn()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeAutobahn
	 * <em>Linienstaerke Autobahn</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienstaerke Autobahn</em>'
	 *            attribute.
	 * @see #isSetLinienstaerkeAutobahn()
	 * @see #unsetLinienstaerkeAutobahn()
	 * @see #getLinienstaerkeAutobahn()
	 * @generated
	 */
	void setLinienstaerkeAutobahn(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeAutobahn
	 * <em>Linienstaerke Autobahn</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isSetLinienstaerkeAutobahn()
	 * @see #getLinienstaerkeAutobahn()
	 * @see #setLinienstaerkeAutobahn(int)
	 * @generated
	 */
	void unsetLinienstaerkeAutobahn();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeAutobahn
	 * <em>Linienstaerke Autobahn</em>}' attribute is set. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Autobahn</em>'
	 *         attribute is set.
	 * @see #unsetLinienstaerkeAutobahn()
	 * @see #getLinienstaerkeAutobahn()
	 * @see #setLinienstaerkeAutobahn(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeAutobahn();

	/**
	 * Returns the value of the '<em><b>Linienabstand Autobahn</b></em>'
	 * attribute. The default value is <code>"0"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienabstand Autobahn</em>' attribute.
	 * @see #setLinienabstandAutobahn(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienabstandAutobahn()
	 * @model default="0"
	 * @generated
	 */
	int getLinienabstandAutobahn();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandAutobahn
	 * <em>Linienabstand Autobahn</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienabstand Autobahn</em>'
	 *            attribute.
	 * @see #getLinienabstandAutobahn()
	 * @generated
	 */
	void setLinienabstandAutobahn(int value);

	/**
	 * Returns the value of the '<em><b>Default Darstellung
	 * Bundesstrasse</b></em>' attribute. The default value is
	 * <code>"true"</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Default Darstellung Bundesstrasse</em>'
	 *         attribute.
	 * @see #setDefaultDarstellungBundesstrasse(boolean)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_DefaultDarstellungBundesstrasse()
	 * @model default="true"
	 * @generated
	 */
	boolean isDefaultDarstellungBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungBundesstrasse
	 * <em>Default Darstellung Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Default Darstellung
	 *            Bundesstrasse</em>' attribute.
	 * @see #isDefaultDarstellungBundesstrasse()
	 * @generated
	 */
	void setDefaultDarstellungBundesstrasse(boolean value);

	/**
	 * Returns the value of the '<em><b>Vordergrund Farbe
	 * Bundesstrasse</b></em>' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the value of the '<em>Vordergrund Farbe Bundesstrasse</em>'
	 *         attribute.
	 * @see #setVordergrundFarbeBundesstrasse(RGB)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_VordergrundFarbeBundesstrasse()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.eclipse.model.RGB"
	 * @generated
	 */
	RGB getVordergrundFarbeBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeBundesstrasse
	 * <em>Vordergrund Farbe Bundesstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Vordergrund Farbe
	 *            Bundesstrasse</em>' attribute.
	 * @see #getVordergrundFarbeBundesstrasse()
	 * @generated
	 */
	void setVordergrundFarbeBundesstrasse(RGB value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Zoomverhalten
	 * Bundesstrasse</b></em>' attribute. The default value is
	 * <code>"statisches Zoomverhalten"</code>. The literals are from the
	 * enumeration
	 * {@link de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Linienstaerke Zoomverhalten
	 *         Bundesstrasse</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #setLinienstaerkeZoomverhaltenBundesstrasse(Zoomverhalten)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenBundesstrasse()
	 * @model default="statisches Zoomverhalten"
	 * @generated
	 */
	Zoomverhalten getLinienstaerkeZoomverhaltenBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenBundesstrasse
	 * <em>Linienstaerke Zoomverhalten Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Zoomverhalten
	 *            Bundesstrasse</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #getLinienstaerkeZoomverhaltenBundesstrasse()
	 * @generated
	 */
	void setLinienstaerkeZoomverhaltenBundesstrasse(Zoomverhalten value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Bundesstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Bundesstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeBundesstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimaleZoomstufeBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimale Zoomstufe
	 *            Bundesstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @generated
	 */
	void setLinienstaerkeMinimaleZoomstufeBundesstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeBundesstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimaleZoomstufeBundesstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}' attribute is
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Bundesstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeBundesstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimaleZoomstufeBundesstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Bundesstrasse</b></em>' attribute. The default value is
	 * <code>"5000"</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Bundesstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeBundesstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @model default="5000" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximaleZoomstufeBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximale Zoomstufe
	 *            Bundesstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @generated
	 */
	void setLinienstaerkeMaximaleZoomstufeBundesstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeBundesstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximaleZoomstufeBundesstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeBundesstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}' attribute is
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Bundesstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeBundesstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximaleZoomstufeBundesstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximum
	 * Bundesstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximum Bundesstrasse</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMaximumBundesstrasse()
	 * @see #unsetLinienstaerkeMaximumBundesstrasse()
	 * @see #setLinienstaerkeMaximumBundesstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximumBundesstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximumBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumBundesstrasse
	 * <em>Linienstaerke Maximum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximum
	 *            Bundesstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximumBundesstrasse()
	 * @see #unsetLinienstaerkeMaximumBundesstrasse()
	 * @see #getLinienstaerkeMaximumBundesstrasse()
	 * @generated
	 */
	void setLinienstaerkeMaximumBundesstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumBundesstrasse
	 * <em>Linienstaerke Maximum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMaximumBundesstrasse()
	 * @see #getLinienstaerkeMaximumBundesstrasse()
	 * @see #setLinienstaerkeMaximumBundesstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximumBundesstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumBundesstrasse
	 * <em>Linienstaerke Maximum Bundesstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Maximum
	 *         Bundesstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximumBundesstrasse()
	 * @see #getLinienstaerkeMaximumBundesstrasse()
	 * @see #setLinienstaerkeMaximumBundesstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximumBundesstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimum
	 * Bundesstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Minimum Bundesstrasse</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMinimumBundesstrasse()
	 * @see #unsetLinienstaerkeMinimumBundesstrasse()
	 * @see #setLinienstaerkeMinimumBundesstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimumBundesstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimumBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumBundesstrasse
	 * <em>Linienstaerke Minimum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimum
	 *            Bundesstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimumBundesstrasse()
	 * @see #unsetLinienstaerkeMinimumBundesstrasse()
	 * @see #getLinienstaerkeMinimumBundesstrasse()
	 * @generated
	 */
	void setLinienstaerkeMinimumBundesstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumBundesstrasse
	 * <em>Linienstaerke Minimum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMinimumBundesstrasse()
	 * @see #getLinienstaerkeMinimumBundesstrasse()
	 * @see #setLinienstaerkeMinimumBundesstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimumBundesstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumBundesstrasse
	 * <em>Linienstaerke Minimum Bundesstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Minimum
	 *         Bundesstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimumBundesstrasse()
	 * @see #getLinienstaerkeMinimumBundesstrasse()
	 * @see #setLinienstaerkeMinimumBundesstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimumBundesstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Bundesstrasse</b></em>'
	 * attribute. The default value is <code>"1"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Bundesstrasse</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeBundesstrasse()
	 * @see #unsetLinienstaerkeBundesstrasse()
	 * @see #setLinienstaerkeBundesstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeBundesstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeBundesstrasse
	 * <em>Linienstaerke Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienstaerke Bundesstrasse</em>'
	 *            attribute.
	 * @see #isSetLinienstaerkeBundesstrasse()
	 * @see #unsetLinienstaerkeBundesstrasse()
	 * @see #getLinienstaerkeBundesstrasse()
	 * @generated
	 */
	void setLinienstaerkeBundesstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeBundesstrasse
	 * <em>Linienstaerke Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isSetLinienstaerkeBundesstrasse()
	 * @see #getLinienstaerkeBundesstrasse()
	 * @see #setLinienstaerkeBundesstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeBundesstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeBundesstrasse
	 * <em>Linienstaerke Bundesstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Bundesstrasse</em>'
	 *         attribute is set.
	 * @see #unsetLinienstaerkeBundesstrasse()
	 * @see #getLinienstaerkeBundesstrasse()
	 * @see #setLinienstaerkeBundesstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeBundesstrasse();

	/**
	 * Returns the value of the '<em><b>Linienabstand Bundesstrasse</b></em>'
	 * attribute. The default value is <code>"0"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienabstand Bundesstrasse</em>'
	 *         attribute.
	 * @see #setLinienabstandBundesstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienabstandBundesstrasse()
	 * @model default="0"
	 * @generated
	 */
	int getLinienabstandBundesstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandBundesstrasse
	 * <em>Linienabstand Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienabstand Bundesstrasse</em>'
	 *            attribute.
	 * @see #getLinienabstandBundesstrasse()
	 * @generated
	 */
	void setLinienabstandBundesstrasse(int value);

	/**
	 * Returns the value of the '<em><b>Default Darstellung
	 * Landstrasse</b></em>' attribute. The default value is
	 * <code>"true"</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Default Darstellung Landstrasse</em>'
	 *         attribute.
	 * @see #setDefaultDarstellungLandstrasse(boolean)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_DefaultDarstellungLandstrasse()
	 * @model default="true"
	 * @generated
	 */
	boolean isDefaultDarstellungLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungLandstrasse
	 * <em>Default Darstellung Landstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Default Darstellung
	 *            Landstrasse</em>' attribute.
	 * @see #isDefaultDarstellungLandstrasse()
	 * @generated
	 */
	void setDefaultDarstellungLandstrasse(boolean value);

	/**
	 * Returns the value of the '<em><b>Vordergrund Farbe Landstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Vordergrund Farbe Landstrasse</em>'
	 *         attribute.
	 * @see #setVordergrundFarbeLandstrasse(RGB)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_VordergrundFarbeLandstrasse()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.eclipse.model.RGB"
	 * @generated
	 */
	RGB getVordergrundFarbeLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeLandstrasse
	 * <em>Vordergrund Farbe Landstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Vordergrund Farbe Landstrasse</em>'
	 *            attribute.
	 * @see #getVordergrundFarbeLandstrasse()
	 * @generated
	 */
	void setVordergrundFarbeLandstrasse(RGB value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Zoomverhalten
	 * Landstrasse</b></em>' attribute. The default value is
	 * <code>"statisches Zoomverhalten"</code>. The literals are from the
	 * enumeration
	 * {@link de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Linienstaerke Zoomverhalten
	 *         Landstrasse</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #setLinienstaerkeZoomverhaltenLandstrasse(Zoomverhalten)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenLandstrasse()
	 * @model default="statisches Zoomverhalten"
	 * @generated
	 */
	Zoomverhalten getLinienstaerkeZoomverhaltenLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenLandstrasse
	 * <em>Linienstaerke Zoomverhalten Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Zoomverhalten
	 *            Landstrasse</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #getLinienstaerkeZoomverhaltenLandstrasse()
	 * @generated
	 */
	void setLinienstaerkeZoomverhaltenLandstrasse(Zoomverhalten value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Landstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Landstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeLandstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimaleZoomstufeLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeLandstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimale Zoomstufe
	 *            Landstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @generated
	 */
	void setLinienstaerkeMinimaleZoomstufeLandstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeLandstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeLandstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimaleZoomstufeLandstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeLandstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Landstrasse</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Landstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeLandstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimaleZoomstufeLandstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Landstrasse</b></em>' attribute. The default value is
	 * <code>"5000"</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Landstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeLandstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @model default="5000" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximaleZoomstufeLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeLandstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximale Zoomstufe
	 *            Landstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @generated
	 */
	void setLinienstaerkeMaximaleZoomstufeLandstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeLandstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeLandstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximaleZoomstufeLandstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeLandstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Landstrasse</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Landstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeLandstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximaleZoomstufeLandstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximum
	 * Landstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximum Landstrasse</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMaximumLandstrasse()
	 * @see #unsetLinienstaerkeMaximumLandstrasse()
	 * @see #setLinienstaerkeMaximumLandstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximumLandstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximumLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumLandstrasse
	 * <em>Linienstaerke Maximum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximum
	 *            Landstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximumLandstrasse()
	 * @see #unsetLinienstaerkeMaximumLandstrasse()
	 * @see #getLinienstaerkeMaximumLandstrasse()
	 * @generated
	 */
	void setLinienstaerkeMaximumLandstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumLandstrasse
	 * <em>Linienstaerke Maximum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMaximumLandstrasse()
	 * @see #getLinienstaerkeMaximumLandstrasse()
	 * @see #setLinienstaerkeMaximumLandstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximumLandstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumLandstrasse
	 * <em>Linienstaerke Maximum Landstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Maximum
	 *         Landstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximumLandstrasse()
	 * @see #getLinienstaerkeMaximumLandstrasse()
	 * @see #setLinienstaerkeMaximumLandstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximumLandstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimum
	 * Landstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Minimum Landstrasse</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMinimumLandstrasse()
	 * @see #unsetLinienstaerkeMinimumLandstrasse()
	 * @see #setLinienstaerkeMinimumLandstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimumLandstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimumLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumLandstrasse
	 * <em>Linienstaerke Minimum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimum
	 *            Landstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimumLandstrasse()
	 * @see #unsetLinienstaerkeMinimumLandstrasse()
	 * @see #getLinienstaerkeMinimumLandstrasse()
	 * @generated
	 */
	void setLinienstaerkeMinimumLandstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumLandstrasse
	 * <em>Linienstaerke Minimum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMinimumLandstrasse()
	 * @see #getLinienstaerkeMinimumLandstrasse()
	 * @see #setLinienstaerkeMinimumLandstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimumLandstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumLandstrasse
	 * <em>Linienstaerke Minimum Landstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Minimum
	 *         Landstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimumLandstrasse()
	 * @see #getLinienstaerkeMinimumLandstrasse()
	 * @see #setLinienstaerkeMinimumLandstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimumLandstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Landstrasse</b></em>'
	 * attribute. The default value is <code>"1"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Landstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeLandstrasse()
	 * @see #unsetLinienstaerkeLandstrasse()
	 * @see #setLinienstaerkeLandstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeLandstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeLandstrasse
	 * <em>Linienstaerke Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienstaerke Landstrasse</em>'
	 *            attribute.
	 * @see #isSetLinienstaerkeLandstrasse()
	 * @see #unsetLinienstaerkeLandstrasse()
	 * @see #getLinienstaerkeLandstrasse()
	 * @generated
	 */
	void setLinienstaerkeLandstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeLandstrasse
	 * <em>Linienstaerke Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isSetLinienstaerkeLandstrasse()
	 * @see #getLinienstaerkeLandstrasse()
	 * @see #setLinienstaerkeLandstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeLandstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeLandstrasse
	 * <em>Linienstaerke Landstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Landstrasse</em>'
	 *         attribute is set.
	 * @see #unsetLinienstaerkeLandstrasse()
	 * @see #getLinienstaerkeLandstrasse()
	 * @see #setLinienstaerkeLandstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeLandstrasse();

	/**
	 * Returns the value of the '<em><b>Linienabstand Landstrasse</b></em>'
	 * attribute. The default value is <code>"0"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienabstand Landstrasse</em>' attribute.
	 * @see #setLinienabstandLandstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienabstandLandstrasse()
	 * @model default="0"
	 * @generated
	 */
	int getLinienabstandLandstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandLandstrasse
	 * <em>Linienabstand Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienabstand Landstrasse</em>'
	 *            attribute.
	 * @see #getLinienabstandLandstrasse()
	 * @generated
	 */
	void setLinienabstandLandstrasse(int value);

	/**
	 * Returns the value of the '<em><b>Vordergrund Farbe Kreisstrasse</b></em>'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Vordergrund Farbe Kreisstrasse</em>'
	 *         attribute.
	 * @see #setVordergrundFarbeKreisstrasse(RGB)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_VordergrundFarbeKreisstrasse()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.eclipse.model.RGB"
	 * @generated
	 */
	RGB getVordergrundFarbeKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getVordergrundFarbeKreisstrasse
	 * <em>Vordergrund Farbe Kreisstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Vordergrund Farbe Kreisstrasse</em>'
	 *            attribute.
	 * @see #getVordergrundFarbeKreisstrasse()
	 * @generated
	 */
	void setVordergrundFarbeKreisstrasse(RGB value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Zoomverhalten
	 * Kreisstrasse</b></em>' attribute. The default value is
	 * <code>"statisches Zoomverhalten"</code>. The literals are from the
	 * enumeration
	 * {@link de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return the value of the '<em>Linienstaerke Zoomverhalten
	 *         Kreisstrasse</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #setLinienstaerkeZoomverhaltenKreisstrasse(Zoomverhalten)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenKreisstrasse()
	 * @model default="statisches Zoomverhalten"
	 * @generated
	 */
	Zoomverhalten getLinienstaerkeZoomverhaltenKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeZoomverhaltenKreisstrasse
	 * <em>Linienstaerke Zoomverhalten Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Zoomverhalten
	 *            Kreisstrasse</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten
	 * @see #getLinienstaerkeZoomverhaltenKreisstrasse()
	 * @generated
	 */
	void setLinienstaerkeZoomverhaltenKreisstrasse(Zoomverhalten value);

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimale Zoomstufe
	 * Kreisstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Kreisstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeKreisstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimaleZoomstufeKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimale Zoomstufe
	 *            Kreisstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #unsetLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @generated
	 */
	void setLinienstaerkeMinimaleZoomstufeKreisstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeKreisstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimaleZoomstufeKreisstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}' attribute is
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Minimale Zoomstufe
	 *         Kreisstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @see #setLinienstaerkeMinimaleZoomstufeKreisstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimaleZoomstufeKreisstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximale Zoomstufe
	 * Kreisstrasse</b></em>' attribute. The default value is
	 * <code>"5000"</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Kreisstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeKreisstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @model default="5000" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximaleZoomstufeKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximale Zoomstufe
	 *            Kreisstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #unsetLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @generated
	 */
	void setLinienstaerkeMaximaleZoomstufeKreisstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeKreisstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximaleZoomstufeKreisstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximaleZoomstufeKreisstrasse
	 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}' attribute is
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return whether the value of the '<em>Linienstaerke Maximale Zoomstufe
	 *         Kreisstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @see #setLinienstaerkeMaximaleZoomstufeKreisstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximaleZoomstufeKreisstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Maximum
	 * Kreisstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Maximum Kreisstrasse</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMaximumKreisstrasse()
	 * @see #unsetLinienstaerkeMaximumKreisstrasse()
	 * @see #setLinienstaerkeMaximumKreisstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMaximumKreisstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMaximumKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumKreisstrasse
	 * <em>Linienstaerke Maximum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Maximum
	 *            Kreisstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMaximumKreisstrasse()
	 * @see #unsetLinienstaerkeMaximumKreisstrasse()
	 * @see #getLinienstaerkeMaximumKreisstrasse()
	 * @generated
	 */
	void setLinienstaerkeMaximumKreisstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumKreisstrasse
	 * <em>Linienstaerke Maximum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMaximumKreisstrasse()
	 * @see #getLinienstaerkeMaximumKreisstrasse()
	 * @see #setLinienstaerkeMaximumKreisstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMaximumKreisstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMaximumKreisstrasse
	 * <em>Linienstaerke Maximum Kreisstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Maximum
	 *         Kreisstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMaximumKreisstrasse()
	 * @see #getLinienstaerkeMaximumKreisstrasse()
	 * @see #setLinienstaerkeMaximumKreisstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMaximumKreisstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Minimum
	 * Kreisstrasse</b></em>' attribute. The default value is <code>"1"</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Minimum Kreisstrasse</em>'
	 *         attribute.
	 * @see #isSetLinienstaerkeMinimumKreisstrasse()
	 * @see #unsetLinienstaerkeMinimumKreisstrasse()
	 * @see #setLinienstaerkeMinimumKreisstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeMinimumKreisstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeMinimumKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumKreisstrasse
	 * <em>Linienstaerke Minimum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Linienstaerke Minimum
	 *            Kreisstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeMinimumKreisstrasse()
	 * @see #unsetLinienstaerkeMinimumKreisstrasse()
	 * @see #getLinienstaerkeMinimumKreisstrasse()
	 * @generated
	 */
	void setLinienstaerkeMinimumKreisstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumKreisstrasse
	 * <em>Linienstaerke Minimum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isSetLinienstaerkeMinimumKreisstrasse()
	 * @see #getLinienstaerkeMinimumKreisstrasse()
	 * @see #setLinienstaerkeMinimumKreisstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeMinimumKreisstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeMinimumKreisstrasse
	 * <em>Linienstaerke Minimum Kreisstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Minimum
	 *         Kreisstrasse</em>' attribute is set.
	 * @see #unsetLinienstaerkeMinimumKreisstrasse()
	 * @see #getLinienstaerkeMinimumKreisstrasse()
	 * @see #setLinienstaerkeMinimumKreisstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeMinimumKreisstrasse();

	/**
	 * Returns the value of the '<em><b>Linienstaerke Kreisstrasse</b></em>'
	 * attribute. The default value is <code>"1"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienstaerke Kreisstrasse</em>' attribute.
	 * @see #isSetLinienstaerkeKreisstrasse()
	 * @see #unsetLinienstaerkeKreisstrasse()
	 * @see #setLinienstaerkeKreisstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienstaerkeKreisstrasse()
	 * @model default="1" unsettable="true"
	 * @generated
	 */
	int getLinienstaerkeKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeKreisstrasse
	 * <em>Linienstaerke Kreisstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienstaerke Kreisstrasse</em>'
	 *            attribute.
	 * @see #isSetLinienstaerkeKreisstrasse()
	 * @see #unsetLinienstaerkeKreisstrasse()
	 * @see #getLinienstaerkeKreisstrasse()
	 * @generated
	 */
	void setLinienstaerkeKreisstrasse(int value);

	/**
	 * Unsets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeKreisstrasse
	 * <em>Linienstaerke Kreisstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isSetLinienstaerkeKreisstrasse()
	 * @see #getLinienstaerkeKreisstrasse()
	 * @see #setLinienstaerkeKreisstrasse(int)
	 * @generated
	 */
	void unsetLinienstaerkeKreisstrasse();

	/**
	 * Returns whether the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienstaerkeKreisstrasse
	 * <em>Linienstaerke Kreisstrasse</em>}' attribute is set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @return whether the value of the '<em>Linienstaerke Kreisstrasse</em>'
	 *         attribute is set.
	 * @see #unsetLinienstaerkeKreisstrasse()
	 * @see #getLinienstaerkeKreisstrasse()
	 * @see #setLinienstaerkeKreisstrasse(int)
	 * @generated
	 */
	boolean isSetLinienstaerkeKreisstrasse();

	/**
	 * Returns the value of the '<em><b>Linienabstand Kreisstrasse</b></em>'
	 * attribute. The default value is <code>"0"</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Linienabstand Kreisstrasse</em>' attribute.
	 * @see #setLinienabstandKreisstrasse(int)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_LinienabstandKreisstrasse()
	 * @model default="0"
	 * @generated
	 */
	int getLinienabstandKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#getLinienabstandKreisstrasse
	 * <em>Linienabstand Kreisstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Linienabstand Kreisstrasse</em>'
	 *            attribute.
	 * @see #getLinienabstandKreisstrasse()
	 * @generated
	 */
	void setLinienabstandKreisstrasse(int value);

	/**
	 * Returns the value of the '<em><b>Default Darstellung
	 * Kreisstrasse</b></em>' attribute. The default value is
	 * <code>"true"</code>. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Default Darstellung Kreisstrasse</em>'
	 *         attribute.
	 * @see #setDefaultDarstellungKreisstrasse(boolean)
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenSegmentDoTyp_DefaultDarstellungKreisstrasse()
	 * @model default="true"
	 * @generated
	 */
	boolean isDefaultDarstellungKreisstrasse();

	/**
	 * Sets the value of the
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp#isDefaultDarstellungKreisstrasse
	 * <em>Default Darstellung Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @param value
	 *            the new value of the '<em>Default Darstellung
	 *            Kreisstrasse</em>' attribute.
	 * @see #isDefaultDarstellungKreisstrasse()
	 * @generated
	 */
	void setDefaultDarstellungKreisstrasse(boolean value);

} // StrassenSegmentDoTyp
