/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration
 * '<em><b>Strassen Typ</b></em>', and utility methods for working with them.
 * <!-- end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#getStrassenTyp()
 * @model
 * @generated
 */
public enum StrassenTyp implements Enumerator {
	/**
	 * The '<em><b>Sonstige</b></em>' literal object. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	SONSTIGE(0, "sonstige", "sonstige"),

	/**
	 * The '<em><b>Autobahn</b></em>' literal object. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #AUTOBAHN_VALUE
	 * @generated
	 * @ordered
	 */
	AUTOBAHN(1, "autobahn", "autobahn"),

	/**
	 * The '<em><b>Bundesstrasse</b></em>' literal object. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #BUNDESSTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	BUNDESSTRASSE(2, "bundesstrasse", "bundesstrasse"),

	/**
	 * The '<em><b>Landstrasse</b></em>' literal object. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #LANDSTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	LANDSTRASSE(3, "landstrasse", "landstrasse"),

	/**
	 * The '<em><b>Kreisstrasse</b></em>' literal object. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #KREISSTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	KREISSTRASSE(4, "kreisstrasse", "kreisstrasse");

	/**
	 * The '<em><b>Sonstige</b></em>' literal value. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #SONSTIGE
	 * @model name="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int SONSTIGE_VALUE = 0;

	/**
	 * The '<em><b>Autobahn</b></em>' literal value. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #AUTOBAHN
	 * @model name="autobahn"
	 * @generated
	 * @ordered
	 */
	public static final int AUTOBAHN_VALUE = 1;

	/**
	 * The '<em><b>Bundesstrasse</b></em>' literal value. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #BUNDESSTRASSE
	 * @model name="bundesstrasse"
	 * @generated
	 * @ordered
	 */
	public static final int BUNDESSTRASSE_VALUE = 2;

	/**
	 * The '<em><b>Landstrasse</b></em>' literal value. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #LANDSTRASSE
	 * @model name="landstrasse"
	 * @generated
	 * @ordered
	 */
	public static final int LANDSTRASSE_VALUE = 3;

	/**
	 * The '<em><b>Kreisstrasse</b></em>' literal value. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #KREISSTRASSE
	 * @model name="kreisstrasse"
	 * @generated
	 * @ordered
	 */
	public static final int KREISSTRASSE_VALUE = 4;

	/**
	 * An array of all the '<em><b>Strassen Typ</b></em>' enumerators. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static final StrassenTyp[] VALUES_ARRAY = new StrassenTyp[] {
			SONSTIGE, AUTOBAHN, BUNDESSTRASSE, LANDSTRASSE, KREISSTRASSE, };

	/**
	 * A public read-only list of all the '<em><b>Strassen Typ</b></em>'
	 * enumerators. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static final List<StrassenTyp> VALUES = Collections
			.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Strassen Typ</b></em>' literal with the specified
	 * literal value. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param literal
	 *            the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static StrassenTyp get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			final StrassenTyp result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Strassen Typ</b></em>' literal with the specified
	 * name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param name
	 *            the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static StrassenTyp getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			final StrassenTyp result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Strassen Typ</b></em>' literal with the specified
	 * integer value. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static StrassenTyp get(int value) {
		switch (value) {
		case SONSTIGE_VALUE:
			return SONSTIGE;
		case AUTOBAHN_VALUE:
			return AUTOBAHN;
		case BUNDESSTRASSE_VALUE:
			return BUNDESSTRASSE;
		case LANDSTRASSE_VALUE:
			return LANDSTRASSE;
		case KREISSTRASSE_VALUE:
			return KREISSTRASSE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	private StrassenTyp(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string
	 * representation. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // StrassenTyp
