/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipseFactory;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object ' <em><b>Mess
 * Querschnitt Do Typ</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getSkalierungsfaktor
 * <em>Skalierungsfaktor</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getKeineQuelleFarbe
 * <em>Keine Quelle Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getKeineDatenFarbe
 * <em>Keine Daten Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getNutzdatenFarbe
 * <em>Nutzdaten Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getLinienabstandZoomverhalten
 * <em>Linienabstand Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getLinienabstandMinimaleZoomstufe
 * <em>Linienabstand Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getLinienabstandMaximaleZoomstufe
 * <em>Linienabstand Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getLinienabstandMaximum
 * <em>Linienabstand Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getLinienabstandMinimum
 * <em>Linienabstand Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getLinienabstand
 * <em>Linienabstand</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.MessQuerschnittDoTypImpl#getTooltipZeitstempelFormat
 * <em>Tooltip Zeitstempel Format</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MessQuerschnittDoTypImpl extends ConfiguratedDoTypImpl
		implements MessQuerschnittDoTyp {
	/**
	 * The default value of the '{@link #getSkalierungsfaktor()
	 * <em>Skalierungsfaktor</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getSkalierungsfaktor()
	 * @generated
	 * @ordered
	 */
	protected static final double SKALIERUNGSFAKTOR_EDEFAULT = 1.0;
	/**
	 * The cached value of the '{@link #getSkalierungsfaktor()
	 * <em>Skalierungsfaktor</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getSkalierungsfaktor()
	 * @generated
	 * @ordered
	 */
	protected double skalierungsfaktor = SKALIERUNGSFAKTOR_EDEFAULT;
	/**
	 * This is true if the Skalierungsfaktor attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean skalierungsfaktorESet;
	/**
	 * The default value of the '{@link #getKeineQuelleFarbe() <em>Keine Quelle
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getKeineQuelleFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB KEINE_QUELLE_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "128,128,128");
	/**
	 * The cached value of the '{@link #getKeineQuelleFarbe() <em>Keine Quelle
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getKeineQuelleFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB keineQuelleFarbe = KEINE_QUELLE_FARBE_EDEFAULT;
	/**
	 * This is true if the Keine Quelle Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean keineQuelleFarbeESet;
	/**
	 * The default value of the '{@link #getKeineDatenFarbe() <em>Keine Daten
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getKeineDatenFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB KEINE_DATEN_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "255,0,0");
	/**
	 * The cached value of the '{@link #getKeineDatenFarbe() <em>Keine Daten
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getKeineDatenFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB keineDatenFarbe = KEINE_DATEN_FARBE_EDEFAULT;
	/**
	 * This is true if the Keine Daten Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean keineDatenFarbeESet;
	/**
	 * The default value of the '{@link #getNutzdatenFarbe() <em>Nutzdaten
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getNutzdatenFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB NUTZDATEN_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "0,255,0");
	/**
	 * The cached value of the '{@link #getNutzdatenFarbe() <em>Nutzdaten
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getNutzdatenFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB nutzdatenFarbe = NUTZDATEN_FARBE_EDEFAULT;
	/**
	 * This is true if the Nutzdaten Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean nutzdatenFarbeESet;

	/**
	 * The default value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;
	/**
	 * The cached value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienabstandZoomverhalten = LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;
	/**
	 * The default value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;
	/**
	 * The cached value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;
	/**
	 * This is true if the Linienabstand Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimaleZoomstufeESet;
	/**
	 * The default value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;
	/**
	 * The cached value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;
	/**
	 * This is true if the Linienabstand Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximaleZoomstufeESet;
	/**
	 * The default value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMUM_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;
	/**
	 * This is true if the Linienabstand Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximumESet;
	/**
	 * The default value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMUM_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;
	/**
	 * This is true if the Linienabstand Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimumESet;
	/**
	 * The default value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected int linienabstand = LINIENABSTAND_EDEFAULT;
	/**
	 * This is true if the Linienabstand attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandESet;
	/**
	 * The default value of the '{@link #getTooltipZeitstempelFormat()
	 * <em>Tooltip Zeitstempel Format</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getTooltipZeitstempelFormat()
	 * @generated
	 * @ordered
	 */
	protected static final String TOOLTIP_ZEITSTEMPEL_FORMAT_EDEFAULT = "dd.MM.yyyy HH:mm:ss,SSS";
	/**
	 * The cached value of the '{@link #getTooltipZeitstempelFormat()
	 * <em>Tooltip Zeitstempel Format</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getTooltipZeitstempelFormat()
	 * @generated
	 * @ordered
	 */
	protected String tooltipZeitstempelFormat = TOOLTIP_ZEITSTEMPEL_FORMAT_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessQuerschnittDoTypImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NetzPackage.Literals.MESS_QUERSCHNITT_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstand() {
		return linienabstand;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstand(int newLinienabstand) {
		final int oldLinienabstand = linienabstand;
		linienabstand = newLinienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstandESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND,
					oldLinienabstand, linienabstand, !oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstand() {
		final int oldLinienabstand = linienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstand = LINIENABSTAND_EDEFAULT;
		linienabstandESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND,
					oldLinienabstand, LINIENABSTAND_EDEFAULT,
					oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstand() {
		return linienabstandESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public double getSkalierungsfaktor() {
		return skalierungsfaktor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setSkalierungsfaktor(double newSkalierungsfaktor) {
		final double oldSkalierungsfaktor = skalierungsfaktor;
		skalierungsfaktor = newSkalierungsfaktor;
		final boolean oldSkalierungsfaktorESet = skalierungsfaktorESet;
		skalierungsfaktorESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR,
					oldSkalierungsfaktor, skalierungsfaktor,
					!oldSkalierungsfaktorESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetSkalierungsfaktor() {
		final double oldSkalierungsfaktor = skalierungsfaktor;
		final boolean oldSkalierungsfaktorESet = skalierungsfaktorESet;
		skalierungsfaktor = SKALIERUNGSFAKTOR_EDEFAULT;
		skalierungsfaktorESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR,
					oldSkalierungsfaktor, SKALIERUNGSFAKTOR_EDEFAULT,
					oldSkalierungsfaktorESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetSkalierungsfaktor() {
		return skalierungsfaktorESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getKeineQuelleFarbe() {
		return keineQuelleFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setKeineQuelleFarbe(RGB newKeineQuelleFarbe) {
		final RGB oldKeineQuelleFarbe = keineQuelleFarbe;
		keineQuelleFarbe = newKeineQuelleFarbe;
		final boolean oldKeineQuelleFarbeESet = keineQuelleFarbeESet;
		keineQuelleFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE,
					oldKeineQuelleFarbe, keineQuelleFarbe,
					!oldKeineQuelleFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetKeineQuelleFarbe() {
		final RGB oldKeineQuelleFarbe = keineQuelleFarbe;
		final boolean oldKeineQuelleFarbeESet = keineQuelleFarbeESet;
		keineQuelleFarbe = KEINE_QUELLE_FARBE_EDEFAULT;
		keineQuelleFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE,
					oldKeineQuelleFarbe, KEINE_QUELLE_FARBE_EDEFAULT,
					oldKeineQuelleFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetKeineQuelleFarbe() {
		return keineQuelleFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getKeineDatenFarbe() {
		return keineDatenFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setKeineDatenFarbe(RGB newKeineDatenFarbe) {
		final RGB oldKeineDatenFarbe = keineDatenFarbe;
		keineDatenFarbe = newKeineDatenFarbe;
		final boolean oldKeineDatenFarbeESet = keineDatenFarbeESet;
		keineDatenFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE,
					oldKeineDatenFarbe, keineDatenFarbe,
					!oldKeineDatenFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetKeineDatenFarbe() {
		final RGB oldKeineDatenFarbe = keineDatenFarbe;
		final boolean oldKeineDatenFarbeESet = keineDatenFarbeESet;
		keineDatenFarbe = KEINE_DATEN_FARBE_EDEFAULT;
		keineDatenFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE,
					oldKeineDatenFarbe, KEINE_DATEN_FARBE_EDEFAULT,
					oldKeineDatenFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetKeineDatenFarbe() {
		return keineDatenFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getNutzdatenFarbe() {
		return nutzdatenFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setNutzdatenFarbe(RGB newNutzdatenFarbe) {
		final RGB oldNutzdatenFarbe = nutzdatenFarbe;
		nutzdatenFarbe = newNutzdatenFarbe;
		final boolean oldNutzdatenFarbeESet = nutzdatenFarbeESet;
		nutzdatenFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE,
					oldNutzdatenFarbe, nutzdatenFarbe, !oldNutzdatenFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetNutzdatenFarbe() {
		final RGB oldNutzdatenFarbe = nutzdatenFarbe;
		final boolean oldNutzdatenFarbeESet = nutzdatenFarbeESet;
		nutzdatenFarbe = NUTZDATEN_FARBE_EDEFAULT;
		nutzdatenFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE,
					oldNutzdatenFarbe, NUTZDATEN_FARBE_EDEFAULT,
					oldNutzdatenFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetNutzdatenFarbe() {
		return nutzdatenFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienabstandZoomverhalten() {
		return linienabstandZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandZoomverhalten(
			Zoomverhalten newLinienabstandZoomverhalten) {
		final Zoomverhalten oldLinienabstandZoomverhalten = linienabstandZoomverhalten;
		linienabstandZoomverhalten = newLinienabstandZoomverhalten == null
				? LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT
				: newLinienabstandZoomverhalten;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN,
					oldLinienabstandZoomverhalten, linienabstandZoomverhalten));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimaleZoomstufe(
			int newLinienabstandMinimaleZoomstufe) {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		linienabstandMinimaleZoomstufe = newLinienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					linienabstandMinimaleZoomstufe,
					!oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimaleZoomstufe() {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMinimaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximaleZoomstufe(
			int newLinienabstandMaximaleZoomstufe) {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		linienabstandMaximaleZoomstufe = newLinienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					linienabstandMaximaleZoomstufe,
					!oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximaleZoomstufe() {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMaximaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximum() {
		return linienabstandMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximum(int newLinienabstandMaximum) {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		linienabstandMaximum = newLinienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, linienabstandMaximum,
					!oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximum() {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;
		linienabstandMaximumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, LINIENABSTAND_MAXIMUM_EDEFAULT,
					oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximum() {
		return linienabstandMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimum() {
		return linienabstandMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimum(int newLinienabstandMinimum) {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		linienabstandMinimum = newLinienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, linienabstandMinimum,
					!oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimum() {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;
		linienabstandMinimumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, LINIENABSTAND_MINIMUM_EDEFAULT,
					oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimum() {
		return linienabstandMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getTooltipZeitstempelFormat() {
		return tooltipZeitstempelFormat;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setTooltipZeitstempelFormat(
			String newTooltipZeitstempelFormat) {
		final String oldTooltipZeitstempelFormat = tooltipZeitstempelFormat;
		tooltipZeitstempelFormat = newTooltipZeitstempelFormat;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT,
					oldTooltipZeitstempelFormat, tooltipZeitstempelFormat));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR:
			return getSkalierungsfaktor();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE:
			return getKeineQuelleFarbe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE:
			return getKeineDatenFarbe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE:
			return getNutzdatenFarbe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return getLinienabstandZoomverhalten();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return getLinienabstandMinimaleZoomstufe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return getLinienabstandMaximaleZoomstufe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM:
			return getLinienabstandMaximum();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM:
			return getLinienabstandMinimum();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND:
			return getLinienabstand();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT:
			return getTooltipZeitstempelFormat();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR:
			setSkalierungsfaktor((Double) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE:
			setKeineQuelleFarbe((RGB) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE:
			setKeineDatenFarbe((RGB) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE:
			setNutzdatenFarbe((RGB) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten((Zoomverhalten) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			setLinienabstandMinimaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			setLinienabstandMaximaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM:
			setLinienabstandMaximum((Integer) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM:
			setLinienabstandMinimum((Integer) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND:
			setLinienabstand((Integer) newValue);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT:
			setTooltipZeitstempelFormat((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR:
			unsetSkalierungsfaktor();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE:
			unsetKeineQuelleFarbe();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE:
			unsetKeineDatenFarbe();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE:
			unsetNutzdatenFarbe();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten(LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT);
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			unsetLinienabstandMinimaleZoomstufe();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			unsetLinienabstandMaximaleZoomstufe();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM:
			unsetLinienabstandMaximum();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM:
			unsetLinienabstandMinimum();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND:
			unsetLinienabstand();
			return;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT:
			setTooltipZeitstempelFormat(TOOLTIP_ZEITSTEMPEL_FORMAT_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR:
			return isSetSkalierungsfaktor();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE:
			return isSetKeineQuelleFarbe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE:
			return isSetKeineDatenFarbe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE:
			return isSetNutzdatenFarbe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return linienabstandZoomverhalten != LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return isSetLinienabstandMinimaleZoomstufe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return isSetLinienabstandMaximaleZoomstufe();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM:
			return isSetLinienabstandMaximum();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM:
			return isSetLinienabstandMinimum();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND:
			return isSetLinienabstand();
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT:
			return TOOLTIP_ZEITSTEMPEL_FORMAT_EDEFAULT == null
					? tooltipZeitstempelFormat != null
					: !TOOLTIP_ZEITSTEMPEL_FORMAT_EDEFAULT
							.equals(tooltipZeitstempelFormat);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID,
			Class<?> baseClass) {
		if (baseClass == SkalierungDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR:
				return DobjDecoratorPackage.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR;
			default:
				return -1;
			}
		}
		if (baseClass == DatenstatusDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE:
				return DobjDecoratorPackage.DATENSTATUS_DECORATOR__KEINE_QUELLE_FARBE;
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE:
				return DobjDecoratorPackage.DATENSTATUS_DECORATOR__KEINE_DATEN_FARBE;
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE:
				return DobjDecoratorPackage.DATENSTATUS_DECORATOR__NUTZDATEN_FARBE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN;
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM;
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM;
			case NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID,
			Class<?> baseClass) {
		if (baseClass == SkalierungDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__SKALIERUNGSFAKTOR;
			default:
				return -1;
			}
		}
		if (baseClass == DatenstatusDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.DATENSTATUS_DECORATOR__KEINE_QUELLE_FARBE:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_QUELLE_FARBE;
			case DobjDecoratorPackage.DATENSTATUS_DECORATOR__KEINE_DATEN_FARBE:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__KEINE_DATEN_FARBE;
			case DobjDecoratorPackage.DATENSTATUS_DECORATOR__NUTZDATEN_FARBE:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__NUTZDATEN_FARBE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MAXIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND_MINIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
				return NetzPackage.MESS_QUERSCHNITT_DO_TYP__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (skalierungsfaktor: ");
		if (skalierungsfaktorESet) {
			result.append(skalierungsfaktor);
		} else {
			result.append("<unset>");
		}
		result.append(", keineQuelleFarbe: ");
		if (keineQuelleFarbeESet) {
			result.append(keineQuelleFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", keineDatenFarbe: ");
		if (keineDatenFarbeESet) {
			result.append(keineDatenFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", nutzdatenFarbe: ");
		if (nutzdatenFarbeESet) {
			result.append(nutzdatenFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandZoomverhalten: ");
		result.append(linienabstandZoomverhalten);
		result.append(", linienabstandMinimaleZoomstufe: ");
		if (linienabstandMinimaleZoomstufeESet) {
			result.append(linienabstandMinimaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximaleZoomstufe: ");
		if (linienabstandMaximaleZoomstufeESet) {
			result.append(linienabstandMaximaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximum: ");
		if (linienabstandMaximumESet) {
			result.append(linienabstandMaximum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMinimum: ");
		if (linienabstandMinimumESet) {
			result.append(linienabstandMinimum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstand: ");
		if (linienabstandESet) {
			result.append(linienabstand);
		} else {
			result.append("<unset>");
		}
		result.append(", tooltipZeitstempelFormat: ");
		result.append(tooltipZeitstempelFormat);
		result.append(')');
		return result.toString();
	}

} // MessQuerschnittDoTypImpl
