/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoModel;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp;
import de.bsvrz.buv.plugin.netz.model.KreisDoModel;
import de.bsvrz.buv.plugin.netz.model.KreisDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.NetzFactory;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class NetzFactoryImpl extends EFactoryImpl implements NetzFactory {
	/**
	 * Creates the default factory implementation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static NetzFactory init() {
		try {
			final NetzFactory theNetzFactory = (NetzFactory) EPackage.Registry.INSTANCE
					.getEFactory(NetzPackage.eNS_URI);
			if (theNetzFactory != null) {
				return theNetzFactory;
			}
		} catch (final Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new NetzFactoryImpl();
	}

	/**
	 * Creates an instance of the factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public NetzFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP:
			return createMessQuerschnittDoTyp();
		case NetzPackage.MESS_QUERSCHNITT_DO_MODEL:
			return createMessQuerschnittDoModel();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP:
			return createStrassenSegmentDoTyp();
		case NetzPackage.STRASSEN_SEGMENT_DO_MODEL:
			return createStrassenSegmentDoModel();
		case NetzPackage.KREIS_DO_TYP:
			return createKreisDoTyp();
		case NetzPackage.KREIS_DO_MODEL:
			return createKreisDoModel();
		case NetzPackage.ORTSLAGE_DO_TYP:
			return createOrtslageDoTyp();
		case NetzPackage.ORTSLAGE_DO_MODEL:
			return createOrtslageDoModel();
		case NetzPackage.ORTSNAME_DO_TYP:
			return createOrtsnameDoTyp();
		case NetzPackage.ORTSNAME_DO_MODEL:
			return createOrtsnameDoModel();
		case NetzPackage.STRASSEN_KNOTEN_DO_TYP:
			return createStrassenKnotenDoTyp();
		case NetzPackage.STRASSEN_KNOTEN_DO_MODEL:
			return createStrassenKnotenDoModel();
		case NetzPackage.STOERFALL_INDIKATOR_DO_MODEL:
			return createStoerfallIndikatorDoModel();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP:
			return createStrassenSegmentStoerfallIndikatorDoTyp();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL:
			return createStrassenSegmentStoerfallIndikatorDoModel();
		case NetzPackage.STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP:
			return createStrassenTeilSegmentStoerfallIndikatorDoTyp();
		case NetzPackage.STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL:
			return createStrassenTeilSegmentStoerfallIndikatorDoModel();
		case NetzPackage.MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP:
			return createMessQuerschnittStoerfallIndikatorDoTyp();
		case NetzPackage.MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL:
			return createMessQuerschnittStoerfallIndikatorDoModel();
		case NetzPackage.FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP:
			return createFahrStreifenStoerfallIndikatorDoTyp();
		case NetzPackage.FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL:
			return createFahrStreifenStoerfallIndikatorDoModel();
		case NetzPackage.UMFELD_DATEN_MESS_STELLE_DO_TYP:
			return createUmfeldDatenMessStelleDoTyp();
		case NetzPackage.UMFELD_DATEN_MESS_STELLE_DO_MODEL:
			return createUmfeldDatenMessStelleDoModel();
		case NetzPackage.ANZEIGE_QUERSCHNITT_DO_TYP:
			return createAnzeigeQuerschnittDoTyp();
		case NetzPackage.ANZEIGE_QUERSCHNITT_DO_MODEL:
			return createAnzeigeQuerschnittDoModel();
		case NetzPackage.GEWAESSER_DO_TYP:
			return createGewaesserDoTyp();
		case NetzPackage.GEWAESSER_DO_MODEL:
			return createGewaesserDoModel();
		case NetzPackage.BAUSTELLE_SYMBOL_DO_TYP:
			return createBaustelleSymbolDoTyp();
		case NetzPackage.BAUSTELLE_SYMBOL_DO_MODEL:
			return createBaustelleSymbolDoModel();
		case NetzPackage.BAUSTELLE_VERLAUF_DO_TYP:
			return createBaustelleVerlaufDoTyp();
		case NetzPackage.BAUSTELLE_VERLAUF_DO_MODEL:
			return createBaustelleVerlaufDoModel();
		case NetzPackage.STAU_SYMBOL_DO_TYP:
			return createStauSymbolDoTyp();
		case NetzPackage.STAU_SYMBOL_DO_MODEL:
			return createStauSymbolDoModel();
		case NetzPackage.STAU_VERLAUF_DO_TYP:
			return createStauVerlaufDoTyp();
		case NetzPackage.STAU_VERLAUF_DO_MODEL:
			return createStauVerlaufDoModel();
		case NetzPackage.UNFALL_SYMBOL_DO_TYP:
			return createUnfallSymbolDoTyp();
		case NetzPackage.UNFALL_SYMBOL_DO_MODEL:
			return createUnfallSymbolDoModel();
		case NetzPackage.RDS_MELDUNG_SYMBOL_DO_TYP:
			return createRdsMeldungSymbolDoTyp();
		case NetzPackage.RDS_MELDUNG_SYMBOL_DO_MODEL:
			return createRdsMeldungSymbolDoModel();
		case NetzPackage.RDS_MELDUNG_VERLAUF_DO_TYP:
			return createRdsMeldungVerlaufDoTyp();
		case NetzPackage.RDS_MELDUNG_VERLAUF_DO_MODEL:
			return createRdsMeldungVerlaufDoModel();
		case NetzPackage.MESS_QUERSCHNITT_NBA_HAN_DO_TYP:
			return createMessQuerschnittNBAHanDoTyp();
		case NetzPackage.MESS_QUERSCHNITT_NBA_HAN_DO_MODEL:
			return createMessQuerschnittNBAHanDoModel();
		case NetzPackage.TMC_MELDUNG_SYMBOL_DO_TYP:
			return createTmcMeldungSymbolDoTyp();
		case NetzPackage.TMC_MELDUNG_SYMBOL_DO_MODEL:
			return createTmcMeldungSymbolDoModel();
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP:
			return createTmcMeldungVerlaufDoTyp();
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_MODEL:
			return createTmcMeldungVerlaufDoModel();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName()
					+ "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
		case NetzPackage.UMFELD_DATEN_MESSSTELLE_IMAGE_TYP:
			return createUmfeldDatenMessstelleImageTypFromString(eDataType,
					initialValue);
		case NetzPackage.STRASSEN_TYP:
			return createStrassenTypFromString(eDataType, initialValue);
		default:
			throw new IllegalArgumentException("The datatype '"
					+ eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
		case NetzPackage.UMFELD_DATEN_MESSSTELLE_IMAGE_TYP:
			return convertUmfeldDatenMessstelleImageTypToString(eDataType,
					instanceValue);
		case NetzPackage.STRASSEN_TYP:
			return convertStrassenTypToString(eDataType, instanceValue);
		default:
			throw new IllegalArgumentException("The datatype '"
					+ eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public FahrStreifenStoerfallIndikatorDoTyp createFahrStreifenStoerfallIndikatorDoTyp() {
		final FahrStreifenStoerfallIndikatorDoTypImpl fahrStreifenStoerfallIndikatorDoTyp = new FahrStreifenStoerfallIndikatorDoTypImpl();
		return fahrStreifenStoerfallIndikatorDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public FahrStreifenStoerfallIndikatorDoModel createFahrStreifenStoerfallIndikatorDoModel() {
		final FahrStreifenStoerfallIndikatorDoModelImpl fahrStreifenStoerfallIndikatorDoModel = new FahrStreifenStoerfallIndikatorDoModelImpl();
		return fahrStreifenStoerfallIndikatorDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public UmfeldDatenMessStelleDoTyp createUmfeldDatenMessStelleDoTyp() {
		final UmfeldDatenMessStelleDoTypImpl umfeldDatenMessStelleDoTyp = new UmfeldDatenMessStelleDoTypImpl();
		return umfeldDatenMessStelleDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public UmfeldDatenMessStelleDoModel createUmfeldDatenMessStelleDoModel() {
		final UmfeldDatenMessStelleDoModelImpl umfeldDatenMessStelleDoModel = new UmfeldDatenMessStelleDoModelImpl();
		return umfeldDatenMessStelleDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public AnzeigeQuerschnittDoTyp createAnzeigeQuerschnittDoTyp() {
		final AnzeigeQuerschnittDoTypImpl anzeigeQuerschnittDoTyp = new AnzeigeQuerschnittDoTypImpl();
		return anzeigeQuerschnittDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public AnzeigeQuerschnittDoModel createAnzeigeQuerschnittDoModel() {
		final AnzeigeQuerschnittDoModelImpl anzeigeQuerschnittDoModel = new AnzeigeQuerschnittDoModelImpl();
		return anzeigeQuerschnittDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public GewaesserDoTyp createGewaesserDoTyp() {
		final GewaesserDoTypImpl gewaesserDoTyp = new GewaesserDoTypImpl();
		return gewaesserDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public GewaesserDoModel createGewaesserDoModel() {
		final GewaesserDoModelImpl gewaesserDoModel = new GewaesserDoModelImpl();
		return gewaesserDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public BaustelleSymbolDoTyp createBaustelleSymbolDoTyp() {
		final BaustelleSymbolDoTypImpl baustelleSymbolDoTyp = new BaustelleSymbolDoTypImpl();
		return baustelleSymbolDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public BaustelleSymbolDoModel createBaustelleSymbolDoModel() {
		final BaustelleSymbolDoModelImpl baustelleSymbolDoModel = new BaustelleSymbolDoModelImpl();
		return baustelleSymbolDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public BaustelleVerlaufDoTyp createBaustelleVerlaufDoTyp() {
		final BaustelleVerlaufDoTypImpl baustelleVerlaufDoTyp = new BaustelleVerlaufDoTypImpl();
		return baustelleVerlaufDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public BaustelleVerlaufDoModel createBaustelleVerlaufDoModel() {
		final BaustelleVerlaufDoModelImpl baustelleVerlaufDoModel = new BaustelleVerlaufDoModelImpl();
		return baustelleVerlaufDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StauSymbolDoTyp createStauSymbolDoTyp() {
		final StauSymbolDoTypImpl stauSymbolDoTyp = new StauSymbolDoTypImpl();
		return stauSymbolDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StauSymbolDoModel createStauSymbolDoModel() {
		final StauSymbolDoModelImpl stauSymbolDoModel = new StauSymbolDoModelImpl();
		return stauSymbolDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StauVerlaufDoTyp createStauVerlaufDoTyp() {
		final StauVerlaufDoTypImpl stauVerlaufDoTyp = new StauVerlaufDoTypImpl();
		return stauVerlaufDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StauVerlaufDoModel createStauVerlaufDoModel() {
		final StauVerlaufDoModelImpl stauVerlaufDoModel = new StauVerlaufDoModelImpl();
		return stauVerlaufDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public UnfallSymbolDoTyp createUnfallSymbolDoTyp() {
		final UnfallSymbolDoTypImpl unfallSymbolDoTyp = new UnfallSymbolDoTypImpl();
		return unfallSymbolDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public UnfallSymbolDoModel createUnfallSymbolDoModel() {
		final UnfallSymbolDoModelImpl unfallSymbolDoModel = new UnfallSymbolDoModelImpl();
		return unfallSymbolDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RdsMeldungSymbolDoTyp createRdsMeldungSymbolDoTyp() {
		final RdsMeldungSymbolDoTypImpl rdsMeldungSymbolDoTyp = new RdsMeldungSymbolDoTypImpl();
		return rdsMeldungSymbolDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RdsMeldungSymbolDoModel createRdsMeldungSymbolDoModel() {
		final RdsMeldungSymbolDoModelImpl rdsMeldungSymbolDoModel = new RdsMeldungSymbolDoModelImpl();
		return rdsMeldungSymbolDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RdsMeldungVerlaufDoTyp createRdsMeldungVerlaufDoTyp() {
		final RdsMeldungVerlaufDoTypImpl rdsMeldungVerlaufDoTyp = new RdsMeldungVerlaufDoTypImpl();
		return rdsMeldungVerlaufDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RdsMeldungVerlaufDoModel createRdsMeldungVerlaufDoModel() {
		final RdsMeldungVerlaufDoModelImpl rdsMeldungVerlaufDoModel = new RdsMeldungVerlaufDoModelImpl();
		return rdsMeldungVerlaufDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public MessQuerschnittNBAHanDoTyp createMessQuerschnittNBAHanDoTyp() {
		final MessQuerschnittNBAHanDoTypImpl messQuerschnittNBAHanDoTyp = new MessQuerschnittNBAHanDoTypImpl();
		return messQuerschnittNBAHanDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public MessQuerschnittNBAHanDoModel createMessQuerschnittNBAHanDoModel() {
		final MessQuerschnittNBAHanDoModelImpl messQuerschnittNBAHanDoModel = new MessQuerschnittNBAHanDoModelImpl();
		return messQuerschnittNBAHanDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public TmcMeldungSymbolDoTyp createTmcMeldungSymbolDoTyp() {
		final TmcMeldungSymbolDoTypImpl tmcMeldungSymbolDoTyp = new TmcMeldungSymbolDoTypImpl();
		return tmcMeldungSymbolDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public TmcMeldungSymbolDoModel createTmcMeldungSymbolDoModel() {
		final TmcMeldungSymbolDoModelImpl tmcMeldungSymbolDoModel = new TmcMeldungSymbolDoModelImpl();
		return tmcMeldungSymbolDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public TmcMeldungVerlaufDoTyp createTmcMeldungVerlaufDoTyp() {
		final TmcMeldungVerlaufDoTypImpl tmcMeldungVerlaufDoTyp = new TmcMeldungVerlaufDoTypImpl();
		return tmcMeldungVerlaufDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public TmcMeldungVerlaufDoModel createTmcMeldungVerlaufDoModel() {
		final TmcMeldungVerlaufDoModelImpl tmcMeldungVerlaufDoModel = new TmcMeldungVerlaufDoModelImpl();
		return tmcMeldungVerlaufDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public UmfeldDatenMessstelleImageTyp createUmfeldDatenMessstelleImageTypFromString(
			EDataType eDataType, String initialValue) {
		final UmfeldDatenMessstelleImageTyp result = UmfeldDatenMessstelleImageTyp
				.get(initialValue);
		if (result == null) {
			throw new IllegalArgumentException("The value '" + initialValue
					+ "' is not a valid enumerator of '" + eDataType.getName()
					+ "'");
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertUmfeldDatenMessstelleImageTypToString(
			EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public StrassenTyp createStrassenTypFromString(EDataType eDataType,
			String initialValue) {
		final StrassenTyp result = StrassenTyp.get(initialValue);
		if (result == null) {
			throw new IllegalArgumentException("The value '" + initialValue
					+ "' is not a valid enumerator of '" + eDataType.getName()
					+ "'");
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertStrassenTypToString(EDataType eDataType,
			Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public MessQuerschnittDoTyp createMessQuerschnittDoTyp() {
		final MessQuerschnittDoTypImpl messQuerschnittDoTyp = new MessQuerschnittDoTypImpl();
		return messQuerschnittDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public MessQuerschnittDoModel createMessQuerschnittDoModel() {
		final MessQuerschnittDoModelImpl messQuerschnittDoModel = new MessQuerschnittDoModelImpl();
		return messQuerschnittDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenSegmentDoTyp createStrassenSegmentDoTyp() {
		final StrassenSegmentDoTypImpl strassenSegmentDoTyp = new StrassenSegmentDoTypImpl();
		return strassenSegmentDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenSegmentDoModel createStrassenSegmentDoModel() {
		final StrassenSegmentDoModelImpl strassenSegmentDoModel = new StrassenSegmentDoModelImpl();
		return strassenSegmentDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public KreisDoTyp createKreisDoTyp() {
		final KreisDoTypImpl kreisDoTyp = new KreisDoTypImpl();
		return kreisDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public KreisDoModel createKreisDoModel() {
		final KreisDoModelImpl kreisDoModel = new KreisDoModelImpl();
		return kreisDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public OrtslageDoTyp createOrtslageDoTyp() {
		final OrtslageDoTypImpl ortslageDoTyp = new OrtslageDoTypImpl();
		return ortslageDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public OrtslageDoModel createOrtslageDoModel() {
		final OrtslageDoModelImpl ortslageDoModel = new OrtslageDoModelImpl();
		return ortslageDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public OrtsnameDoTyp createOrtsnameDoTyp() {
		final OrtsnameDoTypImpl ortsnameDoTyp = new OrtsnameDoTypImpl();
		return ortsnameDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public OrtsnameDoModel createOrtsnameDoModel() {
		final OrtsnameDoModelImpl ortsnameDoModel = new OrtsnameDoModelImpl();
		return ortsnameDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenKnotenDoTyp createStrassenKnotenDoTyp() {
		final StrassenKnotenDoTypImpl strassenKnotenDoTyp = new StrassenKnotenDoTypImpl();
		return strassenKnotenDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenKnotenDoModel createStrassenKnotenDoModel() {
		final StrassenKnotenDoModelImpl strassenKnotenDoModel = new StrassenKnotenDoModelImpl();
		return strassenKnotenDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StoerfallIndikatorDoModel createStoerfallIndikatorDoModel() {
		final StoerfallIndikatorDoModelImpl stoerfallIndikatorDoModel = new StoerfallIndikatorDoModelImpl();
		return stoerfallIndikatorDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenSegmentStoerfallIndikatorDoTyp createStrassenSegmentStoerfallIndikatorDoTyp() {
		final StrassenSegmentStoerfallIndikatorDoTypImpl strassenSegmentStoerfallIndikatorDoTyp = new StrassenSegmentStoerfallIndikatorDoTypImpl();
		return strassenSegmentStoerfallIndikatorDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenSegmentStoerfallIndikatorDoModel createStrassenSegmentStoerfallIndikatorDoModel() {
		final StrassenSegmentStoerfallIndikatorDoModelImpl strassenSegmentStoerfallIndikatorDoModel = new StrassenSegmentStoerfallIndikatorDoModelImpl();
		return strassenSegmentStoerfallIndikatorDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenTeilSegmentStoerfallIndikatorDoTyp createStrassenTeilSegmentStoerfallIndikatorDoTyp() {
		final StrassenTeilSegmentStoerfallIndikatorDoTypImpl strassenTeilSegmentStoerfallIndikatorDoTyp = new StrassenTeilSegmentStoerfallIndikatorDoTypImpl();
		return strassenTeilSegmentStoerfallIndikatorDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public StrassenTeilSegmentStoerfallIndikatorDoModel createStrassenTeilSegmentStoerfallIndikatorDoModel() {
		final StrassenTeilSegmentStoerfallIndikatorDoModelImpl strassenTeilSegmentStoerfallIndikatorDoModel = new StrassenTeilSegmentStoerfallIndikatorDoModelImpl();
		return strassenTeilSegmentStoerfallIndikatorDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public MessQuerschnittStoerfallIndikatorDoTyp createMessQuerschnittStoerfallIndikatorDoTyp() {
		final MessQuerschnittStoerfallIndikatorDoTypImpl messQuerschnittStoerfallIndikatorDoTyp = new MessQuerschnittStoerfallIndikatorDoTypImpl();
		return messQuerschnittStoerfallIndikatorDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public MessQuerschnittStoerfallIndikatorDoModel createMessQuerschnittStoerfallIndikatorDoModel() {
		final MessQuerschnittStoerfallIndikatorDoModelImpl messQuerschnittStoerfallIndikatorDoModel = new MessQuerschnittStoerfallIndikatorDoModelImpl();
		return messQuerschnittStoerfallIndikatorDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NetzPackage getNetzPackage() {
		return (NetzPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static NetzPackage getPackage() {
		return NetzPackage.eINSTANCE;
	}

} // NetzFactoryImpl
