/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.lib.eclipse.emf.dav.model.DavPackage;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoModel;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp;
import de.bsvrz.buv.plugin.netz.model.KomplexDoTyp;
import de.bsvrz.buv.plugin.netz.model.KreisDoModel;
import de.bsvrz.buv.plugin.netz.model.KreisDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.NetzFactory;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.SituationDoModel;
import de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class NetzPackageImpl extends EPackageImpl implements NetzPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass fahrStreifenStoerfallIndikatorDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass fahrStreifenStoerfallIndikatorDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass umfeldDatenMessStelleDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass umfeldDatenMessStelleDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass anzeigeQuerschnittDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass anzeigeQuerschnittDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass gewaesserDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass gewaesserDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass situationDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass situationSymbolDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass situationVerlaufDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass baustelleDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass baustelleSymbolDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass baustelleSymbolDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass baustelleVerlaufDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass baustelleVerlaufDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stauDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stauSymbolDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stauSymbolDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stauVerlaufDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stauVerlaufDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass unfallSymbolDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass unfallSymbolDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rdsMeldungDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rdsMeldungSymbolDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rdsMeldungSymbolDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rdsMeldungVerlaufDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass rdsMeldungVerlaufDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass messQuerschnittNBAHanDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass messQuerschnittNBAHanDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass tmcMeldungDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass tmcMeldungSymbolDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass tmcMeldungSymbolDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass tmcMeldungVerlaufDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass tmcMeldungVerlaufDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum umfeldDatenMessstelleImageTypEEnum = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EEnum strassenTypEEnum = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass messQuerschnittDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass messQuerschnittDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenSegmentDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenSegmentDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass kreisDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass kreisDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass ortslageDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass ortslageDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass komplexDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass ortsnameDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass ortsnameDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenKnotenDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenKnotenDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stoerfallIndikatorDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass stoerfallIndikatorDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenSegmentStoerfallIndikatorDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenSegmentStoerfallIndikatorDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenTeilSegmentStoerfallIndikatorDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass strassenTeilSegmentStoerfallIndikatorDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass messQuerschnittStoerfallIndikatorDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private EClass messQuerschnittStoerfallIndikatorDoModelEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private NetzPackageImpl() {
		super(eNS_URI, NetzFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 *
	 * <p>
	 * This method is used to initialize {@link NetzPackage#eINSTANCE} when that
	 * field is accessed. Clients should not invoke it directly. Instead, they
	 * should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static NetzPackage init() {
		if (isInited) {
			return (NetzPackage) EPackage.Registry.INSTANCE
					.getEPackage(NetzPackage.eNS_URI);
		}

		// Obtain or create and register package
		final Object registeredNetzPackage = EPackage.Registry.INSTANCE
				.get(eNS_URI);
		final NetzPackageImpl theNetzPackage = registeredNetzPackage instanceof NetzPackageImpl
				? (NetzPackageImpl) registeredNetzPackage
				: new NetzPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		DavPackage.eINSTANCE.eClass();
		DavbitctrlPackage.eINSTANCE.eClass();
		DobjPackage.eINSTANCE.eClass();
		DobjDecoratorPackage.eINSTANCE.eClass();
		EclipsePackage.eINSTANCE.eClass();
		GefPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theNetzPackage.createPackageContents();

		// Initialize created meta-data
		theNetzPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theNetzPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(NetzPackage.eNS_URI, theNetzPackage);
		return theNetzPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getFahrStreifenStoerfallIndikatorDoTyp() {
		return fahrStreifenStoerfallIndikatorDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getFahrStreifenStoerfallIndikatorDoTyp_Fahrstreifenabstand() {
		return (EAttribute) fahrStreifenStoerfallIndikatorDoTypEClass
				.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getFahrStreifenStoerfallIndikatorDoModel() {
		return fahrStreifenStoerfallIndikatorDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getUmfeldDatenMessStelleDoTyp() {
		return umfeldDatenMessStelleDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getUmfeldDatenMessStelleDoModel() {
		return umfeldDatenMessStelleDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getUmfeldDatenMessStelleDoModel_ImageTyp() {
		return (EAttribute) umfeldDatenMessStelleDoModelEClass
				.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getAnzeigeQuerschnittDoTyp() {
		return anzeigeQuerschnittDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getAnzeigeQuerschnittDoModel() {
		return anzeigeQuerschnittDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getGewaesserDoTyp() {
		return gewaesserDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getGewaesserDoModel() {
		return gewaesserDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getSituationDoModel() {
		return situationDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getSituationSymbolDoTyp() {
		return situationSymbolDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getSituationVerlaufDoTyp() {
		return situationVerlaufDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getBaustelleDoTyp() {
		return baustelleDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getBaustelleSymbolDoTyp() {
		return baustelleSymbolDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getBaustelleSymbolDoModel() {
		return baustelleSymbolDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getBaustelleVerlaufDoTyp() {
		return baustelleVerlaufDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getBaustelleVerlaufDoModel() {
		return baustelleVerlaufDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStauDoTyp() {
		return stauDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStauSymbolDoTyp() {
		return stauSymbolDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStauSymbolDoModel() {
		return stauSymbolDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStauVerlaufDoTyp() {
		return stauVerlaufDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStauVerlaufDoModel() {
		return stauVerlaufDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getUnfallSymbolDoTyp() {
		return unfallSymbolDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getUnfallSymbolDoModel() {
		return unfallSymbolDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getRdsMeldungDoTyp() {
		return rdsMeldungDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getRdsMeldungSymbolDoTyp() {
		return rdsMeldungSymbolDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getRdsMeldungSymbolDoModel() {
		return rdsMeldungSymbolDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getRdsMeldungVerlaufDoTyp() {
		return rdsMeldungVerlaufDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getRdsMeldungVerlaufDoModel() {
		return rdsMeldungVerlaufDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getMessQuerschnittNBAHanDoTyp() {
		return messQuerschnittNBAHanDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getMessQuerschnittNBAHanDoModel() {
		return messQuerschnittNBAHanDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getTmcMeldungDoTyp() {
		return tmcMeldungDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getTmcMeldungSymbolDoTyp() {
		return tmcMeldungSymbolDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getTmcMeldungSymbolDoModel() {
		return tmcMeldungSymbolDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getTmcMeldungVerlaufDoTyp() {
		return tmcMeldungVerlaufDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getTmcMeldungVerlaufDoModel() {
		return tmcMeldungVerlaufDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EEnum getUmfeldDatenMessstelleImageTyp() {
		return umfeldDatenMessstelleImageTypEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EEnum getStrassenTyp() {
		return strassenTypEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getMessQuerschnittDoTyp() {
		return messQuerschnittDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getMessQuerschnittDoTyp_TooltipZeitstempelFormat() {
		return (EAttribute) messQuerschnittDoTypEClass.getEStructuralFeatures()
				.get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getMessQuerschnittDoModel() {
		return messQuerschnittDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenSegmentDoTyp() {
		return strassenSegmentDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_DefaultDarstellungAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_VordergrundFarbeAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(6);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(7);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienabstandAutobahn() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(8);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_DefaultDarstellungBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(9);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_VordergrundFarbeBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(10);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(11);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(12);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(13);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(14);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(15);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(16);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienabstandBundesstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(17);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_DefaultDarstellungLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(18);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_VordergrundFarbeLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(19);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienabstandLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(26);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(20);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(21);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(22);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(23);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(24);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeLandstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(25);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_VordergrundFarbeKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(27);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(28);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(29);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(30);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMaximumKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(31);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeMinimumKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(32);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienstaerkeKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(33);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_LinienabstandKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(34);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenSegmentDoTyp_DefaultDarstellungKreisstrasse() {
		return (EAttribute) strassenSegmentDoTypEClass.getEStructuralFeatures()
				.get(35);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenSegmentDoModel() {
		return strassenSegmentDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getKreisDoTyp() {
		return kreisDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getKreisDoModel() {
		return kreisDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getOrtslageDoTyp() {
		return ortslageDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getOrtslageDoModel() {
		return ortslageDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getKomplexDoTyp() {
		return komplexDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getOrtsnameDoTyp() {
		return ortsnameDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getOrtsnameDoModel() {
		return ortsnameDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenKnotenDoTyp() {
		return strassenKnotenDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenKnotenDoTyp_AusgangsdurchmesserInMeter() {
		return (EAttribute) strassenKnotenDoTypEClass.getEStructuralFeatures()
				.get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EAttribute getStrassenKnotenDoTyp_MinimalerDurchmesserInPixel() {
		return (EAttribute) strassenKnotenDoTypEClass.getEStructuralFeatures()
				.get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenKnotenDoModel() {
		return strassenKnotenDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStoerfallIndikatorDoTyp() {
		return stoerfallIndikatorDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStoerfallIndikatorDoModel() {
		return stoerfallIndikatorDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenSegmentStoerfallIndikatorDoTyp() {
		return strassenSegmentStoerfallIndikatorDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenSegmentStoerfallIndikatorDoModel() {
		return strassenSegmentStoerfallIndikatorDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenTeilSegmentStoerfallIndikatorDoTyp() {
		return strassenTeilSegmentStoerfallIndikatorDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getStrassenTeilSegmentStoerfallIndikatorDoModel() {
		return strassenTeilSegmentStoerfallIndikatorDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getMessQuerschnittStoerfallIndikatorDoTyp() {
		return messQuerschnittStoerfallIndikatorDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EClass getMessQuerschnittStoerfallIndikatorDoModel() {
		return messQuerschnittStoerfallIndikatorDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NetzFactory getNetzFactory() {
		return (NetzFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is guarded to
	 * have no affect on any invocation but its first. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		messQuerschnittDoTypEClass = createEClass(MESS_QUERSCHNITT_DO_TYP);
		createEAttribute(messQuerschnittDoTypEClass,
				MESS_QUERSCHNITT_DO_TYP__TOOLTIP_ZEITSTEMPEL_FORMAT);

		messQuerschnittDoModelEClass = createEClass(MESS_QUERSCHNITT_DO_MODEL);

		strassenSegmentDoTypEClass = createEClass(STRASSEN_SEGMENT_DO_TYP);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE);
		createEAttribute(strassenSegmentDoTypEClass,
				STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE);

		strassenSegmentDoModelEClass = createEClass(STRASSEN_SEGMENT_DO_MODEL);

		kreisDoTypEClass = createEClass(KREIS_DO_TYP);

		kreisDoModelEClass = createEClass(KREIS_DO_MODEL);

		ortslageDoTypEClass = createEClass(ORTSLAGE_DO_TYP);

		ortslageDoModelEClass = createEClass(ORTSLAGE_DO_MODEL);

		komplexDoTypEClass = createEClass(KOMPLEX_DO_TYP);

		ortsnameDoTypEClass = createEClass(ORTSNAME_DO_TYP);

		ortsnameDoModelEClass = createEClass(ORTSNAME_DO_MODEL);

		strassenKnotenDoTypEClass = createEClass(STRASSEN_KNOTEN_DO_TYP);
		createEAttribute(strassenKnotenDoTypEClass,
				STRASSEN_KNOTEN_DO_TYP__AUSGANGSDURCHMESSER_IN_METER);
		createEAttribute(strassenKnotenDoTypEClass,
				STRASSEN_KNOTEN_DO_TYP__MINIMALER_DURCHMESSER_IN_PIXEL);

		strassenKnotenDoModelEClass = createEClass(STRASSEN_KNOTEN_DO_MODEL);

		stoerfallIndikatorDoTypEClass = createEClass(
				STOERFALL_INDIKATOR_DO_TYP);

		stoerfallIndikatorDoModelEClass = createEClass(
				STOERFALL_INDIKATOR_DO_MODEL);

		strassenSegmentStoerfallIndikatorDoTypEClass = createEClass(
				STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP);

		strassenSegmentStoerfallIndikatorDoModelEClass = createEClass(
				STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL);

		strassenTeilSegmentStoerfallIndikatorDoTypEClass = createEClass(
				STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP);

		strassenTeilSegmentStoerfallIndikatorDoModelEClass = createEClass(
				STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL);

		messQuerschnittStoerfallIndikatorDoTypEClass = createEClass(
				MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP);

		messQuerschnittStoerfallIndikatorDoModelEClass = createEClass(
				MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL);

		fahrStreifenStoerfallIndikatorDoTypEClass = createEClass(
				FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP);
		createEAttribute(fahrStreifenStoerfallIndikatorDoTypEClass,
				FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP__FAHRSTREIFENABSTAND);

		fahrStreifenStoerfallIndikatorDoModelEClass = createEClass(
				FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL);

		umfeldDatenMessStelleDoTypEClass = createEClass(
				UMFELD_DATEN_MESS_STELLE_DO_TYP);

		umfeldDatenMessStelleDoModelEClass = createEClass(
				UMFELD_DATEN_MESS_STELLE_DO_MODEL);
		createEAttribute(umfeldDatenMessStelleDoModelEClass,
				UMFELD_DATEN_MESS_STELLE_DO_MODEL__IMAGE_TYP);

		anzeigeQuerschnittDoTypEClass = createEClass(
				ANZEIGE_QUERSCHNITT_DO_TYP);

		anzeigeQuerschnittDoModelEClass = createEClass(
				ANZEIGE_QUERSCHNITT_DO_MODEL);

		gewaesserDoTypEClass = createEClass(GEWAESSER_DO_TYP);

		gewaesserDoModelEClass = createEClass(GEWAESSER_DO_MODEL);

		situationDoModelEClass = createEClass(SITUATION_DO_MODEL);

		situationSymbolDoTypEClass = createEClass(SITUATION_SYMBOL_DO_TYP);

		situationVerlaufDoTypEClass = createEClass(SITUATION_VERLAUF_DO_TYP);

		baustelleDoTypEClass = createEClass(BAUSTELLE_DO_TYP);

		baustelleSymbolDoTypEClass = createEClass(BAUSTELLE_SYMBOL_DO_TYP);

		baustelleSymbolDoModelEClass = createEClass(BAUSTELLE_SYMBOL_DO_MODEL);

		baustelleVerlaufDoTypEClass = createEClass(BAUSTELLE_VERLAUF_DO_TYP);

		baustelleVerlaufDoModelEClass = createEClass(
				BAUSTELLE_VERLAUF_DO_MODEL);

		stauDoTypEClass = createEClass(STAU_DO_TYP);

		stauSymbolDoTypEClass = createEClass(STAU_SYMBOL_DO_TYP);

		stauSymbolDoModelEClass = createEClass(STAU_SYMBOL_DO_MODEL);

		stauVerlaufDoTypEClass = createEClass(STAU_VERLAUF_DO_TYP);

		stauVerlaufDoModelEClass = createEClass(STAU_VERLAUF_DO_MODEL);

		unfallSymbolDoTypEClass = createEClass(UNFALL_SYMBOL_DO_TYP);

		unfallSymbolDoModelEClass = createEClass(UNFALL_SYMBOL_DO_MODEL);

		rdsMeldungDoTypEClass = createEClass(RDS_MELDUNG_DO_TYP);

		rdsMeldungSymbolDoTypEClass = createEClass(RDS_MELDUNG_SYMBOL_DO_TYP);

		rdsMeldungSymbolDoModelEClass = createEClass(
				RDS_MELDUNG_SYMBOL_DO_MODEL);

		rdsMeldungVerlaufDoTypEClass = createEClass(RDS_MELDUNG_VERLAUF_DO_TYP);

		rdsMeldungVerlaufDoModelEClass = createEClass(
				RDS_MELDUNG_VERLAUF_DO_MODEL);

		messQuerschnittNBAHanDoTypEClass = createEClass(
				MESS_QUERSCHNITT_NBA_HAN_DO_TYP);

		messQuerschnittNBAHanDoModelEClass = createEClass(
				MESS_QUERSCHNITT_NBA_HAN_DO_MODEL);

		tmcMeldungDoTypEClass = createEClass(TMC_MELDUNG_DO_TYP);

		tmcMeldungSymbolDoTypEClass = createEClass(TMC_MELDUNG_SYMBOL_DO_TYP);

		tmcMeldungSymbolDoModelEClass = createEClass(
				TMC_MELDUNG_SYMBOL_DO_MODEL);

		tmcMeldungVerlaufDoTypEClass = createEClass(TMC_MELDUNG_VERLAUF_DO_TYP);

		tmcMeldungVerlaufDoModelEClass = createEClass(
				TMC_MELDUNG_VERLAUF_DO_MODEL);

		// Create enums
		umfeldDatenMessstelleImageTypEEnum = createEEnum(
				UMFELD_DATEN_MESSSTELLE_IMAGE_TYP);
		strassenTypEEnum = createEEnum(STRASSEN_TYP);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		final DobjPackage theDobjPackage = (DobjPackage) EPackage.Registry.INSTANCE
				.getEPackage(DobjPackage.eNS_URI);
		final DobjDecoratorPackage theDobjDecoratorPackage = (DobjDecoratorPackage) EPackage.Registry.INSTANCE
				.getEPackage(DobjDecoratorPackage.eNS_URI);
		final DavbitctrlPackage theDavbitctrlPackage = (DavbitctrlPackage) EPackage.Registry.INSTANCE
				.getEPackage(DavbitctrlPackage.eNS_URI);
		final EclipsePackage theEclipsePackage = (EclipsePackage) EPackage.Registry.INSTANCE
				.getEPackage(EclipsePackage.eNS_URI);

		// Create type parameters
		final ETypeParameter situationDoModelEClass_T = addETypeParameter(
				situationDoModelEClass, "T");

		// Set bounds for type parameters
		EGenericType g1 = createEGenericType(
				theDavbitctrlPackage.getSituation());
		situationDoModelEClass_T.getEBounds().add(g1);

		// Add supertypes to classes
		messQuerschnittDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		messQuerschnittDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getSkalierungDecorator());
		messQuerschnittDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getDatenstatusDecorator());
		messQuerschnittDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		EGenericType g2 = createEGenericType(
				theDavbitctrlPackage.getMessQuerschnittAllgemein());
		g1.getETypeArguments().add(g2);
		messQuerschnittDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(
				theDobjDecoratorPackage.getSkalierungDecorator());
		messQuerschnittDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getDrehungDecorator());
		messQuerschnittDoModelEClass.getEGenericSuperTypes().add(g1);
		strassenSegmentDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		strassenSegmentDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		strassenSegmentDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		strassenSegmentDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getStrassenSegment());
		g1.getETypeArguments().add(g2);
		strassenSegmentDoModelEClass.getEGenericSuperTypes().add(g1);
		kreisDoTypEClass.getESuperTypes().add(this.getKomplexDoTyp());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getKomplexXY());
		g1.getETypeArguments().add(g2);
		kreisDoModelEClass.getEGenericSuperTypes().add(g1);
		ortslageDoTypEClass.getESuperTypes().add(this.getKomplexDoTyp());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getKomplexXY());
		g1.getETypeArguments().add(g2);
		ortslageDoModelEClass.getEGenericSuperTypes().add(g1);
		komplexDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		komplexDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		komplexDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getHintergrundfarbeDecorator());
		ortsnameDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		ortsnameDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getSchriftDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getPunktXY());
		g1.getETypeArguments().add(g2);
		ortsnameDoModelEClass.getEGenericSuperTypes().add(g1);
		strassenKnotenDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		strassenKnotenDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getHintergrundfarbeDecorator());
		strassenKnotenDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getStrassenKnoten());
		g1.getETypeArguments().add(g2);
		strassenKnotenDoModelEClass.getEGenericSuperTypes().add(g1);
		stoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		stoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getStoerfallIndikatorDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getStoerfallIndikator());
		g1.getETypeArguments().add(g2);
		stoerfallIndikatorDoModelEClass.getEGenericSuperTypes().add(g1);
		strassenSegmentStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoTyp());
		strassenSegmentStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		strassenSegmentStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		strassenSegmentStoerfallIndikatorDoModelEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoModel());
		strassenTeilSegmentStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoTyp());
		strassenTeilSegmentStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		strassenTeilSegmentStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		strassenTeilSegmentStoerfallIndikatorDoModelEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoModel());
		messQuerschnittStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoTyp());
		messQuerschnittStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		messQuerschnittStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		messQuerschnittStoerfallIndikatorDoModelEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoModel());
		fahrStreifenStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoTyp());
		fahrStreifenStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		fahrStreifenStoerfallIndikatorDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		fahrStreifenStoerfallIndikatorDoModelEClass.getESuperTypes()
				.add(this.getStoerfallIndikatorDoModel());
		umfeldDatenMessStelleDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(
				theDavbitctrlPackage.getUmfeldDatenMessStelle());
		g1.getETypeArguments().add(g2);
		umfeldDatenMessStelleDoModelEClass.getEGenericSuperTypes().add(g1);
		anzeigeQuerschnittDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getAnzeigeQuerschnitt());
		g1.getETypeArguments().add(g2);
		anzeigeQuerschnittDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getDrehungDecorator());
		anzeigeQuerschnittDoModelEClass.getEGenericSuperTypes().add(g1);
		gewaesserDoTypEClass.getESuperTypes().add(this.getKomplexDoTyp());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getKomplexXY());
		g1.getETypeArguments().add(g2);
		gewaesserDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(situationDoModelEClass_T);
		g1.getETypeArguments().add(g2);
		situationDoModelEClass.getEGenericSuperTypes().add(g1);
		situationSymbolDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		situationSymbolDoTypEClass.getESuperTypes().add(theDobjDecoratorPackage
				.getAntikollisionsalgorithmusDecorator());
		situationSymbolDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		situationVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		situationVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		situationVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		situationVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		baustelleDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		baustelleDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		baustelleSymbolDoTypEClass.getESuperTypes()
				.add(this.getBaustelleDoTyp());
		baustelleSymbolDoTypEClass.getESuperTypes()
				.add(this.getSituationSymbolDoTyp());
		g1 = createEGenericType(this.getSituationDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getBaustelle());
		g1.getETypeArguments().add(g2);
		baustelleSymbolDoModelEClass.getEGenericSuperTypes().add(g1);
		baustelleVerlaufDoTypEClass.getESuperTypes()
				.add(this.getBaustelleDoTyp());
		baustelleVerlaufDoTypEClass.getESuperTypes()
				.add(this.getSituationVerlaufDoTyp());
		g1 = createEGenericType(this.getSituationDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getBaustelle());
		g1.getETypeArguments().add(g2);
		baustelleVerlaufDoModelEClass.getEGenericSuperTypes().add(g1);
		stauDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		stauDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		stauSymbolDoTypEClass.getESuperTypes().add(this.getStauDoTyp());
		stauSymbolDoTypEClass.getESuperTypes()
				.add(this.getSituationSymbolDoTyp());
		g1 = createEGenericType(this.getSituationDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getStau());
		g1.getETypeArguments().add(g2);
		stauSymbolDoModelEClass.getEGenericSuperTypes().add(g1);
		stauVerlaufDoTypEClass.getESuperTypes().add(this.getStauDoTyp());
		stauVerlaufDoTypEClass.getESuperTypes()
				.add(this.getSituationVerlaufDoTyp());
		g1 = createEGenericType(this.getSituationDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getStau());
		g1.getETypeArguments().add(g2);
		stauVerlaufDoModelEClass.getEGenericSuperTypes().add(g1);
		unfallSymbolDoTypEClass.getESuperTypes()
				.add(this.getSituationSymbolDoTyp());
		g1 = createEGenericType(this.getSituationDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getUnfall());
		g1.getETypeArguments().add(g2);
		unfallSymbolDoModelEClass.getEGenericSuperTypes().add(g1);
		rdsMeldungDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		rdsMeldungDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		rdsMeldungSymbolDoTypEClass.getESuperTypes()
				.add(this.getRdsMeldungDoTyp());
		rdsMeldungSymbolDoTypEClass.getESuperTypes().add(theDobjDecoratorPackage
				.getAntikollisionsalgorithmusDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getRdsMeldung());
		g1.getETypeArguments().add(g2);
		rdsMeldungSymbolDoModelEClass.getEGenericSuperTypes().add(g1);
		rdsMeldungVerlaufDoTypEClass.getESuperTypes()
				.add(this.getRdsMeldungDoTyp());
		rdsMeldungVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		rdsMeldungVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getRdsMeldung());
		g1.getETypeArguments().add(g2);
		rdsMeldungVerlaufDoModelEClass.getEGenericSuperTypes().add(g1);
		messQuerschnittNBAHanDoTypEClass.getESuperTypes()
				.add(this.getMessQuerschnittDoTyp());
		messQuerschnittNBAHanDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getZoomVerhaltenFixDecorator());
		messQuerschnittNBAHanDoModelEClass.getESuperTypes()
				.add(this.getMessQuerschnittDoModel());
		tmcMeldungDoTypEClass.getESuperTypes()
				.add(theDobjPackage.getConfiguratedDoTyp());
		tmcMeldungDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienabstandZoomDecorator());
		tmcMeldungSymbolDoTypEClass.getESuperTypes()
				.add(this.getTmcMeldungDoTyp());
		tmcMeldungSymbolDoTypEClass.getESuperTypes().add(theDobjDecoratorPackage
				.getAntikollisionsalgorithmusDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getTmcVerkehrsMeldung());
		g1.getETypeArguments().add(g2);
		tmcMeldungSymbolDoModelEClass.getEGenericSuperTypes().add(g1);
		tmcMeldungVerlaufDoTypEClass.getESuperTypes()
				.add(this.getTmcMeldungDoTyp());
		tmcMeldungVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getVordergrundfarbeDecorator());
		tmcMeldungVerlaufDoTypEClass.getESuperTypes()
				.add(theDobjDecoratorPackage.getLinienstaerkeZoomDecorator());
		g1 = createEGenericType(theDobjPackage.getBitCtrlDoModel());
		g2 = createEGenericType(theDavbitctrlPackage.getTmcVerkehrsMeldung());
		g1.getETypeArguments().add(g2);
		tmcMeldungVerlaufDoModelEClass.getEGenericSuperTypes().add(g1);

		// Initialize classes and features; add operations and parameters
		initEClass(messQuerschnittDoTypEClass, MessQuerschnittDoTyp.class,
				"MessQuerschnittDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMessQuerschnittDoTyp_TooltipZeitstempelFormat(),
				ecorePackage.getEString(), "tooltipZeitstempelFormat",
				"dd.MM.yyyy HH:mm:ss,SSS", 0, 1, MessQuerschnittDoTyp.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(messQuerschnittDoModelEClass, MessQuerschnittDoModel.class,
				"MessQuerschnittDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(strassenSegmentDoTypEClass, StrassenSegmentDoTyp.class,
				"StrassenSegmentDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStrassenSegmentDoTyp_DefaultDarstellungAutobahn(),
				ecorePackage.getEBoolean(), "defaultDarstellungAutobahn",
				"true", 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_VordergrundFarbeAutobahn(),
				theEclipsePackage.getRGB(), "vordergrundFarbeAutobahn", null, 0,
				1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenAutobahn(),
				theDobjDecoratorPackage.getZoomverhalten(),
				"linienstaerkeZoomverhaltenAutobahn",
				"statisches Zoomverhalten", 0, 1, StrassenSegmentDoTyp.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeAutobahn(),
				ecorePackage.getEInt(),
				"linienstaerkeMinimaleZoomstufeAutobahn", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeAutobahn(),
				ecorePackage.getEInt(),
				"linienstaerkeMaximaleZoomstufeAutobahn", "5000", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienstaerkeMaximumAutobahn(),
				ecorePackage.getEInt(), "linienstaerkeMaximumAutobahn", "1", 0,
				1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienstaerkeMinimumAutobahn(),
				ecorePackage.getEInt(), "linienstaerkeMinimumAutobahn", "1", 0,
				1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienstaerkeAutobahn(),
				ecorePackage.getEInt(), "linienstaerkeAutobahn", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienabstandAutobahn(),
				ecorePackage.getEInt(), "linienabstandAutobahn", "0", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_DefaultDarstellungBundesstrasse(),
				ecorePackage.getEBoolean(), "defaultDarstellungBundesstrasse",
				"true", 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_VordergrundFarbeBundesstrasse(),
				theEclipsePackage.getRGB(), "vordergrundFarbeBundesstrasse",
				null, 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenBundesstrasse(),
				theDobjDecoratorPackage.getZoomverhalten(),
				"linienstaerkeZoomverhaltenBundesstrasse",
				"statisches Zoomverhalten", 0, 1, StrassenSegmentDoTyp.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeBundesstrasse(),
				ecorePackage.getEInt(),
				"linienstaerkeMinimaleZoomstufeBundesstrasse", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeBundesstrasse(),
				ecorePackage.getEInt(),
				"linienstaerkeMaximaleZoomstufeBundesstrasse", "5000", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMaximumBundesstrasse(),
				ecorePackage.getEInt(), "linienstaerkeMaximumBundesstrasse",
				"1", 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMinimumBundesstrasse(),
				ecorePackage.getEInt(), "linienstaerkeMinimumBundesstrasse",
				"1", 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienstaerkeBundesstrasse(),
				ecorePackage.getEInt(), "linienstaerkeBundesstrasse", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienabstandBundesstrasse(),
				ecorePackage.getEInt(), "linienabstandBundesstrasse", "0", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_DefaultDarstellungLandstrasse(),
				ecorePackage.getEBoolean(), "defaultDarstellungLandstrasse",
				"true", 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_VordergrundFarbeLandstrasse(),
				theEclipsePackage.getRGB(), "vordergrundFarbeLandstrasse", null,
				0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenLandstrasse(),
				theDobjDecoratorPackage.getZoomverhalten(),
				"linienstaerkeZoomverhaltenLandstrasse",
				"statisches Zoomverhalten", 0, 1, StrassenSegmentDoTyp.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeLandstrasse(),
				ecorePackage.getEInt(),
				"linienstaerkeMinimaleZoomstufeLandstrasse", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeLandstrasse(),
				ecorePackage.getEInt(),
				"linienstaerkeMaximaleZoomstufeLandstrasse", "5000", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMaximumLandstrasse(),
				ecorePackage.getEInt(), "linienstaerkeMaximumLandstrasse", "1",
				0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMinimumLandstrasse(),
				ecorePackage.getEInt(), "linienstaerkeMinimumLandstrasse", "1",
				0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienstaerkeLandstrasse(),
				ecorePackage.getEInt(), "linienstaerkeLandstrasse", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienabstandLandstrasse(),
				ecorePackage.getEInt(), "linienabstandLandstrasse", "0", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_VordergrundFarbeKreisstrasse(),
				theEclipsePackage.getRGB(), "vordergrundFarbeKreisstrasse",
				null, 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeZoomverhaltenKreisstrasse(),
				theDobjDecoratorPackage.getZoomverhalten(),
				"linienstaerkeZoomverhaltenKreisstrasse",
				"statisches Zoomverhalten", 0, 1, StrassenSegmentDoTyp.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMinimaleZoomstufeKreisstrasse(),
				ecorePackage.getEInt(),
				"linienstaerkeMinimaleZoomstufeKreisstrasse", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMaximaleZoomstufeKreisstrasse(),
				ecorePackage.getEInt(),
				"linienstaerkeMaximaleZoomstufeKreisstrasse", "5000", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMaximumKreisstrasse(),
				ecorePackage.getEInt(), "linienstaerkeMaximumKreisstrasse", "1",
				0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(
				getStrassenSegmentDoTyp_LinienstaerkeMinimumKreisstrasse(),
				ecorePackage.getEInt(), "linienstaerkeMinimumKreisstrasse", "1",
				0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienstaerkeKreisstrasse(),
				ecorePackage.getEInt(), "linienstaerkeKreisstrasse", "1", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_LinienabstandKreisstrasse(),
				ecorePackage.getEInt(), "linienabstandKreisstrasse", "0", 0, 1,
				StrassenSegmentDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenSegmentDoTyp_DefaultDarstellungKreisstrasse(),
				ecorePackage.getEBoolean(), "defaultDarstellungKreisstrasse",
				"true", 0, 1, StrassenSegmentDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(strassenSegmentDoModelEClass, StrassenSegmentDoModel.class,
				"StrassenSegmentDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(kreisDoTypEClass, KreisDoTyp.class, "KreisDoTyp",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(kreisDoModelEClass, KreisDoModel.class, "KreisDoModel",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ortslageDoTypEClass, OrtslageDoTyp.class, "OrtslageDoTyp",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ortslageDoModelEClass, OrtslageDoModel.class,
				"OrtslageDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(komplexDoTypEClass, KomplexDoTyp.class, "KomplexDoTyp",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ortsnameDoTypEClass, OrtsnameDoTyp.class, "OrtsnameDoTyp",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ortsnameDoModelEClass, OrtsnameDoModel.class,
				"OrtsnameDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(strassenKnotenDoTypEClass, StrassenKnotenDoTyp.class,
				"StrassenKnotenDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStrassenKnotenDoTyp_AusgangsdurchmesserInMeter(),
				ecorePackage.getEInt(), "ausgangsdurchmesserInMeter", "2000", 0,
				1, StrassenKnotenDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getStrassenKnotenDoTyp_MinimalerDurchmesserInPixel(),
				ecorePackage.getEInt(), "minimalerDurchmesserInPixel", "5", 0,
				1, StrassenKnotenDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);

		initEClass(strassenKnotenDoModelEClass, StrassenKnotenDoModel.class,
				"StrassenKnotenDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(stoerfallIndikatorDoTypEClass, StoerfallIndikatorDoTyp.class,
				"StoerfallIndikatorDoTyp", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(stoerfallIndikatorDoModelEClass,
				StoerfallIndikatorDoModel.class, "StoerfallIndikatorDoModel",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(strassenSegmentStoerfallIndikatorDoTypEClass,
				StrassenSegmentStoerfallIndikatorDoTyp.class,
				"StrassenSegmentStoerfallIndikatorDoTyp", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(strassenSegmentStoerfallIndikatorDoModelEClass,
				StrassenSegmentStoerfallIndikatorDoModel.class,
				"StrassenSegmentStoerfallIndikatorDoModel", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(strassenTeilSegmentStoerfallIndikatorDoTypEClass,
				StrassenTeilSegmentStoerfallIndikatorDoTyp.class,
				"StrassenTeilSegmentStoerfallIndikatorDoTyp", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(strassenTeilSegmentStoerfallIndikatorDoModelEClass,
				StrassenTeilSegmentStoerfallIndikatorDoModel.class,
				"StrassenTeilSegmentStoerfallIndikatorDoModel", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(messQuerschnittStoerfallIndikatorDoTypEClass,
				MessQuerschnittStoerfallIndikatorDoTyp.class,
				"MessQuerschnittStoerfallIndikatorDoTyp", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(messQuerschnittStoerfallIndikatorDoModelEClass,
				MessQuerschnittStoerfallIndikatorDoModel.class,
				"MessQuerschnittStoerfallIndikatorDoModel", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(fahrStreifenStoerfallIndikatorDoTypEClass,
				FahrStreifenStoerfallIndikatorDoTyp.class,
				"FahrStreifenStoerfallIndikatorDoTyp", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(
				getFahrStreifenStoerfallIndikatorDoTyp_Fahrstreifenabstand(),
				ecorePackage.getEInt(), "fahrstreifenabstand", "5", 0, 1,
				FahrStreifenStoerfallIndikatorDoTyp.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(fahrStreifenStoerfallIndikatorDoModelEClass,
				FahrStreifenStoerfallIndikatorDoModel.class,
				"FahrStreifenStoerfallIndikatorDoModel", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(umfeldDatenMessStelleDoTypEClass,
				UmfeldDatenMessStelleDoTyp.class, "UmfeldDatenMessStelleDoTyp",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(umfeldDatenMessStelleDoModelEClass,
				UmfeldDatenMessStelleDoModel.class,
				"UmfeldDatenMessStelleDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUmfeldDatenMessStelleDoModel_ImageTyp(),
				this.getUmfeldDatenMessstelleImageTyp(), "imageTyp",
				"Standardbild", 0, 1, UmfeldDatenMessStelleDoModel.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(anzeigeQuerschnittDoTypEClass, AnzeigeQuerschnittDoTyp.class,
				"AnzeigeQuerschnittDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(anzeigeQuerschnittDoModelEClass,
				AnzeigeQuerschnittDoModel.class, "AnzeigeQuerschnittDoModel",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(gewaesserDoTypEClass, GewaesserDoTyp.class, "GewaesserDoTyp",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(gewaesserDoModelEClass, GewaesserDoModel.class,
				"GewaesserDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(situationDoModelEClass, SituationDoModel.class,
				"SituationDoModel", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(situationSymbolDoTypEClass, SituationSymbolDoTyp.class,
				"SituationSymbolDoTyp", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(situationVerlaufDoTypEClass, SituationVerlaufDoTyp.class,
				"SituationVerlaufDoTyp", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(baustelleDoTypEClass, BaustelleDoTyp.class, "BaustelleDoTyp",
				IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(baustelleSymbolDoTypEClass, BaustelleSymbolDoTyp.class,
				"BaustelleSymbolDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(baustelleSymbolDoModelEClass, BaustelleSymbolDoModel.class,
				"BaustelleSymbolDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(baustelleVerlaufDoTypEClass, BaustelleVerlaufDoTyp.class,
				"BaustelleVerlaufDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(baustelleVerlaufDoModelEClass, BaustelleVerlaufDoModel.class,
				"BaustelleVerlaufDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(stauDoTypEClass, StauDoTyp.class, "StauDoTyp", IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(stauSymbolDoTypEClass, StauSymbolDoTyp.class,
				"StauSymbolDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(stauSymbolDoModelEClass, StauSymbolDoModel.class,
				"StauSymbolDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(stauVerlaufDoTypEClass, StauVerlaufDoTyp.class,
				"StauVerlaufDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(stauVerlaufDoModelEClass, StauVerlaufDoModel.class,
				"StauVerlaufDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(unfallSymbolDoTypEClass, UnfallSymbolDoTyp.class,
				"UnfallSymbolDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(unfallSymbolDoModelEClass, UnfallSymbolDoModel.class,
				"UnfallSymbolDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdsMeldungDoTypEClass, RdsMeldungDoTyp.class,
				"RdsMeldungDoTyp", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdsMeldungSymbolDoTypEClass, RdsMeldungSymbolDoTyp.class,
				"RdsMeldungSymbolDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdsMeldungSymbolDoModelEClass, RdsMeldungSymbolDoModel.class,
				"RdsMeldungSymbolDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdsMeldungVerlaufDoTypEClass, RdsMeldungVerlaufDoTyp.class,
				"RdsMeldungVerlaufDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rdsMeldungVerlaufDoModelEClass,
				RdsMeldungVerlaufDoModel.class, "RdsMeldungVerlaufDoModel",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(messQuerschnittNBAHanDoTypEClass,
				MessQuerschnittNBAHanDoTyp.class, "MessQuerschnittNBAHanDoTyp",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(messQuerschnittNBAHanDoModelEClass,
				MessQuerschnittNBAHanDoModel.class,
				"MessQuerschnittNBAHanDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(tmcMeldungDoTypEClass, TmcMeldungDoTyp.class,
				"TmcMeldungDoTyp", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(tmcMeldungSymbolDoTypEClass, TmcMeldungSymbolDoTyp.class,
				"TmcMeldungSymbolDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(tmcMeldungSymbolDoModelEClass, TmcMeldungSymbolDoModel.class,
				"TmcMeldungSymbolDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(tmcMeldungVerlaufDoTypEClass, TmcMeldungVerlaufDoTyp.class,
				"TmcMeldungVerlaufDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(tmcMeldungVerlaufDoModelEClass,
				TmcMeldungVerlaufDoModel.class, "TmcMeldungVerlaufDoModel",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Initialize enums and add enum literals
		initEEnum(umfeldDatenMessstelleImageTypEEnum,
				UmfeldDatenMessstelleImageTyp.class,
				"UmfeldDatenMessstelleImageTyp");
		addEEnumLiteral(umfeldDatenMessstelleImageTypEEnum,
				UmfeldDatenMessstelleImageTyp.STANDARDBILD);
		addEEnumLiteral(umfeldDatenMessstelleImageTypEEnum,
				UmfeldDatenMessstelleImageTyp.SWIS);

		initEEnum(strassenTypEEnum, StrassenTyp.class, "StrassenTyp");
		addEEnumLiteral(strassenTypEEnum, StrassenTyp.SONSTIGE);
		addEEnumLiteral(strassenTypEEnum, StrassenTyp.AUTOBAHN);
		addEEnumLiteral(strassenTypEEnum, StrassenTyp.BUNDESSTRASSE);
		addEEnumLiteral(strassenTypEEnum, StrassenTyp.LANDSTRASSE);
		addEEnumLiteral(strassenTypEEnum, StrassenTyp.KREISSTRASSE);

		// Create resource
		createResource(eNS_URI);
	}

} // NetzPackageImpl
