/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp;

/**
 * <!-- begin-user-doc --> An implementation of the model object ' <em><b>Rds
 * Meldung Do Typ</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl#getLinienabstandZoomverhalten
 * <em>Linienabstand Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl#getLinienabstandMinimaleZoomstufe
 * <em>Linienabstand Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl#getLinienabstandMaximaleZoomstufe
 * <em>Linienabstand Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl#getLinienabstandMaximum
 * <em>Linienabstand Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl#getLinienabstandMinimum
 * <em>Linienabstand Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.RdsMeldungDoTypImpl#getLinienabstand
 * <em>Linienabstand</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class RdsMeldungDoTypImpl extends ConfiguratedDoTypImpl
		implements RdsMeldungDoTyp {
	/**
	 * The default value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienabstandZoomverhalten = LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienabstand Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;

	/**
	 * The cached value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienabstand Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;

	/**
	 * This is true if the Linienabstand Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximumESet;

	/**
	 * The default value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;

	/**
	 * This is true if the Linienabstand Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimumESet;

	/**
	 * The default value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 *
	 * @see #getLinienabstand()
	 * @generated NOT
	 * @ordered
	 */
	protected static final int LINIENABSTAND_EDEFAULT = 14;

	/**
	 * The cached value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected int linienabstand = LINIENABSTAND_EDEFAULT;

	/**
	 * This is true if the Linienabstand attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandESet;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RdsMeldungDoTypImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NetzPackage.Literals.RDS_MELDUNG_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienabstandZoomverhalten() {
		return linienabstandZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandZoomverhalten(
			Zoomverhalten newLinienabstandZoomverhalten) {
		final Zoomverhalten oldLinienabstandZoomverhalten = linienabstandZoomverhalten;
		linienabstandZoomverhalten = newLinienabstandZoomverhalten == null
				? LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT
				: newLinienabstandZoomverhalten;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN,
					oldLinienabstandZoomverhalten, linienabstandZoomverhalten));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimaleZoomstufe(
			int newLinienabstandMinimaleZoomstufe) {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		linienabstandMinimaleZoomstufe = newLinienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					linienabstandMinimaleZoomstufe,
					!oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimaleZoomstufe() {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMinimaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximaleZoomstufe(
			int newLinienabstandMaximaleZoomstufe) {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		linienabstandMaximaleZoomstufe = newLinienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					linienabstandMaximaleZoomstufe,
					!oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximaleZoomstufe() {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMaximaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximum() {
		return linienabstandMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximum(int newLinienabstandMaximum) {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		linienabstandMaximum = newLinienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, linienabstandMaximum,
					!oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximum() {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;
		linienabstandMaximumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, LINIENABSTAND_MAXIMUM_EDEFAULT,
					oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximum() {
		return linienabstandMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimum() {
		return linienabstandMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimum(int newLinienabstandMinimum) {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		linienabstandMinimum = newLinienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, linienabstandMinimum,
					!oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimum() {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;
		linienabstandMinimumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, LINIENABSTAND_MINIMUM_EDEFAULT,
					oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimum() {
		return linienabstandMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstand() {
		return linienabstand;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstand(int newLinienabstand) {
		final int oldLinienabstand = linienabstand;
		linienabstand = newLinienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstandESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND,
					oldLinienabstand, linienabstand, !oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstand() {
		final int oldLinienabstand = linienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstand = LINIENABSTAND_EDEFAULT;
		linienabstandESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND,
					oldLinienabstand, LINIENABSTAND_EDEFAULT,
					oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstand() {
		return linienabstandESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return getLinienabstandZoomverhalten();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return getLinienabstandMinimaleZoomstufe();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return getLinienabstandMaximaleZoomstufe();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM:
			return getLinienabstandMaximum();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM:
			return getLinienabstandMinimum();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND:
			return getLinienabstand();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten((Zoomverhalten) newValue);
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			setLinienabstandMinimaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			setLinienabstandMaximaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM:
			setLinienabstandMaximum((Integer) newValue);
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM:
			setLinienabstandMinimum((Integer) newValue);
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND:
			setLinienabstand((Integer) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten(LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT);
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			unsetLinienabstandMinimaleZoomstufe();
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			unsetLinienabstandMaximaleZoomstufe();
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM:
			unsetLinienabstandMaximum();
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM:
			unsetLinienabstandMinimum();
			return;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND:
			unsetLinienabstand();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return linienabstandZoomverhalten != LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return isSetLinienabstandMinimaleZoomstufe();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return isSetLinienabstandMaximaleZoomstufe();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM:
			return isSetLinienabstandMaximum();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM:
			return isSetLinienabstandMinimum();
		case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND:
			return isSetLinienabstand();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID,
			Class<?> baseClass) {
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN;
			case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM;
			case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM;
			case NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID,
			Class<?> baseClass) {
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
				return NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
				return NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MAXIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
				return NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND_MINIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
				return NetzPackage.RDS_MELDUNG_DO_TYP__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (linienabstandZoomverhalten: ");
		result.append(linienabstandZoomverhalten);
		result.append(", linienabstandMinimaleZoomstufe: ");
		if (linienabstandMinimaleZoomstufeESet) {
			result.append(linienabstandMinimaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximaleZoomstufe: ");
		if (linienabstandMaximaleZoomstufeESet) {
			result.append(linienabstandMaximaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximum: ");
		if (linienabstandMaximumESet) {
			result.append(linienabstandMaximum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMinimum: ");
		if (linienabstandMinimumESet) {
			result.append(linienabstandMinimum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstand: ");
		if (linienabstandESet) {
			result.append(linienabstand);
		} else {
			result.append("<unset>");
		}
		result.append(')');
		return result.toString();
	}

} // RdsMeldungDoTypImpl
