/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipseFactory;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Stoerfall Indikator Do Typ</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getStoerungFarbe
 * <em>Stoerung Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getKeineAussageFarbe
 * <em>Keine Aussage Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getFreierVerkehrFarbe
 * <em>Freier Verkehr Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getLebhafterVerkehrFarbe
 * <em>Lebhafter Verkehr Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getDichterVerkehrFarbe
 * <em>Dichter Verkehr Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getZaehfliessenderVerkehrFarbe
 * <em>Zaehfliessender Verkehr Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getStockenderVerkehrFarbe
 * <em>Stockender Verkehr Farbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StoerfallIndikatorDoTypImpl#getStauFarbe
 * <em>Stau Farbe</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class StoerfallIndikatorDoTypImpl extends ConfiguratedDoTypImpl
		implements StoerfallIndikatorDoTyp {

	/**
	 * The default value of the '{@link #getStoerungFarbe() <em>Stoerung
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getStoerungFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB STOERUNG_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "255,255,255");
	/**
	 * The cached value of the '{@link #getStoerungFarbe() <em>Stoerung
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getStoerungFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB stoerungFarbe = STOERUNG_FARBE_EDEFAULT;
	/**
	 * This is true if the Stoerung Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean stoerungFarbeESet;
	/**
	 * The default value of the '{@link #getKeineAussageFarbe() <em>Keine
	 * Aussage Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getKeineAussageFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB KEINE_AUSSAGE_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "128,128,128");
	/**
	 * The cached value of the '{@link #getKeineAussageFarbe() <em>Keine Aussage
	 * Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getKeineAussageFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB keineAussageFarbe = KEINE_AUSSAGE_FARBE_EDEFAULT;
	/**
	 * This is true if the Keine Aussage Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean keineAussageFarbeESet;
	/**
	 * The default value of the '{@link #getFreierVerkehrFarbe() <em>Freier
	 * Verkehr Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getFreierVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB FREIER_VERKEHR_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "96,255,96");
	/**
	 * The cached value of the '{@link #getFreierVerkehrFarbe() <em>Freier
	 * Verkehr Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getFreierVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB freierVerkehrFarbe = FREIER_VERKEHR_FARBE_EDEFAULT;
	/**
	 * This is true if the Freier Verkehr Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean freierVerkehrFarbeESet;
	/**
	 * The default value of the '{@link #getLebhafterVerkehrFarbe()
	 * <em>Lebhafter Verkehr Farbe</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLebhafterVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB LEBHAFTER_VERKEHR_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "0,127,0");
	/**
	 * The cached value of the '{@link #getLebhafterVerkehrFarbe() <em>Lebhafter
	 * Verkehr Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getLebhafterVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB lebhafterVerkehrFarbe = LEBHAFTER_VERKEHR_FARBE_EDEFAULT;
	/**
	 * This is true if the Lebhafter Verkehr Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean lebhafterVerkehrFarbeESet;
	/**
	 * The default value of the '{@link #getDichterVerkehrFarbe() <em>Dichter
	 * Verkehr Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getDichterVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB DICHTER_VERKEHR_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "255,255,0");
	/**
	 * The cached value of the '{@link #getDichterVerkehrFarbe() <em>Dichter
	 * Verkehr Farbe</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @see #getDichterVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB dichterVerkehrFarbe = DICHTER_VERKEHR_FARBE_EDEFAULT;
	/**
	 * This is true if the Dichter Verkehr Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean dichterVerkehrFarbeESet;
	/**
	 * The default value of the '{@link #getZaehfliessenderVerkehrFarbe()
	 * <em>Zaehfliessender Verkehr Farbe</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getZaehfliessenderVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB ZAEHFLIESSENDER_VERKEHR_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "255,196,0");
	/**
	 * The cached value of the '{@link #getZaehfliessenderVerkehrFarbe()
	 * <em>Zaehfliessender Verkehr Farbe</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getZaehfliessenderVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB zaehfliessenderVerkehrFarbe = ZAEHFLIESSENDER_VERKEHR_FARBE_EDEFAULT;
	/**
	 * This is true if the Zaehfliessender Verkehr Farbe attribute has been set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean zaehfliessenderVerkehrFarbeESet;
	/**
	 * The default value of the '{@link #getStockenderVerkehrFarbe()
	 * <em>Stockender Verkehr Farbe</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getStockenderVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB STOCKENDER_VERKEHR_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "255,100,100");
	/**
	 * The cached value of the '{@link #getStockenderVerkehrFarbe()
	 * <em>Stockender Verkehr Farbe</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getStockenderVerkehrFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB stockenderVerkehrFarbe = STOCKENDER_VERKEHR_FARBE_EDEFAULT;
	/**
	 * This is true if the Stockender Verkehr Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean stockenderVerkehrFarbeESet;
	/**
	 * The default value of the '{@link #getStauFarbe() <em>Stau Farbe</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getStauFarbe()
	 * @generated
	 * @ordered
	 */
	protected static final RGB STAU_FARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "255,0,0");
	/**
	 * The cached value of the '{@link #getStauFarbe() <em>Stau Farbe</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getStauFarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB stauFarbe = STAU_FARBE_EDEFAULT;
	/**
	 * This is true if the Stau Farbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean stauFarbeESet;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StoerfallIndikatorDoTypImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NetzPackage.Literals.STOERFALL_INDIKATOR_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getStoerungFarbe() {
		return stoerungFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setStoerungFarbe(RGB newStoerungFarbe) {
		final RGB oldStoerungFarbe = stoerungFarbe;
		stoerungFarbe = newStoerungFarbe;
		final boolean oldStoerungFarbeESet = stoerungFarbeESet;
		stoerungFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE,
					oldStoerungFarbe, stoerungFarbe, !oldStoerungFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetStoerungFarbe() {
		final RGB oldStoerungFarbe = stoerungFarbe;
		final boolean oldStoerungFarbeESet = stoerungFarbeESet;
		stoerungFarbe = STOERUNG_FARBE_EDEFAULT;
		stoerungFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE,
					oldStoerungFarbe, STOERUNG_FARBE_EDEFAULT,
					oldStoerungFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetStoerungFarbe() {
		return stoerungFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getKeineAussageFarbe() {
		return keineAussageFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setKeineAussageFarbe(RGB newKeineAussageFarbe) {
		final RGB oldKeineAussageFarbe = keineAussageFarbe;
		keineAussageFarbe = newKeineAussageFarbe;
		final boolean oldKeineAussageFarbeESet = keineAussageFarbeESet;
		keineAussageFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE,
					oldKeineAussageFarbe, keineAussageFarbe,
					!oldKeineAussageFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetKeineAussageFarbe() {
		final RGB oldKeineAussageFarbe = keineAussageFarbe;
		final boolean oldKeineAussageFarbeESet = keineAussageFarbeESet;
		keineAussageFarbe = KEINE_AUSSAGE_FARBE_EDEFAULT;
		keineAussageFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE,
					oldKeineAussageFarbe, KEINE_AUSSAGE_FARBE_EDEFAULT,
					oldKeineAussageFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetKeineAussageFarbe() {
		return keineAussageFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getFreierVerkehrFarbe() {
		return freierVerkehrFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setFreierVerkehrFarbe(RGB newFreierVerkehrFarbe) {
		final RGB oldFreierVerkehrFarbe = freierVerkehrFarbe;
		freierVerkehrFarbe = newFreierVerkehrFarbe;
		final boolean oldFreierVerkehrFarbeESet = freierVerkehrFarbeESet;
		freierVerkehrFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE,
					oldFreierVerkehrFarbe, freierVerkehrFarbe,
					!oldFreierVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetFreierVerkehrFarbe() {
		final RGB oldFreierVerkehrFarbe = freierVerkehrFarbe;
		final boolean oldFreierVerkehrFarbeESet = freierVerkehrFarbeESet;
		freierVerkehrFarbe = FREIER_VERKEHR_FARBE_EDEFAULT;
		freierVerkehrFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE,
					oldFreierVerkehrFarbe, FREIER_VERKEHR_FARBE_EDEFAULT,
					oldFreierVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetFreierVerkehrFarbe() {
		return freierVerkehrFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getLebhafterVerkehrFarbe() {
		return lebhafterVerkehrFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLebhafterVerkehrFarbe(RGB newLebhafterVerkehrFarbe) {
		final RGB oldLebhafterVerkehrFarbe = lebhafterVerkehrFarbe;
		lebhafterVerkehrFarbe = newLebhafterVerkehrFarbe;
		final boolean oldLebhafterVerkehrFarbeESet = lebhafterVerkehrFarbeESet;
		lebhafterVerkehrFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE,
					oldLebhafterVerkehrFarbe, lebhafterVerkehrFarbe,
					!oldLebhafterVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLebhafterVerkehrFarbe() {
		final RGB oldLebhafterVerkehrFarbe = lebhafterVerkehrFarbe;
		final boolean oldLebhafterVerkehrFarbeESet = lebhafterVerkehrFarbeESet;
		lebhafterVerkehrFarbe = LEBHAFTER_VERKEHR_FARBE_EDEFAULT;
		lebhafterVerkehrFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE,
					oldLebhafterVerkehrFarbe, LEBHAFTER_VERKEHR_FARBE_EDEFAULT,
					oldLebhafterVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLebhafterVerkehrFarbe() {
		return lebhafterVerkehrFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getDichterVerkehrFarbe() {
		return dichterVerkehrFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setDichterVerkehrFarbe(RGB newDichterVerkehrFarbe) {
		final RGB oldDichterVerkehrFarbe = dichterVerkehrFarbe;
		dichterVerkehrFarbe = newDichterVerkehrFarbe;
		final boolean oldDichterVerkehrFarbeESet = dichterVerkehrFarbeESet;
		dichterVerkehrFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE,
					oldDichterVerkehrFarbe, dichterVerkehrFarbe,
					!oldDichterVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetDichterVerkehrFarbe() {
		final RGB oldDichterVerkehrFarbe = dichterVerkehrFarbe;
		final boolean oldDichterVerkehrFarbeESet = dichterVerkehrFarbeESet;
		dichterVerkehrFarbe = DICHTER_VERKEHR_FARBE_EDEFAULT;
		dichterVerkehrFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE,
					oldDichterVerkehrFarbe, DICHTER_VERKEHR_FARBE_EDEFAULT,
					oldDichterVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetDichterVerkehrFarbe() {
		return dichterVerkehrFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getZaehfliessenderVerkehrFarbe() {
		return zaehfliessenderVerkehrFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setZaehfliessenderVerkehrFarbe(
			RGB newZaehfliessenderVerkehrFarbe) {
		final RGB oldZaehfliessenderVerkehrFarbe = zaehfliessenderVerkehrFarbe;
		zaehfliessenderVerkehrFarbe = newZaehfliessenderVerkehrFarbe;
		final boolean oldZaehfliessenderVerkehrFarbeESet = zaehfliessenderVerkehrFarbeESet;
		zaehfliessenderVerkehrFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE,
					oldZaehfliessenderVerkehrFarbe, zaehfliessenderVerkehrFarbe,
					!oldZaehfliessenderVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetZaehfliessenderVerkehrFarbe() {
		final RGB oldZaehfliessenderVerkehrFarbe = zaehfliessenderVerkehrFarbe;
		final boolean oldZaehfliessenderVerkehrFarbeESet = zaehfliessenderVerkehrFarbeESet;
		zaehfliessenderVerkehrFarbe = ZAEHFLIESSENDER_VERKEHR_FARBE_EDEFAULT;
		zaehfliessenderVerkehrFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE,
					oldZaehfliessenderVerkehrFarbe,
					ZAEHFLIESSENDER_VERKEHR_FARBE_EDEFAULT,
					oldZaehfliessenderVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetZaehfliessenderVerkehrFarbe() {
		return zaehfliessenderVerkehrFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getStockenderVerkehrFarbe() {
		return stockenderVerkehrFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setStockenderVerkehrFarbe(RGB newStockenderVerkehrFarbe) {
		final RGB oldStockenderVerkehrFarbe = stockenderVerkehrFarbe;
		stockenderVerkehrFarbe = newStockenderVerkehrFarbe;
		final boolean oldStockenderVerkehrFarbeESet = stockenderVerkehrFarbeESet;
		stockenderVerkehrFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE,
					oldStockenderVerkehrFarbe, stockenderVerkehrFarbe,
					!oldStockenderVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetStockenderVerkehrFarbe() {
		final RGB oldStockenderVerkehrFarbe = stockenderVerkehrFarbe;
		final boolean oldStockenderVerkehrFarbeESet = stockenderVerkehrFarbeESet;
		stockenderVerkehrFarbe = STOCKENDER_VERKEHR_FARBE_EDEFAULT;
		stockenderVerkehrFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE,
					oldStockenderVerkehrFarbe,
					STOCKENDER_VERKEHR_FARBE_EDEFAULT,
					oldStockenderVerkehrFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetStockenderVerkehrFarbe() {
		return stockenderVerkehrFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getStauFarbe() {
		return stauFarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setStauFarbe(RGB newStauFarbe) {
		final RGB oldStauFarbe = stauFarbe;
		stauFarbe = newStauFarbe;
		final boolean oldStauFarbeESet = stauFarbeESet;
		stauFarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE,
					oldStauFarbe, stauFarbe, !oldStauFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetStauFarbe() {
		final RGB oldStauFarbe = stauFarbe;
		final boolean oldStauFarbeESet = stauFarbeESet;
		stauFarbe = STAU_FARBE_EDEFAULT;
		stauFarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE,
					oldStauFarbe, STAU_FARBE_EDEFAULT, oldStauFarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetStauFarbe() {
		return stauFarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE:
			return getStoerungFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE:
			return getKeineAussageFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE:
			return getFreierVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE:
			return getLebhafterVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE:
			return getDichterVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE:
			return getZaehfliessenderVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE:
			return getStockenderVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE:
			return getStauFarbe();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE:
			setStoerungFarbe((RGB) newValue);
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE:
			setKeineAussageFarbe((RGB) newValue);
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE:
			setFreierVerkehrFarbe((RGB) newValue);
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE:
			setLebhafterVerkehrFarbe((RGB) newValue);
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE:
			setDichterVerkehrFarbe((RGB) newValue);
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE:
			setZaehfliessenderVerkehrFarbe((RGB) newValue);
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE:
			setStockenderVerkehrFarbe((RGB) newValue);
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE:
			setStauFarbe((RGB) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE:
			unsetStoerungFarbe();
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE:
			unsetKeineAussageFarbe();
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE:
			unsetFreierVerkehrFarbe();
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE:
			unsetLebhafterVerkehrFarbe();
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE:
			unsetDichterVerkehrFarbe();
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE:
			unsetZaehfliessenderVerkehrFarbe();
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE:
			unsetStockenderVerkehrFarbe();
			return;
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE:
			unsetStauFarbe();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE:
			return isSetStoerungFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE:
			return isSetKeineAussageFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE:
			return isSetFreierVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE:
			return isSetLebhafterVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE:
			return isSetDichterVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE:
			return isSetZaehfliessenderVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE:
			return isSetStockenderVerkehrFarbe();
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE:
			return isSetStauFarbe();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID,
			Class<?> baseClass) {
		if (baseClass == StoerfallIndikatorDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__STOERUNG_FARBE;
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__KEINE_AUSSAGE_FARBE;
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__FREIER_VERKEHR_FARBE;
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__LEBHAFTER_VERKEHR_FARBE;
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__DICHTER_VERKEHR_FARBE;
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__ZAEHFLIESSENDER_VERKEHR_FARBE;
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__STOCKENDER_VERKEHR_FARBE;
			case NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE:
				return DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__STAU_FARBE;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID,
			Class<?> baseClass) {
		if (baseClass == StoerfallIndikatorDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__STOERUNG_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOERUNG_FARBE;
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__KEINE_AUSSAGE_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__KEINE_AUSSAGE_FARBE;
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__FREIER_VERKEHR_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__FREIER_VERKEHR_FARBE;
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__LEBHAFTER_VERKEHR_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__LEBHAFTER_VERKEHR_FARBE;
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__DICHTER_VERKEHR_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__DICHTER_VERKEHR_FARBE;
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__ZAEHFLIESSENDER_VERKEHR_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__ZAEHFLIESSENDER_VERKEHR_FARBE;
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__STOCKENDER_VERKEHR_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STOCKENDER_VERKEHR_FARBE;
			case DobjDecoratorPackage.STOERFALL_INDIKATOR_DECORATOR__STAU_FARBE:
				return NetzPackage.STOERFALL_INDIKATOR_DO_TYP__STAU_FARBE;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (stoerungFarbe: ");
		if (stoerungFarbeESet) {
			result.append(stoerungFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", keineAussageFarbe: ");
		if (keineAussageFarbeESet) {
			result.append(keineAussageFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", freierVerkehrFarbe: ");
		if (freierVerkehrFarbeESet) {
			result.append(freierVerkehrFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", lebhafterVerkehrFarbe: ");
		if (lebhafterVerkehrFarbeESet) {
			result.append(lebhafterVerkehrFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", dichterVerkehrFarbe: ");
		if (dichterVerkehrFarbeESet) {
			result.append(dichterVerkehrFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", zaehfliessenderVerkehrFarbe: ");
		if (zaehfliessenderVerkehrFarbeESet) {
			result.append(zaehfliessenderVerkehrFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", stockenderVerkehrFarbe: ");
		if (stockenderVerkehrFarbeESet) {
			result.append(stockenderVerkehrFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", stauFarbe: ");
		if (stauFarbeESet) {
			result.append(stauFarbe);
		} else {
			result.append("<unset>");
		}
		result.append(')');
		return result.toString();
	}

} // StoerfallIndikatorDoTypImpl
