/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipseFactory;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Strassen Segment Do Typ</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getVordergrundfarbe
 * <em>Vordergrundfarbe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeZoomverhalten
 * <em>Linienstaerke Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimaleZoomstufe
 * <em>Linienstaerke Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximaleZoomstufe
 * <em>Linienstaerke Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximum
 * <em>Linienstaerke Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimum
 * <em>Linienstaerke Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerke
 * <em>Linienstaerke</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandZoomverhalten
 * <em>Linienabstand Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandMinimaleZoomstufe
 * <em>Linienabstand Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandMaximaleZoomstufe
 * <em>Linienabstand Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandMaximum
 * <em>Linienabstand Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandMinimum
 * <em>Linienabstand Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstand
 * <em>Linienabstand</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#isDefaultDarstellungAutobahn
 * <em>Default Darstellung Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getVordergrundFarbeAutobahn
 * <em>Vordergrund Farbe Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeZoomverhaltenAutobahn
 * <em>Linienstaerke Zoomverhalten Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimaleZoomstufeAutobahn
 * <em>Linienstaerke Minimale Zoomstufe Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximaleZoomstufeAutobahn
 * <em>Linienstaerke Maximale Zoomstufe Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximumAutobahn
 * <em>Linienstaerke Maximum Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimumAutobahn
 * <em>Linienstaerke Minimum Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeAutobahn
 * <em>Linienstaerke Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandAutobahn
 * <em>Linienabstand Autobahn</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#isDefaultDarstellungBundesstrasse
 * <em>Default Darstellung Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getVordergrundFarbeBundesstrasse
 * <em>Vordergrund Farbe Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeZoomverhaltenBundesstrasse
 * <em>Linienstaerke Zoomverhalten Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimaleZoomstufeBundesstrasse
 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximaleZoomstufeBundesstrasse
 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximumBundesstrasse
 * <em>Linienstaerke Maximum Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimumBundesstrasse
 * <em>Linienstaerke Minimum Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeBundesstrasse
 * <em>Linienstaerke Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandBundesstrasse
 * <em>Linienabstand Bundesstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#isDefaultDarstellungLandstrasse
 * <em>Default Darstellung Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getVordergrundFarbeLandstrasse
 * <em>Vordergrund Farbe Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeZoomverhaltenLandstrasse
 * <em>Linienstaerke Zoomverhalten Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimaleZoomstufeLandstrasse
 * <em>Linienstaerke Minimale Zoomstufe Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximaleZoomstufeLandstrasse
 * <em>Linienstaerke Maximale Zoomstufe Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximumLandstrasse
 * <em>Linienstaerke Maximum Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimumLandstrasse
 * <em>Linienstaerke Minimum Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeLandstrasse
 * <em>Linienstaerke Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandLandstrasse
 * <em>Linienabstand Landstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getVordergrundFarbeKreisstrasse
 * <em>Vordergrund Farbe Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeZoomverhaltenKreisstrasse
 * <em>Linienstaerke Zoomverhalten Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimaleZoomstufeKreisstrasse
 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximaleZoomstufeKreisstrasse
 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMaximumKreisstrasse
 * <em>Linienstaerke Maximum Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeMinimumKreisstrasse
 * <em>Linienstaerke Minimum Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienstaerkeKreisstrasse
 * <em>Linienstaerke Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#getLinienabstandKreisstrasse
 * <em>Linienabstand Kreisstrasse</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentDoTypImpl#isDefaultDarstellungKreisstrasse
 * <em>Default Darstellung Kreisstrasse</em>}</li>
 * </ul>
 *
 * @generated
 */
public class StrassenSegmentDoTypImpl extends ConfiguratedDoTypImpl
		implements StrassenSegmentDoTyp {
	/**
	 * The default value of the '{@link #getVordergrundfarbe()
	 * <em>Vordergrundfarbe</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 *
	 * @see #getVordergrundfarbe()
	 * @generated NOT
	 * @ordered
	 */
	protected static final RGB VORDERGRUNDFARBE_EDEFAULT = (RGB) EclipseFactory.eINSTANCE
			.createFromString(EclipsePackage.eINSTANCE.getRGB(), "128,128,128");

	/**
	 * The cached value of the '{@link #getVordergrundfarbe()
	 * <em>Vordergrundfarbe</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getVordergrundfarbe()
	 * @generated
	 * @ordered
	 */
	protected RGB vordergrundfarbe = VORDERGRUNDFARBE_EDEFAULT;

	/**
	 * This is true if the Vordergrundfarbe attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean vordergrundfarbeESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeZoomverhalten()
	 * <em>Linienstaerke Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the '{@link #getLinienstaerkeZoomverhalten()
	 * <em>Linienstaerke Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienstaerkeZoomverhalten = LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimaleZoomstufe()
	 * <em>Linienstaerke Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimaleZoomstufe()
	 * <em>Linienstaerke Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimaleZoomstufe = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximaleZoomstufe()
	 * <em>Linienstaerke Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximaleZoomstufe()
	 * <em>Linienstaerke Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximaleZoomstufe = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximum()
	 * <em>Linienstaerke Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximum()
	 * <em>Linienstaerke Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximum = LINIENSTAERKE_MAXIMUM_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximumESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimum()
	 * <em>Linienstaerke Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimum()
	 * <em>Linienstaerke Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimum = LINIENSTAERKE_MINIMUM_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimumESet;

	/**
	 * The default value of the '{@link #getLinienstaerke()
	 * <em>Linienstaerke</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerke()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerke()
	 * <em>Linienstaerke</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerke()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerke = LINIENSTAERKE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeESet;

	/**
	 * The default value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienabstandZoomverhalten = LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienabstand Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;

	/**
	 * The cached value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;

	/**
	 * This is true if the Linienabstand Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximaleZoomstufeESet;

	/**
	 * The default value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;

	/**
	 * This is true if the Linienabstand Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximumESet;

	/**
	 * The default value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMUM_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;

	/**
	 * This is true if the Linienabstand Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimumESet;

	/**
	 * The default value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected int linienabstand = LINIENABSTAND_EDEFAULT;

	/**
	 * This is true if the Linienabstand attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandESet;

	/**
	 * The default value of the '{@link #isDefaultDarstellungAutobahn()
	 * <em>Default Darstellung Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isDefaultDarstellungAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DEFAULT_DARSTELLUNG_AUTOBAHN_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isDefaultDarstellungAutobahn()
	 * <em>Default Darstellung Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isDefaultDarstellungAutobahn()
	 * @generated
	 * @ordered
	 */
	protected boolean defaultDarstellungAutobahn = DEFAULT_DARSTELLUNG_AUTOBAHN_EDEFAULT;

	/**
	 * The default value of the '{@link #getVordergrundFarbeAutobahn()
	 * <em>Vordergrund Farbe Autobahn</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final RGB VORDERGRUND_FARBE_AUTOBAHN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVordergrundFarbeAutobahn()
	 * <em>Vordergrund Farbe Autobahn</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected RGB vordergrundFarbeAutobahn = VORDERGRUND_FARBE_AUTOBAHN_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinienstaerkeZoomverhaltenAutobahn()
	 * <em>Linienstaerke Zoomverhalten Autobahn</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeZoomverhaltenAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the '{@link #getLinienstaerkeZoomverhaltenAutobahn()
	 * <em>Linienstaerke Zoomverhalten Autobahn</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeZoomverhaltenAutobahn()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienstaerkeZoomverhaltenAutobahn = LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN_EDEFAULT;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeAutobahn() <em>Linienstaerke
	 * Minimale Zoomstufe Autobahn</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT = 1;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeAutobahn() <em>Linienstaerke
	 * Minimale Zoomstufe Autobahn</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimaleZoomstufeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimaleZoomstufeAutobahn = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimale Zoomstufe Autobahn attribute
	 * has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimaleZoomstufeAutobahnESet;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeAutobahn() <em>Linienstaerke
	 * Maximale Zoomstufe Autobahn</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT = 5000;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeAutobahn() <em>Linienstaerke
	 * Maximale Zoomstufe Autobahn</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximaleZoomstufeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximaleZoomstufeAutobahn = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximale Zoomstufe Autobahn attribute
	 * has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximaleZoomstufeAutobahnESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximumAutobahn()
	 * <em>Linienstaerke Maximum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximumAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMUM_AUTOBAHN_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximumAutobahn()
	 * <em>Linienstaerke Maximum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximumAutobahn()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximumAutobahn = LINIENSTAERKE_MAXIMUM_AUTOBAHN_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximum Autobahn attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximumAutobahnESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimumAutobahn()
	 * <em>Linienstaerke Minimum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimumAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMUM_AUTOBAHN_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimumAutobahn()
	 * <em>Linienstaerke Minimum Autobahn</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimumAutobahn()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimumAutobahn = LINIENSTAERKE_MINIMUM_AUTOBAHN_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimum Autobahn attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimumAutobahnESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeAutobahn()
	 * <em>Linienstaerke Autobahn</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_AUTOBAHN_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeAutobahn()
	 * <em>Linienstaerke Autobahn</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeAutobahn()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeAutobahn = LINIENSTAERKE_AUTOBAHN_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Autobahn attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeAutobahnESet;

	/**
	 * The default value of the '{@link #getLinienabstandAutobahn()
	 * <em>Linienabstand Autobahn</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandAutobahn()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_AUTOBAHN_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienabstandAutobahn()
	 * <em>Linienabstand Autobahn</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandAutobahn()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandAutobahn = LINIENABSTAND_AUTOBAHN_EDEFAULT;

	/**
	 * The default value of the '{@link #isDefaultDarstellungBundesstrasse()
	 * <em>Default Darstellung Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isDefaultDarstellungBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DEFAULT_DARSTELLUNG_BUNDESSTRASSE_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isDefaultDarstellungBundesstrasse()
	 * <em>Default Darstellung Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isDefaultDarstellungBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected boolean defaultDarstellungBundesstrasse = DEFAULT_DARSTELLUNG_BUNDESSTRASSE_EDEFAULT;

	/**
	 * The default value of the '{@link #getVordergrundFarbeBundesstrasse()
	 * <em>Vordergrund Farbe Bundesstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final RGB VORDERGRUND_FARBE_BUNDESSTRASSE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVordergrundFarbeBundesstrasse()
	 * <em>Vordergrund Farbe Bundesstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected RGB vordergrundFarbeBundesstrasse = VORDERGRUND_FARBE_BUNDESSTRASSE_EDEFAULT;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeZoomverhaltenBundesstrasse() <em>Linienstaerke
	 * Zoomverhalten Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhaltenBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeZoomverhaltenBundesstrasse() <em>Linienstaerke
	 * Zoomverhalten Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhaltenBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienstaerkeZoomverhaltenBundesstrasse = LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE_EDEFAULT;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * <em>Linienstaerke Minimale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimaleZoomstufeBundesstrasse = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimale Zoomstufe Bundesstrasse
	 * attribute has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimaleZoomstufeBundesstrasseESet;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT = 5000;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * <em>Linienstaerke Maximale Zoomstufe Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximaleZoomstufeBundesstrasse = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximale Zoomstufe Bundesstrasse
	 * attribute has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximaleZoomstufeBundesstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximumBundesstrasse()
	 * <em>Linienstaerke Maximum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximumBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximumBundesstrasse()
	 * <em>Linienstaerke Maximum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximumBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximumBundesstrasse = LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximum Bundesstrasse attribute has
	 * been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximumBundesstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimumBundesstrasse()
	 * <em>Linienstaerke Minimum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimumBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMUM_BUNDESSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimumBundesstrasse()
	 * <em>Linienstaerke Minimum Bundesstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimumBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimumBundesstrasse = LINIENSTAERKE_MINIMUM_BUNDESSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimum Bundesstrasse attribute has
	 * been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimumBundesstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeBundesstrasse()
	 * <em>Linienstaerke Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_BUNDESSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeBundesstrasse()
	 * <em>Linienstaerke Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeBundesstrasse = LINIENSTAERKE_BUNDESSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Bundesstrasse attribute has been set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeBundesstrasseESet;

	/**
	 * The default value of the '{@link #getLinienabstandBundesstrasse()
	 * <em>Linienabstand Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_BUNDESSTRASSE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienabstandBundesstrasse()
	 * <em>Linienabstand Bundesstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandBundesstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandBundesstrasse = LINIENABSTAND_BUNDESSTRASSE_EDEFAULT;

	/**
	 * The default value of the '{@link #isDefaultDarstellungLandstrasse()
	 * <em>Default Darstellung Landstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isDefaultDarstellungLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DEFAULT_DARSTELLUNG_LANDSTRASSE_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isDefaultDarstellungLandstrasse()
	 * <em>Default Darstellung Landstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #isDefaultDarstellungLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected boolean defaultDarstellungLandstrasse = DEFAULT_DARSTELLUNG_LANDSTRASSE_EDEFAULT;

	/**
	 * The default value of the '{@link #getVordergrundFarbeLandstrasse()
	 * <em>Vordergrund Farbe Landstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final RGB VORDERGRUND_FARBE_LANDSTRASSE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVordergrundFarbeLandstrasse()
	 * <em>Vordergrund Farbe Landstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected RGB vordergrundFarbeLandstrasse = VORDERGRUND_FARBE_LANDSTRASSE_EDEFAULT;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeZoomverhaltenLandstrasse() <em>Linienstaerke
	 * Zoomverhalten Landstrasse</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhaltenLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeZoomverhaltenLandstrasse() <em>Linienstaerke
	 * Zoomverhalten Landstrasse</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhaltenLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienstaerkeZoomverhaltenLandstrasse = LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE_EDEFAULT;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeLandstrasse() <em>Linienstaerke
	 * Minimale Zoomstufe Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeLandstrasse() <em>Linienstaerke
	 * Minimale Zoomstufe Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimaleZoomstufeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimaleZoomstufeLandstrasse = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimale Zoomstufe Landstrasse
	 * attribute has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimaleZoomstufeLandstrasseESet;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeLandstrasse() <em>Linienstaerke
	 * Maximale Zoomstufe Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT = 5000;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeLandstrasse() <em>Linienstaerke
	 * Maximale Zoomstufe Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximaleZoomstufeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximaleZoomstufeLandstrasse = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximale Zoomstufe Landstrasse
	 * attribute has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximaleZoomstufeLandstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximumLandstrasse()
	 * <em>Linienstaerke Maximum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximumLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMUM_LANDSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximumLandstrasse()
	 * <em>Linienstaerke Maximum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximumLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximumLandstrasse = LINIENSTAERKE_MAXIMUM_LANDSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximum Landstrasse attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximumLandstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimumLandstrasse()
	 * <em>Linienstaerke Minimum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimumLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMUM_LANDSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimumLandstrasse()
	 * <em>Linienstaerke Minimum Landstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimumLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimumLandstrasse = LINIENSTAERKE_MINIMUM_LANDSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimum Landstrasse attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimumLandstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeLandstrasse()
	 * <em>Linienstaerke Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_LANDSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeLandstrasse()
	 * <em>Linienstaerke Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeLandstrasse = LINIENSTAERKE_LANDSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Landstrasse attribute has been set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeLandstrasseESet;

	/**
	 * The default value of the '{@link #getLinienabstandLandstrasse()
	 * <em>Linienabstand Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_LANDSTRASSE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienabstandLandstrasse()
	 * <em>Linienabstand Landstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandLandstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandLandstrasse = LINIENABSTAND_LANDSTRASSE_EDEFAULT;

	/**
	 * The default value of the '{@link #getVordergrundFarbeKreisstrasse()
	 * <em>Vordergrund Farbe Kreisstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final RGB VORDERGRUND_FARBE_KREISSTRASSE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVordergrundFarbeKreisstrasse()
	 * <em>Vordergrund Farbe Kreisstrasse</em>}' attribute. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getVordergrundFarbeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected RGB vordergrundFarbeKreisstrasse = VORDERGRUND_FARBE_KREISSTRASSE_EDEFAULT;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeZoomverhaltenKreisstrasse() <em>Linienstaerke
	 * Zoomverhalten Kreisstrasse</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhaltenKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeZoomverhaltenKreisstrasse() <em>Linienstaerke
	 * Zoomverhalten Kreisstrasse</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhaltenKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienstaerkeZoomverhaltenKreisstrasse = LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE_EDEFAULT;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * <em>Linienstaerke Minimale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimaleZoomstufeKreisstrasse = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimale Zoomstufe Kreisstrasse
	 * attribute has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimaleZoomstufeKreisstrasseESet;

	/**
	 * The default value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT = 5000;

	/**
	 * The cached value of the
	 * '{@link #getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * <em>Linienstaerke Maximale Zoomstufe Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximaleZoomstufeKreisstrasse = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximale Zoomstufe Kreisstrasse
	 * attribute has been set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximaleZoomstufeKreisstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMaximumKreisstrasse()
	 * <em>Linienstaerke Maximum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximumKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMUM_KREISSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximumKreisstrasse()
	 * <em>Linienstaerke Maximum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximumKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximumKreisstrasse = LINIENSTAERKE_MAXIMUM_KREISSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Maximum Kreisstrasse attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximumKreisstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeMinimumKreisstrasse()
	 * <em>Linienstaerke Minimum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimumKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMUM_KREISSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimumKreisstrasse()
	 * <em>Linienstaerke Minimum Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimumKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimumKreisstrasse = LINIENSTAERKE_MINIMUM_KREISSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Minimum Kreisstrasse attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimumKreisstrasseESet;

	/**
	 * The default value of the '{@link #getLinienstaerkeKreisstrasse()
	 * <em>Linienstaerke Kreisstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_KREISSTRASSE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getLinienstaerkeKreisstrasse()
	 * <em>Linienstaerke Kreisstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeKreisstrasse = LINIENSTAERKE_KREISSTRASSE_EDEFAULT;

	/**
	 * This is true if the Linienstaerke Kreisstrasse attribute has been set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeKreisstrasseESet;

	/**
	 * The default value of the '{@link #getLinienabstandKreisstrasse()
	 * <em>Linienabstand Kreisstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_KREISSTRASSE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinienabstandKreisstrasse()
	 * <em>Linienabstand Kreisstrasse</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandKreisstrasse = LINIENABSTAND_KREISSTRASSE_EDEFAULT;

	/**
	 * The default value of the '{@link #isDefaultDarstellungKreisstrasse()
	 * <em>Default Darstellung Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isDefaultDarstellungKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DEFAULT_DARSTELLUNG_KREISSTRASSE_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isDefaultDarstellungKreisstrasse()
	 * <em>Default Darstellung Kreisstrasse</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #isDefaultDarstellungKreisstrasse()
	 * @generated
	 * @ordered
	 */
	protected boolean defaultDarstellungKreisstrasse = DEFAULT_DARSTELLUNG_KREISSTRASSE_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenSegmentDoTypImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getVordergrundfarbe() {
		return vordergrundfarbe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setVordergrundfarbe(RGB newVordergrundfarbe) {
		final RGB oldVordergrundfarbe = vordergrundfarbe;
		vordergrundfarbe = newVordergrundfarbe;
		final boolean oldVordergrundfarbeESet = vordergrundfarbeESet;
		vordergrundfarbeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE,
					oldVordergrundfarbe, vordergrundfarbe,
					!oldVordergrundfarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetVordergrundfarbe() {
		final RGB oldVordergrundfarbe = vordergrundfarbe;
		final boolean oldVordergrundfarbeESet = vordergrundfarbeESet;
		vordergrundfarbe = VORDERGRUNDFARBE_EDEFAULT;
		vordergrundfarbeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE,
					oldVordergrundfarbe, VORDERGRUNDFARBE_EDEFAULT,
					oldVordergrundfarbeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetVordergrundfarbe() {
		return vordergrundfarbeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerke() {
		return linienstaerke;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerke(int newLinienstaerke) {
		final int oldLinienstaerke = linienstaerke;
		linienstaerke = newLinienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerkeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE,
					oldLinienstaerke, linienstaerke, !oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerke() {
		final int oldLinienstaerke = linienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerke = LINIENSTAERKE_EDEFAULT;
		linienstaerkeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE,
					oldLinienstaerke, LINIENSTAERKE_EDEFAULT,
					oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerke() {
		return linienstaerkeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienabstandZoomverhalten() {
		return linienabstandZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandZoomverhalten(
			Zoomverhalten newLinienabstandZoomverhalten) {
		final Zoomverhalten oldLinienabstandZoomverhalten = linienabstandZoomverhalten;
		linienabstandZoomverhalten = newLinienabstandZoomverhalten == null
				? LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT
				: newLinienabstandZoomverhalten;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN,
					oldLinienabstandZoomverhalten, linienabstandZoomverhalten));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimaleZoomstufe(
			int newLinienabstandMinimaleZoomstufe) {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		linienabstandMinimaleZoomstufe = newLinienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					linienabstandMinimaleZoomstufe,
					!oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimaleZoomstufe() {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMinimaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximaleZoomstufe(
			int newLinienabstandMaximaleZoomstufe) {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		linienabstandMaximaleZoomstufe = newLinienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					linienabstandMaximaleZoomstufe,
					!oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximaleZoomstufe() {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMaximaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximum() {
		return linienabstandMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximum(int newLinienabstandMaximum) {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		linienabstandMaximum = newLinienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, linienabstandMaximum,
					!oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximum() {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;
		linienabstandMaximumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, LINIENABSTAND_MAXIMUM_EDEFAULT,
					oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximum() {
		return linienabstandMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimum() {
		return linienabstandMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimum(int newLinienabstandMinimum) {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		linienabstandMinimum = newLinienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, linienabstandMinimum,
					!oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimum() {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;
		linienabstandMinimumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, LINIENABSTAND_MINIMUM_EDEFAULT,
					oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimum() {
		return linienabstandMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstand() {
		return linienabstand;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstand(int newLinienabstand) {
		final int oldLinienabstand = linienabstand;
		linienabstand = newLinienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstandESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND,
					oldLinienabstand, linienabstand, !oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstand() {
		final int oldLinienabstand = linienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstand = LINIENABSTAND_EDEFAULT;
		linienabstandESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND,
					oldLinienabstand, LINIENABSTAND_EDEFAULT,
					oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstand() {
		return linienabstandESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienstaerkeZoomverhalten() {
		return linienstaerkeZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeZoomverhalten(
			Zoomverhalten newLinienstaerkeZoomverhalten) {
		final Zoomverhalten oldLinienstaerkeZoomverhalten = linienstaerkeZoomverhalten;
		linienstaerkeZoomverhalten = newLinienstaerkeZoomverhalten == null
				? LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT
				: newLinienstaerkeZoomverhalten;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN,
					oldLinienstaerkeZoomverhalten, linienstaerkeZoomverhalten));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimaleZoomstufe() {
		return linienstaerkeMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimaleZoomstufe(
			int newLinienstaerkeMinimaleZoomstufe) {
		final int oldLinienstaerkeMinimaleZoomstufe = linienstaerkeMinimaleZoomstufe;
		linienstaerkeMinimaleZoomstufe = newLinienstaerkeMinimaleZoomstufe;
		final boolean oldLinienstaerkeMinimaleZoomstufeESet = linienstaerkeMinimaleZoomstufeESet;
		linienstaerkeMinimaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
					oldLinienstaerkeMinimaleZoomstufe,
					linienstaerkeMinimaleZoomstufe,
					!oldLinienstaerkeMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimaleZoomstufe() {
		final int oldLinienstaerkeMinimaleZoomstufe = linienstaerkeMinimaleZoomstufe;
		final boolean oldLinienstaerkeMinimaleZoomstufeESet = linienstaerkeMinimaleZoomstufeESet;
		linienstaerkeMinimaleZoomstufe = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienstaerkeMinimaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
					oldLinienstaerkeMinimaleZoomstufe,
					LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienstaerkeMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimaleZoomstufe() {
		return linienstaerkeMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximaleZoomstufe() {
		return linienstaerkeMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximaleZoomstufe(
			int newLinienstaerkeMaximaleZoomstufe) {
		final int oldLinienstaerkeMaximaleZoomstufe = linienstaerkeMaximaleZoomstufe;
		linienstaerkeMaximaleZoomstufe = newLinienstaerkeMaximaleZoomstufe;
		final boolean oldLinienstaerkeMaximaleZoomstufeESet = linienstaerkeMaximaleZoomstufeESet;
		linienstaerkeMaximaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
					oldLinienstaerkeMaximaleZoomstufe,
					linienstaerkeMaximaleZoomstufe,
					!oldLinienstaerkeMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximaleZoomstufe() {
		final int oldLinienstaerkeMaximaleZoomstufe = linienstaerkeMaximaleZoomstufe;
		final boolean oldLinienstaerkeMaximaleZoomstufeESet = linienstaerkeMaximaleZoomstufeESet;
		linienstaerkeMaximaleZoomstufe = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienstaerkeMaximaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
					oldLinienstaerkeMaximaleZoomstufe,
					LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienstaerkeMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximaleZoomstufe() {
		return linienstaerkeMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximum() {
		return linienstaerkeMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximum(int newLinienstaerkeMaximum) {
		final int oldLinienstaerkeMaximum = linienstaerkeMaximum;
		linienstaerkeMaximum = newLinienstaerkeMaximum;
		final boolean oldLinienstaerkeMaximumESet = linienstaerkeMaximumESet;
		linienstaerkeMaximumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM,
					oldLinienstaerkeMaximum, linienstaerkeMaximum,
					!oldLinienstaerkeMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximum() {
		final int oldLinienstaerkeMaximum = linienstaerkeMaximum;
		final boolean oldLinienstaerkeMaximumESet = linienstaerkeMaximumESet;
		linienstaerkeMaximum = LINIENSTAERKE_MAXIMUM_EDEFAULT;
		linienstaerkeMaximumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM,
					oldLinienstaerkeMaximum, LINIENSTAERKE_MAXIMUM_EDEFAULT,
					oldLinienstaerkeMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximum() {
		return linienstaerkeMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimum() {
		return linienstaerkeMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimum(int newLinienstaerkeMinimum) {
		final int oldLinienstaerkeMinimum = linienstaerkeMinimum;
		linienstaerkeMinimum = newLinienstaerkeMinimum;
		final boolean oldLinienstaerkeMinimumESet = linienstaerkeMinimumESet;
		linienstaerkeMinimumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM,
					oldLinienstaerkeMinimum, linienstaerkeMinimum,
					!oldLinienstaerkeMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimum() {
		final int oldLinienstaerkeMinimum = linienstaerkeMinimum;
		final boolean oldLinienstaerkeMinimumESet = linienstaerkeMinimumESet;
		linienstaerkeMinimum = LINIENSTAERKE_MINIMUM_EDEFAULT;
		linienstaerkeMinimumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM,
					oldLinienstaerkeMinimum, LINIENSTAERKE_MINIMUM_EDEFAULT,
					oldLinienstaerkeMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimum() {
		return linienstaerkeMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isDefaultDarstellungAutobahn() {
		return defaultDarstellungAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setDefaultDarstellungAutobahn(
			boolean newDefaultDarstellungAutobahn) {
		final boolean oldDefaultDarstellungAutobahn = defaultDarstellungAutobahn;
		defaultDarstellungAutobahn = newDefaultDarstellungAutobahn;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN,
					oldDefaultDarstellungAutobahn, defaultDarstellungAutobahn));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getVordergrundFarbeAutobahn() {
		return vordergrundFarbeAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setVordergrundFarbeAutobahn(RGB newVordergrundFarbeAutobahn) {
		final RGB oldVordergrundFarbeAutobahn = vordergrundFarbeAutobahn;
		vordergrundFarbeAutobahn = newVordergrundFarbeAutobahn;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN,
					oldVordergrundFarbeAutobahn, vordergrundFarbeAutobahn));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienstaerkeZoomverhaltenAutobahn() {
		return linienstaerkeZoomverhaltenAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeZoomverhaltenAutobahn(
			Zoomverhalten newLinienstaerkeZoomverhaltenAutobahn) {
		final Zoomverhalten oldLinienstaerkeZoomverhaltenAutobahn = linienstaerkeZoomverhaltenAutobahn;
		linienstaerkeZoomverhaltenAutobahn = newLinienstaerkeZoomverhaltenAutobahn == null
				? LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN_EDEFAULT
				: newLinienstaerkeZoomverhaltenAutobahn;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN,
					oldLinienstaerkeZoomverhaltenAutobahn,
					linienstaerkeZoomverhaltenAutobahn));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimaleZoomstufeAutobahn() {
		return linienstaerkeMinimaleZoomstufeAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimaleZoomstufeAutobahn(
			int newLinienstaerkeMinimaleZoomstufeAutobahn) {
		final int oldLinienstaerkeMinimaleZoomstufeAutobahn = linienstaerkeMinimaleZoomstufeAutobahn;
		linienstaerkeMinimaleZoomstufeAutobahn = newLinienstaerkeMinimaleZoomstufeAutobahn;
		final boolean oldLinienstaerkeMinimaleZoomstufeAutobahnESet = linienstaerkeMinimaleZoomstufeAutobahnESet;
		linienstaerkeMinimaleZoomstufeAutobahnESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN,
					oldLinienstaerkeMinimaleZoomstufeAutobahn,
					linienstaerkeMinimaleZoomstufeAutobahn,
					!oldLinienstaerkeMinimaleZoomstufeAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimaleZoomstufeAutobahn() {
		final int oldLinienstaerkeMinimaleZoomstufeAutobahn = linienstaerkeMinimaleZoomstufeAutobahn;
		final boolean oldLinienstaerkeMinimaleZoomstufeAutobahnESet = linienstaerkeMinimaleZoomstufeAutobahnESet;
		linienstaerkeMinimaleZoomstufeAutobahn = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT;
		linienstaerkeMinimaleZoomstufeAutobahnESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN,
					oldLinienstaerkeMinimaleZoomstufeAutobahn,
					LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT,
					oldLinienstaerkeMinimaleZoomstufeAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimaleZoomstufeAutobahn() {
		return linienstaerkeMinimaleZoomstufeAutobahnESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximaleZoomstufeAutobahn() {
		return linienstaerkeMaximaleZoomstufeAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximaleZoomstufeAutobahn(
			int newLinienstaerkeMaximaleZoomstufeAutobahn) {
		final int oldLinienstaerkeMaximaleZoomstufeAutobahn = linienstaerkeMaximaleZoomstufeAutobahn;
		linienstaerkeMaximaleZoomstufeAutobahn = newLinienstaerkeMaximaleZoomstufeAutobahn;
		final boolean oldLinienstaerkeMaximaleZoomstufeAutobahnESet = linienstaerkeMaximaleZoomstufeAutobahnESet;
		linienstaerkeMaximaleZoomstufeAutobahnESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN,
					oldLinienstaerkeMaximaleZoomstufeAutobahn,
					linienstaerkeMaximaleZoomstufeAutobahn,
					!oldLinienstaerkeMaximaleZoomstufeAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximaleZoomstufeAutobahn() {
		final int oldLinienstaerkeMaximaleZoomstufeAutobahn = linienstaerkeMaximaleZoomstufeAutobahn;
		final boolean oldLinienstaerkeMaximaleZoomstufeAutobahnESet = linienstaerkeMaximaleZoomstufeAutobahnESet;
		linienstaerkeMaximaleZoomstufeAutobahn = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT;
		linienstaerkeMaximaleZoomstufeAutobahnESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN,
					oldLinienstaerkeMaximaleZoomstufeAutobahn,
					LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN_EDEFAULT,
					oldLinienstaerkeMaximaleZoomstufeAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximaleZoomstufeAutobahn() {
		return linienstaerkeMaximaleZoomstufeAutobahnESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximumAutobahn() {
		return linienstaerkeMaximumAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximumAutobahn(
			int newLinienstaerkeMaximumAutobahn) {
		final int oldLinienstaerkeMaximumAutobahn = linienstaerkeMaximumAutobahn;
		linienstaerkeMaximumAutobahn = newLinienstaerkeMaximumAutobahn;
		final boolean oldLinienstaerkeMaximumAutobahnESet = linienstaerkeMaximumAutobahnESet;
		linienstaerkeMaximumAutobahnESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN,
					oldLinienstaerkeMaximumAutobahn,
					linienstaerkeMaximumAutobahn,
					!oldLinienstaerkeMaximumAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximumAutobahn() {
		final int oldLinienstaerkeMaximumAutobahn = linienstaerkeMaximumAutobahn;
		final boolean oldLinienstaerkeMaximumAutobahnESet = linienstaerkeMaximumAutobahnESet;
		linienstaerkeMaximumAutobahn = LINIENSTAERKE_MAXIMUM_AUTOBAHN_EDEFAULT;
		linienstaerkeMaximumAutobahnESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN,
					oldLinienstaerkeMaximumAutobahn,
					LINIENSTAERKE_MAXIMUM_AUTOBAHN_EDEFAULT,
					oldLinienstaerkeMaximumAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximumAutobahn() {
		return linienstaerkeMaximumAutobahnESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimumAutobahn() {
		return linienstaerkeMinimumAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimumAutobahn(
			int newLinienstaerkeMinimumAutobahn) {
		final int oldLinienstaerkeMinimumAutobahn = linienstaerkeMinimumAutobahn;
		linienstaerkeMinimumAutobahn = newLinienstaerkeMinimumAutobahn;
		final boolean oldLinienstaerkeMinimumAutobahnESet = linienstaerkeMinimumAutobahnESet;
		linienstaerkeMinimumAutobahnESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN,
					oldLinienstaerkeMinimumAutobahn,
					linienstaerkeMinimumAutobahn,
					!oldLinienstaerkeMinimumAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimumAutobahn() {
		final int oldLinienstaerkeMinimumAutobahn = linienstaerkeMinimumAutobahn;
		final boolean oldLinienstaerkeMinimumAutobahnESet = linienstaerkeMinimumAutobahnESet;
		linienstaerkeMinimumAutobahn = LINIENSTAERKE_MINIMUM_AUTOBAHN_EDEFAULT;
		linienstaerkeMinimumAutobahnESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN,
					oldLinienstaerkeMinimumAutobahn,
					LINIENSTAERKE_MINIMUM_AUTOBAHN_EDEFAULT,
					oldLinienstaerkeMinimumAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimumAutobahn() {
		return linienstaerkeMinimumAutobahnESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeAutobahn() {
		return linienstaerkeAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeAutobahn(int newLinienstaerkeAutobahn) {
		final int oldLinienstaerkeAutobahn = linienstaerkeAutobahn;
		linienstaerkeAutobahn = newLinienstaerkeAutobahn;
		final boolean oldLinienstaerkeAutobahnESet = linienstaerkeAutobahnESet;
		linienstaerkeAutobahnESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN,
					oldLinienstaerkeAutobahn, linienstaerkeAutobahn,
					!oldLinienstaerkeAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeAutobahn() {
		final int oldLinienstaerkeAutobahn = linienstaerkeAutobahn;
		final boolean oldLinienstaerkeAutobahnESet = linienstaerkeAutobahnESet;
		linienstaerkeAutobahn = LINIENSTAERKE_AUTOBAHN_EDEFAULT;
		linienstaerkeAutobahnESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN,
					oldLinienstaerkeAutobahn, LINIENSTAERKE_AUTOBAHN_EDEFAULT,
					oldLinienstaerkeAutobahnESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeAutobahn() {
		return linienstaerkeAutobahnESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandAutobahn() {
		return linienabstandAutobahn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandAutobahn(int newLinienabstandAutobahn) {
		final int oldLinienabstandAutobahn = linienabstandAutobahn;
		linienabstandAutobahn = newLinienabstandAutobahn;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN,
					oldLinienabstandAutobahn, linienabstandAutobahn));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isDefaultDarstellungBundesstrasse() {
		return defaultDarstellungBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setDefaultDarstellungBundesstrasse(
			boolean newDefaultDarstellungBundesstrasse) {
		final boolean oldDefaultDarstellungBundesstrasse = defaultDarstellungBundesstrasse;
		defaultDarstellungBundesstrasse = newDefaultDarstellungBundesstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE,
					oldDefaultDarstellungBundesstrasse,
					defaultDarstellungBundesstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getVordergrundFarbeBundesstrasse() {
		return vordergrundFarbeBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setVordergrundFarbeBundesstrasse(
			RGB newVordergrundFarbeBundesstrasse) {
		final RGB oldVordergrundFarbeBundesstrasse = vordergrundFarbeBundesstrasse;
		vordergrundFarbeBundesstrasse = newVordergrundFarbeBundesstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE,
					oldVordergrundFarbeBundesstrasse,
					vordergrundFarbeBundesstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienstaerkeZoomverhaltenBundesstrasse() {
		return linienstaerkeZoomverhaltenBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeZoomverhaltenBundesstrasse(
			Zoomverhalten newLinienstaerkeZoomverhaltenBundesstrasse) {
		final Zoomverhalten oldLinienstaerkeZoomverhaltenBundesstrasse = linienstaerkeZoomverhaltenBundesstrasse;
		linienstaerkeZoomverhaltenBundesstrasse = newLinienstaerkeZoomverhaltenBundesstrasse == null
				? LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE_EDEFAULT
				: newLinienstaerkeZoomverhaltenBundesstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE,
					oldLinienstaerkeZoomverhaltenBundesstrasse,
					linienstaerkeZoomverhaltenBundesstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimaleZoomstufeBundesstrasse() {
		return linienstaerkeMinimaleZoomstufeBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimaleZoomstufeBundesstrasse(
			int newLinienstaerkeMinimaleZoomstufeBundesstrasse) {
		final int oldLinienstaerkeMinimaleZoomstufeBundesstrasse = linienstaerkeMinimaleZoomstufeBundesstrasse;
		linienstaerkeMinimaleZoomstufeBundesstrasse = newLinienstaerkeMinimaleZoomstufeBundesstrasse;
		final boolean oldLinienstaerkeMinimaleZoomstufeBundesstrasseESet = linienstaerkeMinimaleZoomstufeBundesstrasseESet;
		linienstaerkeMinimaleZoomstufeBundesstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE,
					oldLinienstaerkeMinimaleZoomstufeBundesstrasse,
					linienstaerkeMinimaleZoomstufeBundesstrasse,
					!oldLinienstaerkeMinimaleZoomstufeBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimaleZoomstufeBundesstrasse() {
		final int oldLinienstaerkeMinimaleZoomstufeBundesstrasse = linienstaerkeMinimaleZoomstufeBundesstrasse;
		final boolean oldLinienstaerkeMinimaleZoomstufeBundesstrasseESet = linienstaerkeMinimaleZoomstufeBundesstrasseESet;
		linienstaerkeMinimaleZoomstufeBundesstrasse = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT;
		linienstaerkeMinimaleZoomstufeBundesstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE,
					oldLinienstaerkeMinimaleZoomstufeBundesstrasse,
					LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT,
					oldLinienstaerkeMinimaleZoomstufeBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimaleZoomstufeBundesstrasse() {
		return linienstaerkeMinimaleZoomstufeBundesstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximaleZoomstufeBundesstrasse() {
		return linienstaerkeMaximaleZoomstufeBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximaleZoomstufeBundesstrasse(
			int newLinienstaerkeMaximaleZoomstufeBundesstrasse) {
		final int oldLinienstaerkeMaximaleZoomstufeBundesstrasse = linienstaerkeMaximaleZoomstufeBundesstrasse;
		linienstaerkeMaximaleZoomstufeBundesstrasse = newLinienstaerkeMaximaleZoomstufeBundesstrasse;
		final boolean oldLinienstaerkeMaximaleZoomstufeBundesstrasseESet = linienstaerkeMaximaleZoomstufeBundesstrasseESet;
		linienstaerkeMaximaleZoomstufeBundesstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE,
					oldLinienstaerkeMaximaleZoomstufeBundesstrasse,
					linienstaerkeMaximaleZoomstufeBundesstrasse,
					!oldLinienstaerkeMaximaleZoomstufeBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximaleZoomstufeBundesstrasse() {
		final int oldLinienstaerkeMaximaleZoomstufeBundesstrasse = linienstaerkeMaximaleZoomstufeBundesstrasse;
		final boolean oldLinienstaerkeMaximaleZoomstufeBundesstrasseESet = linienstaerkeMaximaleZoomstufeBundesstrasseESet;
		linienstaerkeMaximaleZoomstufeBundesstrasse = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT;
		linienstaerkeMaximaleZoomstufeBundesstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE,
					oldLinienstaerkeMaximaleZoomstufeBundesstrasse,
					LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE_EDEFAULT,
					oldLinienstaerkeMaximaleZoomstufeBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximaleZoomstufeBundesstrasse() {
		return linienstaerkeMaximaleZoomstufeBundesstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximumBundesstrasse() {
		return linienstaerkeMaximumBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximumBundesstrasse(
			int newLinienstaerkeMaximumBundesstrasse) {
		final int oldLinienstaerkeMaximumBundesstrasse = linienstaerkeMaximumBundesstrasse;
		linienstaerkeMaximumBundesstrasse = newLinienstaerkeMaximumBundesstrasse;
		final boolean oldLinienstaerkeMaximumBundesstrasseESet = linienstaerkeMaximumBundesstrasseESet;
		linienstaerkeMaximumBundesstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE,
					oldLinienstaerkeMaximumBundesstrasse,
					linienstaerkeMaximumBundesstrasse,
					!oldLinienstaerkeMaximumBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximumBundesstrasse() {
		final int oldLinienstaerkeMaximumBundesstrasse = linienstaerkeMaximumBundesstrasse;
		final boolean oldLinienstaerkeMaximumBundesstrasseESet = linienstaerkeMaximumBundesstrasseESet;
		linienstaerkeMaximumBundesstrasse = LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE_EDEFAULT;
		linienstaerkeMaximumBundesstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE,
					oldLinienstaerkeMaximumBundesstrasse,
					LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE_EDEFAULT,
					oldLinienstaerkeMaximumBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximumBundesstrasse() {
		return linienstaerkeMaximumBundesstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimumBundesstrasse() {
		return linienstaerkeMinimumBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimumBundesstrasse(
			int newLinienstaerkeMinimumBundesstrasse) {
		final int oldLinienstaerkeMinimumBundesstrasse = linienstaerkeMinimumBundesstrasse;
		linienstaerkeMinimumBundesstrasse = newLinienstaerkeMinimumBundesstrasse;
		final boolean oldLinienstaerkeMinimumBundesstrasseESet = linienstaerkeMinimumBundesstrasseESet;
		linienstaerkeMinimumBundesstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE,
					oldLinienstaerkeMinimumBundesstrasse,
					linienstaerkeMinimumBundesstrasse,
					!oldLinienstaerkeMinimumBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimumBundesstrasse() {
		final int oldLinienstaerkeMinimumBundesstrasse = linienstaerkeMinimumBundesstrasse;
		final boolean oldLinienstaerkeMinimumBundesstrasseESet = linienstaerkeMinimumBundesstrasseESet;
		linienstaerkeMinimumBundesstrasse = LINIENSTAERKE_MINIMUM_BUNDESSTRASSE_EDEFAULT;
		linienstaerkeMinimumBundesstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE,
					oldLinienstaerkeMinimumBundesstrasse,
					LINIENSTAERKE_MINIMUM_BUNDESSTRASSE_EDEFAULT,
					oldLinienstaerkeMinimumBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimumBundesstrasse() {
		return linienstaerkeMinimumBundesstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeBundesstrasse() {
		return linienstaerkeBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeBundesstrasse(
			int newLinienstaerkeBundesstrasse) {
		final int oldLinienstaerkeBundesstrasse = linienstaerkeBundesstrasse;
		linienstaerkeBundesstrasse = newLinienstaerkeBundesstrasse;
		final boolean oldLinienstaerkeBundesstrasseESet = linienstaerkeBundesstrasseESet;
		linienstaerkeBundesstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE,
					oldLinienstaerkeBundesstrasse, linienstaerkeBundesstrasse,
					!oldLinienstaerkeBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeBundesstrasse() {
		final int oldLinienstaerkeBundesstrasse = linienstaerkeBundesstrasse;
		final boolean oldLinienstaerkeBundesstrasseESet = linienstaerkeBundesstrasseESet;
		linienstaerkeBundesstrasse = LINIENSTAERKE_BUNDESSTRASSE_EDEFAULT;
		linienstaerkeBundesstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE,
					oldLinienstaerkeBundesstrasse,
					LINIENSTAERKE_BUNDESSTRASSE_EDEFAULT,
					oldLinienstaerkeBundesstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeBundesstrasse() {
		return linienstaerkeBundesstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandBundesstrasse() {
		return linienabstandBundesstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandBundesstrasse(
			int newLinienabstandBundesstrasse) {
		final int oldLinienabstandBundesstrasse = linienabstandBundesstrasse;
		linienabstandBundesstrasse = newLinienabstandBundesstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE,
					oldLinienabstandBundesstrasse, linienabstandBundesstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isDefaultDarstellungLandstrasse() {
		return defaultDarstellungLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setDefaultDarstellungLandstrasse(
			boolean newDefaultDarstellungLandstrasse) {
		final boolean oldDefaultDarstellungLandstrasse = defaultDarstellungLandstrasse;
		defaultDarstellungLandstrasse = newDefaultDarstellungLandstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE,
					oldDefaultDarstellungLandstrasse,
					defaultDarstellungLandstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getVordergrundFarbeLandstrasse() {
		return vordergrundFarbeLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setVordergrundFarbeLandstrasse(
			RGB newVordergrundFarbeLandstrasse) {
		final RGB oldVordergrundFarbeLandstrasse = vordergrundFarbeLandstrasse;
		vordergrundFarbeLandstrasse = newVordergrundFarbeLandstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE,
					oldVordergrundFarbeLandstrasse,
					vordergrundFarbeLandstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandLandstrasse() {
		return linienabstandLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandLandstrasse(int newLinienabstandLandstrasse) {
		final int oldLinienabstandLandstrasse = linienabstandLandstrasse;
		linienabstandLandstrasse = newLinienabstandLandstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE,
					oldLinienabstandLandstrasse, linienabstandLandstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienstaerkeZoomverhaltenLandstrasse() {
		return linienstaerkeZoomverhaltenLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeZoomverhaltenLandstrasse(
			Zoomverhalten newLinienstaerkeZoomverhaltenLandstrasse) {
		final Zoomverhalten oldLinienstaerkeZoomverhaltenLandstrasse = linienstaerkeZoomverhaltenLandstrasse;
		linienstaerkeZoomverhaltenLandstrasse = newLinienstaerkeZoomverhaltenLandstrasse == null
				? LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE_EDEFAULT
				: newLinienstaerkeZoomverhaltenLandstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE,
					oldLinienstaerkeZoomverhaltenLandstrasse,
					linienstaerkeZoomverhaltenLandstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimaleZoomstufeLandstrasse() {
		return linienstaerkeMinimaleZoomstufeLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimaleZoomstufeLandstrasse(
			int newLinienstaerkeMinimaleZoomstufeLandstrasse) {
		final int oldLinienstaerkeMinimaleZoomstufeLandstrasse = linienstaerkeMinimaleZoomstufeLandstrasse;
		linienstaerkeMinimaleZoomstufeLandstrasse = newLinienstaerkeMinimaleZoomstufeLandstrasse;
		final boolean oldLinienstaerkeMinimaleZoomstufeLandstrasseESet = linienstaerkeMinimaleZoomstufeLandstrasseESet;
		linienstaerkeMinimaleZoomstufeLandstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE,
					oldLinienstaerkeMinimaleZoomstufeLandstrasse,
					linienstaerkeMinimaleZoomstufeLandstrasse,
					!oldLinienstaerkeMinimaleZoomstufeLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimaleZoomstufeLandstrasse() {
		final int oldLinienstaerkeMinimaleZoomstufeLandstrasse = linienstaerkeMinimaleZoomstufeLandstrasse;
		final boolean oldLinienstaerkeMinimaleZoomstufeLandstrasseESet = linienstaerkeMinimaleZoomstufeLandstrasseESet;
		linienstaerkeMinimaleZoomstufeLandstrasse = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT;
		linienstaerkeMinimaleZoomstufeLandstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE,
					oldLinienstaerkeMinimaleZoomstufeLandstrasse,
					LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT,
					oldLinienstaerkeMinimaleZoomstufeLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimaleZoomstufeLandstrasse() {
		return linienstaerkeMinimaleZoomstufeLandstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximaleZoomstufeLandstrasse() {
		return linienstaerkeMaximaleZoomstufeLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximaleZoomstufeLandstrasse(
			int newLinienstaerkeMaximaleZoomstufeLandstrasse) {
		final int oldLinienstaerkeMaximaleZoomstufeLandstrasse = linienstaerkeMaximaleZoomstufeLandstrasse;
		linienstaerkeMaximaleZoomstufeLandstrasse = newLinienstaerkeMaximaleZoomstufeLandstrasse;
		final boolean oldLinienstaerkeMaximaleZoomstufeLandstrasseESet = linienstaerkeMaximaleZoomstufeLandstrasseESet;
		linienstaerkeMaximaleZoomstufeLandstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE,
					oldLinienstaerkeMaximaleZoomstufeLandstrasse,
					linienstaerkeMaximaleZoomstufeLandstrasse,
					!oldLinienstaerkeMaximaleZoomstufeLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximaleZoomstufeLandstrasse() {
		final int oldLinienstaerkeMaximaleZoomstufeLandstrasse = linienstaerkeMaximaleZoomstufeLandstrasse;
		final boolean oldLinienstaerkeMaximaleZoomstufeLandstrasseESet = linienstaerkeMaximaleZoomstufeLandstrasseESet;
		linienstaerkeMaximaleZoomstufeLandstrasse = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT;
		linienstaerkeMaximaleZoomstufeLandstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE,
					oldLinienstaerkeMaximaleZoomstufeLandstrasse,
					LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE_EDEFAULT,
					oldLinienstaerkeMaximaleZoomstufeLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximaleZoomstufeLandstrasse() {
		return linienstaerkeMaximaleZoomstufeLandstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximumLandstrasse() {
		return linienstaerkeMaximumLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximumLandstrasse(
			int newLinienstaerkeMaximumLandstrasse) {
		final int oldLinienstaerkeMaximumLandstrasse = linienstaerkeMaximumLandstrasse;
		linienstaerkeMaximumLandstrasse = newLinienstaerkeMaximumLandstrasse;
		final boolean oldLinienstaerkeMaximumLandstrasseESet = linienstaerkeMaximumLandstrasseESet;
		linienstaerkeMaximumLandstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE,
					oldLinienstaerkeMaximumLandstrasse,
					linienstaerkeMaximumLandstrasse,
					!oldLinienstaerkeMaximumLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximumLandstrasse() {
		final int oldLinienstaerkeMaximumLandstrasse = linienstaerkeMaximumLandstrasse;
		final boolean oldLinienstaerkeMaximumLandstrasseESet = linienstaerkeMaximumLandstrasseESet;
		linienstaerkeMaximumLandstrasse = LINIENSTAERKE_MAXIMUM_LANDSTRASSE_EDEFAULT;
		linienstaerkeMaximumLandstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE,
					oldLinienstaerkeMaximumLandstrasse,
					LINIENSTAERKE_MAXIMUM_LANDSTRASSE_EDEFAULT,
					oldLinienstaerkeMaximumLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximumLandstrasse() {
		return linienstaerkeMaximumLandstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimumLandstrasse() {
		return linienstaerkeMinimumLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimumLandstrasse(
			int newLinienstaerkeMinimumLandstrasse) {
		final int oldLinienstaerkeMinimumLandstrasse = linienstaerkeMinimumLandstrasse;
		linienstaerkeMinimumLandstrasse = newLinienstaerkeMinimumLandstrasse;
		final boolean oldLinienstaerkeMinimumLandstrasseESet = linienstaerkeMinimumLandstrasseESet;
		linienstaerkeMinimumLandstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE,
					oldLinienstaerkeMinimumLandstrasse,
					linienstaerkeMinimumLandstrasse,
					!oldLinienstaerkeMinimumLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimumLandstrasse() {
		final int oldLinienstaerkeMinimumLandstrasse = linienstaerkeMinimumLandstrasse;
		final boolean oldLinienstaerkeMinimumLandstrasseESet = linienstaerkeMinimumLandstrasseESet;
		linienstaerkeMinimumLandstrasse = LINIENSTAERKE_MINIMUM_LANDSTRASSE_EDEFAULT;
		linienstaerkeMinimumLandstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE,
					oldLinienstaerkeMinimumLandstrasse,
					LINIENSTAERKE_MINIMUM_LANDSTRASSE_EDEFAULT,
					oldLinienstaerkeMinimumLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimumLandstrasse() {
		return linienstaerkeMinimumLandstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeLandstrasse() {
		return linienstaerkeLandstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeLandstrasse(int newLinienstaerkeLandstrasse) {
		final int oldLinienstaerkeLandstrasse = linienstaerkeLandstrasse;
		linienstaerkeLandstrasse = newLinienstaerkeLandstrasse;
		final boolean oldLinienstaerkeLandstrasseESet = linienstaerkeLandstrasseESet;
		linienstaerkeLandstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE,
					oldLinienstaerkeLandstrasse, linienstaerkeLandstrasse,
					!oldLinienstaerkeLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeLandstrasse() {
		final int oldLinienstaerkeLandstrasse = linienstaerkeLandstrasse;
		final boolean oldLinienstaerkeLandstrasseESet = linienstaerkeLandstrasseESet;
		linienstaerkeLandstrasse = LINIENSTAERKE_LANDSTRASSE_EDEFAULT;
		linienstaerkeLandstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE,
					oldLinienstaerkeLandstrasse,
					LINIENSTAERKE_LANDSTRASSE_EDEFAULT,
					oldLinienstaerkeLandstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeLandstrasse() {
		return linienstaerkeLandstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public RGB getVordergrundFarbeKreisstrasse() {
		return vordergrundFarbeKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setVordergrundFarbeKreisstrasse(
			RGB newVordergrundFarbeKreisstrasse) {
		final RGB oldVordergrundFarbeKreisstrasse = vordergrundFarbeKreisstrasse;
		vordergrundFarbeKreisstrasse = newVordergrundFarbeKreisstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE,
					oldVordergrundFarbeKreisstrasse,
					vordergrundFarbeKreisstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienstaerkeZoomverhaltenKreisstrasse() {
		return linienstaerkeZoomverhaltenKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeZoomverhaltenKreisstrasse(
			Zoomverhalten newLinienstaerkeZoomverhaltenKreisstrasse) {
		final Zoomverhalten oldLinienstaerkeZoomverhaltenKreisstrasse = linienstaerkeZoomverhaltenKreisstrasse;
		linienstaerkeZoomverhaltenKreisstrasse = newLinienstaerkeZoomverhaltenKreisstrasse == null
				? LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE_EDEFAULT
				: newLinienstaerkeZoomverhaltenKreisstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE,
					oldLinienstaerkeZoomverhaltenKreisstrasse,
					linienstaerkeZoomverhaltenKreisstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimaleZoomstufeKreisstrasse() {
		return linienstaerkeMinimaleZoomstufeKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimaleZoomstufeKreisstrasse(
			int newLinienstaerkeMinimaleZoomstufeKreisstrasse) {
		final int oldLinienstaerkeMinimaleZoomstufeKreisstrasse = linienstaerkeMinimaleZoomstufeKreisstrasse;
		linienstaerkeMinimaleZoomstufeKreisstrasse = newLinienstaerkeMinimaleZoomstufeKreisstrasse;
		final boolean oldLinienstaerkeMinimaleZoomstufeKreisstrasseESet = linienstaerkeMinimaleZoomstufeKreisstrasseESet;
		linienstaerkeMinimaleZoomstufeKreisstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE,
					oldLinienstaerkeMinimaleZoomstufeKreisstrasse,
					linienstaerkeMinimaleZoomstufeKreisstrasse,
					!oldLinienstaerkeMinimaleZoomstufeKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimaleZoomstufeKreisstrasse() {
		final int oldLinienstaerkeMinimaleZoomstufeKreisstrasse = linienstaerkeMinimaleZoomstufeKreisstrasse;
		final boolean oldLinienstaerkeMinimaleZoomstufeKreisstrasseESet = linienstaerkeMinimaleZoomstufeKreisstrasseESet;
		linienstaerkeMinimaleZoomstufeKreisstrasse = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT;
		linienstaerkeMinimaleZoomstufeKreisstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE,
					oldLinienstaerkeMinimaleZoomstufeKreisstrasse,
					LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT,
					oldLinienstaerkeMinimaleZoomstufeKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimaleZoomstufeKreisstrasse() {
		return linienstaerkeMinimaleZoomstufeKreisstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximaleZoomstufeKreisstrasse() {
		return linienstaerkeMaximaleZoomstufeKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximaleZoomstufeKreisstrasse(
			int newLinienstaerkeMaximaleZoomstufeKreisstrasse) {
		final int oldLinienstaerkeMaximaleZoomstufeKreisstrasse = linienstaerkeMaximaleZoomstufeKreisstrasse;
		linienstaerkeMaximaleZoomstufeKreisstrasse = newLinienstaerkeMaximaleZoomstufeKreisstrasse;
		final boolean oldLinienstaerkeMaximaleZoomstufeKreisstrasseESet = linienstaerkeMaximaleZoomstufeKreisstrasseESet;
		linienstaerkeMaximaleZoomstufeKreisstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE,
					oldLinienstaerkeMaximaleZoomstufeKreisstrasse,
					linienstaerkeMaximaleZoomstufeKreisstrasse,
					!oldLinienstaerkeMaximaleZoomstufeKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximaleZoomstufeKreisstrasse() {
		final int oldLinienstaerkeMaximaleZoomstufeKreisstrasse = linienstaerkeMaximaleZoomstufeKreisstrasse;
		final boolean oldLinienstaerkeMaximaleZoomstufeKreisstrasseESet = linienstaerkeMaximaleZoomstufeKreisstrasseESet;
		linienstaerkeMaximaleZoomstufeKreisstrasse = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT;
		linienstaerkeMaximaleZoomstufeKreisstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE,
					oldLinienstaerkeMaximaleZoomstufeKreisstrasse,
					LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE_EDEFAULT,
					oldLinienstaerkeMaximaleZoomstufeKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximaleZoomstufeKreisstrasse() {
		return linienstaerkeMaximaleZoomstufeKreisstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximumKreisstrasse() {
		return linienstaerkeMaximumKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximumKreisstrasse(
			int newLinienstaerkeMaximumKreisstrasse) {
		final int oldLinienstaerkeMaximumKreisstrasse = linienstaerkeMaximumKreisstrasse;
		linienstaerkeMaximumKreisstrasse = newLinienstaerkeMaximumKreisstrasse;
		final boolean oldLinienstaerkeMaximumKreisstrasseESet = linienstaerkeMaximumKreisstrasseESet;
		linienstaerkeMaximumKreisstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE,
					oldLinienstaerkeMaximumKreisstrasse,
					linienstaerkeMaximumKreisstrasse,
					!oldLinienstaerkeMaximumKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximumKreisstrasse() {
		final int oldLinienstaerkeMaximumKreisstrasse = linienstaerkeMaximumKreisstrasse;
		final boolean oldLinienstaerkeMaximumKreisstrasseESet = linienstaerkeMaximumKreisstrasseESet;
		linienstaerkeMaximumKreisstrasse = LINIENSTAERKE_MAXIMUM_KREISSTRASSE_EDEFAULT;
		linienstaerkeMaximumKreisstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE,
					oldLinienstaerkeMaximumKreisstrasse,
					LINIENSTAERKE_MAXIMUM_KREISSTRASSE_EDEFAULT,
					oldLinienstaerkeMaximumKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximumKreisstrasse() {
		return linienstaerkeMaximumKreisstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimumKreisstrasse() {
		return linienstaerkeMinimumKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimumKreisstrasse(
			int newLinienstaerkeMinimumKreisstrasse) {
		final int oldLinienstaerkeMinimumKreisstrasse = linienstaerkeMinimumKreisstrasse;
		linienstaerkeMinimumKreisstrasse = newLinienstaerkeMinimumKreisstrasse;
		final boolean oldLinienstaerkeMinimumKreisstrasseESet = linienstaerkeMinimumKreisstrasseESet;
		linienstaerkeMinimumKreisstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE,
					oldLinienstaerkeMinimumKreisstrasse,
					linienstaerkeMinimumKreisstrasse,
					!oldLinienstaerkeMinimumKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimumKreisstrasse() {
		final int oldLinienstaerkeMinimumKreisstrasse = linienstaerkeMinimumKreisstrasse;
		final boolean oldLinienstaerkeMinimumKreisstrasseESet = linienstaerkeMinimumKreisstrasseESet;
		linienstaerkeMinimumKreisstrasse = LINIENSTAERKE_MINIMUM_KREISSTRASSE_EDEFAULT;
		linienstaerkeMinimumKreisstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE,
					oldLinienstaerkeMinimumKreisstrasse,
					LINIENSTAERKE_MINIMUM_KREISSTRASSE_EDEFAULT,
					oldLinienstaerkeMinimumKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimumKreisstrasse() {
		return linienstaerkeMinimumKreisstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeKreisstrasse() {
		return linienstaerkeKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeKreisstrasse(int newLinienstaerkeKreisstrasse) {
		final int oldLinienstaerkeKreisstrasse = linienstaerkeKreisstrasse;
		linienstaerkeKreisstrasse = newLinienstaerkeKreisstrasse;
		final boolean oldLinienstaerkeKreisstrasseESet = linienstaerkeKreisstrasseESet;
		linienstaerkeKreisstrasseESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE,
					oldLinienstaerkeKreisstrasse, linienstaerkeKreisstrasse,
					!oldLinienstaerkeKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeKreisstrasse() {
		final int oldLinienstaerkeKreisstrasse = linienstaerkeKreisstrasse;
		final boolean oldLinienstaerkeKreisstrasseESet = linienstaerkeKreisstrasseESet;
		linienstaerkeKreisstrasse = LINIENSTAERKE_KREISSTRASSE_EDEFAULT;
		linienstaerkeKreisstrasseESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE,
					oldLinienstaerkeKreisstrasse,
					LINIENSTAERKE_KREISSTRASSE_EDEFAULT,
					oldLinienstaerkeKreisstrasseESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeKreisstrasse() {
		return linienstaerkeKreisstrasseESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandKreisstrasse() {
		return linienabstandKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandKreisstrasse(int newLinienabstandKreisstrasse) {
		final int oldLinienabstandKreisstrasse = linienabstandKreisstrasse;
		linienabstandKreisstrasse = newLinienabstandKreisstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE,
					oldLinienabstandKreisstrasse, linienabstandKreisstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isDefaultDarstellungKreisstrasse() {
		return defaultDarstellungKreisstrasse;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setDefaultDarstellungKreisstrasse(
			boolean newDefaultDarstellungKreisstrasse) {
		final boolean oldDefaultDarstellungKreisstrasse = defaultDarstellungKreisstrasse;
		defaultDarstellungKreisstrasse = newDefaultDarstellungKreisstrasse;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE,
					oldDefaultDarstellungKreisstrasse,
					defaultDarstellungKreisstrasse));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE:
			return getVordergrundfarbe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			return getLinienstaerkeZoomverhalten();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			return getLinienstaerkeMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			return getLinienstaerkeMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM:
			return getLinienstaerkeMaximum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM:
			return getLinienstaerkeMinimum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE:
			return getLinienstaerke();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return getLinienabstandZoomverhalten();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return getLinienabstandMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return getLinienabstandMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM:
			return getLinienabstandMaximum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM:
			return getLinienabstandMinimum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND:
			return getLinienabstand();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN:
			return isDefaultDarstellungAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN:
			return getVordergrundFarbeAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN:
			return getLinienstaerkeZoomverhaltenAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN:
			return getLinienstaerkeMinimaleZoomstufeAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN:
			return getLinienstaerkeMaximaleZoomstufeAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN:
			return getLinienstaerkeMaximumAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN:
			return getLinienstaerkeMinimumAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN:
			return getLinienstaerkeAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN:
			return getLinienabstandAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE:
			return isDefaultDarstellungBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE:
			return getVordergrundFarbeBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE:
			return getLinienstaerkeZoomverhaltenBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			return getLinienstaerkeMinimaleZoomstufeBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			return getLinienstaerkeMaximaleZoomstufeBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE:
			return getLinienstaerkeMaximumBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE:
			return getLinienstaerkeMinimumBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE:
			return getLinienstaerkeBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE:
			return getLinienabstandBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE:
			return isDefaultDarstellungLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE:
			return getVordergrundFarbeLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE:
			return getLinienstaerkeZoomverhaltenLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE:
			return getLinienstaerkeMinimaleZoomstufeLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE:
			return getLinienstaerkeMaximaleZoomstufeLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE:
			return getLinienstaerkeMaximumLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE:
			return getLinienstaerkeMinimumLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE:
			return getLinienstaerkeLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE:
			return getLinienabstandLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE:
			return getVordergrundFarbeKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE:
			return getLinienstaerkeZoomverhaltenKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE:
			return getLinienstaerkeMinimaleZoomstufeKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE:
			return getLinienstaerkeMaximaleZoomstufeKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE:
			return getLinienstaerkeMaximumKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE:
			return getLinienstaerkeMinimumKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE:
			return getLinienstaerkeKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE:
			return getLinienabstandKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE:
			return isDefaultDarstellungKreisstrasse();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE:
			setVordergrundfarbe((RGB) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			setLinienstaerkeZoomverhalten((Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			setLinienstaerkeMinimaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			setLinienstaerkeMaximaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM:
			setLinienstaerkeMaximum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM:
			setLinienstaerkeMinimum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE:
			setLinienstaerke((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten((Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			setLinienabstandMinimaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			setLinienabstandMaximaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM:
			setLinienabstandMaximum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM:
			setLinienabstandMinimum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND:
			setLinienabstand((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN:
			setDefaultDarstellungAutobahn((Boolean) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN:
			setVordergrundFarbeAutobahn((RGB) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN:
			setLinienstaerkeZoomverhaltenAutobahn((Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN:
			setLinienstaerkeMinimaleZoomstufeAutobahn((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN:
			setLinienstaerkeMaximaleZoomstufeAutobahn((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN:
			setLinienstaerkeMaximumAutobahn((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN:
			setLinienstaerkeMinimumAutobahn((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN:
			setLinienstaerkeAutobahn((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN:
			setLinienabstandAutobahn((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE:
			setDefaultDarstellungBundesstrasse((Boolean) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE:
			setVordergrundFarbeBundesstrasse((RGB) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE:
			setLinienstaerkeZoomverhaltenBundesstrasse(
					(Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			setLinienstaerkeMinimaleZoomstufeBundesstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			setLinienstaerkeMaximaleZoomstufeBundesstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE:
			setLinienstaerkeMaximumBundesstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE:
			setLinienstaerkeMinimumBundesstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE:
			setLinienstaerkeBundesstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE:
			setLinienabstandBundesstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE:
			setDefaultDarstellungLandstrasse((Boolean) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE:
			setVordergrundFarbeLandstrasse((RGB) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE:
			setLinienstaerkeZoomverhaltenLandstrasse((Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE:
			setLinienstaerkeMinimaleZoomstufeLandstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE:
			setLinienstaerkeMaximaleZoomstufeLandstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE:
			setLinienstaerkeMaximumLandstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE:
			setLinienstaerkeMinimumLandstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE:
			setLinienstaerkeLandstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE:
			setLinienabstandLandstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE:
			setVordergrundFarbeKreisstrasse((RGB) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE:
			setLinienstaerkeZoomverhaltenKreisstrasse((Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE:
			setLinienstaerkeMinimaleZoomstufeKreisstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE:
			setLinienstaerkeMaximaleZoomstufeKreisstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE:
			setLinienstaerkeMaximumKreisstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE:
			setLinienstaerkeMinimumKreisstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE:
			setLinienstaerkeKreisstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE:
			setLinienabstandKreisstrasse((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE:
			setDefaultDarstellungKreisstrasse((Boolean) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE:
			unsetVordergrundfarbe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			setLinienstaerkeZoomverhalten(LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			unsetLinienstaerkeMinimaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			unsetLinienstaerkeMaximaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM:
			unsetLinienstaerkeMaximum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM:
			unsetLinienstaerkeMinimum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE:
			unsetLinienstaerke();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten(LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			unsetLinienabstandMinimaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			unsetLinienabstandMaximaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM:
			unsetLinienabstandMaximum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM:
			unsetLinienabstandMinimum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND:
			unsetLinienabstand();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN:
			setDefaultDarstellungAutobahn(
					DEFAULT_DARSTELLUNG_AUTOBAHN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN:
			setVordergrundFarbeAutobahn(VORDERGRUND_FARBE_AUTOBAHN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN:
			setLinienstaerkeZoomverhaltenAutobahn(
					LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN:
			unsetLinienstaerkeMinimaleZoomstufeAutobahn();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN:
			unsetLinienstaerkeMaximaleZoomstufeAutobahn();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN:
			unsetLinienstaerkeMaximumAutobahn();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN:
			unsetLinienstaerkeMinimumAutobahn();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN:
			unsetLinienstaerkeAutobahn();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN:
			setLinienabstandAutobahn(LINIENABSTAND_AUTOBAHN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE:
			setDefaultDarstellungBundesstrasse(
					DEFAULT_DARSTELLUNG_BUNDESSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE:
			setVordergrundFarbeBundesstrasse(
					VORDERGRUND_FARBE_BUNDESSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE:
			setLinienstaerkeZoomverhaltenBundesstrasse(
					LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			unsetLinienstaerkeMinimaleZoomstufeBundesstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			unsetLinienstaerkeMaximaleZoomstufeBundesstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE:
			unsetLinienstaerkeMaximumBundesstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE:
			unsetLinienstaerkeMinimumBundesstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE:
			unsetLinienstaerkeBundesstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE:
			setLinienabstandBundesstrasse(LINIENABSTAND_BUNDESSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE:
			setDefaultDarstellungLandstrasse(
					DEFAULT_DARSTELLUNG_LANDSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE:
			setVordergrundFarbeLandstrasse(
					VORDERGRUND_FARBE_LANDSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE:
			setLinienstaerkeZoomverhaltenLandstrasse(
					LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE:
			unsetLinienstaerkeMinimaleZoomstufeLandstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE:
			unsetLinienstaerkeMaximaleZoomstufeLandstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE:
			unsetLinienstaerkeMaximumLandstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE:
			unsetLinienstaerkeMinimumLandstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE:
			unsetLinienstaerkeLandstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE:
			setLinienabstandLandstrasse(LINIENABSTAND_LANDSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE:
			setVordergrundFarbeKreisstrasse(
					VORDERGRUND_FARBE_KREISSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE:
			setLinienstaerkeZoomverhaltenKreisstrasse(
					LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE:
			unsetLinienstaerkeMinimaleZoomstufeKreisstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE:
			unsetLinienstaerkeMaximaleZoomstufeKreisstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE:
			unsetLinienstaerkeMaximumKreisstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE:
			unsetLinienstaerkeMinimumKreisstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE:
			unsetLinienstaerkeKreisstrasse();
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE:
			setLinienabstandKreisstrasse(LINIENABSTAND_KREISSTRASSE_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE:
			setDefaultDarstellungKreisstrasse(
					DEFAULT_DARSTELLUNG_KREISSTRASSE_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE:
			return isSetVordergrundfarbe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			return linienstaerkeZoomverhalten != LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			return isSetLinienstaerkeMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			return isSetLinienstaerkeMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM:
			return isSetLinienstaerkeMaximum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM:
			return isSetLinienstaerkeMinimum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE:
			return isSetLinienstaerke();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return linienabstandZoomverhalten != LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return isSetLinienabstandMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return isSetLinienabstandMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM:
			return isSetLinienabstandMaximum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM:
			return isSetLinienabstandMinimum();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND:
			return isSetLinienabstand();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN:
			return defaultDarstellungAutobahn != DEFAULT_DARSTELLUNG_AUTOBAHN_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN:
			return VORDERGRUND_FARBE_AUTOBAHN_EDEFAULT == null
					? vordergrundFarbeAutobahn != null
					: !VORDERGRUND_FARBE_AUTOBAHN_EDEFAULT
							.equals(vordergrundFarbeAutobahn);
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN:
			return linienstaerkeZoomverhaltenAutobahn != LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN:
			return isSetLinienstaerkeMinimaleZoomstufeAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN:
			return isSetLinienstaerkeMaximaleZoomstufeAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN:
			return isSetLinienstaerkeMaximumAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN:
			return isSetLinienstaerkeMinimumAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN:
			return isSetLinienstaerkeAutobahn();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN:
			return linienabstandAutobahn != LINIENABSTAND_AUTOBAHN_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE:
			return defaultDarstellungBundesstrasse != DEFAULT_DARSTELLUNG_BUNDESSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE:
			return VORDERGRUND_FARBE_BUNDESSTRASSE_EDEFAULT == null
					? vordergrundFarbeBundesstrasse != null
					: !VORDERGRUND_FARBE_BUNDESSTRASSE_EDEFAULT
							.equals(vordergrundFarbeBundesstrasse);
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE:
			return linienstaerkeZoomverhaltenBundesstrasse != LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			return isSetLinienstaerkeMinimaleZoomstufeBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE:
			return isSetLinienstaerkeMaximaleZoomstufeBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE:
			return isSetLinienstaerkeMaximumBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE:
			return isSetLinienstaerkeMinimumBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE:
			return isSetLinienstaerkeBundesstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE:
			return linienabstandBundesstrasse != LINIENABSTAND_BUNDESSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE:
			return defaultDarstellungLandstrasse != DEFAULT_DARSTELLUNG_LANDSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE:
			return VORDERGRUND_FARBE_LANDSTRASSE_EDEFAULT == null
					? vordergrundFarbeLandstrasse != null
					: !VORDERGRUND_FARBE_LANDSTRASSE_EDEFAULT
							.equals(vordergrundFarbeLandstrasse);
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE:
			return linienstaerkeZoomverhaltenLandstrasse != LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE:
			return isSetLinienstaerkeMinimaleZoomstufeLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE:
			return isSetLinienstaerkeMaximaleZoomstufeLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE:
			return isSetLinienstaerkeMaximumLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE:
			return isSetLinienstaerkeMinimumLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE:
			return isSetLinienstaerkeLandstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE:
			return linienabstandLandstrasse != LINIENABSTAND_LANDSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE:
			return VORDERGRUND_FARBE_KREISSTRASSE_EDEFAULT == null
					? vordergrundFarbeKreisstrasse != null
					: !VORDERGRUND_FARBE_KREISSTRASSE_EDEFAULT
							.equals(vordergrundFarbeKreisstrasse);
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE:
			return linienstaerkeZoomverhaltenKreisstrasse != LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE:
			return isSetLinienstaerkeMinimaleZoomstufeKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE:
			return isSetLinienstaerkeMaximaleZoomstufeKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE:
			return isSetLinienstaerkeMaximumKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE:
			return isSetLinienstaerkeMinimumKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE:
			return isSetLinienstaerkeKreisstrasse();
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE:
			return linienabstandKreisstrasse != LINIENABSTAND_KREISSTRASSE_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE:
			return defaultDarstellungKreisstrasse != DEFAULT_DARSTELLUNG_KREISSTRASSE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID,
			Class<?> baseClass) {
		if (baseClass == VordergrundfarbeDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE:
				return DobjDecoratorPackage.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienstaerkeZoomDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM;
			case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID,
			Class<?> baseClass) {
		if (baseClass == VordergrundfarbeDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienstaerkeZoomDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
				return NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (vordergrundfarbe: ");
		if (vordergrundfarbeESet) {
			result.append(vordergrundfarbe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeZoomverhalten: ");
		result.append(linienstaerkeZoomverhalten);
		result.append(", linienstaerkeMinimaleZoomstufe: ");
		if (linienstaerkeMinimaleZoomstufeESet) {
			result.append(linienstaerkeMinimaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximaleZoomstufe: ");
		if (linienstaerkeMaximaleZoomstufeESet) {
			result.append(linienstaerkeMaximaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximum: ");
		if (linienstaerkeMaximumESet) {
			result.append(linienstaerkeMaximum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMinimum: ");
		if (linienstaerkeMinimumESet) {
			result.append(linienstaerkeMinimum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerke: ");
		if (linienstaerkeESet) {
			result.append(linienstaerke);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandZoomverhalten: ");
		result.append(linienabstandZoomverhalten);
		result.append(", linienabstandMinimaleZoomstufe: ");
		if (linienabstandMinimaleZoomstufeESet) {
			result.append(linienabstandMinimaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximaleZoomstufe: ");
		if (linienabstandMaximaleZoomstufeESet) {
			result.append(linienabstandMaximaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximum: ");
		if (linienabstandMaximumESet) {
			result.append(linienabstandMaximum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMinimum: ");
		if (linienabstandMinimumESet) {
			result.append(linienabstandMinimum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstand: ");
		if (linienabstandESet) {
			result.append(linienabstand);
		} else {
			result.append("<unset>");
		}
		result.append(", defaultDarstellungAutobahn: ");
		result.append(defaultDarstellungAutobahn);
		result.append(", vordergrundFarbeAutobahn: ");
		result.append(vordergrundFarbeAutobahn);
		result.append(", linienstaerkeZoomverhaltenAutobahn: ");
		result.append(linienstaerkeZoomverhaltenAutobahn);
		result.append(", linienstaerkeMinimaleZoomstufeAutobahn: ");
		if (linienstaerkeMinimaleZoomstufeAutobahnESet) {
			result.append(linienstaerkeMinimaleZoomstufeAutobahn);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximaleZoomstufeAutobahn: ");
		if (linienstaerkeMaximaleZoomstufeAutobahnESet) {
			result.append(linienstaerkeMaximaleZoomstufeAutobahn);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximumAutobahn: ");
		if (linienstaerkeMaximumAutobahnESet) {
			result.append(linienstaerkeMaximumAutobahn);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMinimumAutobahn: ");
		if (linienstaerkeMinimumAutobahnESet) {
			result.append(linienstaerkeMinimumAutobahn);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeAutobahn: ");
		if (linienstaerkeAutobahnESet) {
			result.append(linienstaerkeAutobahn);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandAutobahn: ");
		result.append(linienabstandAutobahn);
		result.append(", defaultDarstellungBundesstrasse: ");
		result.append(defaultDarstellungBundesstrasse);
		result.append(", vordergrundFarbeBundesstrasse: ");
		result.append(vordergrundFarbeBundesstrasse);
		result.append(", linienstaerkeZoomverhaltenBundesstrasse: ");
		result.append(linienstaerkeZoomverhaltenBundesstrasse);
		result.append(", linienstaerkeMinimaleZoomstufeBundesstrasse: ");
		if (linienstaerkeMinimaleZoomstufeBundesstrasseESet) {
			result.append(linienstaerkeMinimaleZoomstufeBundesstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximaleZoomstufeBundesstrasse: ");
		if (linienstaerkeMaximaleZoomstufeBundesstrasseESet) {
			result.append(linienstaerkeMaximaleZoomstufeBundesstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximumBundesstrasse: ");
		if (linienstaerkeMaximumBundesstrasseESet) {
			result.append(linienstaerkeMaximumBundesstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMinimumBundesstrasse: ");
		if (linienstaerkeMinimumBundesstrasseESet) {
			result.append(linienstaerkeMinimumBundesstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeBundesstrasse: ");
		if (linienstaerkeBundesstrasseESet) {
			result.append(linienstaerkeBundesstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandBundesstrasse: ");
		result.append(linienabstandBundesstrasse);
		result.append(", defaultDarstellungLandstrasse: ");
		result.append(defaultDarstellungLandstrasse);
		result.append(", vordergrundFarbeLandstrasse: ");
		result.append(vordergrundFarbeLandstrasse);
		result.append(", linienstaerkeZoomverhaltenLandstrasse: ");
		result.append(linienstaerkeZoomverhaltenLandstrasse);
		result.append(", linienstaerkeMinimaleZoomstufeLandstrasse: ");
		if (linienstaerkeMinimaleZoomstufeLandstrasseESet) {
			result.append(linienstaerkeMinimaleZoomstufeLandstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximaleZoomstufeLandstrasse: ");
		if (linienstaerkeMaximaleZoomstufeLandstrasseESet) {
			result.append(linienstaerkeMaximaleZoomstufeLandstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximumLandstrasse: ");
		if (linienstaerkeMaximumLandstrasseESet) {
			result.append(linienstaerkeMaximumLandstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMinimumLandstrasse: ");
		if (linienstaerkeMinimumLandstrasseESet) {
			result.append(linienstaerkeMinimumLandstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeLandstrasse: ");
		if (linienstaerkeLandstrasseESet) {
			result.append(linienstaerkeLandstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandLandstrasse: ");
		result.append(linienabstandLandstrasse);
		result.append(", vordergrundFarbeKreisstrasse: ");
		result.append(vordergrundFarbeKreisstrasse);
		result.append(", linienstaerkeZoomverhaltenKreisstrasse: ");
		result.append(linienstaerkeZoomverhaltenKreisstrasse);
		result.append(", linienstaerkeMinimaleZoomstufeKreisstrasse: ");
		if (linienstaerkeMinimaleZoomstufeKreisstrasseESet) {
			result.append(linienstaerkeMinimaleZoomstufeKreisstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximaleZoomstufeKreisstrasse: ");
		if (linienstaerkeMaximaleZoomstufeKreisstrasseESet) {
			result.append(linienstaerkeMaximaleZoomstufeKreisstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximumKreisstrasse: ");
		if (linienstaerkeMaximumKreisstrasseESet) {
			result.append(linienstaerkeMaximumKreisstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMinimumKreisstrasse: ");
		if (linienstaerkeMinimumKreisstrasseESet) {
			result.append(linienstaerkeMinimumKreisstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeKreisstrasse: ");
		if (linienstaerkeKreisstrasseESet) {
			result.append(linienstaerkeKreisstrasse);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandKreisstrasse: ");
		result.append(linienabstandKreisstrasse);
		result.append(", defaultDarstellungKreisstrasse: ");
		result.append(defaultDarstellungKreisstrasse);
		result.append(')');
		return result.toString();
	}

} // StrassenSegmentDoTypImpl
