/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Strassen Segment Stoerfall Indikator Do Typ</b></em>'. <!--
 * end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienstaerkeZoomverhalten
 * <em>Linienstaerke Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienstaerkeMinimaleZoomstufe
 * <em>Linienstaerke Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienstaerkeMaximaleZoomstufe
 * <em>Linienstaerke Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienstaerkeMaximum
 * <em>Linienstaerke Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienstaerkeMinimum
 * <em>Linienstaerke Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienstaerke
 * <em>Linienstaerke</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienabstandZoomverhalten
 * <em>Linienabstand Zoomverhalten</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienabstandMinimaleZoomstufe
 * <em>Linienabstand Minimale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienabstandMaximaleZoomstufe
 * <em>Linienabstand Maximale Zoomstufe</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienabstandMaximum
 * <em>Linienabstand Maximum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienabstandMinimum
 * <em>Linienabstand Minimum</em>}</li>
 * <li>{@link de.bsvrz.buv.plugin.netz.model.impl.StrassenSegmentStoerfallIndikatorDoTypImpl#getLinienabstand
 * <em>Linienabstand</em>}</li>
 * </ul>
 *
 * @generated
 */
public class StrassenSegmentStoerfallIndikatorDoTypImpl
		extends StoerfallIndikatorDoTypImpl
		implements StrassenSegmentStoerfallIndikatorDoTyp {
	/**
	 * The default value of the '{@link #getLinienstaerkeZoomverhalten()
	 * <em>Linienstaerke Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;
	/**
	 * The cached value of the '{@link #getLinienstaerkeZoomverhalten()
	 * <em>Linienstaerke Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienstaerkeZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienstaerkeZoomverhalten = LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT;
	/**
	 * The default value of the '{@link #getLinienstaerkeMinimaleZoomstufe()
	 * <em>Linienstaerke Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;
	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimaleZoomstufe()
	 * <em>Linienstaerke Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimaleZoomstufe = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT;
	/**
	 * This is true if the Linienstaerke Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimaleZoomstufeESet;
	/**
	 * The default value of the '{@link #getLinienstaerkeMaximaleZoomstufe()
	 * <em>Linienstaerke Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;
	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximaleZoomstufe()
	 * <em>Linienstaerke Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienstaerkeMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximaleZoomstufe = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT;
	/**
	 * This is true if the Linienstaerke Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximaleZoomstufeESet;
	/**
	 * The default value of the '{@link #getLinienstaerkeMaximum()
	 * <em>Linienstaerke Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MAXIMUM_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienstaerkeMaximum()
	 * <em>Linienstaerke Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMaximum = LINIENSTAERKE_MAXIMUM_EDEFAULT;
	/**
	 * This is true if the Linienstaerke Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMaximumESet;
	/**
	 * The default value of the '{@link #getLinienstaerkeMinimum()
	 * <em>Linienstaerke Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_MINIMUM_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienstaerkeMinimum()
	 * <em>Linienstaerke Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerkeMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerkeMinimum = LINIENSTAERKE_MINIMUM_EDEFAULT;
	/**
	 * This is true if the Linienstaerke Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeMinimumESet;
	/**
	 * The default value of the '{@link #getLinienstaerke()
	 * <em>Linienstaerke</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 *
	 * @see #getLinienstaerke()
	 * @generated NOT
	 * @ordered
	 */
	protected static final int LINIENSTAERKE_EDEFAULT = 3;
	/**
	 * The cached value of the '{@link #getLinienstaerke()
	 * <em>Linienstaerke</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienstaerke()
	 * @generated
	 * @ordered
	 */
	protected int linienstaerke = LINIENSTAERKE_EDEFAULT;
	/**
	 * This is true if the Linienstaerke attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienstaerkeESet;

	/**
	 * The default value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected static final Zoomverhalten LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT = Zoomverhalten.STATISCHES_ZOOMVERHALTEN;
	/**
	 * The cached value of the '{@link #getLinienabstandZoomverhalten()
	 * <em>Linienabstand Zoomverhalten</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getLinienabstandZoomverhalten()
	 * @generated
	 * @ordered
	 */
	protected Zoomverhalten linienabstandZoomverhalten = LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;
	/**
	 * The default value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT = 0;
	/**
	 * The cached value of the '{@link #getLinienabstandMinimaleZoomstufe()
	 * <em>Linienabstand Minimale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMinimaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;
	/**
	 * This is true if the Linienabstand Minimale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimaleZoomstufeESet;
	/**
	 * The default value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT = 5000;
	/**
	 * The cached value of the '{@link #getLinienabstandMaximaleZoomstufe()
	 * <em>Linienabstand Maximale Zoomstufe</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @see #getLinienabstandMaximaleZoomstufe()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;
	/**
	 * This is true if the Linienabstand Maximale Zoomstufe attribute has been
	 * set. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximaleZoomstufeESet;
	/**
	 * The default value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MAXIMUM_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienabstandMaximum()
	 * <em>Linienabstand Maximum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMaximum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;
	/**
	 * This is true if the Linienabstand Maximum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMaximumESet;
	/**
	 * The default value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected static final int LINIENABSTAND_MINIMUM_EDEFAULT = 1;
	/**
	 * The cached value of the '{@link #getLinienabstandMinimum()
	 * <em>Linienabstand Minimum</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstandMinimum()
	 * @generated
	 * @ordered
	 */
	protected int linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;
	/**
	 * This is true if the Linienabstand Minimum attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandMinimumESet;
	/**
	 * The default value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 *
	 * @see #getLinienabstand()
	 * @generated NOT
	 * @ordered
	 */
	protected static final int LINIENABSTAND_EDEFAULT = 5;
	/**
	 * The cached value of the '{@link #getLinienabstand()
	 * <em>Linienabstand</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getLinienabstand()
	 * @generated
	 * @ordered
	 */
	protected int linienabstand = LINIENABSTAND_EDEFAULT;
	/**
	 * This is true if the Linienabstand attribute has been set. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	protected boolean linienabstandESet;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenSegmentStoerfallIndikatorDoTypImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NetzPackage.Literals.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstand() {
		return linienabstand;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstand(int newLinienabstand) {
		final int oldLinienabstand = linienabstand;
		linienabstand = newLinienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstandESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND,
					oldLinienabstand, linienabstand, !oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstand() {
		final int oldLinienabstand = linienabstand;
		final boolean oldLinienabstandESet = linienabstandESet;
		linienabstand = LINIENABSTAND_EDEFAULT;
		linienabstandESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND,
					oldLinienabstand, LINIENABSTAND_EDEFAULT,
					oldLinienabstandESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstand() {
		return linienabstandESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienstaerkeZoomverhalten() {
		return linienstaerkeZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeZoomverhalten(
			Zoomverhalten newLinienstaerkeZoomverhalten) {
		final Zoomverhalten oldLinienstaerkeZoomverhalten = linienstaerkeZoomverhalten;
		linienstaerkeZoomverhalten = newLinienstaerkeZoomverhalten == null
				? LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT
				: newLinienstaerkeZoomverhalten;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN,
					oldLinienstaerkeZoomverhalten, linienstaerkeZoomverhalten));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimaleZoomstufe() {
		return linienstaerkeMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimaleZoomstufe(
			int newLinienstaerkeMinimaleZoomstufe) {
		final int oldLinienstaerkeMinimaleZoomstufe = linienstaerkeMinimaleZoomstufe;
		linienstaerkeMinimaleZoomstufe = newLinienstaerkeMinimaleZoomstufe;
		final boolean oldLinienstaerkeMinimaleZoomstufeESet = linienstaerkeMinimaleZoomstufeESet;
		linienstaerkeMinimaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
					oldLinienstaerkeMinimaleZoomstufe,
					linienstaerkeMinimaleZoomstufe,
					!oldLinienstaerkeMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimaleZoomstufe() {
		final int oldLinienstaerkeMinimaleZoomstufe = linienstaerkeMinimaleZoomstufe;
		final boolean oldLinienstaerkeMinimaleZoomstufeESet = linienstaerkeMinimaleZoomstufeESet;
		linienstaerkeMinimaleZoomstufe = LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienstaerkeMinimaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
					oldLinienstaerkeMinimaleZoomstufe,
					LINIENSTAERKE_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienstaerkeMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimaleZoomstufe() {
		return linienstaerkeMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximaleZoomstufe() {
		return linienstaerkeMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximaleZoomstufe(
			int newLinienstaerkeMaximaleZoomstufe) {
		final int oldLinienstaerkeMaximaleZoomstufe = linienstaerkeMaximaleZoomstufe;
		linienstaerkeMaximaleZoomstufe = newLinienstaerkeMaximaleZoomstufe;
		final boolean oldLinienstaerkeMaximaleZoomstufeESet = linienstaerkeMaximaleZoomstufeESet;
		linienstaerkeMaximaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
					oldLinienstaerkeMaximaleZoomstufe,
					linienstaerkeMaximaleZoomstufe,
					!oldLinienstaerkeMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximaleZoomstufe() {
		final int oldLinienstaerkeMaximaleZoomstufe = linienstaerkeMaximaleZoomstufe;
		final boolean oldLinienstaerkeMaximaleZoomstufeESet = linienstaerkeMaximaleZoomstufeESet;
		linienstaerkeMaximaleZoomstufe = LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienstaerkeMaximaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
					oldLinienstaerkeMaximaleZoomstufe,
					LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienstaerkeMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximaleZoomstufe() {
		return linienstaerkeMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMaximum() {
		return linienstaerkeMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMaximum(int newLinienstaerkeMaximum) {
		final int oldLinienstaerkeMaximum = linienstaerkeMaximum;
		linienstaerkeMaximum = newLinienstaerkeMaximum;
		final boolean oldLinienstaerkeMaximumESet = linienstaerkeMaximumESet;
		linienstaerkeMaximumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM,
					oldLinienstaerkeMaximum, linienstaerkeMaximum,
					!oldLinienstaerkeMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMaximum() {
		final int oldLinienstaerkeMaximum = linienstaerkeMaximum;
		final boolean oldLinienstaerkeMaximumESet = linienstaerkeMaximumESet;
		linienstaerkeMaximum = LINIENSTAERKE_MAXIMUM_EDEFAULT;
		linienstaerkeMaximumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM,
					oldLinienstaerkeMaximum, LINIENSTAERKE_MAXIMUM_EDEFAULT,
					oldLinienstaerkeMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMaximum() {
		return linienstaerkeMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerkeMinimum() {
		return linienstaerkeMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerkeMinimum(int newLinienstaerkeMinimum) {
		final int oldLinienstaerkeMinimum = linienstaerkeMinimum;
		linienstaerkeMinimum = newLinienstaerkeMinimum;
		final boolean oldLinienstaerkeMinimumESet = linienstaerkeMinimumESet;
		linienstaerkeMinimumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM,
					oldLinienstaerkeMinimum, linienstaerkeMinimum,
					!oldLinienstaerkeMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerkeMinimum() {
		final int oldLinienstaerkeMinimum = linienstaerkeMinimum;
		final boolean oldLinienstaerkeMinimumESet = linienstaerkeMinimumESet;
		linienstaerkeMinimum = LINIENSTAERKE_MINIMUM_EDEFAULT;
		linienstaerkeMinimumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM,
					oldLinienstaerkeMinimum, LINIENSTAERKE_MINIMUM_EDEFAULT,
					oldLinienstaerkeMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerkeMinimum() {
		return linienstaerkeMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienstaerke() {
		return linienstaerke;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienstaerke(int newLinienstaerke) {
		final int oldLinienstaerke = linienstaerke;
		linienstaerke = newLinienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerkeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE,
					oldLinienstaerke, linienstaerke, !oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienstaerke() {
		final int oldLinienstaerke = linienstaerke;
		final boolean oldLinienstaerkeESet = linienstaerkeESet;
		linienstaerke = LINIENSTAERKE_EDEFAULT;
		linienstaerkeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE,
					oldLinienstaerke, LINIENSTAERKE_EDEFAULT,
					oldLinienstaerkeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienstaerke() {
		return linienstaerkeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Zoomverhalten getLinienabstandZoomverhalten() {
		return linienabstandZoomverhalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandZoomverhalten(
			Zoomverhalten newLinienabstandZoomverhalten) {
		final Zoomverhalten oldLinienabstandZoomverhalten = linienabstandZoomverhalten;
		linienabstandZoomverhalten = newLinienabstandZoomverhalten == null
				? LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT
				: newLinienabstandZoomverhalten;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN,
					oldLinienabstandZoomverhalten, linienabstandZoomverhalten));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimaleZoomstufe(
			int newLinienabstandMinimaleZoomstufe) {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		linienabstandMinimaleZoomstufe = newLinienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					linienabstandMinimaleZoomstufe,
					!oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimaleZoomstufe() {
		final int oldLinienabstandMinimaleZoomstufe = linienabstandMinimaleZoomstufe;
		final boolean oldLinienabstandMinimaleZoomstufeESet = linienabstandMinimaleZoomstufeESet;
		linienabstandMinimaleZoomstufe = LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMinimaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
					oldLinienabstandMinimaleZoomstufe,
					LINIENABSTAND_MINIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMinimaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimaleZoomstufe() {
		return linienabstandMinimaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximaleZoomstufe(
			int newLinienabstandMaximaleZoomstufe) {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		linienabstandMaximaleZoomstufe = newLinienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufeESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					linienabstandMaximaleZoomstufe,
					!oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximaleZoomstufe() {
		final int oldLinienabstandMaximaleZoomstufe = linienabstandMaximaleZoomstufe;
		final boolean oldLinienabstandMaximaleZoomstufeESet = linienabstandMaximaleZoomstufeESet;
		linienabstandMaximaleZoomstufe = LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT;
		linienabstandMaximaleZoomstufeESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
					oldLinienabstandMaximaleZoomstufe,
					LINIENABSTAND_MAXIMALE_ZOOMSTUFE_EDEFAULT,
					oldLinienabstandMaximaleZoomstufeESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximaleZoomstufe() {
		return linienabstandMaximaleZoomstufeESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMaximum() {
		return linienabstandMaximum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMaximum(int newLinienabstandMaximum) {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		linienabstandMaximum = newLinienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, linienabstandMaximum,
					!oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMaximum() {
		final int oldLinienabstandMaximum = linienabstandMaximum;
		final boolean oldLinienabstandMaximumESet = linienabstandMaximumESet;
		linienabstandMaximum = LINIENABSTAND_MAXIMUM_EDEFAULT;
		linienabstandMaximumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM,
					oldLinienabstandMaximum, LINIENABSTAND_MAXIMUM_EDEFAULT,
					oldLinienabstandMaximumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMaximum() {
		return linienabstandMaximumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int getLinienabstandMinimum() {
		return linienabstandMinimum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLinienabstandMinimum(int newLinienabstandMinimum) {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		linienabstandMinimum = newLinienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimumESet = true;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, linienabstandMinimum,
					!oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void unsetLinienabstandMinimum() {
		final int oldLinienabstandMinimum = linienabstandMinimum;
		final boolean oldLinienabstandMinimumESet = linienabstandMinimumESet;
		linienabstandMinimum = LINIENABSTAND_MINIMUM_EDEFAULT;
		linienabstandMinimumESet = false;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM,
					oldLinienabstandMinimum, LINIENABSTAND_MINIMUM_EDEFAULT,
					oldLinienabstandMinimumESet));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isSetLinienabstandMinimum() {
		return linienabstandMinimumESet;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			return getLinienstaerkeZoomverhalten();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			return getLinienstaerkeMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			return getLinienstaerkeMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM:
			return getLinienstaerkeMaximum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM:
			return getLinienstaerkeMinimum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE:
			return getLinienstaerke();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return getLinienabstandZoomverhalten();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return getLinienabstandMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return getLinienabstandMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM:
			return getLinienabstandMaximum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM:
			return getLinienabstandMinimum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND:
			return getLinienabstand();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			setLinienstaerkeZoomverhalten((Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			setLinienstaerkeMinimaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			setLinienstaerkeMaximaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM:
			setLinienstaerkeMaximum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM:
			setLinienstaerkeMinimum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE:
			setLinienstaerke((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten((Zoomverhalten) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			setLinienabstandMinimaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			setLinienabstandMaximaleZoomstufe((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM:
			setLinienabstandMaximum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM:
			setLinienabstandMinimum((Integer) newValue);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND:
			setLinienabstand((Integer) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			setLinienstaerkeZoomverhalten(LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			unsetLinienstaerkeMinimaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			unsetLinienstaerkeMaximaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM:
			unsetLinienstaerkeMaximum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM:
			unsetLinienstaerkeMinimum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE:
			unsetLinienstaerke();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			setLinienabstandZoomverhalten(LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT);
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			unsetLinienabstandMinimaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			unsetLinienabstandMaximaleZoomstufe();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM:
			unsetLinienabstandMaximum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM:
			unsetLinienabstandMinimum();
			return;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND:
			unsetLinienabstand();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
			return linienstaerkeZoomverhalten != LINIENSTAERKE_ZOOMVERHALTEN_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
			return isSetLinienstaerkeMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
			return isSetLinienstaerkeMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM:
			return isSetLinienstaerkeMaximum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM:
			return isSetLinienstaerkeMinimum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE:
			return isSetLinienstaerke();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
			return linienabstandZoomverhalten != LINIENABSTAND_ZOOMVERHALTEN_EDEFAULT;
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
			return isSetLinienabstandMinimaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
			return isSetLinienabstandMaximaleZoomstufe();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM:
			return isSetLinienabstandMaximum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM:
			return isSetLinienabstandMinimum();
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND:
			return isSetLinienabstand();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID,
			Class<?> baseClass) {
		if (baseClass == LinienstaerkeZoomDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE:
				return DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (derivedFeatureID) {
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM;
			case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND:
				return DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID,
			Class<?> baseClass) {
		if (baseClass == LinienstaerkeZoomDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MAXIMUM;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE_MINIMUM;
			case DobjDecoratorPackage.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENSTAERKE;
			default:
				return -1;
			}
		}
		if (baseClass == LinienabstandZoomDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MAXIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND_MINIMUM;
			case DobjDecoratorPackage.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND:
				return NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP__LINIENABSTAND;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		final StringBuilder result = new StringBuilder(super.toString());
		result.append(" (linienstaerkeZoomverhalten: ");
		result.append(linienstaerkeZoomverhalten);
		result.append(", linienstaerkeMinimaleZoomstufe: ");
		if (linienstaerkeMinimaleZoomstufeESet) {
			result.append(linienstaerkeMinimaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximaleZoomstufe: ");
		if (linienstaerkeMaximaleZoomstufeESet) {
			result.append(linienstaerkeMaximaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMaximum: ");
		if (linienstaerkeMaximumESet) {
			result.append(linienstaerkeMaximum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerkeMinimum: ");
		if (linienstaerkeMinimumESet) {
			result.append(linienstaerkeMinimum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienstaerke: ");
		if (linienstaerkeESet) {
			result.append(linienstaerke);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandZoomverhalten: ");
		result.append(linienabstandZoomverhalten);
		result.append(", linienabstandMinimaleZoomstufe: ");
		if (linienabstandMinimaleZoomstufeESet) {
			result.append(linienabstandMinimaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximaleZoomstufe: ");
		if (linienabstandMaximaleZoomstufeESet) {
			result.append(linienabstandMaximaleZoomstufe);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMaximum: ");
		if (linienabstandMaximumESet) {
			result.append(linienabstandMaximum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstandMinimum: ");
		if (linienabstandMinimumESet) {
			result.append(linienabstandMinimum);
		} else {
			result.append("<unset>");
		}
		result.append(", linienabstand: ");
		if (linienabstandESet) {
			result.append(linienabstand);
		} else {
			result.append("<unset>");
		}
		result.append(')');
		return result.toString();
	}

} // StrassenSegmentStoerfallIndikatorDoTypImpl
