/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.bsvrz.buv.plugin.netz.model.util.NetzAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support
 * Viewers. The adapters generated by this factory convert EMF adapter
 * notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The
 * adapters also support Eclipse property sheets. Note that most of the adapters
 * are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class NetzItemProviderAdapterFactory extends NetzAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this
	 * adapter factory. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement
	 * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by
	 * {@link #isFactoryForType isFactoryForType}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<>();

	/**
	 * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 */
	public NetzItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected FahrStreifenStoerfallIndikatorDoTypItemProvider fahrStreifenStoerfallIndikatorDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFahrStreifenStoerfallIndikatorDoTypAdapter() {
		if (fahrStreifenStoerfallIndikatorDoTypItemProvider == null) {
			fahrStreifenStoerfallIndikatorDoTypItemProvider = new FahrStreifenStoerfallIndikatorDoTypItemProvider(
					this);
		}

		return fahrStreifenStoerfallIndikatorDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected FahrStreifenStoerfallIndikatorDoModelItemProvider fahrStreifenStoerfallIndikatorDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFahrStreifenStoerfallIndikatorDoModelAdapter() {
		if (fahrStreifenStoerfallIndikatorDoModelItemProvider == null) {
			fahrStreifenStoerfallIndikatorDoModelItemProvider = new FahrStreifenStoerfallIndikatorDoModelItemProvider(
					this);
		}

		return fahrStreifenStoerfallIndikatorDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UmfeldDatenMessStelleDoTypItemProvider umfeldDatenMessStelleDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createUmfeldDatenMessStelleDoTypAdapter() {
		if (umfeldDatenMessStelleDoTypItemProvider == null) {
			umfeldDatenMessStelleDoTypItemProvider = new UmfeldDatenMessStelleDoTypItemProvider(
					this);
		}

		return umfeldDatenMessStelleDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UmfeldDatenMessStelleDoModelItemProvider umfeldDatenMessStelleDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createUmfeldDatenMessStelleDoModelAdapter() {
		if (umfeldDatenMessStelleDoModelItemProvider == null) {
			umfeldDatenMessStelleDoModelItemProvider = new UmfeldDatenMessStelleDoModelItemProvider(
					this);
		}

		return umfeldDatenMessStelleDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AnzeigeQuerschnittDoTypItemProvider anzeigeQuerschnittDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createAnzeigeQuerschnittDoTypAdapter() {
		if (anzeigeQuerschnittDoTypItemProvider == null) {
			anzeigeQuerschnittDoTypItemProvider = new AnzeigeQuerschnittDoTypItemProvider(
					this);
		}

		return anzeigeQuerschnittDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AnzeigeQuerschnittDoModelItemProvider anzeigeQuerschnittDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createAnzeigeQuerschnittDoModelAdapter() {
		if (anzeigeQuerschnittDoModelItemProvider == null) {
			anzeigeQuerschnittDoModelItemProvider = new AnzeigeQuerschnittDoModelItemProvider(
					this);
		}

		return anzeigeQuerschnittDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected GewaesserDoTypItemProvider gewaesserDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createGewaesserDoTypAdapter() {
		if (gewaesserDoTypItemProvider == null) {
			gewaesserDoTypItemProvider = new GewaesserDoTypItemProvider(this);
		}

		return gewaesserDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.GewaesserDoModel} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected GewaesserDoModelItemProvider gewaesserDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.GewaesserDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createGewaesserDoModelAdapter() {
		if (gewaesserDoModelItemProvider == null) {
			gewaesserDoModelItemProvider = new GewaesserDoModelItemProvider(
					this);
		}

		return gewaesserDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BaustelleSymbolDoTypItemProvider baustelleSymbolDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createBaustelleSymbolDoTypAdapter() {
		if (baustelleSymbolDoTypItemProvider == null) {
			baustelleSymbolDoTypItemProvider = new BaustelleSymbolDoTypItemProvider(
					this);
		}

		return baustelleSymbolDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BaustelleSymbolDoModelItemProvider baustelleSymbolDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createBaustelleSymbolDoModelAdapter() {
		if (baustelleSymbolDoModelItemProvider == null) {
			baustelleSymbolDoModelItemProvider = new BaustelleSymbolDoModelItemProvider(
					this);
		}

		return baustelleSymbolDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BaustelleVerlaufDoTypItemProvider baustelleVerlaufDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createBaustelleVerlaufDoTypAdapter() {
		if (baustelleVerlaufDoTypItemProvider == null) {
			baustelleVerlaufDoTypItemProvider = new BaustelleVerlaufDoTypItemProvider(
					this);
		}

		return baustelleVerlaufDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BaustelleVerlaufDoModelItemProvider baustelleVerlaufDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createBaustelleVerlaufDoModelAdapter() {
		if (baustelleVerlaufDoModelItemProvider == null) {
			baustelleVerlaufDoModelItemProvider = new BaustelleVerlaufDoModelItemProvider(
					this);
		}

		return baustelleVerlaufDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected StauSymbolDoTypItemProvider stauSymbolDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStauSymbolDoTypAdapter() {
		if (stauSymbolDoTypItemProvider == null) {
			stauSymbolDoTypItemProvider = new StauSymbolDoTypItemProvider(this);
		}

		return stauSymbolDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected StauSymbolDoModelItemProvider stauSymbolDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStauSymbolDoModelAdapter() {
		if (stauSymbolDoModelItemProvider == null) {
			stauSymbolDoModelItemProvider = new StauSymbolDoModelItemProvider(
					this);
		}

		return stauSymbolDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected StauVerlaufDoTypItemProvider stauVerlaufDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStauVerlaufDoTypAdapter() {
		if (stauVerlaufDoTypItemProvider == null) {
			stauVerlaufDoTypItemProvider = new StauVerlaufDoTypItemProvider(
					this);
		}

		return stauVerlaufDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected StauVerlaufDoModelItemProvider stauVerlaufDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStauVerlaufDoModelAdapter() {
		if (stauVerlaufDoModelItemProvider == null) {
			stauVerlaufDoModelItemProvider = new StauVerlaufDoModelItemProvider(
					this);
		}

		return stauVerlaufDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected UnfallSymbolDoTypItemProvider unfallSymbolDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createUnfallSymbolDoTypAdapter() {
		if (unfallSymbolDoTypItemProvider == null) {
			unfallSymbolDoTypItemProvider = new UnfallSymbolDoTypItemProvider(
					this);
		}

		return unfallSymbolDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected UnfallSymbolDoModelItemProvider unfallSymbolDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createUnfallSymbolDoModelAdapter() {
		if (unfallSymbolDoModelItemProvider == null) {
			unfallSymbolDoModelItemProvider = new UnfallSymbolDoModelItemProvider(
					this);
		}

		return unfallSymbolDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RdsMeldungSymbolDoTypItemProvider rdsMeldungSymbolDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createRdsMeldungSymbolDoTypAdapter() {
		if (rdsMeldungSymbolDoTypItemProvider == null) {
			rdsMeldungSymbolDoTypItemProvider = new RdsMeldungSymbolDoTypItemProvider(
					this);
		}

		return rdsMeldungSymbolDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RdsMeldungSymbolDoModelItemProvider rdsMeldungSymbolDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createRdsMeldungSymbolDoModelAdapter() {
		if (rdsMeldungSymbolDoModelItemProvider == null) {
			rdsMeldungSymbolDoModelItemProvider = new RdsMeldungSymbolDoModelItemProvider(
					this);
		}

		return rdsMeldungSymbolDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RdsMeldungVerlaufDoTypItemProvider rdsMeldungVerlaufDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createRdsMeldungVerlaufDoTypAdapter() {
		if (rdsMeldungVerlaufDoTypItemProvider == null) {
			rdsMeldungVerlaufDoTypItemProvider = new RdsMeldungVerlaufDoTypItemProvider(
					this);
		}

		return rdsMeldungVerlaufDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RdsMeldungVerlaufDoModelItemProvider rdsMeldungVerlaufDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createRdsMeldungVerlaufDoModelAdapter() {
		if (rdsMeldungVerlaufDoModelItemProvider == null) {
			rdsMeldungVerlaufDoModelItemProvider = new RdsMeldungVerlaufDoModelItemProvider(
					this);
		}

		return rdsMeldungVerlaufDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessQuerschnittNBAHanDoTypItemProvider messQuerschnittNBAHanDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createMessQuerschnittNBAHanDoTypAdapter() {
		if (messQuerschnittNBAHanDoTypItemProvider == null) {
			messQuerschnittNBAHanDoTypItemProvider = new MessQuerschnittNBAHanDoTypItemProvider(
					this);
		}

		return messQuerschnittNBAHanDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessQuerschnittNBAHanDoModelItemProvider messQuerschnittNBAHanDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createMessQuerschnittNBAHanDoModelAdapter() {
		if (messQuerschnittNBAHanDoModelItemProvider == null) {
			messQuerschnittNBAHanDoModelItemProvider = new MessQuerschnittNBAHanDoModelItemProvider(
					this);
		}

		return messQuerschnittNBAHanDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TmcMeldungSymbolDoTypItemProvider tmcMeldungSymbolDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createTmcMeldungSymbolDoTypAdapter() {
		if (tmcMeldungSymbolDoTypItemProvider == null) {
			tmcMeldungSymbolDoTypItemProvider = new TmcMeldungSymbolDoTypItemProvider(
					this);
		}

		return tmcMeldungSymbolDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TmcMeldungSymbolDoModelItemProvider tmcMeldungSymbolDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createTmcMeldungSymbolDoModelAdapter() {
		if (tmcMeldungSymbolDoModelItemProvider == null) {
			tmcMeldungSymbolDoModelItemProvider = new TmcMeldungSymbolDoModelItemProvider(
					this);
		}

		return tmcMeldungSymbolDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TmcMeldungVerlaufDoTypItemProvider tmcMeldungVerlaufDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createTmcMeldungVerlaufDoTypAdapter() {
		if (tmcMeldungVerlaufDoTypItemProvider == null) {
			tmcMeldungVerlaufDoTypItemProvider = new TmcMeldungVerlaufDoTypItemProvider(
					this);
		}

		return tmcMeldungVerlaufDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TmcMeldungVerlaufDoModelItemProvider tmcMeldungVerlaufDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createTmcMeldungVerlaufDoModelAdapter() {
		if (tmcMeldungVerlaufDoModelItemProvider == null) {
			tmcMeldungVerlaufDoModelItemProvider = new TmcMeldungVerlaufDoModelItemProvider(
					this);
		}

		return tmcMeldungVerlaufDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessQuerschnittDoTypItemProvider messQuerschnittDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createMessQuerschnittDoTypAdapter() {
		if (messQuerschnittDoTypItemProvider == null) {
			messQuerschnittDoTypItemProvider = new MessQuerschnittDoTypItemProvider(
					this);
		}

		return messQuerschnittDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessQuerschnittDoModelItemProvider messQuerschnittDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createMessQuerschnittDoModelAdapter() {
		if (messQuerschnittDoModelItemProvider == null) {
			messQuerschnittDoModelItemProvider = new MessQuerschnittDoModelItemProvider(
					this);
		}

		return messQuerschnittDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenSegmentDoTypItemProvider strassenSegmentDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStrassenSegmentDoTypAdapter() {
		if (strassenSegmentDoTypItemProvider == null) {
			strassenSegmentDoTypItemProvider = new StrassenSegmentDoTypItemProvider(
					this);
		}

		return strassenSegmentDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenSegmentDoModelItemProvider strassenSegmentDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStrassenSegmentDoModelAdapter() {
		if (strassenSegmentDoModelItemProvider == null) {
			strassenSegmentDoModelItemProvider = new StrassenSegmentDoModelItemProvider(
					this);
		}

		return strassenSegmentDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.KreisDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected KreisDoTypItemProvider kreisDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.KreisDoTyp}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createKreisDoTypAdapter() {
		if (kreisDoTypItemProvider == null) {
			kreisDoTypItemProvider = new KreisDoTypItemProvider(this);
		}

		return kreisDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.KreisDoModel} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected KreisDoModelItemProvider kreisDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.KreisDoModel}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createKreisDoModelAdapter() {
		if (kreisDoModelItemProvider == null) {
			kreisDoModelItemProvider = new KreisDoModelItemProvider(this);
		}

		return kreisDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OrtslageDoTypItemProvider ortslageDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createOrtslageDoTypAdapter() {
		if (ortslageDoTypItemProvider == null) {
			ortslageDoTypItemProvider = new OrtslageDoTypItemProvider(this);
		}

		return ortslageDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtslageDoModel} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OrtslageDoModelItemProvider ortslageDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtslageDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createOrtslageDoModelAdapter() {
		if (ortslageDoModelItemProvider == null) {
			ortslageDoModelItemProvider = new OrtslageDoModelItemProvider(this);
		}

		return ortslageDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OrtsnameDoTypItemProvider ortsnameDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createOrtsnameDoTypAdapter() {
		if (ortsnameDoTypItemProvider == null) {
			ortsnameDoTypItemProvider = new OrtsnameDoTypItemProvider(this);
		}

		return ortsnameDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected OrtsnameDoModelItemProvider ortsnameDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createOrtsnameDoModelAdapter() {
		if (ortsnameDoModelItemProvider == null) {
			ortsnameDoModelItemProvider = new OrtsnameDoModelItemProvider(this);
		}

		return ortsnameDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenKnotenDoTypItemProvider strassenKnotenDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStrassenKnotenDoTypAdapter() {
		if (strassenKnotenDoTypItemProvider == null) {
			strassenKnotenDoTypItemProvider = new StrassenKnotenDoTypItemProvider(
					this);
		}

		return strassenKnotenDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenKnotenDoModelItemProvider strassenKnotenDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStrassenKnotenDoModelAdapter() {
		if (strassenKnotenDoModelItemProvider == null) {
			strassenKnotenDoModelItemProvider = new StrassenKnotenDoModelItemProvider(
					this);
		}

		return strassenKnotenDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StoerfallIndikatorDoModelItemProvider stoerfallIndikatorDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Adapter createStoerfallIndikatorDoModelAdapter() {
		if (stoerfallIndikatorDoModelItemProvider == null) {
			stoerfallIndikatorDoModelItemProvider = new StoerfallIndikatorDoModelItemProvider(
					this);
		}

		return stoerfallIndikatorDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenSegmentStoerfallIndikatorDoTypItemProvider strassenSegmentStoerfallIndikatorDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStrassenSegmentStoerfallIndikatorDoTypAdapter() {
		if (strassenSegmentStoerfallIndikatorDoTypItemProvider == null) {
			strassenSegmentStoerfallIndikatorDoTypItemProvider = new StrassenSegmentStoerfallIndikatorDoTypItemProvider(
					this);
		}

		return strassenSegmentStoerfallIndikatorDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenSegmentStoerfallIndikatorDoModelItemProvider strassenSegmentStoerfallIndikatorDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStrassenSegmentStoerfallIndikatorDoModelAdapter() {
		if (strassenSegmentStoerfallIndikatorDoModelItemProvider == null) {
			strassenSegmentStoerfallIndikatorDoModelItemProvider = new StrassenSegmentStoerfallIndikatorDoModelItemProvider(
					this);
		}

		return strassenSegmentStoerfallIndikatorDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenTeilSegmentStoerfallIndikatorDoTypItemProvider strassenTeilSegmentStoerfallIndikatorDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStrassenTeilSegmentStoerfallIndikatorDoTypAdapter() {
		if (strassenTeilSegmentStoerfallIndikatorDoTypItemProvider == null) {
			strassenTeilSegmentStoerfallIndikatorDoTypItemProvider = new StrassenTeilSegmentStoerfallIndikatorDoTypItemProvider(
					this);
		}

		return strassenTeilSegmentStoerfallIndikatorDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StrassenTeilSegmentStoerfallIndikatorDoModelItemProvider strassenTeilSegmentStoerfallIndikatorDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStrassenTeilSegmentStoerfallIndikatorDoModelAdapter() {
		if (strassenTeilSegmentStoerfallIndikatorDoModelItemProvider == null) {
			strassenTeilSegmentStoerfallIndikatorDoModelItemProvider = new StrassenTeilSegmentStoerfallIndikatorDoModelItemProvider(
					this);
		}

		return strassenTeilSegmentStoerfallIndikatorDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessQuerschnittStoerfallIndikatorDoTypItemProvider messQuerschnittStoerfallIndikatorDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMessQuerschnittStoerfallIndikatorDoTypAdapter() {
		if (messQuerschnittStoerfallIndikatorDoTypItemProvider == null) {
			messQuerschnittStoerfallIndikatorDoTypItemProvider = new MessQuerschnittStoerfallIndikatorDoTypItemProvider(
					this);
		}

		return messQuerschnittStoerfallIndikatorDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessQuerschnittStoerfallIndikatorDoModelItemProvider messQuerschnittStoerfallIndikatorDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMessQuerschnittStoerfallIndikatorDoModelAdapter() {
		if (messQuerschnittStoerfallIndikatorDoModelItemProvider == null) {
			messQuerschnittStoerfallIndikatorDoModelItemProvider = new MessQuerschnittStoerfallIndikatorDoModelItemProvider(
					this);
		}

		return messQuerschnittStoerfallIndikatorDoModelItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this
				: parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the
	 * adapter. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			final Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
					|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to
	 * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 *
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void dispose() {
		if (messQuerschnittDoTypItemProvider != null) {
			messQuerschnittDoTypItemProvider.dispose();
		}
		if (messQuerschnittDoModelItemProvider != null) {
			messQuerschnittDoModelItemProvider.dispose();
		}
		if (strassenSegmentDoTypItemProvider != null) {
			strassenSegmentDoTypItemProvider.dispose();
		}
		if (strassenSegmentDoModelItemProvider != null) {
			strassenSegmentDoModelItemProvider.dispose();
		}
		if (kreisDoTypItemProvider != null) {
			kreisDoTypItemProvider.dispose();
		}
		if (kreisDoModelItemProvider != null) {
			kreisDoModelItemProvider.dispose();
		}
		if (ortslageDoTypItemProvider != null) {
			ortslageDoTypItemProvider.dispose();
		}
		if (ortslageDoModelItemProvider != null) {
			ortslageDoModelItemProvider.dispose();
		}
		if (ortsnameDoTypItemProvider != null) {
			ortsnameDoTypItemProvider.dispose();
		}
		if (ortsnameDoModelItemProvider != null) {
			ortsnameDoModelItemProvider.dispose();
		}
		if (strassenKnotenDoTypItemProvider != null) {
			strassenKnotenDoTypItemProvider.dispose();
		}
		if (strassenKnotenDoModelItemProvider != null) {
			strassenKnotenDoModelItemProvider.dispose();
		}
		if (stoerfallIndikatorDoModelItemProvider != null) {
			stoerfallIndikatorDoModelItemProvider.dispose();
		}
		if (strassenSegmentStoerfallIndikatorDoTypItemProvider != null) {
			strassenSegmentStoerfallIndikatorDoTypItemProvider.dispose();
		}
		if (strassenSegmentStoerfallIndikatorDoModelItemProvider != null) {
			strassenSegmentStoerfallIndikatorDoModelItemProvider.dispose();
		}
		if (strassenTeilSegmentStoerfallIndikatorDoTypItemProvider != null) {
			strassenTeilSegmentStoerfallIndikatorDoTypItemProvider.dispose();
		}
		if (strassenTeilSegmentStoerfallIndikatorDoModelItemProvider != null) {
			strassenTeilSegmentStoerfallIndikatorDoModelItemProvider.dispose();
		}
		if (messQuerschnittStoerfallIndikatorDoTypItemProvider != null) {
			messQuerschnittStoerfallIndikatorDoTypItemProvider.dispose();
		}
		if (messQuerschnittStoerfallIndikatorDoModelItemProvider != null) {
			messQuerschnittStoerfallIndikatorDoModelItemProvider.dispose();
		}
		if (fahrStreifenStoerfallIndikatorDoTypItemProvider != null) {
			fahrStreifenStoerfallIndikatorDoTypItemProvider.dispose();
		}
		if (fahrStreifenStoerfallIndikatorDoModelItemProvider != null) {
			fahrStreifenStoerfallIndikatorDoModelItemProvider.dispose();
		}
		if (umfeldDatenMessStelleDoTypItemProvider != null) {
			umfeldDatenMessStelleDoTypItemProvider.dispose();
		}
		if (umfeldDatenMessStelleDoModelItemProvider != null) {
			umfeldDatenMessStelleDoModelItemProvider.dispose();
		}
		if (anzeigeQuerschnittDoTypItemProvider != null) {
			anzeigeQuerschnittDoTypItemProvider.dispose();
		}
		if (anzeigeQuerschnittDoModelItemProvider != null) {
			anzeigeQuerschnittDoModelItemProvider.dispose();
		}
		if (gewaesserDoTypItemProvider != null) {
			gewaesserDoTypItemProvider.dispose();
		}
		if (gewaesserDoModelItemProvider != null) {
			gewaesserDoModelItemProvider.dispose();
		}
		if (baustelleSymbolDoTypItemProvider != null) {
			baustelleSymbolDoTypItemProvider.dispose();
		}
		if (baustelleSymbolDoModelItemProvider != null) {
			baustelleSymbolDoModelItemProvider.dispose();
		}
		if (baustelleVerlaufDoTypItemProvider != null) {
			baustelleVerlaufDoTypItemProvider.dispose();
		}
		if (baustelleVerlaufDoModelItemProvider != null) {
			baustelleVerlaufDoModelItemProvider.dispose();
		}
		if (stauSymbolDoTypItemProvider != null) {
			stauSymbolDoTypItemProvider.dispose();
		}
		if (stauSymbolDoModelItemProvider != null) {
			stauSymbolDoModelItemProvider.dispose();
		}
		if (stauVerlaufDoTypItemProvider != null) {
			stauVerlaufDoTypItemProvider.dispose();
		}
		if (stauVerlaufDoModelItemProvider != null) {
			stauVerlaufDoModelItemProvider.dispose();
		}
		if (unfallSymbolDoTypItemProvider != null) {
			unfallSymbolDoTypItemProvider.dispose();
		}
		if (unfallSymbolDoModelItemProvider != null) {
			unfallSymbolDoModelItemProvider.dispose();
		}
		if (rdsMeldungSymbolDoTypItemProvider != null) {
			rdsMeldungSymbolDoTypItemProvider.dispose();
		}
		if (rdsMeldungSymbolDoModelItemProvider != null) {
			rdsMeldungSymbolDoModelItemProvider.dispose();
		}
		if (rdsMeldungVerlaufDoTypItemProvider != null) {
			rdsMeldungVerlaufDoTypItemProvider.dispose();
		}
		if (rdsMeldungVerlaufDoModelItemProvider != null) {
			rdsMeldungVerlaufDoModelItemProvider.dispose();
		}
		if (messQuerschnittNBAHanDoTypItemProvider != null) {
			messQuerschnittNBAHanDoTypItemProvider.dispose();
		}
		if (messQuerschnittNBAHanDoModelItemProvider != null) {
			messQuerschnittNBAHanDoModelItemProvider.dispose();
		}
		if (tmcMeldungSymbolDoTypItemProvider != null) {
			tmcMeldungSymbolDoTypItemProvider.dispose();
		}
		if (tmcMeldungSymbolDoModelItemProvider != null) {
			tmcMeldungSymbolDoModelItemProvider.dispose();
		}
		if (tmcMeldungVerlaufDoTypItemProvider != null) {
			tmcMeldungVerlaufDoTypItemProvider.dispose();
		}
		if (tmcMeldungVerlaufDoModelItemProvider != null) {
			tmcMeldungVerlaufDoModelItemProvider.dispose();
		}
	}

}
