/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.model.provider.ConfiguratedDoTypItemProvider;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp;

/**
 * This is the item provider adapter for a
 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 *
 * @generated
 */
public class StrassenSegmentDoTypItemProvider
		extends ConfiguratedDoTypItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public StrassenSegmentDoTypItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addVordergrundfarbePropertyDescriptor(object);
			addLinienstaerkeZoomverhaltenPropertyDescriptor(object);
			addLinienstaerkeMinimaleZoomstufePropertyDescriptor(object);
			addLinienstaerkeMaximaleZoomstufePropertyDescriptor(object);
			addLinienstaerkeMaximumPropertyDescriptor(object);
			addLinienstaerkeMinimumPropertyDescriptor(object);
			addLinienstaerkePropertyDescriptor(object);
			addLinienabstandZoomverhaltenPropertyDescriptor(object);
			addLinienabstandMinimaleZoomstufePropertyDescriptor(object);
			addLinienabstandMaximaleZoomstufePropertyDescriptor(object);
			addLinienabstandMaximumPropertyDescriptor(object);
			addLinienabstandMinimumPropertyDescriptor(object);
			addLinienabstandPropertyDescriptor(object);
			addDefaultDarstellungAutobahnPropertyDescriptor(object);
			addVordergrundFarbeAutobahnPropertyDescriptor(object);
			addLinienstaerkeZoomverhaltenAutobahnPropertyDescriptor(object);
			addLinienstaerkeMinimaleZoomstufeAutobahnPropertyDescriptor(object);
			addLinienstaerkeMaximaleZoomstufeAutobahnPropertyDescriptor(object);
			addLinienstaerkeMaximumAutobahnPropertyDescriptor(object);
			addLinienstaerkeMinimumAutobahnPropertyDescriptor(object);
			addLinienstaerkeAutobahnPropertyDescriptor(object);
			addLinienabstandAutobahnPropertyDescriptor(object);
			addDefaultDarstellungBundesstrassePropertyDescriptor(object);
			addVordergrundFarbeBundesstrassePropertyDescriptor(object);
			addLinienstaerkeZoomverhaltenBundesstrassePropertyDescriptor(
					object);
			addLinienstaerkeMinimaleZoomstufeBundesstrassePropertyDescriptor(
					object);
			addLinienstaerkeMaximaleZoomstufeBundesstrassePropertyDescriptor(
					object);
			addLinienstaerkeMaximumBundesstrassePropertyDescriptor(object);
			addLinienstaerkeMinimumBundesstrassePropertyDescriptor(object);
			addLinienstaerkeBundesstrassePropertyDescriptor(object);
			addLinienabstandBundesstrassePropertyDescriptor(object);
			addDefaultDarstellungLandstrassePropertyDescriptor(object);
			addVordergrundFarbeLandstrassePropertyDescriptor(object);
			addLinienstaerkeZoomverhaltenLandstrassePropertyDescriptor(object);
			addLinienstaerkeMinimaleZoomstufeLandstrassePropertyDescriptor(
					object);
			addLinienstaerkeMaximaleZoomstufeLandstrassePropertyDescriptor(
					object);
			addLinienstaerkeMaximumLandstrassePropertyDescriptor(object);
			addLinienstaerkeMinimumLandstrassePropertyDescriptor(object);
			addLinienstaerkeLandstrassePropertyDescriptor(object);
			addLinienabstandLandstrassePropertyDescriptor(object);
			addVordergrundFarbeKreisstrassePropertyDescriptor(object);
			addLinienstaerkeZoomverhaltenKreisstrassePropertyDescriptor(object);
			addLinienstaerkeMinimaleZoomstufeKreisstrassePropertyDescriptor(
					object);
			addLinienstaerkeMaximaleZoomstufeKreisstrassePropertyDescriptor(
					object);
			addLinienstaerkeMaximumKreisstrassePropertyDescriptor(object);
			addLinienstaerkeMinimumKreisstrassePropertyDescriptor(object);
			addLinienstaerkeKreisstrassePropertyDescriptor(object);
			addLinienabstandKreisstrassePropertyDescriptor(object);
			addDefaultDarstellungKreisstrassePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Vordergrundfarbe feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addVordergrundfarbePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_VordergrundfarbeDecorator_vordergrundfarbe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_VordergrundfarbeDecorator_vordergrundfarbe_feature",
						"_UI_VordergrundfarbeDecorator_type"),
				DobjDecoratorPackage.Literals.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addLinienstaerkePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerke_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerke_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Zoomverhalten
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandZoomverhaltenPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandZoomverhalten_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandZoomverhalten_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Minimale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMinimaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMinimaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMinimaleZoomstufe_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Maximale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMaximaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMaximaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMaximaleZoomstufe_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Maximum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMaximumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMaximum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMaximum_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Minimum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMinimumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMinimum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMinimum_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addLinienabstandPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstand_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstand_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Zoomverhalten
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeZoomverhaltenPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeZoomverhalten_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeZoomverhalten_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimaleZoomstufe_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximaleZoomstufe_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximum_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimum_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Default Darstellung Autobahn
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addDefaultDarstellungAutobahnPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_defaultDarstellungAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_defaultDarstellungAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Vordergrund Farbe Autobahn
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addVordergrundFarbeAutobahnPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Zoomverhalten
	 * Autobahn feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeZoomverhaltenAutobahnPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimale Zoomstufe
	 * Autobahn feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimaleZoomstufeAutobahnPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximale Zoomstufe
	 * Autobahn feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximaleZoomstufeAutobahnPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximum Autobahn
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximumAutobahnPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimum Autobahn
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimumAutobahnPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Autobahn feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeAutobahnPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Autobahn feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandAutobahnPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienabstandAutobahn_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienabstandAutobahn_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Default Darstellung Bundesstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addDefaultDarstellungBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_defaultDarstellungBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_defaultDarstellungBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Vordergrund Farbe Bundesstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addVordergrundFarbeBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Zoomverhalten
	 * Bundesstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeZoomverhaltenBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimale Zoomstufe
	 * Bundesstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimaleZoomstufeBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximale Zoomstufe
	 * Bundesstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximaleZoomstufeBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximum
	 * Bundesstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximumBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimum
	 * Bundesstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimumBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Bundesstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Bundesstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandBundesstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienabstandBundesstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienabstandBundesstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Default Darstellung Landstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addDefaultDarstellungLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_defaultDarstellungLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_defaultDarstellungLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Vordergrund Farbe Landstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addVordergrundFarbeLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Landstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienabstandLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienabstandLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Zoomverhalten
	 * Landstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeZoomverhaltenLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimale Zoomstufe
	 * Landstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimaleZoomstufeLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximale Zoomstufe
	 * Landstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximaleZoomstufeLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximum Landstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximumLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimum Landstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimumLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Landstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeLandstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeLandstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeLandstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Vordergrund Farbe Kreisstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addVordergrundFarbeKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_vordergrundFarbeKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Zoomverhalten
	 * Kreisstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeZoomverhaltenKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeZoomverhaltenKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimale Zoomstufe
	 * Kreisstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimaleZoomstufeKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimaleZoomstufeKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximale Zoomstufe
	 * Kreisstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximaleZoomstufeKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximaleZoomstufeKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximum
	 * Kreisstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximumKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMaximumKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimum
	 * Kreisstrasse feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimumKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeMinimumKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Kreisstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienstaerkeKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienstaerkeKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Kreisstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_linienabstandKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_linienabstandKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Default Darstellung Kreisstrasse
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addDefaultDarstellungKreisstrassePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_StrassenSegmentDoTyp_defaultDarstellungKreisstrasse_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_StrassenSegmentDoTyp_defaultDarstellungKreisstrasse_feature",
						"_UI_StrassenSegmentDoTyp_type"),
				NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE,
				true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This returns StrassenSegmentDoTyp.gif. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public Object getImage(final Object object) {
		return super.getImage(object);
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public String getText(final Object object) {
		final String label = ((StrassenSegmentDoTyp) object).getName();
		return label == null || label.length() == 0
				? getString("_UI_StrassenSegmentDoTyp_type")
				: label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to
	 * update any cached children and by creating a viewer notification, which
	 * it passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(StrassenSegmentDoTyp.class)) {
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUNDFARBE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MAXIMUM:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_MINIMUM:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE:
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return NetzEditPlugin.INSTANCE;
	}

}
