/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.model.provider.ConfiguratedDoTypItemProvider;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp;

/**
 * This is the item provider adapter for a
 * {@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 *
 * @generated
 */
public class TmcMeldungVerlaufDoTypItemProvider
		extends ConfiguratedDoTypItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public TmcMeldungVerlaufDoTypItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addLinienabstandZoomverhaltenPropertyDescriptor(object);
			addLinienabstandMinimaleZoomstufePropertyDescriptor(object);
			addLinienabstandMaximaleZoomstufePropertyDescriptor(object);
			addLinienabstandMaximumPropertyDescriptor(object);
			addLinienabstandMinimumPropertyDescriptor(object);
			addLinienabstandPropertyDescriptor(object);
			addVordergrundfarbePropertyDescriptor(object);
			addLinienstaerkeZoomverhaltenPropertyDescriptor(object);
			addLinienstaerkeMinimaleZoomstufePropertyDescriptor(object);
			addLinienstaerkeMaximaleZoomstufePropertyDescriptor(object);
			addLinienstaerkeMaximumPropertyDescriptor(object);
			addLinienstaerkeMinimumPropertyDescriptor(object);
			addLinienstaerkePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Linienabstand Zoomverhalten
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandZoomverhaltenPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandZoomverhalten_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandZoomverhalten_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_ZOOMVERHALTEN,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Minimale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMinimaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMinimaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMinimaleZoomstufe_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Maximale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMaximaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMaximaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMaximaleZoomstufe_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Maximum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMaximumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMaximum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMaximum_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MAXIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand Minimum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienabstandMinimumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstandMinimum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstandMinimum_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND_MINIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Vordergrundfarbe feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addVordergrundfarbePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_VordergrundfarbeDecorator_vordergrundfarbe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_VordergrundfarbeDecorator_vordergrundfarbe_feature",
						"_UI_VordergrundfarbeDecorator_type"),
				DobjDecoratorPackage.Literals.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Zoomverhalten
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeZoomverhaltenPropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeZoomverhalten_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeZoomverhalten_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimaleZoomstufe_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximale Zoomstufe
	 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximaleZoomstufePropertyDescriptor(
			Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximaleZoomstufe_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximaleZoomstufe_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Maximum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMaximumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMaximum_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke Minimum feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLinienstaerkeMinimumPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimum_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerkeMinimum_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienstaerke feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addLinienstaerkePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienstaerkeZoomDecorator_linienstaerke_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienstaerkeZoomDecorator_linienstaerke_feature",
						"_UI_LinienstaerkeZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Linienabstand feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addLinienabstandPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString(
						"_UI_LinienabstandZoomDecorator_linienabstand_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienabstandZoomDecorator_linienabstand_feature",
						"_UI_LinienabstandZoomDecorator_type"),
				DobjDecoratorPackage.Literals.LINIENABSTAND_ZOOM_DECORATOR__LINIENABSTAND,
				true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This returns TmcMeldungVerlaufDoTyp.gif. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator()
				.getImage("full/obj16/TmcMeldungVerlaufDoTyp"));
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		final String label = ((TmcMeldungVerlaufDoTyp) object).getName();
		return label == null || label.length() == 0
				? getString("_UI_TmcMeldungVerlaufDoTyp_type")
				: getString("_UI_TmcMeldungVerlaufDoTyp_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to
	 * update any cached children and by creating a viewer notification, which
	 * it passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(TmcMeldungVerlaufDoTyp.class)) {
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_ZOOMVERHALTEN:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MINIMALE_ZOOMSTUFE:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMALE_ZOOMSTUFE:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MAXIMUM:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND_MINIMUM:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENABSTAND:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__VORDERGRUNDFARBE:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MAXIMUM:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE_MINIMUM:
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP__LINIENSTAERKE:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return NetzEditPlugin.INSTANCE;
	}

}
