/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;

import de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoModel;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp;
import de.bsvrz.buv.plugin.netz.model.KomplexDoTyp;
import de.bsvrz.buv.plugin.netz.model.KreisDoModel;
import de.bsvrz.buv.plugin.netz.model.KreisDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.SituationDoModel;
import de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage
 * @generated
 */
public class NetzAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static NetzPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public NetzAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = NetzPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * 
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected NetzSwitch<Adapter> modelSwitch = new NetzSwitch<Adapter>() {
		@Override
		public Adapter caseMessQuerschnittDoTyp(MessQuerschnittDoTyp object) {
			return createMessQuerschnittDoTypAdapter();
		}

		@Override
		public Adapter caseMessQuerschnittDoModel(
				MessQuerschnittDoModel object) {
			return createMessQuerschnittDoModelAdapter();
		}

		@Override
		public Adapter caseStrassenSegmentDoTyp(StrassenSegmentDoTyp object) {
			return createStrassenSegmentDoTypAdapter();
		}

		@Override
		public Adapter caseStrassenSegmentDoModel(
				StrassenSegmentDoModel object) {
			return createStrassenSegmentDoModelAdapter();
		}

		@Override
		public Adapter caseKreisDoTyp(KreisDoTyp object) {
			return createKreisDoTypAdapter();
		}

		@Override
		public Adapter caseKreisDoModel(KreisDoModel object) {
			return createKreisDoModelAdapter();
		}

		@Override
		public Adapter caseOrtslageDoTyp(OrtslageDoTyp object) {
			return createOrtslageDoTypAdapter();
		}

		@Override
		public Adapter caseOrtslageDoModel(OrtslageDoModel object) {
			return createOrtslageDoModelAdapter();
		}

		@Override
		public Adapter caseKomplexDoTyp(KomplexDoTyp object) {
			return createKomplexDoTypAdapter();
		}

		@Override
		public Adapter caseOrtsnameDoTyp(OrtsnameDoTyp object) {
			return createOrtsnameDoTypAdapter();
		}

		@Override
		public Adapter caseOrtsnameDoModel(OrtsnameDoModel object) {
			return createOrtsnameDoModelAdapter();
		}

		@Override
		public Adapter caseStrassenKnotenDoTyp(StrassenKnotenDoTyp object) {
			return createStrassenKnotenDoTypAdapter();
		}

		@Override
		public Adapter caseStrassenKnotenDoModel(StrassenKnotenDoModel object) {
			return createStrassenKnotenDoModelAdapter();
		}

		@Override
		public Adapter caseStoerfallIndikatorDoTyp(
				StoerfallIndikatorDoTyp object) {
			return createStoerfallIndikatorDoTypAdapter();
		}

		@Override
		public Adapter caseStoerfallIndikatorDoModel(
				StoerfallIndikatorDoModel object) {
			return createStoerfallIndikatorDoModelAdapter();
		}

		@Override
		public Adapter caseStrassenSegmentStoerfallIndikatorDoTyp(
				StrassenSegmentStoerfallIndikatorDoTyp object) {
			return createStrassenSegmentStoerfallIndikatorDoTypAdapter();
		}

		@Override
		public Adapter caseStrassenSegmentStoerfallIndikatorDoModel(
				StrassenSegmentStoerfallIndikatorDoModel object) {
			return createStrassenSegmentStoerfallIndikatorDoModelAdapter();
		}

		@Override
		public Adapter caseStrassenTeilSegmentStoerfallIndikatorDoTyp(
				StrassenTeilSegmentStoerfallIndikatorDoTyp object) {
			return createStrassenTeilSegmentStoerfallIndikatorDoTypAdapter();
		}

		@Override
		public Adapter caseStrassenTeilSegmentStoerfallIndikatorDoModel(
				StrassenTeilSegmentStoerfallIndikatorDoModel object) {
			return createStrassenTeilSegmentStoerfallIndikatorDoModelAdapter();
		}

		@Override
		public Adapter caseMessQuerschnittStoerfallIndikatorDoTyp(
				MessQuerschnittStoerfallIndikatorDoTyp object) {
			return createMessQuerschnittStoerfallIndikatorDoTypAdapter();
		}

		@Override
		public Adapter caseMessQuerschnittStoerfallIndikatorDoModel(
				MessQuerschnittStoerfallIndikatorDoModel object) {
			return createMessQuerschnittStoerfallIndikatorDoModelAdapter();
		}

		@Override
		public Adapter caseFahrStreifenStoerfallIndikatorDoTyp(
				FahrStreifenStoerfallIndikatorDoTyp object) {
			return createFahrStreifenStoerfallIndikatorDoTypAdapter();
		}

		@Override
		public Adapter caseFahrStreifenStoerfallIndikatorDoModel(
				FahrStreifenStoerfallIndikatorDoModel object) {
			return createFahrStreifenStoerfallIndikatorDoModelAdapter();
		}

		@Override
		public Adapter caseUmfeldDatenMessStelleDoTyp(
				UmfeldDatenMessStelleDoTyp object) {
			return createUmfeldDatenMessStelleDoTypAdapter();
		}

		@Override
		public Adapter caseUmfeldDatenMessStelleDoModel(
				UmfeldDatenMessStelleDoModel object) {
			return createUmfeldDatenMessStelleDoModelAdapter();
		}

		@Override
		public Adapter caseAnzeigeQuerschnittDoTyp(
				AnzeigeQuerschnittDoTyp object) {
			return createAnzeigeQuerschnittDoTypAdapter();
		}

		@Override
		public Adapter caseAnzeigeQuerschnittDoModel(
				AnzeigeQuerschnittDoModel object) {
			return createAnzeigeQuerschnittDoModelAdapter();
		}

		@Override
		public Adapter caseGewaesserDoTyp(GewaesserDoTyp object) {
			return createGewaesserDoTypAdapter();
		}

		@Override
		public Adapter caseGewaesserDoModel(GewaesserDoModel object) {
			return createGewaesserDoModelAdapter();
		}

		@Override
		public <T extends Situation> Adapter caseSituationDoModel(
				SituationDoModel<T> object) {
			return createSituationDoModelAdapter();
		}

		@Override
		public Adapter caseSituationSymbolDoTyp(SituationSymbolDoTyp object) {
			return createSituationSymbolDoTypAdapter();
		}

		@Override
		public Adapter caseSituationVerlaufDoTyp(SituationVerlaufDoTyp object) {
			return createSituationVerlaufDoTypAdapter();
		}

		@Override
		public Adapter caseBaustelleDoTyp(BaustelleDoTyp object) {
			return createBaustelleDoTypAdapter();
		}

		@Override
		public Adapter caseBaustelleSymbolDoTyp(BaustelleSymbolDoTyp object) {
			return createBaustelleSymbolDoTypAdapter();
		}

		@Override
		public Adapter caseBaustelleSymbolDoModel(
				BaustelleSymbolDoModel object) {
			return createBaustelleSymbolDoModelAdapter();
		}

		@Override
		public Adapter caseBaustelleVerlaufDoTyp(BaustelleVerlaufDoTyp object) {
			return createBaustelleVerlaufDoTypAdapter();
		}

		@Override
		public Adapter caseBaustelleVerlaufDoModel(
				BaustelleVerlaufDoModel object) {
			return createBaustelleVerlaufDoModelAdapter();
		}

		@Override
		public Adapter caseStauDoTyp(StauDoTyp object) {
			return createStauDoTypAdapter();
		}

		@Override
		public Adapter caseStauSymbolDoTyp(StauSymbolDoTyp object) {
			return createStauSymbolDoTypAdapter();
		}

		@Override
		public Adapter caseStauSymbolDoModel(StauSymbolDoModel object) {
			return createStauSymbolDoModelAdapter();
		}

		@Override
		public Adapter caseStauVerlaufDoTyp(StauVerlaufDoTyp object) {
			return createStauVerlaufDoTypAdapter();
		}

		@Override
		public Adapter caseStauVerlaufDoModel(StauVerlaufDoModel object) {
			return createStauVerlaufDoModelAdapter();
		}

		@Override
		public Adapter caseUnfallSymbolDoTyp(UnfallSymbolDoTyp object) {
			return createUnfallSymbolDoTypAdapter();
		}

		@Override
		public Adapter caseUnfallSymbolDoModel(UnfallSymbolDoModel object) {
			return createUnfallSymbolDoModelAdapter();
		}

		@Override
		public Adapter caseRdsMeldungDoTyp(RdsMeldungDoTyp object) {
			return createRdsMeldungDoTypAdapter();
		}

		@Override
		public Adapter caseRdsMeldungSymbolDoTyp(RdsMeldungSymbolDoTyp object) {
			return createRdsMeldungSymbolDoTypAdapter();
		}

		@Override
		public Adapter caseRdsMeldungSymbolDoModel(
				RdsMeldungSymbolDoModel object) {
			return createRdsMeldungSymbolDoModelAdapter();
		}

		@Override
		public Adapter caseRdsMeldungVerlaufDoTyp(
				RdsMeldungVerlaufDoTyp object) {
			return createRdsMeldungVerlaufDoTypAdapter();
		}

		@Override
		public Adapter caseRdsMeldungVerlaufDoModel(
				RdsMeldungVerlaufDoModel object) {
			return createRdsMeldungVerlaufDoModelAdapter();
		}

		@Override
		public Adapter caseMessQuerschnittNBAHanDoTyp(
				MessQuerschnittNBAHanDoTyp object) {
			return createMessQuerschnittNBAHanDoTypAdapter();
		}

		@Override
		public Adapter caseMessQuerschnittNBAHanDoModel(
				MessQuerschnittNBAHanDoModel object) {
			return createMessQuerschnittNBAHanDoModelAdapter();
		}

		@Override
		public Adapter caseTmcMeldungDoTyp(TmcMeldungDoTyp object) {
			return createTmcMeldungDoTypAdapter();
		}

		@Override
		public Adapter caseTmcMeldungSymbolDoTyp(TmcMeldungSymbolDoTyp object) {
			return createTmcMeldungSymbolDoTypAdapter();
		}

		@Override
		public Adapter caseTmcMeldungSymbolDoModel(
				TmcMeldungSymbolDoModel object) {
			return createTmcMeldungSymbolDoModelAdapter();
		}

		@Override
		public Adapter caseTmcMeldungVerlaufDoTyp(
				TmcMeldungVerlaufDoTyp object) {
			return createTmcMeldungVerlaufDoTypAdapter();
		}

		@Override
		public Adapter caseTmcMeldungVerlaufDoModel(
				TmcMeldungVerlaufDoModel object) {
			return createTmcMeldungVerlaufDoModelAdapter();
		}

		@Override
		public Adapter caseNamed(Named object) {
			return createNamedAdapter();
		}

		@Override
		public Adapter caseDoTyp(DoTyp object) {
			return createDoTypAdapter();
		}

		@Override
		public Adapter caseConfiguratedDoTyp(ConfiguratedDoTyp object) {
			return createConfiguratedDoTypAdapter();
		}

		@Override
		public Adapter caseSkalierungDecorator(SkalierungDecorator object) {
			return createSkalierungDecoratorAdapter();
		}

		@Override
		public Adapter caseDatenstatusDecorator(DatenstatusDecorator object) {
			return createDatenstatusDecoratorAdapter();
		}

		@Override
		public Adapter caseLinienabstandZoomDecorator(
				LinienabstandZoomDecorator object) {
			return createLinienabstandZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseLocated(Located object) {
			return createLocatedAdapter();
		}

		@Override
		public Adapter caseDoKomponente(DoKomponente object) {
			return createDoKomponenteAdapter();
		}

		@Override
		public Adapter caseDoModel(DoModel object) {
			return createDoModelAdapter();
		}

		@Override
		public <T extends SystemObjekt> Adapter caseBitCtrlDoModel(
				BitCtrlDoModel<T> object) {
			return createBitCtrlDoModelAdapter();
		}

		@Override
		public Adapter caseDrehungDecorator(DrehungDecorator object) {
			return createDrehungDecoratorAdapter();
		}

		@Override
		public Adapter caseVordergrundfarbeDecorator(
				VordergrundfarbeDecorator object) {
			return createVordergrundfarbeDecoratorAdapter();
		}

		@Override
		public Adapter caseLinienstaerkeZoomDecorator(
				LinienstaerkeZoomDecorator object) {
			return createLinienstaerkeZoomDecoratorAdapter();
		}

		@Override
		public Adapter caseHintergrundfarbeDecorator(
				HintergrundfarbeDecorator object) {
			return createHintergrundfarbeDecoratorAdapter();
		}

		@Override
		public Adapter caseSchriftDecorator(SchriftDecorator object) {
			return createSchriftDecoratorAdapter();
		}

		@Override
		public Adapter caseStoerfallIndikatorDecorator(
				StoerfallIndikatorDecorator object) {
			return createStoerfallIndikatorDecoratorAdapter();
		}

		@Override
		public Adapter caseAntikollisionsalgorithmusDecorator(
				AntikollisionsalgorithmusDecorator object) {
			return createAntikollisionsalgorithmusDecoratorAdapter();
		}

		@Override
		public Adapter caseZoomVerhaltenFixDecorator(
				ZoomVerhaltenFixDecorator object) {
			return createZoomVerhaltenFixDecoratorAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param target
	 *            the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp
	 * <em>Fahr Streifen Stoerfall Indikator Do Typ</em>}'. <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp
	 * @generated
	 */
	public Adapter createFahrStreifenStoerfallIndikatorDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel
	 * <em>Fahr Streifen Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel
	 * @generated
	 */
	public Adapter createFahrStreifenStoerfallIndikatorDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp
	 * <em>Umfeld Daten Mess Stelle Do Typ</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp
	 * @generated
	 */
	public Adapter createUmfeldDatenMessStelleDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel
	 * <em>Umfeld Daten Mess Stelle Do Model</em>}'. <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel
	 * @generated
	 */
	public Adapter createUmfeldDatenMessStelleDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp
	 * <em>Anzeige Querschnitt Do Typ</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp
	 * @generated
	 */
	public Adapter createAnzeigeQuerschnittDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel
	 * <em>Anzeige Querschnitt Do Model</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel
	 * @generated
	 */
	public Adapter createAnzeigeQuerschnittDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp <em>Gewaesser Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp
	 * @generated
	 */
	public Adapter createGewaesserDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.GewaesserDoModel <em>Gewaesser Do
	 * Model</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.GewaesserDoModel
	 * @generated
	 */
	public Adapter createGewaesserDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationDoModel <em>Situation Do
	 * Model</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.SituationDoModel
	 * @generated
	 */
	public Adapter createSituationDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp <em>Situation
	 * Symbol Do Typ</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp
	 * @generated
	 */
	public Adapter createSituationSymbolDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
	 * <em>Situation Verlauf Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp
	 * @generated
	 */
	public Adapter createSituationVerlaufDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleDoTyp <em>Baustelle Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleDoTyp
	 * @generated
	 */
	public Adapter createBaustelleDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp <em>Baustelle
	 * Symbol Do Typ</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp
	 * @generated
	 */
	public Adapter createBaustelleSymbolDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel
	 * <em>Baustelle Symbol Do Model</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel
	 * @generated
	 */
	public Adapter createBaustelleSymbolDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp
	 * <em>Baustelle Verlauf Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp
	 * @generated
	 */
	public Adapter createBaustelleVerlaufDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel
	 * <em>Baustelle Verlauf Do Model</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel
	 * @generated
	 */
	public Adapter createBaustelleVerlaufDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauDoTyp <em>Stau Do Typ</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StauDoTyp
	 * @generated
	 */
	public Adapter createStauDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp <em>Stau Symbol Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp
	 * @generated
	 */
	public Adapter createStauSymbolDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel <em>Stau Symbol
	 * Do Model</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel
	 * @generated
	 */
	public Adapter createStauSymbolDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp <em>Stau Verlauf
	 * Do Typ</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp
	 * @generated
	 */
	public Adapter createStauVerlaufDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel <em>Stau
	 * Verlauf Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel
	 * @generated
	 */
	public Adapter createStauVerlaufDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp <em>Unfall
	 * Symbol Do Typ</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp
	 * @generated
	 */
	public Adapter createUnfallSymbolDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel <em>Unfall
	 * Symbol Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel
	 * @generated
	 */
	public Adapter createUnfallSymbolDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp <em>Rds Meldung Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp
	 * @generated
	 */
	public Adapter createRdsMeldungDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp <em>Rds
	 * Meldung Symbol Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp
	 * @generated
	 */
	public Adapter createRdsMeldungSymbolDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel <em>Rds
	 * Meldung Symbol Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel
	 * @generated
	 */
	public Adapter createRdsMeldungSymbolDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp <em>Rds
	 * Meldung Verlauf Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp
	 * @generated
	 */
	public Adapter createRdsMeldungVerlaufDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel <em>Rds
	 * Meldung Verlauf Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel
	 * @generated
	 */
	public Adapter createRdsMeldungVerlaufDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp
	 * <em>Mess Querschnitt NBA Han Do Typ</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp
	 * @generated
	 */
	public Adapter createMessQuerschnittNBAHanDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel
	 * <em>Mess Querschnitt NBA Han Do Model</em>}'. <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel
	 * @generated
	 */
	public Adapter createMessQuerschnittNBAHanDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp <em>Tmc Meldung Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp
	 * @generated
	 */
	public Adapter createTmcMeldungDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp <em>Tmc
	 * Meldung Symbol Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp
	 * @generated
	 */
	public Adapter createTmcMeldungSymbolDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel <em>Tmc
	 * Meldung Symbol Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel
	 * @generated
	 */
	public Adapter createTmcMeldungSymbolDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp <em>Tmc
	 * Meldung Verlauf Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp
	 * @generated
	 */
	public Adapter createTmcMeldungVerlaufDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel <em>Tmc
	 * Meldung Verlauf Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel
	 * @generated
	 */
	public Adapter createTmcMeldungVerlaufDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp <em>Mess
	 * Querschnitt Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp
	 * @generated
	 */
	public Adapter createMessQuerschnittDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel <em>Mess
	 * Querschnitt Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel
	 * @generated
	 */
	public Adapter createMessQuerschnittDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp <em>Strassen
	 * Segment Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp
	 * @generated
	 */
	public Adapter createStrassenSegmentDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel
	 * <em>Strassen Segment Do Model</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel
	 * @generated
	 */
	public Adapter createStrassenSegmentDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.KreisDoTyp <em>Kreis Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.KreisDoTyp
	 * @generated
	 */
	public Adapter createKreisDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.KreisDoModel <em>Kreis Do
	 * Model</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.KreisDoModel
	 * @generated
	 */
	public Adapter createKreisDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp <em>Ortslage Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp
	 * @generated
	 */
	public Adapter createOrtslageDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtslageDoModel <em>Ortslage Do
	 * Model</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtslageDoModel
	 * @generated
	 */
	public Adapter createOrtslageDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.KomplexDoTyp <em>Komplex Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.KomplexDoTyp
	 * @generated
	 */
	public Adapter createKomplexDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp <em>Ortsname Do
	 * Typ</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp
	 * @generated
	 */
	public Adapter createOrtsnameDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel <em>Ortsname Do
	 * Model</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel
	 * @generated
	 */
	public Adapter createOrtsnameDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp <em>Strassen
	 * Knoten Do Typ</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp
	 * @generated
	 */
	public Adapter createStrassenKnotenDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel <em>Strassen
	 * Knoten Do Model</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel
	 * @generated
	 */
	public Adapter createStrassenKnotenDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp
	 * <em>Stoerfall Indikator Do Typ</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp
	 * @generated
	 */
	public Adapter createStoerfallIndikatorDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel
	 * <em>Stoerfall Indikator Do Model</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel
	 * @generated
	 */
	public Adapter createStoerfallIndikatorDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp
	 * <em>Strassen Segment Stoerfall Indikator Do Typ</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp
	 * @generated
	 */
	public Adapter createStrassenSegmentStoerfallIndikatorDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel
	 * <em>Strassen Segment Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel
	 * @generated
	 */
	public Adapter createStrassenSegmentStoerfallIndikatorDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Typ</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp
	 * @generated
	 */
	public Adapter createStrassenTeilSegmentStoerfallIndikatorDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel
	 * @generated
	 */
	public Adapter createStrassenTeilSegmentStoerfallIndikatorDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp
	 * <em>Mess Querschnitt Stoerfall Indikator Do Typ</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp
	 * @generated
	 */
	public Adapter createMessQuerschnittStoerfallIndikatorDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel
	 * <em>Mess Querschnitt Stoerfall Indikator Do Model</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel
	 * @generated
	 */
	public Adapter createMessQuerschnittStoerfallIndikatorDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link com.bitctrl.lib.eclipse.emf.eclipse.model.Named <em>Named</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.eclipse.model.Named
	 * @generated
	 */
	public Adapter createNamedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoTyp <em>Do Typ</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp
	 * @generated
	 */
	public Adapter createDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp <em>Configurated
	 * Do Typ</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp
	 * @generated
	 */
	public Adapter createConfiguratedDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link com.bitctrl.lib.eclipse.emf.gef.model.Located <em>Located</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.gef.model.Located
	 * @generated
	 */
	public Adapter createLocatedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.model.DoKomponente <em>Do
	 * Komponente</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKomponente
	 * @generated
	 */
	public Adapter createDoKomponenteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoModel <em>Do Model</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel
	 * @generated
	 */
	public Adapter createDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel <em>Bit Ctrl Do
	 * Model</em>}'. <!-- begin-user-doc --> This default implementation returns
	 * null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel
	 * @generated
	 */
	public Adapter createBitCtrlDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * <em>Skalierung Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator
	 * @generated
	 */
	public Adapter createSkalierungDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * <em>Datenstatus Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator
	 * @generated
	 */
	public Adapter createDatenstatusDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator
	 * <em>Linienabstand Zoom Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator
	 * @generated
	 */
	public Adapter createLinienabstandZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * <em>Drehung Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator
	 * @generated
	 */
	public Adapter createDrehungDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * <em>Vordergrundfarbe Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator
	 * @generated
	 */
	public Adapter createVordergrundfarbeDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator
	 * <em>Linienstaerke Zoom Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator
	 * @generated
	 */
	public Adapter createLinienstaerkeZoomDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * <em>Hintergrundfarbe Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator
	 * @generated
	 */
	public Adapter createHintergrundfarbeDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * <em>Schrift Decorator</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator
	 * @generated
	 */
	public Adapter createSchriftDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * <em>Stoerfall Indikator Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator
	 * @generated
	 */
	public Adapter createStoerfallIndikatorDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * <em>Antikollisionsalgorithmus Decorator</em>}'. <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore
	 * cases; it's useful to ignore a case when inheritance will catch all the
	 * cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator
	 * @generated
	 */
	public Adapter createAntikollisionsalgorithmusDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class
	 * '{@link de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * <em>Zoom Verhalten Fix Decorator</em>}'. <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases
	 * anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * @generated
	 */
	public Adapter createZoomVerhaltenFixDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case. <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // NetzAdapterFactory
