/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.model.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;

import de.bsvrz.buv.plugin.dobj.decorator.model.AntikollisionsalgorithmusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienabstandZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.AnzeigeQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.BaustelleVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.FahrStreifenStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoModel;
import de.bsvrz.buv.plugin.netz.model.GewaesserDoTyp;
import de.bsvrz.buv.plugin.netz.model.KomplexDoTyp;
import de.bsvrz.buv.plugin.netz.model.KreisDoModel;
import de.bsvrz.buv.plugin.netz.model.KreisDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittNBAHanDoTyp;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.MessQuerschnittStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtslageDoTyp;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoModel;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.SituationDoModel;
import de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.SituationVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.StauSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.StauVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoModel;
import de.bsvrz.buv.plugin.netz.model.StrassenTeilSegmentStoerfallIndikatorDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungSymbolDoTyp;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoTyp;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.UnfallSymbolDoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * 
 * @see de.bsvrz.buv.plugin.netz.model.NetzPackage
 * @generated
 */
public class NetzSwitch<T1> extends Switch<T1> {
	/**
	 * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static NetzPackage modelPackage;

	/**
	 * Creates an instance of the switch. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public NetzSwitch() {
		if (modelPackage == null) {
			modelPackage = NetzPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	@Override
	protected T1 doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case NetzPackage.MESS_QUERSCHNITT_DO_TYP: {
			final MessQuerschnittDoTyp messQuerschnittDoTyp = (MessQuerschnittDoTyp) theEObject;
			T1 result = caseMessQuerschnittDoTyp(messQuerschnittDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(messQuerschnittDoTyp);
			}
			if (result == null) {
				result = caseSkalierungDecorator(messQuerschnittDoTyp);
			}
			if (result == null) {
				result = caseDatenstatusDecorator(messQuerschnittDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(messQuerschnittDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(messQuerschnittDoTyp);
			}
			if (result == null) {
				result = caseNamed(messQuerschnittDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.MESS_QUERSCHNITT_DO_MODEL: {
			final MessQuerschnittDoModel messQuerschnittDoModel = (MessQuerschnittDoModel) theEObject;
			T1 result = caseMessQuerschnittDoModel(messQuerschnittDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(messQuerschnittDoModel);
			}
			if (result == null) {
				result = caseSkalierungDecorator(messQuerschnittDoModel);
			}
			if (result == null) {
				result = caseDrehungDecorator(messQuerschnittDoModel);
			}
			if (result == null) {
				result = caseDoModel(messQuerschnittDoModel);
			}
			if (result == null) {
				result = caseNamed(messQuerschnittDoModel);
			}
			if (result == null) {
				result = caseLocated(messQuerschnittDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(messQuerschnittDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_SEGMENT_DO_TYP: {
			final StrassenSegmentDoTyp strassenSegmentDoTyp = (StrassenSegmentDoTyp) theEObject;
			T1 result = caseStrassenSegmentDoTyp(strassenSegmentDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(strassenSegmentDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(strassenSegmentDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(strassenSegmentDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(strassenSegmentDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(strassenSegmentDoTyp);
			}
			if (result == null) {
				result = caseNamed(strassenSegmentDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_SEGMENT_DO_MODEL: {
			final StrassenSegmentDoModel strassenSegmentDoModel = (StrassenSegmentDoModel) theEObject;
			T1 result = caseStrassenSegmentDoModel(strassenSegmentDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(strassenSegmentDoModel);
			}
			if (result == null) {
				result = caseDoModel(strassenSegmentDoModel);
			}
			if (result == null) {
				result = caseNamed(strassenSegmentDoModel);
			}
			if (result == null) {
				result = caseLocated(strassenSegmentDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(strassenSegmentDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.KREIS_DO_TYP: {
			final KreisDoTyp kreisDoTyp = (KreisDoTyp) theEObject;
			T1 result = caseKreisDoTyp(kreisDoTyp);
			if (result == null) {
				result = caseKomplexDoTyp(kreisDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(kreisDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(kreisDoTyp);
			}
			if (result == null) {
				result = caseHintergrundfarbeDecorator(kreisDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(kreisDoTyp);
			}
			if (result == null) {
				result = caseNamed(kreisDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.KREIS_DO_MODEL: {
			final KreisDoModel kreisDoModel = (KreisDoModel) theEObject;
			T1 result = caseKreisDoModel(kreisDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(kreisDoModel);
			}
			if (result == null) {
				result = caseDoModel(kreisDoModel);
			}
			if (result == null) {
				result = caseNamed(kreisDoModel);
			}
			if (result == null) {
				result = caseLocated(kreisDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(kreisDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.ORTSLAGE_DO_TYP: {
			final OrtslageDoTyp ortslageDoTyp = (OrtslageDoTyp) theEObject;
			T1 result = caseOrtslageDoTyp(ortslageDoTyp);
			if (result == null) {
				result = caseKomplexDoTyp(ortslageDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(ortslageDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(ortslageDoTyp);
			}
			if (result == null) {
				result = caseHintergrundfarbeDecorator(ortslageDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(ortslageDoTyp);
			}
			if (result == null) {
				result = caseNamed(ortslageDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.ORTSLAGE_DO_MODEL: {
			final OrtslageDoModel ortslageDoModel = (OrtslageDoModel) theEObject;
			T1 result = caseOrtslageDoModel(ortslageDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(ortslageDoModel);
			}
			if (result == null) {
				result = caseDoModel(ortslageDoModel);
			}
			if (result == null) {
				result = caseNamed(ortslageDoModel);
			}
			if (result == null) {
				result = caseLocated(ortslageDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(ortslageDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.KOMPLEX_DO_TYP: {
			final KomplexDoTyp komplexDoTyp = (KomplexDoTyp) theEObject;
			T1 result = caseKomplexDoTyp(komplexDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(komplexDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(komplexDoTyp);
			}
			if (result == null) {
				result = caseHintergrundfarbeDecorator(komplexDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(komplexDoTyp);
			}
			if (result == null) {
				result = caseNamed(komplexDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.ORTSNAME_DO_TYP: {
			final OrtsnameDoTyp ortsnameDoTyp = (OrtsnameDoTyp) theEObject;
			T1 result = caseOrtsnameDoTyp(ortsnameDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(ortsnameDoTyp);
			}
			if (result == null) {
				result = caseSchriftDecorator(ortsnameDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(ortsnameDoTyp);
			}
			if (result == null) {
				result = caseNamed(ortsnameDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.ORTSNAME_DO_MODEL: {
			final OrtsnameDoModel ortsnameDoModel = (OrtsnameDoModel) theEObject;
			T1 result = caseOrtsnameDoModel(ortsnameDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(ortsnameDoModel);
			}
			if (result == null) {
				result = caseDoModel(ortsnameDoModel);
			}
			if (result == null) {
				result = caseNamed(ortsnameDoModel);
			}
			if (result == null) {
				result = caseLocated(ortsnameDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(ortsnameDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_KNOTEN_DO_TYP: {
			final StrassenKnotenDoTyp strassenKnotenDoTyp = (StrassenKnotenDoTyp) theEObject;
			T1 result = caseStrassenKnotenDoTyp(strassenKnotenDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(strassenKnotenDoTyp);
			}
			if (result == null) {
				result = caseHintergrundfarbeDecorator(strassenKnotenDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(strassenKnotenDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(strassenKnotenDoTyp);
			}
			if (result == null) {
				result = caseNamed(strassenKnotenDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_KNOTEN_DO_MODEL: {
			final StrassenKnotenDoModel strassenKnotenDoModel = (StrassenKnotenDoModel) theEObject;
			T1 result = caseStrassenKnotenDoModel(strassenKnotenDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(strassenKnotenDoModel);
			}
			if (result == null) {
				result = caseDoModel(strassenKnotenDoModel);
			}
			if (result == null) {
				result = caseNamed(strassenKnotenDoModel);
			}
			if (result == null) {
				result = caseLocated(strassenKnotenDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(strassenKnotenDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STOERFALL_INDIKATOR_DO_TYP: {
			final StoerfallIndikatorDoTyp stoerfallIndikatorDoTyp = (StoerfallIndikatorDoTyp) theEObject;
			T1 result = caseStoerfallIndikatorDoTyp(stoerfallIndikatorDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(stoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseStoerfallIndikatorDecorator(
						stoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(stoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseNamed(stoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STOERFALL_INDIKATOR_DO_MODEL: {
			final StoerfallIndikatorDoModel stoerfallIndikatorDoModel = (StoerfallIndikatorDoModel) theEObject;
			T1 result = caseStoerfallIndikatorDoModel(
					stoerfallIndikatorDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(stoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoModel(stoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseNamed(stoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseLocated(stoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(stoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_TYP: {
			final StrassenSegmentStoerfallIndikatorDoTyp strassenSegmentStoerfallIndikatorDoTyp = (StrassenSegmentStoerfallIndikatorDoTyp) theEObject;
			T1 result = caseStrassenSegmentStoerfallIndikatorDoTyp(
					strassenSegmentStoerfallIndikatorDoTyp);
			if (result == null) {
				result = caseStoerfallIndikatorDoTyp(
						strassenSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(
						strassenSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(
						strassenSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(
						strassenSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseStoerfallIndikatorDecorator(
						strassenSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(strassenSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseNamed(strassenSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL: {
			final StrassenSegmentStoerfallIndikatorDoModel strassenSegmentStoerfallIndikatorDoModel = (StrassenSegmentStoerfallIndikatorDoModel) theEObject;
			T1 result = caseStrassenSegmentStoerfallIndikatorDoModel(
					strassenSegmentStoerfallIndikatorDoModel);
			if (result == null) {
				result = caseStoerfallIndikatorDoModel(
						strassenSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(
						strassenSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoModel(strassenSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseNamed(strassenSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseLocated(strassenSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(
						strassenSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_TYP: {
			final StrassenTeilSegmentStoerfallIndikatorDoTyp strassenTeilSegmentStoerfallIndikatorDoTyp = (StrassenTeilSegmentStoerfallIndikatorDoTyp) theEObject;
			T1 result = caseStrassenTeilSegmentStoerfallIndikatorDoTyp(
					strassenTeilSegmentStoerfallIndikatorDoTyp);
			if (result == null) {
				result = caseStoerfallIndikatorDoTyp(
						strassenTeilSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(
						strassenTeilSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(
						strassenTeilSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(
						strassenTeilSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseStoerfallIndikatorDecorator(
						strassenTeilSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(strassenTeilSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseNamed(strassenTeilSegmentStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STRASSEN_TEIL_SEGMENT_STOERFALL_INDIKATOR_DO_MODEL: {
			final StrassenTeilSegmentStoerfallIndikatorDoModel strassenTeilSegmentStoerfallIndikatorDoModel = (StrassenTeilSegmentStoerfallIndikatorDoModel) theEObject;
			T1 result = caseStrassenTeilSegmentStoerfallIndikatorDoModel(
					strassenTeilSegmentStoerfallIndikatorDoModel);
			if (result == null) {
				result = caseStoerfallIndikatorDoModel(
						strassenTeilSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(
						strassenTeilSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoModel(
						strassenTeilSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseNamed(
						strassenTeilSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseLocated(
						strassenTeilSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(
						strassenTeilSegmentStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_TYP: {
			final MessQuerschnittStoerfallIndikatorDoTyp messQuerschnittStoerfallIndikatorDoTyp = (MessQuerschnittStoerfallIndikatorDoTyp) theEObject;
			T1 result = caseMessQuerschnittStoerfallIndikatorDoTyp(
					messQuerschnittStoerfallIndikatorDoTyp);
			if (result == null) {
				result = caseStoerfallIndikatorDoTyp(
						messQuerschnittStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(
						messQuerschnittStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(
						messQuerschnittStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(
						messQuerschnittStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseStoerfallIndikatorDecorator(
						messQuerschnittStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(messQuerschnittStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseNamed(messQuerschnittStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.MESS_QUERSCHNITT_STOERFALL_INDIKATOR_DO_MODEL: {
			final MessQuerschnittStoerfallIndikatorDoModel messQuerschnittStoerfallIndikatorDoModel = (MessQuerschnittStoerfallIndikatorDoModel) theEObject;
			T1 result = caseMessQuerschnittStoerfallIndikatorDoModel(
					messQuerschnittStoerfallIndikatorDoModel);
			if (result == null) {
				result = caseStoerfallIndikatorDoModel(
						messQuerschnittStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(
						messQuerschnittStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoModel(messQuerschnittStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseNamed(messQuerschnittStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseLocated(messQuerschnittStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(
						messQuerschnittStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_TYP: {
			final FahrStreifenStoerfallIndikatorDoTyp fahrStreifenStoerfallIndikatorDoTyp = (FahrStreifenStoerfallIndikatorDoTyp) theEObject;
			T1 result = caseFahrStreifenStoerfallIndikatorDoTyp(
					fahrStreifenStoerfallIndikatorDoTyp);
			if (result == null) {
				result = caseStoerfallIndikatorDoTyp(
						fahrStreifenStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(
						fahrStreifenStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(
						fahrStreifenStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(
						fahrStreifenStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseStoerfallIndikatorDecorator(
						fahrStreifenStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(fahrStreifenStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = caseNamed(fahrStreifenStoerfallIndikatorDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.FAHR_STREIFEN_STOERFALL_INDIKATOR_DO_MODEL: {
			final FahrStreifenStoerfallIndikatorDoModel fahrStreifenStoerfallIndikatorDoModel = (FahrStreifenStoerfallIndikatorDoModel) theEObject;
			T1 result = caseFahrStreifenStoerfallIndikatorDoModel(
					fahrStreifenStoerfallIndikatorDoModel);
			if (result == null) {
				result = caseStoerfallIndikatorDoModel(
						fahrStreifenStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(
						fahrStreifenStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoModel(fahrStreifenStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseNamed(fahrStreifenStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseLocated(fahrStreifenStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(
						fahrStreifenStoerfallIndikatorDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.UMFELD_DATEN_MESS_STELLE_DO_TYP: {
			final UmfeldDatenMessStelleDoTyp umfeldDatenMessStelleDoTyp = (UmfeldDatenMessStelleDoTyp) theEObject;
			T1 result = caseUmfeldDatenMessStelleDoTyp(
					umfeldDatenMessStelleDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(umfeldDatenMessStelleDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(umfeldDatenMessStelleDoTyp);
			}
			if (result == null) {
				result = caseNamed(umfeldDatenMessStelleDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.UMFELD_DATEN_MESS_STELLE_DO_MODEL: {
			final UmfeldDatenMessStelleDoModel umfeldDatenMessStelleDoModel = (UmfeldDatenMessStelleDoModel) theEObject;
			T1 result = caseUmfeldDatenMessStelleDoModel(
					umfeldDatenMessStelleDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(umfeldDatenMessStelleDoModel);
			}
			if (result == null) {
				result = caseDoModel(umfeldDatenMessStelleDoModel);
			}
			if (result == null) {
				result = caseNamed(umfeldDatenMessStelleDoModel);
			}
			if (result == null) {
				result = caseLocated(umfeldDatenMessStelleDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(umfeldDatenMessStelleDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.ANZEIGE_QUERSCHNITT_DO_TYP: {
			final AnzeigeQuerschnittDoTyp anzeigeQuerschnittDoTyp = (AnzeigeQuerschnittDoTyp) theEObject;
			T1 result = caseAnzeigeQuerschnittDoTyp(anzeigeQuerschnittDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(anzeigeQuerschnittDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(anzeigeQuerschnittDoTyp);
			}
			if (result == null) {
				result = caseNamed(anzeigeQuerschnittDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.ANZEIGE_QUERSCHNITT_DO_MODEL: {
			final AnzeigeQuerschnittDoModel anzeigeQuerschnittDoModel = (AnzeigeQuerschnittDoModel) theEObject;
			T1 result = caseAnzeigeQuerschnittDoModel(
					anzeigeQuerschnittDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(anzeigeQuerschnittDoModel);
			}
			if (result == null) {
				result = caseDrehungDecorator(anzeigeQuerschnittDoModel);
			}
			if (result == null) {
				result = caseDoModel(anzeigeQuerschnittDoModel);
			}
			if (result == null) {
				result = caseNamed(anzeigeQuerschnittDoModel);
			}
			if (result == null) {
				result = caseLocated(anzeigeQuerschnittDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(anzeigeQuerschnittDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.GEWAESSER_DO_TYP: {
			final GewaesserDoTyp gewaesserDoTyp = (GewaesserDoTyp) theEObject;
			T1 result = caseGewaesserDoTyp(gewaesserDoTyp);
			if (result == null) {
				result = caseKomplexDoTyp(gewaesserDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(gewaesserDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(gewaesserDoTyp);
			}
			if (result == null) {
				result = caseHintergrundfarbeDecorator(gewaesserDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(gewaesserDoTyp);
			}
			if (result == null) {
				result = caseNamed(gewaesserDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.GEWAESSER_DO_MODEL: {
			final GewaesserDoModel gewaesserDoModel = (GewaesserDoModel) theEObject;
			T1 result = caseGewaesserDoModel(gewaesserDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(gewaesserDoModel);
			}
			if (result == null) {
				result = caseDoModel(gewaesserDoModel);
			}
			if (result == null) {
				result = caseNamed(gewaesserDoModel);
			}
			if (result == null) {
				result = caseLocated(gewaesserDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(gewaesserDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.SITUATION_DO_MODEL: {
			final SituationDoModel<?> situationDoModel = (SituationDoModel<?>) theEObject;
			T1 result = caseSituationDoModel(situationDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(situationDoModel);
			}
			if (result == null) {
				result = caseDoModel(situationDoModel);
			}
			if (result == null) {
				result = caseNamed(situationDoModel);
			}
			if (result == null) {
				result = caseLocated(situationDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(situationDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.SITUATION_SYMBOL_DO_TYP: {
			final SituationSymbolDoTyp situationSymbolDoTyp = (SituationSymbolDoTyp) theEObject;
			T1 result = caseSituationSymbolDoTyp(situationSymbolDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(situationSymbolDoTyp);
			}
			if (result == null) {
				result = caseAntikollisionsalgorithmusDecorator(
						situationSymbolDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(situationSymbolDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(situationSymbolDoTyp);
			}
			if (result == null) {
				result = caseNamed(situationSymbolDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.SITUATION_VERLAUF_DO_TYP: {
			final SituationVerlaufDoTyp situationVerlaufDoTyp = (SituationVerlaufDoTyp) theEObject;
			T1 result = caseSituationVerlaufDoTyp(situationVerlaufDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(situationVerlaufDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(situationVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(situationVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(situationVerlaufDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(situationVerlaufDoTyp);
			}
			if (result == null) {
				result = caseNamed(situationVerlaufDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.BAUSTELLE_DO_TYP: {
			final BaustelleDoTyp baustelleDoTyp = (BaustelleDoTyp) theEObject;
			T1 result = caseBaustelleDoTyp(baustelleDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(baustelleDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(baustelleDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(baustelleDoTyp);
			}
			if (result == null) {
				result = caseNamed(baustelleDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.BAUSTELLE_SYMBOL_DO_TYP: {
			final BaustelleSymbolDoTyp baustelleSymbolDoTyp = (BaustelleSymbolDoTyp) theEObject;
			T1 result = caseBaustelleSymbolDoTyp(baustelleSymbolDoTyp);
			if (result == null) {
				result = caseBaustelleDoTyp(baustelleSymbolDoTyp);
			}
			if (result == null) {
				result = caseSituationSymbolDoTyp(baustelleSymbolDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(baustelleSymbolDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(baustelleSymbolDoTyp);
			}
			if (result == null) {
				result = caseAntikollisionsalgorithmusDecorator(
						baustelleSymbolDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(baustelleSymbolDoTyp);
			}
			if (result == null) {
				result = caseNamed(baustelleSymbolDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.BAUSTELLE_SYMBOL_DO_MODEL: {
			final BaustelleSymbolDoModel baustelleSymbolDoModel = (BaustelleSymbolDoModel) theEObject;
			T1 result = caseBaustelleSymbolDoModel(baustelleSymbolDoModel);
			if (result == null) {
				result = caseSituationDoModel(baustelleSymbolDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(baustelleSymbolDoModel);
			}
			if (result == null) {
				result = caseDoModel(baustelleSymbolDoModel);
			}
			if (result == null) {
				result = caseNamed(baustelleSymbolDoModel);
			}
			if (result == null) {
				result = caseLocated(baustelleSymbolDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(baustelleSymbolDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.BAUSTELLE_VERLAUF_DO_TYP: {
			final BaustelleVerlaufDoTyp baustelleVerlaufDoTyp = (BaustelleVerlaufDoTyp) theEObject;
			T1 result = caseBaustelleVerlaufDoTyp(baustelleVerlaufDoTyp);
			if (result == null) {
				result = caseBaustelleDoTyp(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = caseSituationVerlaufDoTyp(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = caseNamed(baustelleVerlaufDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.BAUSTELLE_VERLAUF_DO_MODEL: {
			final BaustelleVerlaufDoModel baustelleVerlaufDoModel = (BaustelleVerlaufDoModel) theEObject;
			T1 result = caseBaustelleVerlaufDoModel(baustelleVerlaufDoModel);
			if (result == null) {
				result = caseSituationDoModel(baustelleVerlaufDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(baustelleVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoModel(baustelleVerlaufDoModel);
			}
			if (result == null) {
				result = caseNamed(baustelleVerlaufDoModel);
			}
			if (result == null) {
				result = caseLocated(baustelleVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(baustelleVerlaufDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STAU_DO_TYP: {
			final StauDoTyp stauDoTyp = (StauDoTyp) theEObject;
			T1 result = caseStauDoTyp(stauDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(stauDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(stauDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(stauDoTyp);
			}
			if (result == null) {
				result = caseNamed(stauDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STAU_SYMBOL_DO_TYP: {
			final StauSymbolDoTyp stauSymbolDoTyp = (StauSymbolDoTyp) theEObject;
			T1 result = caseStauSymbolDoTyp(stauSymbolDoTyp);
			if (result == null) {
				result = caseStauDoTyp(stauSymbolDoTyp);
			}
			if (result == null) {
				result = caseSituationSymbolDoTyp(stauSymbolDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(stauSymbolDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(stauSymbolDoTyp);
			}
			if (result == null) {
				result = caseAntikollisionsalgorithmusDecorator(
						stauSymbolDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(stauSymbolDoTyp);
			}
			if (result == null) {
				result = caseNamed(stauSymbolDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STAU_SYMBOL_DO_MODEL: {
			final StauSymbolDoModel stauSymbolDoModel = (StauSymbolDoModel) theEObject;
			T1 result = caseStauSymbolDoModel(stauSymbolDoModel);
			if (result == null) {
				result = caseSituationDoModel(stauSymbolDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(stauSymbolDoModel);
			}
			if (result == null) {
				result = caseDoModel(stauSymbolDoModel);
			}
			if (result == null) {
				result = caseNamed(stauSymbolDoModel);
			}
			if (result == null) {
				result = caseLocated(stauSymbolDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(stauSymbolDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STAU_VERLAUF_DO_TYP: {
			final StauVerlaufDoTyp stauVerlaufDoTyp = (StauVerlaufDoTyp) theEObject;
			T1 result = caseStauVerlaufDoTyp(stauVerlaufDoTyp);
			if (result == null) {
				result = caseStauDoTyp(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = caseSituationVerlaufDoTyp(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = caseNamed(stauVerlaufDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.STAU_VERLAUF_DO_MODEL: {
			final StauVerlaufDoModel stauVerlaufDoModel = (StauVerlaufDoModel) theEObject;
			T1 result = caseStauVerlaufDoModel(stauVerlaufDoModel);
			if (result == null) {
				result = caseSituationDoModel(stauVerlaufDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(stauVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoModel(stauVerlaufDoModel);
			}
			if (result == null) {
				result = caseNamed(stauVerlaufDoModel);
			}
			if (result == null) {
				result = caseLocated(stauVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(stauVerlaufDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.UNFALL_SYMBOL_DO_TYP: {
			final UnfallSymbolDoTyp unfallSymbolDoTyp = (UnfallSymbolDoTyp) theEObject;
			T1 result = caseUnfallSymbolDoTyp(unfallSymbolDoTyp);
			if (result == null) {
				result = caseSituationSymbolDoTyp(unfallSymbolDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(unfallSymbolDoTyp);
			}
			if (result == null) {
				result = caseAntikollisionsalgorithmusDecorator(
						unfallSymbolDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(unfallSymbolDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(unfallSymbolDoTyp);
			}
			if (result == null) {
				result = caseNamed(unfallSymbolDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.UNFALL_SYMBOL_DO_MODEL: {
			final UnfallSymbolDoModel unfallSymbolDoModel = (UnfallSymbolDoModel) theEObject;
			T1 result = caseUnfallSymbolDoModel(unfallSymbolDoModel);
			if (result == null) {
				result = caseSituationDoModel(unfallSymbolDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(unfallSymbolDoModel);
			}
			if (result == null) {
				result = caseDoModel(unfallSymbolDoModel);
			}
			if (result == null) {
				result = caseNamed(unfallSymbolDoModel);
			}
			if (result == null) {
				result = caseLocated(unfallSymbolDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(unfallSymbolDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.RDS_MELDUNG_DO_TYP: {
			final RdsMeldungDoTyp rdsMeldungDoTyp = (RdsMeldungDoTyp) theEObject;
			T1 result = caseRdsMeldungDoTyp(rdsMeldungDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(rdsMeldungDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(rdsMeldungDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(rdsMeldungDoTyp);
			}
			if (result == null) {
				result = caseNamed(rdsMeldungDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.RDS_MELDUNG_SYMBOL_DO_TYP: {
			final RdsMeldungSymbolDoTyp rdsMeldungSymbolDoTyp = (RdsMeldungSymbolDoTyp) theEObject;
			T1 result = caseRdsMeldungSymbolDoTyp(rdsMeldungSymbolDoTyp);
			if (result == null) {
				result = caseRdsMeldungDoTyp(rdsMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseAntikollisionsalgorithmusDecorator(
						rdsMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(rdsMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(rdsMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(rdsMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseNamed(rdsMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.RDS_MELDUNG_SYMBOL_DO_MODEL: {
			final RdsMeldungSymbolDoModel rdsMeldungSymbolDoModel = (RdsMeldungSymbolDoModel) theEObject;
			T1 result = caseRdsMeldungSymbolDoModel(rdsMeldungSymbolDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(rdsMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseDoModel(rdsMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseNamed(rdsMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseLocated(rdsMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(rdsMeldungSymbolDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.RDS_MELDUNG_VERLAUF_DO_TYP: {
			final RdsMeldungVerlaufDoTyp rdsMeldungVerlaufDoTyp = (RdsMeldungVerlaufDoTyp) theEObject;
			T1 result = caseRdsMeldungVerlaufDoTyp(rdsMeldungVerlaufDoTyp);
			if (result == null) {
				result = caseRdsMeldungDoTyp(rdsMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(rdsMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(rdsMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(rdsMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(rdsMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(rdsMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseNamed(rdsMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.RDS_MELDUNG_VERLAUF_DO_MODEL: {
			final RdsMeldungVerlaufDoModel rdsMeldungVerlaufDoModel = (RdsMeldungVerlaufDoModel) theEObject;
			T1 result = caseRdsMeldungVerlaufDoModel(rdsMeldungVerlaufDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(rdsMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoModel(rdsMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseNamed(rdsMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseLocated(rdsMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(rdsMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.MESS_QUERSCHNITT_NBA_HAN_DO_TYP: {
			final MessQuerschnittNBAHanDoTyp messQuerschnittNBAHanDoTyp = (MessQuerschnittNBAHanDoTyp) theEObject;
			T1 result = caseMessQuerschnittNBAHanDoTyp(
					messQuerschnittNBAHanDoTyp);
			if (result == null) {
				result = caseMessQuerschnittDoTyp(messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = caseZoomVerhaltenFixDecorator(
						messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = caseSkalierungDecorator(messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = caseDatenstatusDecorator(messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(
						messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = caseNamed(messQuerschnittNBAHanDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.MESS_QUERSCHNITT_NBA_HAN_DO_MODEL: {
			final MessQuerschnittNBAHanDoModel messQuerschnittNBAHanDoModel = (MessQuerschnittNBAHanDoModel) theEObject;
			T1 result = caseMessQuerschnittNBAHanDoModel(
					messQuerschnittNBAHanDoModel);
			if (result == null) {
				result = caseMessQuerschnittDoModel(
						messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = caseBitCtrlDoModel(messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = caseSkalierungDecorator(messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = caseDrehungDecorator(messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = caseDoModel(messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = caseNamed(messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = caseLocated(messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(messQuerschnittNBAHanDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.TMC_MELDUNG_DO_TYP: {
			final TmcMeldungDoTyp tmcMeldungDoTyp = (TmcMeldungDoTyp) theEObject;
			T1 result = caseTmcMeldungDoTyp(tmcMeldungDoTyp);
			if (result == null) {
				result = caseConfiguratedDoTyp(tmcMeldungDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(tmcMeldungDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(tmcMeldungDoTyp);
			}
			if (result == null) {
				result = caseNamed(tmcMeldungDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.TMC_MELDUNG_SYMBOL_DO_TYP: {
			final TmcMeldungSymbolDoTyp tmcMeldungSymbolDoTyp = (TmcMeldungSymbolDoTyp) theEObject;
			T1 result = caseTmcMeldungSymbolDoTyp(tmcMeldungSymbolDoTyp);
			if (result == null) {
				result = caseTmcMeldungDoTyp(tmcMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseAntikollisionsalgorithmusDecorator(
						tmcMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(tmcMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(tmcMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(tmcMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = caseNamed(tmcMeldungSymbolDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.TMC_MELDUNG_SYMBOL_DO_MODEL: {
			final TmcMeldungSymbolDoModel tmcMeldungSymbolDoModel = (TmcMeldungSymbolDoModel) theEObject;
			T1 result = caseTmcMeldungSymbolDoModel(tmcMeldungSymbolDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(tmcMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseDoModel(tmcMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseNamed(tmcMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseLocated(tmcMeldungSymbolDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(tmcMeldungSymbolDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_TYP: {
			final TmcMeldungVerlaufDoTyp tmcMeldungVerlaufDoTyp = (TmcMeldungVerlaufDoTyp) theEObject;
			T1 result = caseTmcMeldungVerlaufDoTyp(tmcMeldungVerlaufDoTyp);
			if (result == null) {
				result = caseTmcMeldungDoTyp(tmcMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseVordergrundfarbeDecorator(tmcMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienstaerkeZoomDecorator(tmcMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseConfiguratedDoTyp(tmcMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseLinienabstandZoomDecorator(tmcMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseDoTyp(tmcMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = caseNamed(tmcMeldungVerlaufDoTyp);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case NetzPackage.TMC_MELDUNG_VERLAUF_DO_MODEL: {
			final TmcMeldungVerlaufDoModel tmcMeldungVerlaufDoModel = (TmcMeldungVerlaufDoModel) theEObject;
			T1 result = caseTmcMeldungVerlaufDoModel(tmcMeldungVerlaufDoModel);
			if (result == null) {
				result = caseBitCtrlDoModel(tmcMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoModel(tmcMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseNamed(tmcMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseLocated(tmcMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = caseDoKomponente(tmcMeldungVerlaufDoModel);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Fahr
	 * Streifen Stoerfall Indikator Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Fahr
	 *         Streifen Stoerfall Indikator Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFahrStreifenStoerfallIndikatorDoTyp(
			FahrStreifenStoerfallIndikatorDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Fahr
	 * Streifen Stoerfall Indikator Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Fahr
	 *         Streifen Stoerfall Indikator Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseFahrStreifenStoerfallIndikatorDoModel(
			FahrStreifenStoerfallIndikatorDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Umfeld Daten Mess Stelle Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Umfeld Daten Mess Stelle Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUmfeldDatenMessStelleDoTyp(
			UmfeldDatenMessStelleDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Umfeld Daten Mess Stelle Do Model</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will
	 * terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Umfeld Daten Mess Stelle Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUmfeldDatenMessStelleDoModel(
			UmfeldDatenMessStelleDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Anzeige Querschnitt Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Anzeige Querschnitt Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseAnzeigeQuerschnittDoTyp(AnzeigeQuerschnittDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Anzeige Querschnitt Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Anzeige Querschnitt Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseAnzeigeQuerschnittDoModel(AnzeigeQuerschnittDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Gewaesser Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Gewaesser Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseGewaesserDoTyp(GewaesserDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Gewaesser Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Gewaesser Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseGewaesserDoModel(GewaesserDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Situation Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Situation Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public <T extends Situation> T1 caseSituationDoModel(
			SituationDoModel<T> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Situation Symbol Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Situation Symbol Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSituationSymbolDoTyp(SituationSymbolDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Situation Verlauf Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Situation Verlauf Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSituationVerlaufDoTyp(SituationVerlaufDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Baustelle Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Baustelle Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBaustelleDoTyp(BaustelleDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Baustelle Symbol Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Baustelle Symbol Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBaustelleSymbolDoTyp(BaustelleSymbolDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Baustelle Symbol Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Baustelle Symbol Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBaustelleSymbolDoModel(BaustelleSymbolDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Baustelle Verlauf Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Baustelle Verlauf Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBaustelleVerlaufDoTyp(BaustelleVerlaufDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Baustelle Verlauf Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Baustelle Verlauf Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseBaustelleVerlaufDoModel(BaustelleVerlaufDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stau
	 * Do Typ</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stau
	 *         Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStauDoTyp(StauDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stau
	 * Symbol Do Typ</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stau
	 *         Symbol Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStauSymbolDoTyp(StauSymbolDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stau
	 * Symbol Do Model</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stau
	 *         Symbol Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStauSymbolDoModel(StauSymbolDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stau
	 * Verlauf Do Typ</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stau
	 *         Verlauf Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStauVerlaufDoTyp(StauVerlaufDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stau
	 * Verlauf Do Model</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stau
	 *         Verlauf Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStauVerlaufDoModel(StauVerlaufDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Unfall Symbol Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Unfall Symbol Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUnfallSymbolDoTyp(UnfallSymbolDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Unfall Symbol Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Unfall Symbol Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseUnfallSymbolDoModel(UnfallSymbolDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rds
	 * Meldung Do Typ</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rds
	 *         Meldung Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseRdsMeldungDoTyp(RdsMeldungDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rds
	 * Meldung Symbol Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rds
	 *         Meldung Symbol Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseRdsMeldungSymbolDoTyp(RdsMeldungSymbolDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rds
	 * Meldung Symbol Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rds
	 *         Meldung Symbol Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseRdsMeldungSymbolDoModel(RdsMeldungSymbolDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rds
	 * Meldung Verlauf Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rds
	 *         Meldung Verlauf Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseRdsMeldungVerlaufDoTyp(RdsMeldungVerlaufDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rds
	 * Meldung Verlauf Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rds
	 *         Meldung Verlauf Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseRdsMeldungVerlaufDoModel(RdsMeldungVerlaufDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mess
	 * Querschnitt NBA Han Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mess
	 *         Querschnitt NBA Han Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseMessQuerschnittNBAHanDoTyp(
			MessQuerschnittNBAHanDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mess
	 * Querschnitt NBA Han Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mess
	 *         Querschnitt NBA Han Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseMessQuerschnittNBAHanDoModel(
			MessQuerschnittNBAHanDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tmc
	 * Meldung Do Typ</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tmc
	 *         Meldung Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTmcMeldungDoTyp(TmcMeldungDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tmc
	 * Meldung Symbol Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tmc
	 *         Meldung Symbol Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTmcMeldungSymbolDoTyp(TmcMeldungSymbolDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tmc
	 * Meldung Symbol Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tmc
	 *         Meldung Symbol Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTmcMeldungSymbolDoModel(TmcMeldungSymbolDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tmc
	 * Meldung Verlauf Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tmc
	 *         Meldung Verlauf Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTmcMeldungVerlaufDoTyp(TmcMeldungVerlaufDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tmc
	 * Meldung Verlauf Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tmc
	 *         Meldung Verlauf Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseTmcMeldungVerlaufDoModel(TmcMeldungVerlaufDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mess
	 * Querschnitt Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mess
	 *         Querschnitt Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseMessQuerschnittDoTyp(MessQuerschnittDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mess
	 * Querschnitt Do Model</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mess
	 *         Querschnitt Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseMessQuerschnittDoModel(MessQuerschnittDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Strassen Segment Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Strassen Segment Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenSegmentDoTyp(StrassenSegmentDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Strassen Segment Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Strassen Segment Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenSegmentDoModel(StrassenSegmentDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Kreis Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Kreis Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseKreisDoTyp(KreisDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Kreis Do Model</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Kreis Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseKreisDoModel(KreisDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Ortslage Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Ortslage Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseOrtslageDoTyp(OrtslageDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Ortslage Do Model</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Ortslage Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseOrtslageDoModel(OrtslageDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Komplex Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Komplex Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseKomplexDoTyp(KomplexDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Ortsname Do Typ</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Ortsname Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseOrtsnameDoTyp(OrtsnameDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Ortsname Do Model</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Ortsname Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseOrtsnameDoModel(OrtsnameDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Strassen Knoten Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Strassen Knoten Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenKnotenDoTyp(StrassenKnotenDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Strassen Knoten Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Strassen Knoten Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenKnotenDoModel(StrassenKnotenDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Stoerfall Indikator Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Stoerfall Indikator Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStoerfallIndikatorDoTyp(StoerfallIndikatorDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Stoerfall Indikator Do Model</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Stoerfall Indikator Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStoerfallIndikatorDoModel(StoerfallIndikatorDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Strassen Segment Stoerfall Indikator Do Typ</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Strassen Segment Stoerfall Indikator Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenSegmentStoerfallIndikatorDoTyp(
			StrassenSegmentStoerfallIndikatorDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Strassen Segment Stoerfall Indikator Do Model</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Strassen Segment Stoerfall Indikator Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenSegmentStoerfallIndikatorDoModel(
			StrassenSegmentStoerfallIndikatorDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Typ</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Strassen Teil Segment Stoerfall Indikator Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenTeilSegmentStoerfallIndikatorDoTyp(
			StrassenTeilSegmentStoerfallIndikatorDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Strassen Teil Segment Stoerfall Indikator Do Model</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Strassen Teil Segment Stoerfall Indikator Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStrassenTeilSegmentStoerfallIndikatorDoModel(
			StrassenTeilSegmentStoerfallIndikatorDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Mess Querschnitt Stoerfall Indikator Do Typ</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Mess Querschnitt Stoerfall Indikator Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseMessQuerschnittStoerfallIndikatorDoTyp(
			MessQuerschnittStoerfallIndikatorDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Mess Querschnitt Stoerfall Indikator Do Model</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Mess Querschnitt Stoerfall Indikator Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseMessQuerschnittStoerfallIndikatorDoModel(
			MessQuerschnittStoerfallIndikatorDoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Named</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Named</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNamed(Named object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do
	 * Typ</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do
	 *         Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoTyp(DoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Configurated Do Typ</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Configurated Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseConfiguratedDoTyp(ConfiguratedDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Located</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Located</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLocated(Located object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do
	 * Komponente</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do
	 *         Komponente</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoKomponente(DoKomponente object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do
	 * Model</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do
	 *         Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoModel(DoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Bit
	 * Ctrl Do Model</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Bit
	 *         Ctrl Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public <T extends SystemObjekt> T1 caseBitCtrlDoModel(
			BitCtrlDoModel<T> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Skalierung Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Skalierung Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSkalierungDecorator(SkalierungDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Datenstatus Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Datenstatus Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDatenstatusDecorator(DatenstatusDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Linienabstand Zoom Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Linienabstand Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLinienabstandZoomDecorator(
			LinienabstandZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Drehung Decorator</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Drehung Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDrehungDecorator(DrehungDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Vordergrundfarbe Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Vordergrundfarbe Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseVordergrundfarbeDecorator(VordergrundfarbeDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Linienstaerke Zoom Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Linienstaerke Zoom Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLinienstaerkeZoomDecorator(
			LinienstaerkeZoomDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Hintergrundfarbe Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Hintergrundfarbe Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseHintergrundfarbeDecorator(HintergrundfarbeDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Schrift Decorator</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Schrift Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSchriftDecorator(SchriftDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Stoerfall Indikator Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Stoerfall Indikator Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseStoerfallIndikatorDecorator(
			StoerfallIndikatorDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>Antikollisionsalgorithmus Decorator</em>'. <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will
	 * terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>Antikollisionsalgorithmus Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseAntikollisionsalgorithmusDecorator(
			AntikollisionsalgorithmusDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom
	 * Verhalten Fix Decorator</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom
	 *         Verhalten Fix Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomVerhaltenFixDecorator(ZoomVerhaltenFixDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of
	 * '<em>EObject</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of
	 *         '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T1 defaultCase(EObject object) {
		return null;
	}

} // NetzSwitch
