/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.ort;

import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.dobj.decorator.SchriftMediator;
import de.bsvrz.buv.plugin.dobj.editparts.PunktEditPart;
import de.bsvrz.buv.plugin.netz.model.OrtsnameDoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY;

/**
 * MVC-Controller für einen Ortsnamen.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public final class OrtsnameEditPart
		extends PunktEditPart<PunktXY, OrtsnameFigure> {

	@Override
	protected OrtsnameFigure createFigure() {
		return new OrtsnameFigure();
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof OrtsnameDoTyp)) {
			refreshVisuals();
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		refreshOrtsname();
		new SchriftMediator(this).mediate();
	}

	private void refreshOrtsname() {
		final OrtsnameFigure f = getFigure();
		if (getModel().getSystemObject() != null) {
			final String ortsname = getModel().getSystemObject().getName();
			f.setOrtsname(ortsname);
		} else {
			f.setOrtsname(null);
		}
	}

}
