/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.ort;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Font;

import com.bitctrl.lib.eclipse.draw2d.FixedSizeFigure;

import de.bsvrz.buv.plugin.dobj.DoFigure;

/**
 * Die Figure zeichnet den Ortsnamen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
final class OrtsnameFigure extends FixedSizeFigure implements DoFigure {

	private final Label ortsname;
	private double zoom = 1.0;
	private double vonZoom;
	private double bisZoom = Double.MAX_VALUE;

	OrtsnameFigure() {
		ortsname = new Label();
		add(ortsname);
	}

	@Override
	public Point getHotspot() {
		return getLocation();
	}

	@Override
	public void setHotspot(final Point hotspot) {
		setLocation(hotspot);
	}

	String getOrtsname() {
		return ortsname.getText();
	}

	void setOrtsname(final String text) {
		ortsname.setText(text);
		updateFigure();
	}

	@Override
	public void setFont(final Font f) {
		super.setFont(f);
		updateFigure();
	}

	private void updateFigure() {
		setVisible(vonZoom <= zoom && zoom <= bisZoom);

		if (ortsname.getText().isEmpty()) {
			setDimension(new Dimension());
		} else {
			final Dimension dimension = TextUtilities.INSTANCE
					.getTextExtents(getOrtsname(), getFont());
			ortsname.setSize(dimension);
			setDimension(dimension);
		}
	}

	@Override
	public void setSichtbareZoomStufe(final double vonZoom,
			final double bisZoom) {
		if (this.vonZoom == vonZoom && this.bisZoom == bisZoom) {
			return;
		}

		this.vonZoom = vonZoom;
		this.bisZoom = bisZoom;

		updateFigure();
	}

	@Override
	public void handleZoomChanged(final double newZoom) {
		setZoom(newZoom);

		zoom = newZoom;

		updateFigure();
	}

}
